/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.AssertiveRepaintManager;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.CliResult;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.customize.CommonCustomizeIDEWizardDialog;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.ide.instrument.WriteIntentLockInstrumenter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.idea.CommandLineArgs;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.PrintStreamLogger;
import com.intellij.idea.SocketLock;
import com.intellij.idea.SplashManager;
import com.intellij.idea.ZipFilePoolImpl;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.AWTExceptionHandler;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.wm.WeakFocusStackManager;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CoreIconManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.mac.MacOSApplicationProvider;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.Java11Shim;
import com.intellij.util.lang.ZipFilePool;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.io.BuiltInServer;
import sun.awt.AWTAutoShutdown;

@ApiStatus.Internal
public final class StartupUtil {
    public static BiFunction<String, String[], Integer> LISTENER = (integer, s) -> 14;
    private static final String IDEA_CLASS_BEFORE_APPLICATION_PROPERTY = "idea.class.before.app";
    private static final String USE_SEPARATE_WRITE_THREAD_PROPERTY = "idea.use.separate.write.thread";
    private static final String PROJECTOR_LAUNCHER_CLASS_NAME = "org.jetbrains.projector.server.ProjectorLauncher$Starter";
    private static final String MAGIC_MAC_PATH = "/AppTranslocation/";
    private static SocketLock socketLock;
    private static Future<@Nullable Boolean> shellEnvLoadFuture;
    public static Activity startupStart;

    private StartupUtil() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void start(@NotNull String mainClass, String @NotNull [] args, @NotNull LinkedHashMap<String, Long> startupTimings) throws Exception {
        CompletionStage agreementDialogWasShown;
        if (mainClass == null) {
            StartupUtil.$$$reportNull$$$0(0);
        }
        if (startupTimings == null) {
            StartupUtil.$$$reportNull$$$0(1);
        }
        if (args == null) {
            StartupUtil.$$$reportNull$$$0(2);
        }
        StartUpMeasurer.addTimings(startupTimings, (String)"bootstrap");
        startupStart = StartUpMeasurer.startActivity((String)"app initialization preparation");
        Main.setFlags((String[])args);
        CommandLineArgs.parse(args);
        LoadingState.setStrictMode();
        LoadingState.errorHandler = (message2, throwable) -> Logger.getInstance(LoadingState.class).error(message2, throwable);
        Activity activity = StartUpMeasurer.startActivity((String)"ForkJoin CommonPool configuration");
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)Main.isHeadless((String[])args));
        ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
        activity = activity.endAndStart("main class loading scheduling");
        CompletableFuture<AppStarter> appStarterFuture = CompletableFuture.supplyAsync(() -> {
            try {
                Activity subActivity = StartUpMeasurer.startActivity((String)"main class loading");
                Class<?> aClass = StartupUtil.class.getClassLoader().loadClass(mainClass);
                subActivity.end();
                return MethodHandles.lookup().findConstructor(aClass, MethodType.methodType(Void.TYPE)).invoke();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        }, forkJoinPool);
        activity = activity.endAndStart("log4j configuration");
        StartupUtil.configureLog4j();
        if (args.length > 0 && ("cwmHost".equals(args[0]) || "cwmHostNoLobby".equals(args[0]))) {
            activity = activity.endAndStart("Cwm Host init");
            try {
                Class<?> projectorMainClass = StartupUtil.class.getClassLoader().loadClass(PROJECTOR_LAUNCHER_CLASS_NAME);
                MethodHandles.privateLookupIn(projectorMainClass, MethodHandles.lookup()).findStatic(projectorMainClass, "runProjectorServer", MethodType.methodType(Boolean.TYPE)).invoke();
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        activity = activity.endAndStart("Check graphics environment");
        if (!Main.isHeadless() && !StartupUtil.checkGraphics()) {
            System.exit(1);
        }
        activity = activity.endAndStart("LaF init scheduling");
        Thread busyThread = Thread.currentThread();
        CompletableFuture<?> initUiTask = StartupUtil.scheduleInitUi(busyThread);
        if (Main.isHeadless()) {
            agreementDialogWasShown = initUiTask.thenApply(__ -> true);
        } else {
            CompletableFuture<@Nullable(value="if accepted") Object> euaDocumentFuture = StartupUtil.scheduleEuaDocumentLoading();
            agreementDialogWasShown = initUiTask.thenCompose(o -> euaDocumentFuture.thenApplyAsync(euaDocument -> {
                boolean result2 = StartupUtil.showEuaAndScheduleSplashIfNeeded(args, euaDocument);
                ForkJoinPool.commonPool().execute(() -> {
                    StartupUtil.updateFrameClassAndWindowIcon();
                    StartupUtil.loadSystemFontsAndDnDCursors();
                });
                return result2;
            }, it -> {
                if (EventQueue.isDispatchThread()) {
                    it.run();
                } else {
                    EventQueue.invokeLater(it);
                }
            }));
        }
        activity.end();
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        activity = StartUpMeasurer.startActivity((String)"config path computing");
        Path configPath = StartupUtil.canonicalPath(PathManager.getConfigPath());
        Path systemPath = StartupUtil.canonicalPath(PathManager.getSystemPath());
        activity = activity.endAndStart("config path existence check");
        boolean configImportNeeded = !Main.isHeadless() && (!Files.exists(configPath, new LinkOption[0]) || Files.exists(configPath.resolve("migrate.config"), new LinkOption[0]));
        activity = activity.endAndStart("system dirs checking");
        if (!StartupUtil.checkSystemDirs(configPath, systemPath)) {
            System.exit(5);
        }
        activity = activity.endAndStart("system dirs locking");
        StartupUtil.lockSystemDirs(configPath, systemPath, args);
        activity = activity.endAndStart("file logger configuration");
        Logger log = StartupUtil.setupLogger();
        activity.end();
        if (!configImportNeeded) {
            ZipFilePool.POOL = new ZipFilePoolImpl();
            PluginManagerCore.scheduleDescriptorLoading();
        }
        Java11Shim.INSTANCE = new Java11ShimImpl();
        forkJoinPool.execute(() -> {
            StartupUtil.setupSystemLibraries();
            StartupUtil.logEssentialInfoAboutIde(log, ApplicationInfoImpl.getShadowInstance(), args);
            StartupUtil.loadSystemLibraries(log);
        });
        shellEnvLoadFuture = forkJoinPool.submit(() -> EnvironmentUtil.loadEnvironment((Activity)StartUpMeasurer.startActivity((String)"environment loading")));
        Thread.currentThread().setUncaughtExceptionHandler((__, e) -> StartupAbortedException.processException(e));
        if (!configImportNeeded) {
            StartupUtil.runPreAppClass(log, args);
        }
        @Nullable CompletionStage prepareUiFuture = ((CompletableFuture)((CompletableFuture)agreementDialogWasShown).thenRunAsync(() -> {
            StartupUtil.patchSystem(log);
            if (!Main.isHeadless()) {
                EventQueue.invokeLater(() -> {
                    StartupUiUtil.configureHtmlKitStylesheet();
                    WeakFocusStackManager.getInstance();
                });
                if (SystemInfoRt.isMac) {
                    ForkJoinPool.commonPool().execute(() -> {
                        Activity subActivity = StartUpMeasurer.startActivity((String)"mac app init");
                        MacOSApplicationProvider.initApplication();
                        subActivity.end();
                    });
                }
            }
        }, it -> EventQueue.invokeLater(it))).exceptionally(e -> {
            StartupAbortedException.logAndExit(new StartupAbortedException("UI initialization failed", (Throwable)e), log);
            return null;
        });
        Activity mainClassLoadingWaitingActivity = StartUpMeasurer.startActivity((String)"main class loading waiting");
        CompletionStage future2 = ((CompletableFuture)appStarterFuture.thenCompose(arg_0 -> StartupUtil.lambda$start$16(mainClassLoadingWaitingActivity, configImportNeeded, (CompletableFuture)prepareUiFuture, args, log, (CompletableFuture)agreementDialogWasShown, arg_0))).exceptionally(e -> {
            Throwable unwrappedError = e instanceof CompletionException && e.getCause() != null ? e.getCause() : e;
            StartupAbortedException.logAndExit(new StartupAbortedException("Cannot start app", unwrappedError), log);
            return null;
        });
        do {
            forkJoinPool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        } while (!((CompletableFuture)future2).isDone());
        log.info("notify that start-up thread is free");
        AWTAutoShutdown.getInstance().notifyThreadFree(busyThread);
    }

    private static boolean checkGraphics() {
        if (GraphicsEnvironment.isHeadless()) {
            Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.startup.error", (Object[])new Object[0]), (String)BootstrapBundle.message((String)"bootstrap.error.message.no.graphics.environment", (Object[])new Object[0]), (boolean)true);
            return false;
        }
        return true;
    }

    public static int processWindowsLauncherCommandLine(String currentDirectory, String[] args) {
        return LISTENER.apply(currentDirectory, args);
    }

    public static boolean isUsingSeparateWriteThread() {
        return Boolean.getBoolean(USE_SEPARATE_WRITE_THREAD_PROPERTY);
    }

    public static synchronized void addExternalInstanceListener(@NotNull Function<List<String>, Future<CliResult>> processor2) {
        if (processor2 == null) {
            StartupUtil.$$$reportNull$$$0(3);
        }
        if (socketLock == null) {
            throw new AssertionError((Object)"Not initialized yet");
        }
        socketLock.setCommandProcessor(processor2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static synchronized BuiltInServer getServer() {
        return socketLock == null ? null : socketLock.getServer();
    }

    @NotNull
    public static synchronized CompletableFuture<BuiltInServer> getServerFuture() {
        CompletableFuture<BuiltInServer> serverFuture = socketLock == null ? null : socketLock.getServerFuture();
        CompletableFuture<Object> completableFuture = serverFuture == null ? CompletableFuture.completedFuture(null) : serverFuture;
        if (completableFuture == null) {
            StartupUtil.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    public static @NotNull Future<@Nullable Boolean> getShellEnvLoadingFuture() {
        Future<Boolean> future2 = shellEnvLoadFuture;
        if (future2 == null) {
            StartupUtil.$$$reportNull$$$0(5);
        }
        return future2;
    }

    private static CompletableFuture<@Nullable(value="if accepted") Object> scheduleEuaDocumentLoading() {
        return CompletableFuture.supplyAsync(() -> {
            String vendorAsProperty = System.getProperty("idea.vendor.name", "");
            if (vendorAsProperty.isEmpty() ? !ApplicationInfoImpl.getShadowInstance().isVendorJetBrains() : !"JetBrains".equals(vendorAsProperty)) {
                return null;
            }
            Activity activity = StartUpMeasurer.startActivity((String)"eua getting");
            EndUserAgreement.Document document = EndUserAgreement.getLatestDocument();
            activity = activity.endAndStart("eua is accepted checking");
            if (document.isAccepted()) {
                document = null;
            }
            activity.end();
            return document;
        }, ForkJoinPool.commonPool());
    }

    private static void runPreAppClass(Logger log, String[] args) {
        String classBeforeAppProperty = System.getProperty(IDEA_CLASS_BEFORE_APPLICATION_PROPERTY);
        if (classBeforeAppProperty != null) {
            Activity activity = StartUpMeasurer.startActivity((String)"pre app class running");
            try {
                Class<?> clazz = Class.forName(classBeforeAppProperty);
                Method invokeMethod = clazz.getDeclaredMethod("invoke", String[].class);
                invokeMethod.setAccessible(true);
                invokeMethod.invoke(null, new Object[]{args});
            }
            catch (Exception e) {
                log.error("Failed pre-app class init for class " + classBeforeAppProperty, (Throwable)e);
            }
            activity.end();
        }
    }

    private static void importConfig(List<String> args, Logger log, AppStarter appStarter, CompletableFuture<Boolean> agreementShown) throws Exception {
        Activity activity = StartUpMeasurer.startActivity((String)"screen reader checking");
        try {
            EventQueue.invokeAndWait(AccessibilityUtils::enableScreenReaderSupportIfNecessary);
        }
        catch (Throwable e) {
            log.error(e);
        }
        activity = activity.endAndStart("config importing");
        appStarter.beforeImportConfigs();
        Path newConfigDir = PathManager.getConfigDir();
        EventQueue.invokeAndWait(() -> ConfigImportHelper.importConfigsTo((Boolean)agreementShown.join(), newConfigDir, args, log));
        appStarter.importFinished(newConfigDir);
        activity.end();
        if (!PlatformUtils.isRider() || ConfigImportHelper.isConfigImported()) {
            PluginManagerCore.scheduleDescriptorLoading();
        }
    }

    private static CompletableFuture<?> scheduleInitUi(Thread busyThread) {
        Activity activityQueue = StartUpMeasurer.startActivity((String)"LaF initialization (schedule)");
        CompletionStage initUiFuture = CompletableFuture.runAsync(() -> {
            StartupUtil.checkHiDPISettings();
            StartupUtil.blockATKWrapper();
            System.setProperty("sun.awt.noerasebackground", "true");
            if (System.getProperty("com.jetbrains.suppressWindowRaise") == null) {
                System.setProperty("com.jetbrains.suppressWindowRaise", "true");
            }
            Activity activity = StartUpMeasurer.startActivity((String)"awt toolkit creating");
            Toolkit.getDefaultToolkit();
            activity.end();
            activityQueue.updateThreadName();
        }, ForkJoinPool.commonPool()).thenRunAsync(() -> {
            LookAndFeel baseLaF;
            activityQueue.end();
            Activity activity = null;
            if (!Main.isHeadless()) {
                activity = StartUpMeasurer.startActivity((String)"icon manager activation");
                try {
                    IconManager.activate((IconManager)new CoreIconManager());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new CompletionException(e);
                }
            }
            activity = activity == null ? StartUpMeasurer.startActivity((String)"base LaF creation") : activity.endAndStart("base LaF creation");
            try {
                baseLaF = DarculaLaf.createBaseLaF();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
            activity = activity.endAndStart("base LaF initialization");
            baseLaF.initialize();
            activity = activity.endAndStart("system font data initialization");
            JBUIScale.getSystemFontData(() -> {
                Activity subActivity = StartUpMeasurer.startActivity((String)"base LaF defaults getting");
                UIDefaults result2 = baseLaF.getDefaults();
                subActivity.end();
                return result2;
            });
            activity = activity.endAndStart("scale initialization");
            JBUIScale.scale((float)1.0f);
            activity = activity.endAndStart("LaF initialization");
            try {
                UIManager.setLookAndFeel(new IntelliJLaf(baseLaF));
            }
            catch (UnsupportedLookAndFeelException e) {
                throw new CompletionException(e);
            }
            StartUpMeasurer.setCurrentState((LoadingState)LoadingState.LAF_INITIALIZED);
            activity = activity.endAndStart("awt thread busy notification");
            activity.end();
            AWTAutoShutdown.getInstance().notifyThreadBusy(busyThread);
        }, it -> EventQueue.invokeLater(it));
        if (StartupUtil.isUsingSeparateWriteThread()) {
            return CompletableFuture.allOf(new CompletableFuture[]{initUiFuture, CompletableFuture.runAsync(() -> {
                Activity activity = StartUpMeasurer.startActivity((String)"Write Intent Lock UI class transformer loading");
                try {
                    WriteIntentLockInstrumenter.instrument();
                }
                finally {
                    activity.end();
                }
            }, ForkJoinPool.commonPool())});
        }
        return initUiFuture;
    }

    private static void blockATKWrapper() {
        if (!SystemInfoRt.isLinux || !Boolean.parseBoolean(System.getProperty("linux.jdk.accessibility.atkwrapper.block", "true"))) {
            return;
        }
        Activity activity = StartUpMeasurer.startActivity((String)"atk wrapper blocking");
        if (ScreenReader.isEnabled((String)"org.GNOME.Accessibility.AtkWrapper")) {
            System.setProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
            Logger.getInstance(StartupUiUtil.class).info("org.GNOME.Accessibility.AtkWrapper is blocked, see IDEA-149219");
        }
        activity.end();
    }

    private static void loadSystemFontsAndDnDCursors() {
        Activity activity = StartUpMeasurer.startActivity((String)"system fonts loading");
        new Font("N0nEx1st5ntF0nt", 0, 1).getFamily();
        GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        activity = activity.endAndStart("DnD setup");
        DragSource.getDefaultDragSource();
        activity.end();
    }

    private static boolean showEuaAndScheduleSplashIfNeeded(String[] args, @Nullable Object euaDocument) {
        Activity activity = StartUpMeasurer.startActivity((String)"eua showing");
        EndUserAgreement.Document document = (EndUserAgreement.Document)euaDocument;
        EndUserAgreement.updateCachedContentToLatestBundledVersion();
        if (document != null) {
            Agreements.showEndUserAndDataSharingAgreements(document);
        } else if (AppUIUtil.needToShowUsageStatsConsent()) {
            Agreements.showDataSharingAgreement();
        }
        activity.end();
        if (!Main.isLightEdit()) {
            int showSplash = -1;
            for (String arg : args) {
                if ("splash".equals(arg)) {
                    showSplash = 1;
                    break;
                }
                if (!"nosplash".equals(arg)) continue;
                showSplash = 0;
                break;
            }
            if (showSplash == -1) {
                if (Boolean.getBoolean("nosplash")) {
                    showSplash = 0;
                } else if (Boolean.getBoolean("splash")) {
                    showSplash = 1;
                }
            }
            if (showSplash == 1) {
                Activity prepareSplashActivity = StartUpMeasurer.startActivity((String)"splash preparation");
                SplashManager.scheduleShow();
                prepareSplashActivity.end();
            }
        }
        return document != null;
    }

    private static void updateFrameClassAndWindowIcon() {
        Activity activity = StartUpMeasurer.startActivity((String)"frame class updating");
        AppUIUtil.updateFrameClass(Toolkit.getDefaultToolkit());
        activity = activity.endAndStart("update window icon");
        if (!PluginManagerCore.isRunningFromSources() && !AppUIUtil.isWindowIconAlreadyExternallySet()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
        }
        activity.end();
    }

    private static void configureLog4j() {
        Activity activity = StartUpMeasurer.startActivity((String)"console logger configuration");
        System.setProperty("log4j.defaultInitOverride", "true");
        org.apache.log4j.Logger root2 = org.apache.log4j.Logger.getRootLogger();
        if (!root2.getAllAppenders().hasMoreElements()) {
            root2.setLevel(Level.WARN);
            root2.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        }
        activity.end();
    }

    private static boolean checkJdkVersion() {
        if ("true".equals(System.getProperty("idea.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException | LinkageError e) {
                String message2 = BootstrapBundle.message((String)"bootstrap.error.title.cannot.load.jdk.class.reason.0.please.ensure.you.run.the.ide.on.jdk.rather.than.jre", (Object[])new Object[]{e.getMessage()});
                Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.jdk.required", (Object[])new Object[0]), (String)message2, (boolean)true);
                return false;
            }
        }
        return true;
    }

    @TestOnly
    public static void test_checkHiDPISettings() {
        StartupUtil.checkHiDPISettings();
    }

    private static void checkHiDPISettings() {
        if (!Boolean.parseBoolean(System.getProperty("hidpi", "true"))) {
            System.setProperty("sun.java2d.uiScale.enabled", "false");
        }
    }

    private static boolean checkSystemDirs(Path configPath, Path systemPath) {
        Path tempPath;
        Path logPath;
        if (configPath.equals(systemPath)) {
            Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.invalid.config.or.system.path", (Object[])new Object[0]), (String)BootstrapBundle.message((String)"bootstrap.error.message.config.0.and.system.1.paths.must.be.different", (Object[])new Object[]{"idea.config.path", "idea.system.path"}), (boolean)true);
            return false;
        }
        if (!StartupUtil.checkDirectory(configPath, "Config", "idea.config.path", true, true, false)) {
            return false;
        }
        if (!StartupUtil.checkDirectory(systemPath, "System", "idea.system.path", true, true, false)) {
            return false;
        }
        if (!StartupUtil.checkDirectory(logPath, "Log", "idea.log.path", !(logPath = Path.of(PathManager.getLogPath(), new String[0]).normalize()).startsWith(systemPath), false, false)) {
            return false;
        }
        return StartupUtil.checkDirectory(tempPath, "Temp", "idea.system.path", !(tempPath = Path.of(PathManager.getTempPath(), new String[0]).normalize()).startsWith(systemPath), false, SystemInfoRt.isUnix && !SystemInfoRt.isMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean checkDirectory(Path directory, String kind, String property2, boolean checkWrite, boolean checkLock, boolean checkExec) {
        boolean ec222;
        Path tempFile;
        String reason;
        String problem;
        block30: {
            block29: {
                problem = null;
                reason = null;
                tempFile = null;
                problem = "bootstrap.error.message.check.ide.directory.problem.cannot.create.the.directory";
                reason = "bootstrap.error.message.check.ide.directory.possible.reason.path.is.incorrect";
                if (!Files.isDirectory(directory, new LinkOption[0])) {
                    problem = "bootstrap.error.message.check.ide.directory.problem.cannot.create.the.directory";
                    reason = "bootstrap.error.message.check.ide.directory.possible.reason.directory.is.read.only.or.the.user.lacks.necessary.permissions";
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                if (checkWrite || checkLock || checkExec) {
                    problem = "bootstrap.error.message.check.ide.directory.problem.the.ide.cannot.create.a.temporary.file.in.the.directory";
                    reason = "bootstrap.error.message.check.ide.directory.possible.reason.directory.is.read.only.or.the.user.lacks.necessary.permissions";
                    tempFile = directory.resolve("ij" + new Random().nextInt(Integer.MAX_VALUE) + ".tmp");
                    Files.writeString(tempFile, (CharSequence)"#!/bin/sh\nexit 0", StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                    if (checkLock) {
                        problem = "bootstrap.error.message.check.ide.directory.problem.the.ide.cannot.create.a.lock.in.directory";
                        reason = "bootstrap.error.message.check.ide.directory.possible.reason.the.directory.is.located.on.a.network.disk";
                        try (FileChannel channel2 = FileChannel.open(tempFile, EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);
                             FileLock lock2 = channel2.tryLock();){
                            if (lock2 == null) {
                                throw new IOException("File is locked");
                            }
                            break block29;
                        }
                    }
                    if (checkExec) {
                        problem = "bootstrap.error.message.check.ide.directory.problem.the.ide.cannot.execute.test.script";
                        reason = "bootstrap.error.message.check.ide.directory.possible.reason.partition.is.mounted.with.no.exec.option";
                        Files.getFileAttributeView(tempFile, PosixFileAttributeView.class, new LinkOption[0]).setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
                        int ec222 = new ProcessBuilder(tempFile.toAbsolutePath().toString()).start().waitFor();
                        if (ec222 != 0) {
                            throw new IOException("Unexpected exit value: " + ec222);
                        }
                    }
                }
            }
            ec222 = true;
            if (tempFile == null) break block30;
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (Exception lock2) {
                // empty catch block
            }
        }
        return ec222;
        catch (Exception e) {
            boolean bl;
            block31: {
                try {
                    String title2 = BootstrapBundle.message((String)"bootstrap.error.title.invalid.ide.directory.type.0.directory", (Object[])new Object[]{kind});
                    String advice = SystemInfoRt.isMac && PathManager.getSystemPath().contains(MAGIC_MAC_PATH) ? BootstrapBundle.message((String)"bootstrap.error.message.invalid.ide.directory.trans.located.macos.directory.advice", (Object[])new Object[0]) : BootstrapBundle.message((String)"bootstrap.error.message.invalid.ide.directory.ensure.the.modified.property.0.is.correct", (Object[])new Object[]{property2});
                    String message2 = BootstrapBundle.message((String)"bootstrap.error.message.invalid.ide.directory.problem.0.possible.reason.1.advice.2.location.3.exception.class.4.exception.message.5", (Object[])new Object[]{BootstrapBundle.message((String)problem, (Object[])new Object[0]), BootstrapBundle.message((String)reason, (Object[])new Object[0]), advice, directory, e.getClass().getName(), e.getMessage()});
                    Main.showMessage((String)title2, (String)message2, (boolean)true);
                    bl = false;
                    if (tempFile == null) break block31;
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        try {
                            Files.deleteIfExists(tempFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
    }

    private static void lockSystemDirs(Path configPath, Path systemPath, String[] args) throws Exception {
        if (socketLock != null) {
            throw new AssertionError((Object)"Already initialized");
        }
        socketLock = new SocketLock(configPath, systemPath);
        Map.Entry<SocketLock.ActivationStatus, CliResult> status = socketLock.lockAndTryActivate(args);
        switch (status.getKey()) {
            case NO_INSTANCE: {
                ShutDownTracker.getInstance().registerShutdownTask(() -> {
                    Class<StartupUtil> clazz = StartupUtil.class;
                    synchronized (StartupUtil.class) {
                        socketLock.dispose();
                        socketLock = null;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                });
                break;
            }
            case ACTIVATED: {
                CliResult result2 = status.getValue();
                String message2 = result2.message;
                if (message2 == null) {
                    message2 = "Already running";
                }
                System.out.println(message2);
                System.exit(result2.exitCode);
            }
            case CANNOT_ACTIVATE: {
                String message3 = BootstrapBundle.message((String)"bootstrap.error.message.only.one.instance.of.0.can.be.run.at.a.time", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.too.many.instances", (Object[])new Object[0]), (String)message3, (boolean)true);
                System.exit(6);
            }
        }
    }

    private static Logger setupLogger() {
        try {
            Logger.setFactory((Logger.Factory)new LoggerFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger log = Logger.getInstance(Main.class);
        log.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ShutDownTracker.getInstance().registerShutdownTask(() -> log.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------"));
        if (Boolean.parseBoolean(System.getProperty("intellij.log.stdout", "true"))) {
            System.setOut(new PrintStreamLogger("STDOUT", System.out));
            System.setErr(new PrintStreamLogger("STDERR", System.err));
            LogLog.setQuietMode((boolean)true);
        }
        return log;
    }

    private static void setupSystemLibraries() {
        Activity subActivity = StartUpMeasurer.startActivity((String)"system libs setup");
        String ideTempPath = PathManager.getTempPath();
        if (System.getProperty("jna.tmpdir") == null) {
            System.setProperty("jna.tmpdir", ideTempPath);
        }
        if (System.getProperty("jna.nosys") == null) {
            System.setProperty("jna.nosys", "true");
        }
        if (SystemInfoRt.isWindows && System.getProperty("winp.folder.preferred") == null) {
            System.setProperty("winp.folder.preferred", ideTempPath);
        }
        if (System.getProperty("pty4j.tmpdir") == null) {
            System.setProperty("pty4j.tmpdir", ideTempPath);
        }
        if (System.getProperty("pty4j.preferred.native.folder") == null) {
            System.setProperty("pty4j.preferred.native.folder", Path.of(PathManager.getLibPath(), "pty4j-native").toAbsolutePath().toString());
        }
        subActivity.end();
    }

    private static void loadSystemLibraries(Logger log) {
        Activity activity = StartUpMeasurer.startActivity((String)"system libs loading");
        JnaLoader.load((Logger)log);
        if (SystemInfoRt.isWindows) {
            IdeaWin32.isAvailable();
        }
        activity.end();
    }

    private static void logEssentialInfoAboutIde(Logger log, ApplicationInfo appInfo, String[] args) {
        Activity activity = StartUpMeasurer.startActivity((String)"essential IDE info logging");
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.US).format(appInfo.getBuildDate().getTime());
        log.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asString() + ", " + buildDate + ")");
        log.info("OS: " + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + System.getProperty("os.arch") + ")");
        log.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> jvmOptions = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (jvmOptions != null) {
            log.info("JVM options: " + jvmOptions);
        }
        log.info("args: " + Arrays.toString(args));
        log.info("library path: " + System.getProperty("java.library.path"));
        log.info("boot library path: " + System.getProperty("sun.boot.library.path"));
        StartupUtil.logEnvVar(log, "_JAVA_OPTIONS");
        StartupUtil.logEnvVar(log, "JDK_JAVA_OPTIONS");
        StartupUtil.logEnvVar(log, "JAVA_TOOL_OPTIONS");
        log.info("locale=" + Locale.getDefault() + " JNU=" + System.getProperty("sun.jnu.encoding") + " file.encoding=" + System.getProperty("file.encoding") + "\n  idea.config.path=" + StartupUtil.logPath(PathManager.getConfigPath()) + "\n  idea.system.path=" + StartupUtil.logPath(PathManager.getSystemPath()) + "\n  idea.plugins.path=" + StartupUtil.logPath(PathManager.getPluginsPath()) + "\n  idea.log.path=" + StartupUtil.logPath(PathManager.getLogPath()));
        int cores = Runtime.getRuntime().availableProcessors();
        ForkJoinPool pool = ForkJoinPool.commonPool();
        log.info("CPU cores: " + cores + "; ForkJoinPool.commonPool: " + pool + "; factory: " + pool.getFactory());
        activity.end();
    }

    private static void logEnvVar(Logger log, String var) {
        String value2 = System.getenv(var);
        if (value2 != null) {
            log.info(var + "=" + value2);
        }
    }

    private static String logPath(String path2) {
        try {
            Path configured = Path.of(path2, new String[0]);
            Path real = configured.toRealPath(new LinkOption[0]);
            if (!configured.equals(real)) {
                return path2 + " -> " + real;
            }
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
        return path2;
    }

    public static void runStartupWizard() {
        String stepsDialogName = ApplicationInfoImpl.getShadowInstance().getWelcomeWizardDialog();
        if (stepsDialogName == null) {
            return;
        }
        try {
            Class<?> dialogClass = Class.forName(stepsDialogName);
            Constructor<?> ctor = dialogClass.getConstructor(AppStarter.class);
            ((CommonCustomizeIDEWizardDialog)ctor.newInstance(new Object[]{null})).showIfNeeded();
        }
        catch (Throwable e) {
            Main.showMessage((String)BootstrapBundle.message((String)"bootstrap.error.title.configuration.wizard.failed", (Object[])new Object[0]), (Throwable)e);
            return;
        }
        PluginManagerCore.invalidatePlugins();
        PluginManagerCore.scheduleDescriptorLoading();
    }

    private static void patchSystem(Logger log) {
        assert (EventQueue.isDispatchThread()) : Thread.currentThread();
        Activity activity = StartUpMeasurer.startActivity((String)"event queue replacing");
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof DarculaLaf) {
            ((DarculaLaf)lookAndFeel).ideEventQueueInitialized(eventQueue);
        }
        if (!Main.isHeadless()) {
            if ("true".equals(System.getProperty("idea.check.swing.threading"))) {
                activity = activity.endAndStart("repaint manager set");
                RepaintManager.setCurrentManager(new AssertiveRepaintManager());
            }
            if (SystemInfoRt.isXWindow) {
                activity = activity.endAndStart("linux wm set");
                String wmName = X11UiUtil.getWmName();
                log.info("WM detected: " + wmName + ", desktop: " + Objects.requireNonNullElse(System.getenv("XDG_CURRENT_DESKTOP"), "-"));
                if (wmName != null) {
                    X11UiUtil.patchDetectedWm(wmName);
                }
            }
        }
        AWTExceptionHandler.register();
        activity.end();
    }

    @NotNull
    static Path canonicalPath(@NotNull String path2) {
        Path path3;
        if (path2 == null) {
            StartupUtil.$$$reportNull$$$0(6);
        }
        try {
            path3 = Path.of(new File(path2).getCanonicalPath(), new String[0]);
        }
        catch (IOException ignore) {
            Path path4;
            Path file2 = Path.of(path2, new String[0]);
            try {
                path4 = file2.toAbsolutePath().normalize();
            }
            catch (IOError ignored) {
                Path path5 = file2.normalize();
                if (path5 == null) {
                    StartupUtil.$$$reportNull$$$0(9);
                }
                return path5;
            }
            if (path4 == null) {
                StartupUtil.$$$reportNull$$$0(8);
            }
            return path4;
        }
        if (path3 == null) {
            StartupUtil.$$$reportNull$$$0(7);
        }
        return path3;
    }

    private static /* synthetic */ CompletionStage lambda$start$16(Activity mainClassLoadingWaitingActivity, boolean configImportNeeded, CompletableFuture prepareUiFuture, String[] args, Logger log, CompletableFuture agreementDialogWasShown, AppStarter appStarter) {
        mainClassLoadingWaitingActivity.end();
        if (!Main.isHeadless() && configImportNeeded) {
            prepareUiFuture.join();
            try {
                StartupUtil.importConfig(Arrays.asList(args), log, appStarter, agreementDialogWasShown);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }
        return appStarter.start(Arrays.asList(args), prepareUiFuture);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupTimings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/StartupUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/StartupUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerFuture";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellEnvLoadingFuture";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExternalInstanceListener";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canonicalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Java11ShimImpl
    extends Java11Shim {
        public <K, V> Map<K, V> copyOf(Map<? extends K, ? extends V> map2) {
            return Map.copyOf(map2);
        }

        @NotNull
        public <E> Set<E> copyOf(Set<? extends E> collection) {
            Set<? extends E> set2 = Set.copyOf(collection);
            if (set2 == null) {
                Java11ShimImpl.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @NotNull
        public <E> List<E> copyOfCollection(Collection<? extends E> collection) {
            List<? extends E> list2 = List.copyOf(collection);
            if (list2 == null) {
                Java11ShimImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/idea/StartupUtil$Java11ShimImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyOf";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyOfCollection";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface AppStarter {
        @NotNull
        public CompletableFuture<?> start(@NotNull List<String> var1, @NotNull CompletableFuture<?> var2);

        default public void beforeImportConfigs() {
        }

        default public void importFinished(@NotNull Path newConfigDir) {
            if (newConfigDir == null) {
                AppStarter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfigDir", "com/intellij/idea/StartupUtil$AppStarter", "importFinished"));
        }
    }
}

