/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.actions.EditAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ConversionResultImpl
implements ConversionResult {
    public static final ConversionResultImpl CONVERSION_NOT_NEEDED = new ConversionResultImpl(false, false, false);
    public static final ConversionResultImpl CONVERSION_CANCELED = new ConversionResultImpl(true, true, false);
    public static final ConversionResultImpl ERROR_OCCURRED = new ConversionResultImpl(true, false, true);
    private final boolean myConversionNeeded;
    private final boolean myConversionCanceled;
    private final boolean myErrorOccurred;
    private final Set<Path> myChangedFiles;
    private final Set<Path> myCreatedFiles;

    private ConversionResultImpl(boolean conversionNeeded, boolean conversionCanceled, boolean errorOccurred2) {
        this.myChangedFiles = new HashSet<Path>();
        this.myCreatedFiles = new HashSet<Path>();
        this.myConversionNeeded = conversionNeeded;
        this.myConversionCanceled = conversionCanceled;
        this.myErrorOccurred = errorOccurred2;
    }

    ConversionResultImpl(@NotNull List<ConversionRunner> converters) {
        if (converters == null) {
            ConversionResultImpl.$$$reportNull$$$0(0);
        }
        this.myChangedFiles = new HashSet<Path>();
        this.myCreatedFiles = new HashSet<Path>();
        this.myConversionNeeded = true;
        this.myConversionCanceled = false;
        this.myErrorOccurred = false;
        for (ConversionRunner converter : converters) {
            converter.collectAffectedFiles(this.myChangedFiles);
            this.myCreatedFiles.addAll(converter.getCreatedFiles());
        }
    }

    @Override
    public boolean conversionNotNeeded() {
        return !this.myConversionNeeded;
    }

    @Override
    public boolean openingIsCanceled() {
        return this.myConversionCanceled || this.myErrorOccurred;
    }

    @Override
    public void postStartupActivity(@NotNull Project project) {
        List<VirtualFile> createdFiles;
        Application app2;
        if (project == null) {
            ConversionResultImpl.$$$reportNull$$$0(1);
        }
        if ((app2 = ApplicationManager.getApplication()).isHeadlessEnvironment() || app2.isUnitTestMode()) {
            return;
        }
        List<VirtualFile> changedFiles = ConversionResultImpl.findVirtualFiles(this.myChangedFiles);
        if (!changedFiles.isEmpty()) {
            EditAction.editFilesAndShowErrors(project, changedFiles);
        }
        if (!ConversionResultImpl.containsFilesUnderVcs(createdFiles = ConversionResultImpl.findVirtualFiles(this.myCreatedFiles), project)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Collection selected2 = AbstractVcsHelper.getInstance((Project)project).selectFilesToProcess(createdFiles, VcsBundle.message((String)"dialog.title.files.created", (Object[])new Object[0]), VcsBundle.message((String)"label.select.files.to.be.added.to.version.control", (Object[])new Object[0]), null, null, VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION);
            if (selected2 != null && !selected2.isEmpty()) {
                ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project);
                changeListManager.addUnversionedFiles(null, new ArrayList(selected2));
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static boolean containsFilesUnderVcs(@NotNull List<VirtualFile> files2, Project project) {
        if (files2 == null) {
            ConversionResultImpl.$$$reportNull$$$0(2);
        }
        if (files2.isEmpty()) {
            return false;
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile file2 : files2) {
            if (projectLevelVcsManager.getVcsFor(file2) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<VirtualFile> findVirtualFiles(@NotNull Collection<Path> files2) {
        if (files2 == null) {
            ConversionResultImpl.$$$reportNull$$$0(3);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files2.size());
        for (Path file2 : files2) {
            VirtualFile element2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file2);
            if (element2 == null) continue;
            result2.add(element2);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            ConversionResultImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/impl/ConversionResultImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/impl/ConversionResultImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postStartupActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsFilesUnderVcs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFiles";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

