/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.internal.CaretVisualAttributesDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/SetCaretVisualAttributesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.lang.impl"})
public final class SetCaretVisualAttributesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
        Editor editor3 = editor2;
        CaretModel caretModel = editor3.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        List list2 = caretModel.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.caretModel.allCarets");
        List carets = list2;
        if (carets.isEmpty()) {
            return;
        }
        Object object = CollectionsKt.first((List)carets);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"carets.first()");
        CaretVisualAttributesDialog dialog2 = new CaretVisualAttributesDialog(project2, ((Caret)object).getVisualAttributes());
        if (dialog2.showAndGet()) {
            CaretVisualAttributes attributes2 = dialog2.getAttributes();
            Iterator iterator2 = carets.iterator();
            while (iterator2.hasNext()) {
                Caret caret;
                Caret caret2 = caret = (Caret)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"caret");
                caret2.setVisualAttributes(attributes2);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        Presentation presentation3 = presentation2;
        Project project = e.getProject();
        EditorImpl editor2 = (EditorImpl)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.EDITOR), EditorImpl.class);
        presentation3.setEnabled(project != null && editor2 != null);
    }
}

