/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TestWriteActionUnderProgress
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TestWriteActionUnderProgress.$$$reportNull$$$0(0);
        }
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> TestWriteActionUnderProgress.runProgresses(), 2L, TimeUnit.SECONDS);
    }

    private static void runProgresses() {
        ApplicationImpl app2 = (ApplicationImpl)ApplicationManager.getApplication();
        boolean success2 = app2.runWriteActionWithNonCancellableProgressInDispatchThread("Progress", null, null, TestWriteActionUnderProgress::runIndeterminateProgress);
        assert (success2);
        app2.runWriteActionWithCancellableProgressInDispatchThread("Cancellable progress", null, null, TestWriteActionUnderProgress::runDeterminateProgress);
    }

    private static void runDeterminateProgress(ProgressIndicator indicator2) {
        indicator2.setIndeterminate(false);
        int iterations = 3000;
        indicator2.setText("In background thread");
        for (int i2 = 0; i2 < iterations; ++i2) {
            TimeoutUtil.sleep((long)1L);
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            indicator2.setFraction(((double)i2 + 1.0) / (double)iterations);
            indicator2.setText2(String.valueOf(i2));
            ProgressManager.checkCanceled();
        }
    }

    private static void runIndeterminateProgress(ProgressIndicator indicator2) {
        indicator2.setIndeterminate(true);
        indicator2.setText("In Event Dispatch thread");
        for (int i2 = 0; i2 < 1000; ++i2) {
            TimeoutUtil.sleep((long)5L);
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            indicator2.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/TestWriteActionUnderProgress", "actionPerformed"));
    }
}

