/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cfgView;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowProvider;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ShowControlFlowHandler
implements CodeInsightActionHandler {
    private static final Logger LOGGER = Logger.getInstance(ShowControlFlowHandler.class);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Show control flow group");
    private static final String NO_GRAPHVIZ_HELP = "Probably graphviz is missing.You could install graphviz using `apt install graphviz` or `brew install graphviz`";

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        int offset;
        PsiElement position;
        if (project == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(2);
        }
        if ((position = file2.findElementAt(offset = editor2.getCaretModel().getOffset())) == null) {
            return;
        }
        try {
            File svgFile = FileUtil.createTempFile((String)"control-flow", (String)".svg", (boolean)true);
            String path2 = svgFile.getAbsolutePath();
            boolean success2 = ShowControlFlowHandler.toSvgFile(path2, position);
            if (success2) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    boolean exists = svgFile.exists();
                    VirtualFile fileByUrl = VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)path2));
                    if (fileByUrl != null) {
                        AnAction openInBrowser2 = ActionManager.getInstance().getAction("OpenInBrowser");
                        DataContext dataContext = dataId -> {
                            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                                return fileByUrl;
                            }
                            if (CommonDataKeys.PROJECT.is(dataId)) {
                                return project;
                            }
                            return null;
                        };
                        AnActionEvent action2 = AnActionEvent.createFromDataContext((String)"ShowControlFlow", null, (DataContext)dataContext);
                        openInBrowser2.actionPerformed(action2);
                    } else {
                        LOGGER.error("cannot find file by URL: " + path2 + " " + exists);
                    }
                });
            }
        }
        catch (FileNotFoundException e) {
            NOTIFICATION_GROUP.createNotification("Show CFG:", NO_GRAPHVIZ_HELP, NotificationType.ERROR).setSubtitle(e.getMessage()).notify(project);
            LOGGER.warn((Throwable)e);
        }
        catch (ExecutionException | IOException e) {
            LOGGER.warn(e);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toSvgFile(@NotNull String outSvgFile, @NotNull PsiElement target2) throws IOException, ExecutionException {
        String dotUtilName;
        File dotFullPath;
        if (outSvgFile == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(3);
        }
        if (target2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(4);
        }
        if ((dotFullPath = PathEnvironmentVariableUtil.findInPath((String)(dotUtilName = SystemInfo.isUnix ? "dot" : "dot.exe"))) == null) {
            throw new FileNotFoundException("Cannot find dot utility in path");
        }
        ControlFlow controlFlow = null;
        ControlFlowProvider provider2 = null;
        for (ControlFlowProvider extension2 : (ControlFlowProvider[])ControlFlowProvider.EP_NAME.getExtensions()) {
            controlFlow = extension2.getControlFlow(target2);
            if (controlFlow == null) continue;
            provider2 = extension2;
            break;
        }
        if (controlFlow == null) {
            return false;
        }
        File tmpFile = FileUtil.createTempFile((String)"control-flow", (String)".dot", (boolean)true);
        try {
            FileUtil.writeToFile((File)tmpFile, (String)ShowControlFlowHandler.toDot(controlFlow, provider2));
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{dotFullPath.getAbsolutePath()}).withInput(tmpFile.getAbsoluteFile()).withParameters(new String[]{"-Tsvg", "-o" + outSvgFile, tmpFile.getAbsolutePath()}).withRedirectErrorStream(true);
            ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine);
        }
        finally {
            if (!tmpFile.delete()) {
                LOGGER.warn("Cannot delete tmp file: " + tmpFile);
            }
        }
        return true;
    }

    @NotNull
    private static String toDot(@NotNull ControlFlow flow2, @NotNull ControlFlowProvider provider2) {
        if (flow2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(5);
        }
        if (provider2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(6);
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append("digraph {");
        for (Instruction instruction : flow2.getInstructions()) {
            ShowControlFlowHandler.printInstruction(builder2, instruction, provider2);
            if (instruction instanceof ConditionalInstruction) {
                ConditionalInstruction conditionalInstruction = (ConditionalInstruction)instruction;
                builder2.append("\n").append("Its ").append(conditionalInstruction.getResult()).append(" branch, condition: ").append(conditionalInstruction.getCondition().getText());
            }
            builder2.append("\"").append("]");
            builder2.append(System.lineSeparator());
            if (instruction.allPred().isEmpty()) {
                builder2.append("Entry -> Instruction").append(instruction.num()).append(System.lineSeparator());
            }
            if (instruction.allSucc().isEmpty()) {
                builder2.append("Instruction").append(instruction.num()).append(" -> Exit").append(System.lineSeparator());
            }
            for (Instruction succ : instruction.allSucc()) {
                builder2.append("Instruction").append(instruction.num()).append(" -> ").append("Instruction").append(succ.num()).append(System.lineSeparator());
            }
        }
        builder2.append("}");
        String string = builder2.toString();
        if (string == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void printInstruction(@NotNull StringBuilder builder2, @NotNull Instruction instruction, @NotNull ControlFlowProvider provider2) {
        if (builder2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(8);
        }
        if (instruction == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(9);
        }
        if (provider2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(10);
        }
        PsiElement element2 = instruction.getElement();
        Class<?> instructionClass = instruction.getClass();
        builder2.append("Instruction").append(instruction.num()).append("[font=\"Courier\", label=\"").append(element2 != null ? ShowControlFlowHandler.escape(element2.getText()) : "").append(" \\n(").append(instruction.num()).append(")[").append(element2 != null ? element2.getClass().getSimpleName() : "null").append("]").append(System.lineSeparator()).append("{").append(instructionClass.getSimpleName().isEmpty() ? instructionClass.getSuperclass().getSimpleName() : instructionClass.getSimpleName()).append("}");
        String additionalInfo = provider2.getAdditionalInfo(instruction);
        if (additionalInfo != null) {
            builder2.append("\n{").append(additionalInfo).append("}");
        }
    }

    @NotNull
    private static String escape(@NotNull String text2) {
        if (text2 == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(11);
        }
        String string = StringUtil.replace((String)StringUtil.escapeChars((String)text2, (char[])new char[]{'\"'}), (String)"\n", (String)"\\n");
        if (string == null) {
            ShowControlFlowHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSvgFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/cfgView/ShowControlFlowHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/cfgView/ShowControlFlowHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toDot";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toSvgFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toDot";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printInstruction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

