/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.ngram;

import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import com.intellij.completion.ngram.slp.sequencing.NGramSequencer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u001d\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u001e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH\u0002J\u001d\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u0003J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010$\u001a\u00020\u0003J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/internal/ml/ngram/NGramRecentTokensSequence;", "Ljava/io/Externalizable;", "maxSequenceLength", "", "nGramOrder", "initialSize", "(III)V", "length", "getMaxSequenceLength", "()I", "sequence", "", "start", "add", "", "element", "addWithLimit", "model", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "addWithLimit$intellij_platform_ml_impl", "adjustIndices", "remove", "elementAt", "index", "forget", "indices", "", "forgetUntil", "keep", "forgetUntil$intellij_platform_ml_impl", "grow", "readExternal", "ins", "Ljava/io/ObjectInput;", "size", "subListFromStart", "newLength", "writeExternal", "out", "Ljava/io/ObjectOutput;", "intellij.platform.ml.impl"})
public final class NGramRecentTokensSequence
implements Externalizable {
    private int[] sequence;
    private int start;
    private int length;
    private final int maxSequenceLength;
    private final int nGramOrder;
    private final int initialSize;

    public final void addWithLimit$intellij_platform_ml_impl(@NotNull NGramModel model2, int element2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        if (this.size() >= this.maxSequenceLength) {
            this.forget(model2, this.subListFromStart(this.nGramOrder));
            this.adjustIndices(1);
        }
        this.add(element2);
    }

    public final void forgetUntil$intellij_platform_ml_impl(@NotNull NGramModel model2, int keep) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        int n = this.maxSequenceLength;
        boolean bl = false;
        int forgetLast = this.size() - Math.min(keep, n);
        if (forgetLast > 0) {
            this.forget(model2, this.subListFromStart(forgetLast + this.nGramOrder - 1));
            this.adjustIndices(forgetLast);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void forget(NGramModel model2, List<Integer> indices) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = NGramSequencer.INSTANCE.sequenceForward(indices, this.nGramOrder);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() == this.nGramOrder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sequences = (List)destination$iv$iv;
        model2.getCounter().unCountBatch(sequences);
    }

    private final void add(int element2) {
        int index2 = this.start + this.length;
        while (this.sequence.length < this.maxSequenceLength && this.sequence.length <= index2) {
            this.grow();
        }
        this.sequence[index2 % this.sequence.length] = element2;
        int n = this.length;
        this.length = n + 1;
    }

    private final void adjustIndices(int remove2) {
        this.start = (this.start + remove2) % this.sequence.length;
        this.length -= remove2;
    }

    private final int elementAt(int index2) {
        return this.sequence[(this.start + index2) % this.sequence.length];
    }

    public final int size() {
        return this.length;
    }

    @NotNull
    public final List<Integer> subListFromStart(int newLength) {
        int end = this.start + newLength;
        int size = this.sequence.length;
        if (end <= size) {
            int[] nArray = this.sequence;
            int n = this.start;
            boolean bl = false;
            return ArraysKt.toList((int[])ArraysKt.copyOfRange((int[])nArray, (int)n, (int)end));
        }
        int[] nArray = this.sequence;
        int n = this.start;
        int n2 = 0;
        int[] first = ArraysKt.copyOfRange((int[])nArray, (int)n, (int)size);
        int[] nArray2 = this.sequence;
        n2 = 0;
        int n3 = end % size;
        boolean bl = false;
        int[] second = ArraysKt.copyOfRange((int[])nArray2, (int)n2, (int)n3);
        return ArraysKt.toList((int[])ArraysKt.plus((int[])first, (int[])second));
    }

    private final void grow() {
        int oldLen = this.sequence.length;
        int newLen = oldLen > 0 ? RangesKt.coerceAtMost((int)(oldLen * 2), (int)this.maxSequenceLength) : this.initialSize;
        int[] nArray = this.sequence;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, newLen);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        this.sequence = nArray2;
        ArraysKt.fill$default((int[])this.sequence, (int)Integer.MAX_VALUE, (int)oldLen, (int)0, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int size = this.size();
        out.writeInt(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i2;
            int elementAt = this.elementAt((int)i2);
            out.writeInt(elementAt);
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readExternal(@NotNull ObjectInput ins) throws IOException {
        int size;
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        this.length = size = ins.readInt();
        this.sequence = new int[size];
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i2;
            this.sequence[i2] = ins.readInt();
            ++i2;
        }
    }

    public final int getMaxSequenceLength() {
        return this.maxSequenceLength;
    }

    public NGramRecentTokensSequence(int maxSequenceLength, int nGramOrder, int initialSize) {
        int[] nArray;
        this.maxSequenceLength = maxSequenceLength;
        this.nGramOrder = nGramOrder;
        int n = this.initialSize = initialSize;
        NGramRecentTokensSequence nGramRecentTokensSequence = this;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n2;
            int n5 = n2++;
            nArray = nArray2;
            boolean bl = false;
            nArray[n5] = n3 = Integer.MAX_VALUE;
        }
        nArray = nArray2;
        nGramRecentTokensSequence.sequence = nArray;
    }
}

