/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.internal.retype.RetypeSession;
import com.intellij.internal.retype.RetypeSessionKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/retype/RetypeEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "Lcom/intellij/openapi/util/Key;", "intellij.platform.lang.impl"})
public final class RetypeEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return RetypeSessionKt.getRETYPE_SESSION_NOTIFICATION_KEY();
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!(fileEditor instanceof PsiAwareTextEditorImpl)) {
            return null;
        }
        RetypeSession retypeSession = (RetypeSession)((PsiAwareTextEditorImpl)fileEditor).getEditor().getUserData(RetypeSessionKt.getRETYPE_SESSION_KEY());
        if (retypeSession == null) {
            return null;
        }
        EditorNotificationPanel panel2 = null;
        if (retypeSession.getRetypePaused()) {
            panel2 = new EditorNotificationPanel(fileEditor);
            panel2.setText("Pause retyping. Click on editor to resume");
        } else {
            panel2 = new EditorNotificationPanel(LightColors.SLIGHTLY_GREEN);
            panel2.setText("Retyping");
        }
        panel2.createActionLabel("Stop without report", new Runnable(retypeSession){
            final /* synthetic */ RetypeSession $retypeSession;

            public final void run() {
                this.$retypeSession.stop(false);
            }
            {
                this.$retypeSession = retypeSession;
            }
        });
        return panel2;
    }
}

