/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.TreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/BookmarkUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "bookmarksTotal", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "bookmarksWithLetter", "bookmarksWithLine", "bookmarksWithNumber", "favoriteCustom", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "favoriteDirectories", "favoriteFiles", "favoritesLists", "favoritesTotal", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
public final class BookmarkUsagesCollector
extends ProjectUsagesCollector {
    private final EventLogGroup group = new EventLogGroup("bookmarks", 1);
    private final EventId1<Integer> bookmarksTotal = this.group.registerEvent("bookmarks.total", (EventField)EventFields.Count);
    private final EventId1<Integer> bookmarksWithLine = this.group.registerEvent("bookmarks.with.line", (EventField)EventFields.Count);
    private final EventId1<Integer> bookmarksWithNumber = this.group.registerEvent("bookmarks.with.number.mnemonic", (EventField)EventFields.Count);
    private final EventId1<Integer> bookmarksWithLetter = this.group.registerEvent("bookmarks.with.letter.mnemonic", (EventField)EventFields.Count);
    private final EventId1<Integer> favoritesLists = this.group.registerEvent("favorites.lists", (EventField)EventFields.Count);
    private final EventId1<Integer> favoritesTotal = this.group.registerEvent("favorites.total", (EventField)EventFields.Count);
    private final EventId1<Integer> favoriteFiles = this.group.registerEvent("favorites.files", (EventField)EventFields.Count);
    private final EventId1<Integer> favoriteDirectories = this.group.registerEvent("favorites.directories", (EventField)EventFields.Count);
    private final EventId3<Integer, String, Object> favoriteCustom = this.group.registerEvent("favorites.custom", (EventField)EventFields.Count, (EventField)EventFields.StringValidatedByCustomRule((String)"type", (String)"favorite_type"), (EventField)EventFields.PluginInfoFromInstance);

    @NotNull
    public EventLogGroup getGroup() {
        return this.group;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Object object;
        FavoritesManager favoritesManager;
        char c;
        Bookmark it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Object $this$filter$iv;
        BookmarkManager bookmarkManager;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = false;
        Set result2 = new LinkedHashSet();
        BookmarkManager bookmarkManager2 = bookmarkManager = BookmarkManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)bookmarkManager2, (String)"bookmarkManager");
        Collection<Bookmark> collection = bookmarkManager2.getAllBookmarks();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"bookmarkManager.allBookmarks");
        Collection<Bookmark> bookmarks = collection;
        Collection collection2 = result2;
        Object object2 = this.bookmarksTotal.metric((Object)bookmarks.size());
        boolean bl2 = false;
        collection2.add(object2);
        collection2 = result2;
        object2 = bookmarks;
        EventId1<Integer> eventId1 = this.bookmarksWithLine;
        boolean $i$f$filter = false;
        void var8_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (Bookmark)element$iv$iv;
            boolean bl3 = false;
            if (!it.hasLine()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = eventId1.metric((Object)list2.size());
        $i$f$filter = false;
        collection2.add($this$filter$iv);
        collection2 = result2;
        $this$filter$iv = bookmarks;
        eventId1 = this.bookmarksWithNumber;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (Bookmark)element$iv$iv;
            boolean bl4 = false;
            Bookmark bookmark = it;
            Intrinsics.checkNotNullExpressionValue((Object)bookmark, (String)"it");
            c = bookmark.getMnemonic();
            if (!('0' <= c && '9' >= c)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        $this$filter$iv = eventId1.metric((Object)list2.size());
        $i$f$filter = false;
        collection2.add($this$filter$iv);
        collection2 = result2;
        $this$filter$iv = bookmarks;
        eventId1 = this.bookmarksWithLetter;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (Bookmark)element$iv$iv;
            boolean bl5 = false;
            Bookmark bookmark = it;
            Intrinsics.checkNotNullExpressionValue((Object)bookmark, (String)"it");
            c = bookmark.getMnemonic();
            if (!('A' <= c && 'Z' >= c)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        $this$filter$iv = eventId1.metric((Object)list2.size());
        $i$f$filter = false;
        collection2.add($this$filter$iv);
        FavoritesManager favoritesManager2 = favoritesManager = FavoritesManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)favoritesManager2, (String)"favoritesManager");
        List<String> list3 = favoritesManager2.getAvailableFavoritesListNames();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"favoritesManager.availableFavoritesListNames");
        List<String> listNames = list3;
        Collection $i$f$filter2 = result2;
        $this$filterTo$iv$iv = this.favoritesLists.metric((Object)listNames.size());
        boolean destination$iv$iv2 = false;
        $i$f$filter2.add($this$filterTo$iv$iv);
        int favTotal = 0;
        int favFiles = 0;
        int favDirectories = 0;
        boolean bl6 = false;
        Map favCustom = new LinkedHashMap();
        boolean element$iv$iv2 = false;
        Map favCustomProviders = new LinkedHashMap();
        for (String listName : listNames) {
            List<TreeItem<Pair<AbstractUrl, String>>> urls22;
            Intrinsics.checkNotNullExpressionValue(favoritesManager.getFavoritesListRootUrls(listName), (String)"favoritesManager.getFavo\u2026tesListRootUrls(listName)");
            favTotal += urls22.size();
            object = urls22.iterator();
            while (object.hasNext()) {
                Object object3;
                String type;
                TreeItem<Pair<AbstractUrl, String>> url;
                TreeItem<Pair<AbstractUrl, String>> treeItem = url = object.next();
                Intrinsics.checkNotNullExpressionValue(treeItem, (String)"url");
                AbstractUrl abstractUrl = (AbstractUrl)((Pair)treeItem.getData()).first;
                if (abstractUrl instanceof PsiFileUrl) {
                    ++favFiles;
                    continue;
                }
                if (abstractUrl instanceof DirectoryUrl) {
                    ++favDirectories;
                    continue;
                }
                if (!(abstractUrl instanceof AbstractUrlFavoriteAdapter)) continue;
                FavoriteNodeProvider favoriteNodeProvider = ((AbstractUrlFavoriteAdapter)abstractUrl).getNodeProvider();
                Intrinsics.checkNotNullExpressionValue((Object)favoriteNodeProvider, (String)"abstractUrl.nodeProvider");
                Intrinsics.checkNotNullExpressionValue((Object)favoriteNodeProvider.getFavoriteTypeId(), (String)"abstractUrl.nodeProvider.favoriteTypeId");
                Map $this$getOrPut$iv = favCustom;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(type);
                if (value$iv == null) {
                    boolean bl7 = false;
                    Integer answer$iv = 0;
                    $this$getOrPut$iv.put(type, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                int count = ((Number)object3).intValue();
                favCustom.put(type, count + 1);
                FavoriteNodeProvider favoriteNodeProvider2 = ((AbstractUrlFavoriteAdapter)abstractUrl).getNodeProvider();
                Intrinsics.checkNotNullExpressionValue((Object)favoriteNodeProvider2, (String)"abstractUrl.nodeProvider");
                favCustomProviders.put(type, favoriteNodeProvider2);
            }
        }
        Object object4 = result2;
        Object object5 = this.favoritesTotal.metric((Object)favTotal);
        boolean urls22 = false;
        object4.add(object5);
        object4 = result2;
        object5 = this.favoriteFiles.metric((Object)favFiles);
        urls22 = false;
        object4.add(object5);
        object4 = result2;
        object5 = this.favoriteDirectories.metric((Object)favDirectories);
        urls22 = false;
        object4.add(object5);
        Object urls22 = favCustom;
        boolean url = false;
        object5 = urls22.entrySet().iterator();
        while (object5.hasNext()) {
            void type;
            object = object4 = (Map.Entry)object5.next();
            boolean bl8 = false;
            urls22 = (String)object.getKey();
            object = object4;
            bl8 = false;
            int count = ((Number)object.getValue()).intValue();
            object = result2;
            Integer n = count;
            Object v = favCustomProviders.get(type);
            Intrinsics.checkNotNull(v);
            MetricEvent metricEvent = this.favoriteCustom.metric((Object)n, (Object)type, v);
            boolean bl9 = false;
            object.add(metricEvent);
        }
        return result2;
    }
}

