/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTypeUsageCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("module.facets", 5);
    private static final EventField<String> FACET_TYPE = EventFields.StringValidatedByCustomRule((String)"facet", (String)"facets_type");
    private static final VarargEventId MODULE = GROUP.registerVarargEvent("module.with.facet", new EventField[]{FACET_TYPE, EventFields.PluginInfo});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            FacetTypeUsageCollector.$$$reportNull$$$0(0);
        }
        HashSet<String> facets2 = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (Facet facet2 : FacetManager.getInstance((Module)module).getAllFacets()) {
                facets2.add(facet2.getType().getStringId());
            }
        }
        Set set2 = ContainerUtil.map2Set(facets2, facet -> MODULE.metric(new EventPair[]{FACET_TYPE.with(facet)}));
        if (set2 == null) {
            FacetTypeUsageCollector.$$$reportNull$$$0(1);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FacetTypeUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "facets_type".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(1);
            }
            if ("invalid".equals(data2) || FacetTypeUtilValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    FacetTypeUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            FacetType facet = FacetTypeUtilValidator.findFacetById(data2);
            if (facet == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    FacetTypeUtilValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(facet.getClass());
            context2.setPayload(PLUGIN_INFO, (Object)info2);
            ValidationResultType validationResultType = info2.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        @Nullable
        private static FacetType findFacetById(@NotNull String data2) {
            FacetType[] facets2;
            if (data2 == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(5);
            }
            for (FacetType facet : facets2 = (FacetType[])FacetType.EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)facet.getStringId(), (CharSequence)data2)) continue;
                return facet;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector$FacetTypeUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector$FacetTypeUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findFacetById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

