/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import com.intellij.internal.statistic.utils.EventsRateWindowThrottle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class TypingEventsLogger
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("editor.typing", 3);
    private static final EventId TYPED = GROUP.registerEvent("typed");
    private static final EventId TOO_MANY_EVENTS = GROUP.registerEvent("too.many.events");
    private static final EventsRateWindowThrottle ourThrottle = new EventsRateWindowThrottle(8000, 3600000L, System.currentTimeMillis());

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static void logTypingEvent(@NotNull DataContext dataContext, @NotNull EventId eventId) {
        if (dataContext == null) {
            TypingEventsLogger.$$$reportNull$$$0(0);
        }
        if (eventId == null) {
            TypingEventsLogger.$$$reportNull$$$0(1);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        eventId.log(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "eventId";
                break;
            }
        }
        objectArray[1] = "com/intellij/internal/statistic/collectors/fus/TypingEventsLogger";
        objectArray[2] = "logTypingEvent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TypingEventsListener
    implements AnActionListener {
        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            EventRateThrottleResult result2;
            if (dataContext == null) {
                TypingEventsListener.$$$reportNull$$$0(0);
            }
            if ((result2 = ourThrottle.tryPass(System.currentTimeMillis())) == EventRateThrottleResult.ACCEPT) {
                TypingEventsLogger.logTypingEvent(dataContext, TYPED);
            } else if (result2 == EventRateThrottleResult.DENY_AND_REPORT) {
                TypingEventsLogger.logTypingEvent(dataContext, TOO_MANY_EVENTS);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/internal/statistic/collectors/fus/TypingEventsLogger$TypingEventsListener", "beforeEditorTyping"));
        }
    }
}

