/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonFileType;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonCopyPastePostProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    static final List<TextBlockTransferableData> DATA_LIST = Collections.singletonList(new DumbData());

    @Override
    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(PsiFile file2, Editor editor2, int[] startOffsets, int[] endOffsets) {
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(Transferable content2) {
        List<TextBlockTransferableData> list2 = DATA_LIST;
        if (list2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public void processTransferableData(Project project, Editor editor2, RangeMarker bounds2, int caretOffset, Ref<? super Boolean> indented, List<? extends TextBlockTransferableData> values2) {
        JsonCopyPastePostProcessor.fixCommasOnPaste(project, editor2, bounds2);
    }

    private static void fixCommasOnPaste(@NotNull Project project, @NotNull Editor editor2, @NotNull RangeMarker bounds2) {
        if (project == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(3);
        }
        if (bounds2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(4);
        }
        if (!JsonEditorOptions.getInstance().COMMA_ON_PASTE) {
            return;
        }
        if (!JsonCopyPastePostProcessor.isJsonEditor(project, editor2)) {
            return;
        }
        PsiDocumentManager manager2 = PsiDocumentManager.getInstance((Project)project);
        manager2.commitDocument(editor2.getDocument());
        PsiFile psiFile = manager2.getPsiFile(editor2.getDocument());
        if (psiFile == null) {
            return;
        }
        JsonCopyPastePostProcessor.fixTrailingComma(bounds2, psiFile, manager2);
        JsonCopyPastePostProcessor.fixLeadingComma(bounds2, psiFile, manager2);
    }

    private static boolean isJsonEditor(@NotNull Project project, @NotNull Editor editor2) {
        VirtualFile file2;
        if (project == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(6);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(editor2.getDocument())) == null) {
            return false;
        }
        FileType fileType = file2.getFileType();
        if (fileType instanceof JsonFileType) {
            return true;
        }
        if (!ScratchUtil.isScratch((VirtualFile)file2)) {
            return false;
        }
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument()) instanceof JsonFile;
    }

    private static void fixLeadingComma(@NotNull RangeMarker bounds2, @NotNull PsiFile psiFile, @NotNull PsiDocumentManager manager2) {
        PsiElement startElement;
        PsiElement propertyOrArrayItem;
        if (bounds2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(8);
        }
        if (manager2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(9);
        }
        PsiElement psiElement = propertyOrArrayItem = (startElement = JsonCopyPastePostProcessor.skipWhitespaces(psiFile.findElementAt(bounds2.getStartOffset()))) instanceof JsonProperty ? startElement : JsonCopyPastePostProcessor.getParentPropertyOrArrayItem(startElement);
        if (propertyOrArrayItem == null) {
            return;
        }
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)propertyOrArrayItem);
        if (prevSibling instanceof PsiErrorElement) {
            int offset = prevSibling.getTextRange().getEndOffset();
            ApplicationManager.getApplication().runWriteAction(() -> bounds2.getDocument().insertString(offset, (CharSequence)","));
            manager2.commitDocument(bounds2.getDocument());
        }
    }

    @Nullable
    private static PsiElement getParentPropertyOrArrayItem(@Nullable PsiElement startElement) {
        PsiElement propertyOrArrayItem = PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{JsonProperty.class, JsonArray.class});
        if (propertyOrArrayItem instanceof JsonArray) {
            for (JsonValue value2 : ((JsonArray)propertyOrArrayItem).getValueList()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)value2, (PsiElement)startElement, (boolean)false)) continue;
                return value2;
            }
            return null;
        }
        return propertyOrArrayItem;
    }

    private static void fixTrailingComma(@NotNull RangeMarker bounds2, @NotNull PsiFile psiFile, @NotNull PsiDocumentManager manager2) {
        PsiElement endElement;
        if (bounds2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(11);
        }
        if (manager2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(12);
        }
        if ((endElement = JsonCopyPastePostProcessor.skipWhitespaces(psiFile.findElementAt(bounds2.getEndOffset() - 1))) != null && endElement.getTextOffset() >= bounds2.getEndOffset()) {
            endElement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endElement);
        }
        if (endElement instanceof LeafPsiElement && ((LeafPsiElement)endElement).getElementType() == JsonElementTypes.COMMA) {
            PsiElement nextNext = JsonCopyPastePostProcessor.skipWhitespaces(endElement.getNextSibling());
            if (nextNext instanceof LeafPsiElement && (((LeafPsiElement)nextNext).getElementType() == JsonElementTypes.R_CURLY || ((LeafPsiElement)nextNext).getElementType() == JsonElementTypes.R_BRACKET)) {
                PsiElement finalEndElement = endElement;
                ApplicationManager.getApplication().runWriteAction(() -> finalEndElement.delete());
            }
        } else {
            PsiElement property2 = JsonCopyPastePostProcessor.getParentPropertyOrArrayItem(endElement);
            if (endElement instanceof PsiErrorElement || property2 != null && JsonCopyPastePostProcessor.skipWhitespaces(property2.getNextSibling()) instanceof PsiErrorElement) {
                PsiElement finalEndElement1 = endElement;
                ApplicationManager.getApplication().runWriteAction(() -> bounds2.getDocument().insertString(JsonCopyPastePostProcessor.getOffset(property2, finalEndElement1), (CharSequence)","));
                manager2.commitDocument(bounds2.getDocument());
            }
        }
    }

    private static int getOffset(@Nullable PsiElement property2, @Nullable PsiElement finalEndElement1) {
        if (finalEndElement1 instanceof PsiErrorElement) {
            return finalEndElement1.getTextOffset();
        }
        assert (finalEndElement1 != null);
        return property2 != null ? property2.getTextRange().getEndOffset() : finalEndElement1.getTextOffset();
    }

    @Nullable
    private static PsiElement skipWhitespaces(@Nullable PsiElement element2) {
        while (element2 instanceof PsiWhiteSpace) {
            element2 = element2.getNextSibling();
        }
        return element2;
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project) {
        if (editor2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(13);
        }
        if (project == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(14);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/JsonCopyPastePostProcessor";
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/JsonCopyPastePostProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fixCommasOnPaste";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isJsonEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fixLeadingComma";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fixTrailingComma";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class DumbData
    implements TextBlockTransferableData {
        private static final DataFlavor DATA_FLAVOR = new DataFlavor(JsonCopyPastePostProcessor.class, "class: JsonCopyPastePostProcessor");

        DumbData() {
        }

        @Override
        public DataFlavor getFlavor() {
            return DATA_FLAVOR;
        }

        @Override
        public int getOffsetCount() {
            return 0;
        }

        @Override
        public int getOffsets(int[] offsets2, int index2) {
            return index2;
        }

        @Override
        public int setOffsets(int[] offsets2, int index2) {
            return index2;
        }
    }
}

