/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsonRainbowVisitor
extends RainbowVisitor {
    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JsonRainbowVisitor.$$$reportNull$$$0(0);
        }
        return file2 instanceof JsonFile;
    }

    @Override
    public void visit(@NotNull PsiElement element2) {
        if (element2 == null) {
            JsonRainbowVisitor.$$$reportNull$$$0(1);
        }
        if (element2 instanceof JsonProperty) {
            JsonPointerPosition position;
            PsiFile file2 = element2.getContainingFile();
            String fileName = file2.getName();
            if (Holder.blacklist.containsKey(fileName) && (position = JsonOriginalPsiWalker.INSTANCE.findPosition(element2, false)) != null && Holder.blacklist.get(fileName).contains(position.toJsonPointer())) {
                return;
            }
            String name2 = ((JsonProperty)element2).getName();
            this.addInfo(this.getInfo((PsiElement)file2, ((JsonProperty)element2).getNameElement(), name2, JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY));
            JsonValue value2 = ((JsonProperty)element2).getValue();
            if (value2 instanceof JsonObject) {
                this.addInfo(this.getInfo((PsiElement)file2, value2.getFirstChild(), name2, JsonSyntaxHighlighterFactory.JSON_BRACES));
                this.addInfo(this.getInfo((PsiElement)file2, value2.getLastChild(), name2, JsonSyntaxHighlighterFactory.JSON_BRACES));
            } else if (value2 instanceof JsonArray) {
                this.addInfo(this.getInfo((PsiElement)file2, value2.getFirstChild(), name2, JsonSyntaxHighlighterFactory.JSON_BRACKETS));
                this.addInfo(this.getInfo((PsiElement)file2, value2.getLastChild(), name2, JsonSyntaxHighlighterFactory.JSON_BRACKETS));
                for (JsonValue jsonValue : ((JsonArray)value2).getValueList()) {
                    this.addSimpleValueInfo(name2, file2, jsonValue);
                }
            } else {
                this.addSimpleValueInfo(name2, file2, value2);
            }
        }
    }

    private void addSimpleValueInfo(String name2, PsiFile file2, JsonValue value2) {
        if (value2 instanceof JsonStringLiteral) {
            this.addInfo(this.getInfo((PsiElement)file2, value2, name2, JsonSyntaxHighlighterFactory.JSON_STRING));
        } else if (value2 instanceof JsonNumberLiteral) {
            this.addInfo(this.getInfo((PsiElement)file2, value2, name2, JsonSyntaxHighlighterFactory.JSON_NUMBER));
        } else if (value2 instanceof JsonLiteral) {
            this.addInfo(this.getInfo((PsiElement)file2, value2, name2, JsonSyntaxHighlighterFactory.JSON_KEYWORD));
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new JsonRainbowVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/highlighting/JsonRainbowVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suitableForFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final Map<String, Set<String>> blacklist = Holder.createBlacklist();

        private Holder() {
        }

        private static Map<String, Set<String>> createBlacklist() {
            HashMap<String, Set<String>> blacklist = new HashMap<String, Set<String>>();
            blacklist.put("package.json", ContainerUtil.set((Object[])new String[]{"/dependencies", "/devDependencies", "/peerDependencies", "/scripts", "/directories", "/optionalDependencies"}));
            return blacklist;
        }
    }
}

