/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.ui.EvaluateResult;
import com.intellij.jsonpath.ui.IncorrectDocument;
import com.intellij.jsonpath.ui.IncorrectExpression;
import com.intellij.jsonpath.ui.ResultNotFound;
import com.intellij.jsonpath.ui.ResultString;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluator;", "", "jsonFile", "Lcom/intellij/json/psi/JsonFile;", "expression", "", "evalOptions", "", "Lcom/jayway/jsonpath/Option;", "(Lcom/intellij/json/psi/JsonFile;Ljava/lang/String;Ljava/util/Set;)V", "getEvalOptions", "()Ljava/util/Set;", "getExpression", "()Ljava/lang/String;", "getJsonFile", "()Lcom/intellij/json/psi/JsonFile;", "evaluate", "Lcom/intellij/jsonpath/ui/EvaluateResult;", "toResultString", "config", "Lcom/jayway/jsonpath/Configuration;", "result", "intellij.json"})
public final class JsonPathEvaluator {
    @Nullable
    private final JsonFile jsonFile;
    @NotNull
    private final String expression;
    @NotNull
    private final Set<Option> evalOptions;

    @Nullable
    public final EvaluateResult evaluate() {
        Object object;
        DocumentContext documentContext;
        String json;
        JsonPath jsonPath;
        try {
            if (StringsKt.isBlank((CharSequence)this.expression)) {
                return null;
            }
            JsonPath jsonPath2 = JsonPath.compile((String)this.expression, (Predicate[])new Predicate[0]);
            Intrinsics.checkNotNullExpressionValue((Object)jsonPath2, (String)"JsonPath.compile(expression)");
            jsonPath = jsonPath2;
        }
        catch (InvalidPathException ip) {
            String string = ip.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip.localizedMessage");
            return new IncorrectExpression(string);
        }
        JsonPath jsonPath3 = jsonPath;
        Configuration config2 = new Configuration.ConfigurationBuilder().options(this.evalOptions).build();
        JsonFile jsonFile = this.jsonFile;
        String string = json = jsonFile != null ? jsonFile.getText() : null;
        if (json == null) {
            String string2 = JsonBundle.message("jsonpath.evaluate.file.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JsonBundle.message(\"json\u2026evaluate.file.not.found\")");
            return new IncorrectDocument(string2);
        }
        try {
            DocumentContext documentContext2 = JsonPath.parse((String)json, (Configuration)config2);
            Intrinsics.checkNotNullExpressionValue((Object)documentContext2, (String)"JsonPath.parse(json, config)");
            documentContext = documentContext2;
        }
        catch (IllegalArgumentException e) {
            String string3 = e.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"e.localizedMessage");
            return new IncorrectDocument(string3);
        }
        catch (InvalidJsonException ej) {
            if (Intrinsics.areEqual((Object)ej.getCause(), (Object)((Object)ej)) ^ true) {
                String string4 = ej.getMessage();
                if (string4 == null) {
                    string4 = "";
                }
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"ParseException", (boolean)false, (int)2, null)) {
                    String message2;
                    Throwable throwable = ej.getCause();
                    String string5 = message2 = throwable != null ? throwable.getLocalizedMessage() : null;
                    if (message2 != null) {
                        return new IncorrectDocument(message2);
                    }
                }
            }
            String string6 = ej.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"ej.localizedMessage");
            return new IncorrectDocument(string6);
        }
        DocumentContext jsonDocument = documentContext;
        try {
            object = jsonDocument.read(jsonPath3);
        }
        catch (PathNotFoundException pe) {
            String string7 = pe.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"pe.localizedMessage");
            return new ResultNotFound(string7);
        }
        catch (JsonPathException jpe) {
            String string8 = jpe.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"jpe.localizedMessage");
            return new ResultNotFound(string8);
        }
        catch (IllegalStateException ise) {
            String string9 = ise.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"ise.localizedMessage");
            return new ResultNotFound(string9);
        }
        Object result2 = object;
        Configuration configuration2 = config2;
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"config");
        return new ResultString(this.toResultString(configuration2, result2));
    }

    private final String toResultString(Configuration config2, Object result2) {
        if (result2 == null) {
            return "null";
        }
        if (result2 instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)((String)result2)) + "\"";
        }
        if (ClassUtil.isPrimitive(result2.getClass())) {
            return result2.toString();
        }
        if (result2 instanceof Collection) {
            return "[" + CollectionsKt.joinToString$default((Iterable)((Iterable)result2), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(this, config2){
                final /* synthetic */ JsonPathEvaluator this$0;
                final /* synthetic */ Configuration $config;

                @NotNull
                public final CharSequence invoke(@Nullable Object it) {
                    return JsonPathEvaluator.access$toResultString(this.this$0, this.$config, it);
                }
                {
                    this.this$0 = jsonPathEvaluator;
                    this.$config = configuration2;
                    super(1);
                }
            }), (int)30, null) + "]";
        }
        String string = config2.jsonProvider().toJson(result2);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final JsonFile getJsonFile() {
        return this.jsonFile;
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @NotNull
    public final Set<Option> getEvalOptions() {
        return this.evalOptions;
    }

    public JsonPathEvaluator(@Nullable JsonFile jsonFile, @NotNull String expression, @NotNull Set<? extends Option> evalOptions) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(evalOptions, (String)"evalOptions");
        this.jsonFile = jsonFile;
        this.expression = expression;
        this.evalOptions = evalOptions;
    }

    public static final /* synthetic */ String access$toResultString(JsonPathEvaluator $this, Configuration config2, Object result2) {
        return $this.toResultString(config2, result2);
    }
}

