/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.actions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.ide.DocumentationBrowserFacade;
import com.intellij.lang.documentation.ide.IdeDocumentationTargetProvider;
import com.intellij.lang.documentation.ide.impl.DocumentationBrowser;
import com.intellij.lang.documentation.ide.impl.DocumentationHistory;
import com.intellij.lang.documentation.ide.ui.DocumentationToolWindowUI;
import com.intellij.lang.documentation.ide.ui.DocumentationToolWindowUIKt;
import com.intellij.lang.documentation.psi.PsiElementDocumentationTarget;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.lang.documentation.symbol.impl.ImplKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001e\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\bH\u0000\u001a\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\bH\u0000\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u001a(\u0010#\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"DOCUMENTATION_BROWSER", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/lang/documentation/ide/DocumentationBrowserFacade;", "DOCUMENTATION_POPUP", "Lcom/intellij/openapi/ui/popup/JBPopup;", "getDOCUMENTATION_POPUP", "()Lcom/intellij/openapi/actionSystem/DataKey;", "DOCUMENTATION_TARGETS", "", "Lcom/intellij/lang/documentation/DocumentationTarget;", "PRIMARY_GROUP_ID", "", "TOGGLE_AUTO_SHOW_ACTION_ID", "TOGGLE_AUTO_UPDATE_ACTION_ID", "TOGGLE_SHOW_IN_POPUP_ACTION_ID", "documentationBrowser", "Lcom/intellij/lang/documentation/ide/impl/DocumentationBrowser;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "documentationHistory", "Lcom/intellij/lang/documentation/ide/impl/DocumentationHistory;", "documentationTargets", "documentationTargetsInner", "documentationToolWindowUI", "Lcom/intellij/lang/documentation/ide/ui/DocumentationToolWindowUI;", "groupActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "groupId", "navigationActions", "primaryActions", "registerBackForwardActions", "", "component", "Ljavax/swing/JComponent;", "targetsFromEditor", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "intellij.platform.lang.impl"})
public final class ActionsKt {
    @JvmField
    @NotNull
    public static final DataKey<List<DocumentationTarget>> DOCUMENTATION_TARGETS;
    @JvmField
    @NotNull
    public static final DataKey<DocumentationBrowserFacade> DOCUMENTATION_BROWSER;
    @NotNull
    private static final DataKey<JBPopup> DOCUMENTATION_POPUP;
    @NotNull
    public static final String PRIMARY_GROUP_ID = "Documentation.PrimaryGroup";
    @NotNull
    public static final String TOGGLE_SHOW_IN_POPUP_ACTION_ID = "Documentation.ToggleShowInPopup";
    @NotNull
    public static final String TOGGLE_AUTO_SHOW_ACTION_ID = "Documentation.ToggleAutoShow";
    @NotNull
    public static final String TOGGLE_AUTO_UPDATE_ACTION_ID = "Documentation.ToggleAutoUpdate";

    @NotNull
    public static final DataKey<JBPopup> getDOCUMENTATION_POPUP() {
        return DOCUMENTATION_POPUP;
    }

    @NotNull
    public static final List<AnAction> primaryActions() {
        return ActionsKt.groupActions(PRIMARY_GROUP_ID);
    }

    @NotNull
    public static final List<AnAction> navigationActions() {
        return ActionsKt.groupActions("Documentation.Navigation");
    }

    private static final List<AnAction> groupActions(String groupId2) {
        ActionGroup actionGroup2 = ActionUtil.getActionGroup((String)groupId2);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (actionGroup2 == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        AnAction[] anActionArray = actionGroup2.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"requireNotNull(ActionUti\u2026oupId)).getChildren(null)");
        return CollectionsKt.listOf((Object[])Arrays.copyOf(anActionArray, anActionArray.length));
    }

    public static final void registerBackForwardActions(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        EmptyAction.registerWithShortcutSet((String)"Documentation.Back", (ShortcutSet)((ShortcutSet)new CustomShortcutSet(new Shortcut[]{(Shortcut)KeyboardShortcut.fromString((String)(ScreenReader.isActive() ? "alt LEFT" : "LEFT")), (Shortcut)KeymapUtil.parseMouseShortcut((String)"button4")})), (JComponent)component2);
        EmptyAction.registerWithShortcutSet((String)"Documentation.Forward", (ShortcutSet)((ShortcutSet)new CustomShortcutSet(new Shortcut[]{(Shortcut)KeyboardShortcut.fromString((String)(ScreenReader.isActive() ? "alt RIGHT" : "RIGHT")), (Shortcut)KeymapUtil.parseMouseShortcut((String)"button5")})), (JComponent)component2);
    }

    @VisibleForTesting
    @NotNull
    public static final List<DocumentationTarget> documentationTargets(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        try {
            return ActionsKt.documentationTargetsInner(dc);
        }
        catch (IndexNotReadyException ignored) {
            return CollectionsKt.emptyList();
        }
    }

    private static final List<DocumentationTarget> documentationTargetsInner(DataContext dc) {
        PsiElement targetElement;
        List<DocumentationTarget> contextTargets = dc.getData(DOCUMENTATION_TARGETS);
        if (contextTargets != null) {
            return contextTargets;
        }
        Project project = (Project)dc.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"dc.getData(CommonDataKey\u2026    ?: return emptyList()");
        Project project2 = project;
        Editor editor2 = (Editor)dc.getData(CommonDataKeys.EDITOR);
        if (editor2 != null) {
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            List<DocumentationTarget> editorTargets = ActionsKt.targetsFromEditor(project2, editor2, caretModel.getOffset());
            if (editorTargets != null) {
                return editorTargets;
            }
        }
        List symbols = (List)dc.getData(CommonDataKeys.SYMBOLS);
        Collection collection = symbols;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            List<DocumentationTarget> symbolTargets = ImplKt.symbolDocumentationTargets(project2, symbols);
            Collection collection2 = symbolTargets;
            bl2 = false;
            if (!collection2.isEmpty()) {
                return symbolTargets;
            }
        }
        if ((targetElement = (PsiElement)dc.getData(CommonDataKeys.PSI_ELEMENT)) != null) {
            DocumentationTarget documentationTarget = UtilKt.psiDocumentationTarget(targetElement);
            if (documentationTarget == null) {
                documentationTarget = new PsiElementDocumentationTarget(project2, targetElement);
            }
            return CollectionsKt.listOf((Object)documentationTarget);
        }
        return CollectionsKt.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public static final List<DocumentationTarget> targetsFromEditor(@NotNull Project project, @NotNull Editor editor2, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiUtilBase.getPsiFileIn\u2026           ?: return null");
        PsiFile file2 = psiFile;
        IdeDocumentationTargetProvider ideDocumentationTargetProvider = IdeDocumentationTargetProvider.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)ideDocumentationTargetProvider, (String)"IdeDocumentationTargetPr\u2026ider.getInstance(project)");
        IdeDocumentationTargetProvider ideTargetProvider = ideDocumentationTargetProvider;
        LookupEx lookup2 = LookupManager.getActiveLookup(editor2);
        if (lookup2 != null) {
            LookupElement lookupElement = lookup2.getCurrentItem();
            if (lookupElement == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"lookup.currentItem\n     \u2026           ?: return null");
            LookupElement lookupElement2 = lookupElement;
            DocumentationTarget documentationTarget = ideTargetProvider.documentationTarget(editor2, file2, lookupElement2);
            if (documentationTarget == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)documentationTarget, (String)"ideTargetProvider.docume\u2026           ?: return null");
            DocumentationTarget target2 = documentationTarget;
            return CollectionsKt.listOf((Object)target2);
        }
        List<DocumentationTarget> list2 = ideTargetProvider.documentationTargets(editor2, file2, offset);
        boolean bl = false;
        boolean bl2 = false;
        List<DocumentationTarget> it = list2;
        boolean bl3 = false;
        List<DocumentationTarget> list3 = it;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"it");
        Collection collection = list3;
        boolean bl4 = false;
        return !collection.isEmpty() ? list2 : null;
    }

    @Nullable
    public static final DocumentationHistory documentationHistory(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        DocumentationBrowser documentationBrowser = ActionsKt.documentationBrowser(dc);
        return documentationBrowser != null ? documentationBrowser.getHistory() : null;
    }

    @Nullable
    public static final DocumentationBrowser documentationBrowser(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        DocumentationBrowserFacade browser2 = dc.getData(DOCUMENTATION_BROWSER);
        if (browser2 != null) {
            return (DocumentationBrowser)browser2;
        }
        DocumentationToolWindowUI documentationToolWindowUI = ActionsKt.documentationToolWindowUI(dc);
        return documentationToolWindowUI != null ? documentationToolWindowUI.getBrowser() : null;
    }

    @Nullable
    public static final DocumentationToolWindowUI documentationToolWindowUI(@NotNull DataContext dc) {
        Content content2;
        Content content3;
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        ToolWindow toolWindow2 = (ToolWindow)dc.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)toolWindow2, (String)"dc.getData(PlatformDataK\u2026           ?: return null");
        ToolWindow toolWindow3 = toolWindow2;
        if (Intrinsics.areEqual((Object)toolWindow3.getId(), (Object)"documentation.v2") ^ true) {
            return null;
        }
        Component component2 = (Component)dc.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        if (component2 instanceof BaseLabel) {
            content3 = ((BaseLabel)component2).getContent();
        } else {
            ContentManager contentManager2 = toolWindow3.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"toolWindow.contentManager");
            content3 = contentManager2.getSelectedContent();
        }
        Content content4 = content2 = content3;
        return content4 != null ? DocumentationToolWindowUIKt.getToolWindowUI(content4) : null;
    }

    static {
        DataKey dataKey = DataKey.create("documentation.targets");
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DataKey.create(\"documentation.targets\")");
        DOCUMENTATION_TARGETS = dataKey;
        DataKey dataKey2 = DataKey.create("documentation.browser");
        Intrinsics.checkNotNullExpressionValue(dataKey2, (String)"DataKey.create(\"documentation.browser\")");
        DOCUMENTATION_BROWSER = dataKey2;
        DataKey dataKey3 = DataKey.create("documentation.popup");
        Intrinsics.checkNotNullExpressionValue(dataKey3, (String)"DataKey.create(\"documentation.popup\")");
        DOCUMENTATION_POPUP = dataKey3;
    }
}

