/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation.ide.actions;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.lang.documentation.ide.DocumentationBrowserFacade;
import com.intellij.lang.documentation.ide.actions.ActionsKt;
import com.intellij.lang.documentation.ide.impl.DocumentationBrowser;
import com.intellij.lang.documentation.ide.impl.LinksKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/documentation/ide/actions/DocumentationViewExternalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/codeInsight/hint/HintManagerImpl$ActionToIgnore;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "browser", "Lcom/intellij/lang/documentation/ide/impl/DocumentationBrowser;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "update", "intellij.platform.lang.impl"})
public final class DocumentationViewExternalAction
extends AnAction
implements HintManagerImpl.ActionToIgnore {
    private final DocumentationBrowser browser(DataContext dc) {
        DocumentationBrowserFacade documentationBrowserFacade = dc.getData(ActionsKt.DOCUMENTATION_BROWSER);
        if (!(documentationBrowserFacade instanceof DocumentationBrowser)) {
            documentationBrowserFacade = null;
        }
        return (DocumentationBrowser)documentationBrowserFacade;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        DocumentationBrowser documentationBrowser = this.browser(dataContext);
        presentation2.setEnabledAndVisible((documentationBrowser != null ? documentationBrowser.currentExternalUrl() : null) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        DocumentationBrowser documentationBrowser = this.browser(dataContext);
        if (documentationBrowser == null) {
            return;
        }
        DocumentationBrowser browser2 = documentationBrowser;
        String string = browser2.currentExternalUrl();
        if (string == null) {
            return;
        }
        String url = string;
        LinksKt.openUrl(project2, browser2.getTargetPointer(), url);
    }
}

