/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.search.PsiSymbolDeclarationSearchParameters;
import com.intellij.model.search.PsiSymbolReferenceSearchParameters;
import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.impl.CompositeQuery;
import com.intellij.model.search.impl.SearchParametersQuery;
import com.intellij.model.search.impl.SearchWordQueryBuilderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u00040\u0007H\u0016J\"\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\nH\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/model/search/impl/SearchServiceImpl;", "Lcom/intellij/model/search/SearchService;", "()V", "merge", "Lcom/intellij/util/Query;", "T", "queries", "", "searchParameters", "parameters", "Lcom/intellij/model/search/SearchParameters;", "searchPsiSymbolDeclarations", "Lcom/intellij/model/psi/PsiSymbolDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchPsiSymbolReferences", "Lcom/intellij/model/psi/PsiSymbolReference;", "searchWord", "Lcom/intellij/model/search/SearchWordQueryBuilder;", "word", "", "DefaultPsiSymbolDeclarationSearchParameters", "DefaultPsiSymbolReferenceSearchParameters", "DefaultSymbolSearchParameters", "intellij.platform.indexing.impl"})
public final class SearchServiceImpl
implements SearchService {
    @NotNull
    public <T> Query<T> searchParameters(@NotNull SearchParameters<T> parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        return new SearchParametersQuery<T>(parameters2);
    }

    @NotNull
    public SearchWordQueryBuilder searchWord(@NotNull Project project, @NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return new SearchWordQueryBuilderImpl(project, word, null, false, null, null, null, null, null, 508, null);
    }

    @NotNull
    public Query<PsiSymbolReference> searchPsiSymbolReferences(@NotNull Project project, @NotNull Symbol symbol, @NotNull SearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Pointer pointer = symbol.createPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"symbol.createPointer()");
        return this.searchParameters((SearchParameters)new DefaultPsiSymbolReferenceSearchParameters(project, (Pointer<? extends Symbol>)pointer, searchScope2));
    }

    @NotNull
    public Query<PsiSymbolDeclaration> searchPsiSymbolDeclarations(@NotNull Project project, @NotNull Symbol symbol, @NotNull SearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Pointer pointer = symbol.createPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"symbol.createPointer()");
        return this.searchParameters((SearchParameters)new DefaultPsiSymbolDeclarationSearchParameters(project, (Pointer<? extends Symbol>)pointer, searchScope2));
    }

    @NotNull
    public <T> Query<? extends T> merge(@NotNull List<? extends Query<? extends T>> queries) {
        Query query2;
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        switch (queries.size()) {
            case 0: {
                Query query3 = EmptyQuery.getEmptyQuery();
                query2 = query3;
                Intrinsics.checkNotNullExpressionValue((Object)query3, (String)"EmptyQuery.getEmptyQuery()");
                break;
            }
            case 1: {
                query2 = queries.get(0);
                break;
            }
            default: {
                query2 = new CompositeQuery((Collection)queries);
            }
        }
        return query2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\u0006R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/model/search/impl/SearchServiceImpl$DefaultSymbolSearchParameters;", "", "project", "Lcom/intellij/openapi/project/Project;", "pointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/model/Symbol;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/model/Pointer;Lcom/intellij/psi/search/SearchScope;)V", "areValid", "", "getProject", "getSearchScope", "getSymbol", "intellij.platform.indexing.impl"})
    private static class DefaultSymbolSearchParameters {
        private final Project project;
        private final Pointer<? extends Symbol> pointer;
        private final SearchScope searchScope;

        public final boolean areValid() {
            return this.pointer.dereference() != null;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Symbol getSymbol() {
            Object object = this.pointer.dereference();
            boolean bl = false;
            boolean bl2 = false;
            if (object == null) {
                boolean bl3 = false;
                String string = "#getSymbol() must not be called on invalid parameters";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return (Symbol)object;
        }

        @NotNull
        public final SearchScope getSearchScope() {
            return this.searchScope;
        }

        public DefaultSymbolSearchParameters(@NotNull Project project, @NotNull Pointer<? extends Symbol> pointer, @NotNull SearchScope searchScope2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
            Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
            this.project = project;
            this.pointer = pointer;
            this.searchScope = searchScope2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/model/search/impl/SearchServiceImpl$DefaultPsiSymbolReferenceSearchParameters;", "Lcom/intellij/model/search/impl/SearchServiceImpl$DefaultSymbolSearchParameters;", "Lcom/intellij/model/search/PsiSymbolReferenceSearchParameters;", "project", "Lcom/intellij/openapi/project/Project;", "pointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/model/Symbol;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/model/Pointer;Lcom/intellij/psi/search/SearchScope;)V", "intellij.platform.indexing.impl"})
    private static final class DefaultPsiSymbolReferenceSearchParameters
    extends DefaultSymbolSearchParameters
    implements PsiSymbolReferenceSearchParameters {
        public DefaultPsiSymbolReferenceSearchParameters(@NotNull Project project, @NotNull Pointer<? extends Symbol> pointer, @NotNull SearchScope searchScope2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
            Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
            super(project, pointer, searchScope2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/model/search/impl/SearchServiceImpl$DefaultPsiSymbolDeclarationSearchParameters;", "Lcom/intellij/model/search/impl/SearchServiceImpl$DefaultSymbolSearchParameters;", "Lcom/intellij/model/search/PsiSymbolDeclarationSearchParameters;", "project", "Lcom/intellij/openapi/project/Project;", "pointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/model/Symbol;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/model/Pointer;Lcom/intellij/psi/search/SearchScope;)V", "intellij.platform.indexing.impl"})
    private static final class DefaultPsiSymbolDeclarationSearchParameters
    extends DefaultSymbolSearchParameters
    implements PsiSymbolDeclarationSearchParameters {
        public DefaultPsiSymbolDeclarationSearchParameters(@NotNull Project project, @NotNull Pointer<? extends Symbol> pointer, @NotNull SearchScope searchScope2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
            Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
            super(project, pointer, searchScope2);
        }
    }
}

