/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u00162\b\b\u0001\u0010\u001a\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\"\u0010\u0019\u001a\u00020\u00132\b\b\u0001\u0010\u001b\u001a\u00020\n2\b\b\u0001\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J@\u0010\u0019\u001a\u00020\u00162\b\b\u0003\u0010\u001b\u001a\u00020\n2\b\b\u0001\u0010\u001a\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J2\u0010\u0019\u001a\u00020\u00132\b\b\u0001\u0010\u001b\u001a\u00020\n2\b\b\u0001\u0010\u001a\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n \u000e*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/notification/SingletonNotificationManager;", "", "group", "Lcom/intellij/notification/NotificationGroup;", "type", "Lcom/intellij/notification/NotificationType;", "defaultListener", "Lcom/intellij/notification/NotificationListener;", "(Lcom/intellij/notification/NotificationGroup;Lcom/intellij/notification/NotificationType;Lcom/intellij/notification/NotificationListener;)V", "groupId", "", "(Ljava/lang/String;Lcom/intellij/notification/NotificationType;)V", "expiredListener", "Ljava/lang/Runnable;", "kotlin.jvm.PlatformType", "notification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "clear", "", "expire", "isVisible", "", "project", "Lcom/intellij/openapi/project/Project;", "notify", "content", "title", "listener", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "customizer", "Ljava/util/function/Consumer;", "intellij.platform.ide.impl"})
public final class SingletonNotificationManager {
    private final NotificationGroup group;
    private final AtomicReference<Notification> notification;
    private NotificationListener defaultListener;
    private final Runnable expiredListener;
    private final NotificationType type;

    public final void notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.notify(title2, content2, project, notify.1.INSTANCE);
    }

    public final void notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project, @NotNull Consumer<Notification> customizer) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
        Notification oldNotification = this.notification.get();
        if (oldNotification != null) {
            if (this.isVisible(oldNotification, project)) {
                return;
            }
            this.expire(oldNotification);
        }
        Notification newNotification = new Notification(this.group.getDisplayId(), title2, content2, this.type);
        customizer.accept(newNotification);
        newNotification.whenExpired(this.expiredListener);
        if (this.notification.compareAndSet(oldNotification, newNotification)) {
            newNotification.notify(project);
        } else {
            this.expire(newNotification);
        }
    }

    private final boolean isVisible(Notification notification, Project project) {
        Balloon balloon2;
        if (this.group.getDisplayType() != NotificationDisplayType.TOOL_WINDOW) {
            balloon2 = notification.getBalloon();
        } else if (project != null) {
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
            String string = this.group.getToolWindowId();
            Intrinsics.checkNotNull((Object)string);
            balloon2 = toolWindowManager.getToolWindowBalloon(string);
        } else {
            balloon2 = null;
        }
        Balloon balloon3 = balloon2;
        return balloon3 != null && !balloon3.isDisposed();
    }

    public final void clear() {
        block0: {
            Notification notification = this.notification.getAndSet(null);
            if (notification == null) break block0;
            Notification notification2 = notification;
            boolean bl = false;
            boolean bl2 = false;
            Notification it = notification2;
            boolean bl3 = false;
            this.expire(it);
        }
    }

    private final void expire(Notification notification) {
        notification.whenExpired(null);
        notification.expire();
    }

    @Deprecated(message="please use `#notify(String, String, Project)` instead")
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public final boolean notify(@NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.notify("", content2, project, notify.2.INSTANCE);
        return true;
    }

    @Deprecated(message="please use `#notify(String, String, Project, Consumer<Notification>)` instead")
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public final boolean notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project, @Nullable NotificationListener listener2, @Nullable AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.notify(title2, content2, project, new Consumer(action2, listener2){
            final /* synthetic */ AnAction $action;
            final /* synthetic */ NotificationListener $listener;

            public final void accept(@NotNull Notification notification) {
                block1: {
                    AnAction it;
                    boolean bl;
                    boolean bl2;
                    AnAction anAction2;
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    AnAction anAction3 = this.$action;
                    if (anAction3 != null) {
                        anAction2 = anAction3;
                        bl2 = false;
                        bl = false;
                        it = anAction2;
                        boolean bl3 = false;
                        notification.addAction(it);
                    }
                    NotificationListener notificationListener = this.$listener;
                    if (notificationListener == null) break block1;
                    anAction2 = notificationListener;
                    bl2 = false;
                    bl = false;
                    it = anAction2;
                    boolean bl4 = false;
                    notification.setListener((NotificationListener)it);
                }
            }
            {
                this.$action = anAction2;
                this.$listener = notificationListener;
            }
        });
        return true;
    }

    public static /* synthetic */ boolean notify$default(SingletonNotificationManager singletonNotificationManager, String string, String string2, Project project, NotificationListener notificationListener, AnAction anAction2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            project = null;
        }
        if ((n & 8) != 0) {
            notificationListener = singletonNotificationManager.defaultListener;
        }
        if ((n & 0x10) != 0) {
            anAction2 = null;
        }
        return singletonNotificationManager.notify(string, string2, project, notificationListener, anAction2);
    }

    @Deprecated(message="please use `#notify(String, String, Project, Consumer<Notification>)` instead")
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public final boolean notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project, @Nullable NotificationListener listener2) {
        return SingletonNotificationManager.notify$default(this, title2, content2, project, listener2, null, 16, null);
    }

    @Deprecated(message="please use `#notify(String, String, Project, Consumer<Notification>)` instead")
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public final boolean notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project) {
        return SingletonNotificationManager.notify$default(this, title2, content2, project, null, null, 24, null);
    }

    @Deprecated(message="please use `#notify(String, String, Project, Consumer<Notification>)` instead")
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public final boolean notify(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String content2) {
        return SingletonNotificationManager.notify$default(this, title2, content2, null, null, null, 28, null);
    }

    @Deprecated(message="please use `#notify(String, String, Project, Consumer<Notification>)` instead")
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public final boolean notify(@NlsContexts.NotificationContent @NotNull String content2) {
        return SingletonNotificationManager.notify$default(this, null, content2, null, null, null, 29, null);
    }

    public SingletonNotificationManager(@NotNull String groupId2, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        this.group = NotificationGroupManager.getInstance().getNotificationGroup(groupId2);
        this.notification = new AtomicReference();
        this.expiredListener = new Runnable(this){
            final /* synthetic */ SingletonNotificationManager this$0;

            public final void run() {
                Notification currentNotification = (Notification)SingletonNotificationManager.access$getNotification$p(this.this$0).get();
                if (currentNotification != null && currentNotification.isExpired()) {
                    SingletonNotificationManager.access$getNotification$p(this.this$0).compareAndSet(currentNotification, null);
                }
            }
            {
                this.this$0 = singletonNotificationManager;
            }
        };
    }

    @Deprecated(message="please use `#SingletonNotificationManager(String, NotificationType)` instead")
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public SingletonNotificationManager(@NotNull NotificationGroup group2, @NotNull NotificationType type, @Nullable NotificationListener defaultListener) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this(group2.getDisplayId(), type);
        this.defaultListener = defaultListener;
    }

    public /* synthetic */ SingletonNotificationManager(NotificationGroup notificationGroup, NotificationType notificationType, NotificationListener notificationListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            notificationListener = null;
        }
        this(notificationGroup, notificationType, notificationListener);
    }

    public static final /* synthetic */ AtomicReference access$getNotification$p(SingletonNotificationManager $this) {
        return $this.notification;
    }
}

