/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsEventLogGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationCollector {
    public static final String UNKNOWN = "unknown";

    private NotificationCollector() {
    }

    public void logBalloonShown(@Nullable Project project, @NotNull NotificationDisplayType displayType, @NotNull Notification notification, boolean isExpandable) {
        if (displayType == null) {
            NotificationCollector.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(1);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId());
        data2.add(NotificationsEventLogGroup.DISPLAY_TYPE.with((Object)displayType));
        NotificationSeverity severity = NotificationCollector.getType(notification);
        if (severity != null) {
            data2.add(NotificationsEventLogGroup.SEVERITY.with((Object)severity));
        }
        data2.add(NotificationsEventLogGroup.IS_EXPANDABLE.with((Object)isExpandable));
        NotificationsEventLogGroup.SHOWN.log(project, data2);
    }

    public void logToolWindowNotificationShown(@Nullable Project project, @NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(2);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId());
        data2.add(NotificationsEventLogGroup.DISPLAY_TYPE.with((Object)NotificationDisplayType.TOOL_WINDOW));
        NotificationSeverity severity = NotificationCollector.getType(notification);
        if (severity != null) {
            data2.add(NotificationsEventLogGroup.SEVERITY.with((Object)severity));
        }
        NotificationsEventLogGroup.SHOWN.log(project, data2);
    }

    public void logNotificationLoggedInEventLog(@NotNull Project project, @NotNull Notification notification) {
        if (project == null) {
            NotificationCollector.$$$reportNull$$$0(3);
        }
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(4);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId());
        NotificationSeverity severity = NotificationCollector.getType(notification);
        if (severity != null) {
            data2.add(NotificationsEventLogGroup.SEVERITY.with((Object)severity));
        }
        NotificationsEventLogGroup.LOGGED.log(project, data2);
    }

    @Nullable
    private static NotificationSeverity getType(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(5);
        }
        NotificationType type = notification.getType();
        switch (type) {
            case ERROR: {
                return NotificationSeverity.ERROR;
            }
            case WARNING: {
                return NotificationSeverity.WARNING;
            }
            case INFORMATION: 
            case IDE_UPDATE: {
                return NotificationSeverity.INFORMATION;
            }
        }
        return null;
    }

    public void logNotificationBalloonClosedByUser(@Nullable Project project, @Nullable String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId2) {
        if (notificationId == null) {
            return;
        }
        NotificationsEventLogGroup.CLOSED_BY_USER.log(project, NotificationCollector.createNotificationData(groupId2, notificationId, notificationDisplayId));
    }

    public void logNotificationActionInvoked(@Nullable Project project, @NotNull Notification notification, @NotNull AnAction action2, @NotNull NotificationPlace notificationPlace) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            NotificationCollector.$$$reportNull$$$0(7);
        }
        if (notificationPlace == null) {
            NotificationCollector.$$$reportNull$$$0(8);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId());
        data2.add(NotificationsEventLogGroup.NOTIFICATION_PLACE.with((Object)notificationPlace));
        if (action2 instanceof NotificationAction.Simple) {
            Object actionInstance = ((NotificationAction.Simple)action2).getActionInstance();
            PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(actionInstance.getClass());
            String actionId = info2.isSafeToReport() ? actionInstance.getClass().getName() : "third.party";
            data2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        } else {
            ActionsCollectorImpl.addActionClass(data2, action2, PluginInfoDetectorKt.getPluginInfo(action2.getClass()));
        }
        NotificationsEventLogGroup.ACTION_INVOKED.log(project, data2);
    }

    public void logHyperlinkClicked(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(9);
        }
        NotificationsEventLogGroup.HYPERLINK_CLICKED.log(NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId()));
    }

    public void logBalloonShownFromEventLog(@Nullable Project project, @NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(10);
        }
        NotificationsEventLogGroup.EVENT_LOG_BALLOON_SHOWN.log(project, NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId()));
    }

    public void logNotificationSettingsClicked(@NotNull String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId2) {
        if (notificationId == null) {
            NotificationCollector.$$$reportNull$$$0(11);
        }
        NotificationsEventLogGroup.SETTINGS_CLICKED.log(NotificationCollector.createNotificationData(groupId2, notificationId, notificationDisplayId));
    }

    public void logNotificationBalloonExpanded(@Nullable Project project, @NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(12);
        }
        NotificationsEventLogGroup.BALLOON_EXPANDED.log(project, NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId()));
    }

    public void logNotificationBalloonCollapsed(@Nullable Project project, @NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(13);
        }
        NotificationsEventLogGroup.BALLOON_COLLAPSED.log(project, NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.getDisplayId()));
    }

    @NotNull
    private static List<EventPair<?>> createNotificationData(@Nullable String groupId2, @NotNull String id2, @Nullable String displayId) {
        if (id2 == null) {
            NotificationCollector.$$$reportNull$$$0(14);
        }
        ArrayList data2 = new ArrayList();
        data2.add(NotificationsEventLogGroup.ID.with((Object)id2));
        if (Strings.isNotEmpty((String)displayId)) {
            data2.add(NotificationsEventLogGroup.ADDITIONAL.with((Object)new ObjectEventData(new EventPair[]{NotificationsEventLogGroup.NOTIFICATION_ID.with(displayId)})));
        }
        data2.add(NotificationsEventLogGroup.NOTIFICATION_GROUP_ID.with((Object)(Strings.isNotEmpty((String)groupId2) ? groupId2 : UNKNOWN)));
        PluginInfo pluginInfo = NotificationCollector.getPluginInfo(groupId2);
        if (pluginInfo != null) {
            data2.add(EventFields.PluginInfo.with((Object)pluginInfo));
        }
        ArrayList arrayList = data2;
        if (arrayList == null) {
            NotificationCollector.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public static NotificationCollector getInstance() {
        return (NotificationCollector)ApplicationManager.getApplication().getService(NotificationCollector.class);
    }

    @Nullable
    private static PluginInfo getPluginInfo(@Nullable String groupId2) {
        if (groupId2 == null) {
            return null;
        }
        NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)groupId2);
        if (group2 == null) {
            return null;
        }
        return PluginInfoDetectorKt.getPluginInfoById((PluginId)group2.getPluginId());
    }

    @NotNull
    public static List<String> parseIds(@Nullable String entry2) {
        String[] values2;
        if (entry2 == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                NotificationCollector.$$$reportNull$$$0(16);
            }
            return list2;
        }
        ArrayList<String> list3 = new ArrayList<String>();
        for (String value2 : values2 = StringUtil.convertLineSeparators((String)entry2, (String)"").split(";")) {
            if (Strings.isEmptyOrSpaces((CharSequence)value2)) continue;
            list3.add(value2.trim());
        }
        ArrayList<String> arrayList = list3;
        if (arrayList == null) {
            NotificationCollector.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationPlace";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShown";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logToolWindowNotificationShown";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationLoggedInEventLog";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationActionInvoked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logHyperlinkClicked";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShownFromEventLog";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationSettingsClicked";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonExpanded";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonCollapsed";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationData";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NotificationSeverity {
        INFORMATION,
        WARNING,
        ERROR;

    }

    public static enum NotificationPlace {
        BALLOON,
        ACTION_CENTER,
        EVENT_LOG,
        TOOL_WINDOW;

    }

    static final class NotificationIdValidator
    extends CustomValidationRule {
        NotificationIdValidator() {
        }

        public boolean acceptRuleId(@Nullable String ruleId) {
            return "notification_display_id".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                NotificationIdValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                NotificationIdValidator.$$$reportNull$$$0(1);
            }
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationIdValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            if (NotificationGroupManager.getInstance().isRegisteredNotificationId(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationIdValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                NotificationIdValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationCollector$NotificationIdValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$NotificationIdValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class NotificationGroupValidator
    extends CustomValidationRule {
        NotificationGroupValidator() {
        }

        public boolean acceptRuleId(@Nullable String ruleId) {
            return "notification_group".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                NotificationGroupValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                NotificationGroupValidator.$$$reportNull$$$0(1);
            }
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationGroupValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            NotificationGroup group2 = NotificationGroupManager.getInstance().getNotificationGroup(data2);
            if (group2 != null && PluginInfoDetectorKt.getPluginInfoById((PluginId)group2.getPluginId()).isDevelopedByJetBrains()) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationGroupValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                NotificationGroupValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationCollector$NotificationGroupValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$NotificationGroupValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

