/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationComponent;
import com.intellij.notification.impl.NotificationGroupComponent;
import com.intellij.notification.impl.NotificationsToolWindowFactory;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notification/impl/NotificationsToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "isApplicable", "", "updateIcon", "notifications", "", "Lcom/intellij/notification/Notification;", "Companion", "intellij.platform.ide.impl"})
public final class NotificationsToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    public static final String ID = "Notifications";
    @NotNull
    private static final ArrayList<Notification> myNotificationList;
    @NotNull
    private static final ArrayList<ToolWindow> myToolWindowList;
    @NotNull
    private static final Object myLock;
    @NotNull
    private static final Key<Consumer<Notification>> ADD_KEY;
    @NotNull
    private static final Key<Consumer<Notification>> REMOVE_KEY;
    @NotNull
    public static final Companion Companion;

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Registry.is((String)"ide.notification.action.center", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText((LayoutManager)new BorderLayout());
        panel2.setBackground(NotificationComponent.Companion.getBG_COLOR());
        panel2.getEmptyText().appendLine(IdeBundle.message((String)"notifications.toolwindow.empty.text.first.line", (Object[])new Object[0]));
        panel2.getEmptyText().appendLine(IdeBundle.message((String)"notifications.toolwindow.empty.text.second.line", (Object[])new Object[0]));
        NotificationGroupComponent suggestions = new NotificationGroupComponent((JPanel)panel2, true, project);
        NotificationGroupComponent timeline = new NotificationGroupComponent((JPanel)panel2, false, project);
        OnePixelSplitter splitter2 = new OnePixelSplitter(true, 0.5f){

            @NotNull
            protected Divider createDivider() {
                return (Divider)new OnePixelDivider(this, true, (Splittable)this){
                    final /* synthetic */ createToolWindowContent.splitter.1 this$0;

                    public void setVisible(boolean aFlag) {
                        super.setVisible(aFlag);
                        this.setResizeEnabled(aFlag);
                        if (!aFlag) {
                            this.setBounds(0, 0, 0, 0);
                        }
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2);
                    }
                };
            }
        };
        splitter2.setFirstComponent((JComponent)suggestions);
        splitter2.setSecondComponent((JComponent)timeline);
        panel2.add((Component)splitter2);
        ArrayList myNotifications = new ArrayList();
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"ContentFactory.SERVICE.g\u2026Content(panel, \"\", false)");
        Content content3 = content2;
        Consumer consumer2 = new Consumer(this, suggestions, timeline, myNotifications, toolWindow2){
            final /* synthetic */ NotificationsToolWindowFactory this$0;
            final /* synthetic */ NotificationGroupComponent $suggestions;
            final /* synthetic */ NotificationGroupComponent $timeline;
            final /* synthetic */ ArrayList $myNotifications;
            final /* synthetic */ ToolWindow $toolWindow;

            public final void accept(Notification notification) {
                Notification notification2 = notification;
                Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"notification");
                if (notification2.isSuggestionType()) {
                    this.$suggestions.add(notification);
                } else {
                    this.$timeline.add(notification);
                }
                this.$myNotifications.add(notification);
                NotificationsToolWindowFactory.access$updateIcon(this.this$0, this.$toolWindow, this.$myNotifications);
            }
            {
                this.this$0 = notificationsToolWindowFactory;
                this.$suggestions = notificationGroupComponent;
                this.$timeline = notificationGroupComponent2;
                this.$myNotifications = arrayList;
                this.$toolWindow = toolWindow2;
            }
        };
        content3.putUserData(ADD_KEY, (Object)consumer2);
        content3.putUserData(REMOVE_KEY, new Consumer(this, myNotifications, suggestions, timeline, toolWindow2){
            final /* synthetic */ NotificationsToolWindowFactory this$0;
            final /* synthetic */ ArrayList $myNotifications;
            final /* synthetic */ NotificationGroupComponent $suggestions;
            final /* synthetic */ NotificationGroupComponent $timeline;
            final /* synthetic */ ToolWindow $toolWindow;

            public final void accept(Notification notification) {
                if (notification == null) {
                    this.$myNotifications.clear();
                    this.$suggestions.clear();
                    this.$timeline.clear();
                } else {
                    if (notification.isSuggestionType()) {
                        this.$suggestions.remove(notification);
                    } else {
                        this.$timeline.remove(notification);
                    }
                    this.$myNotifications.remove(notification);
                }
                NotificationsToolWindowFactory.access$updateIcon(this.this$0, this.$toolWindow, this.$myNotifications);
            }
            {
                this.this$0 = notificationsToolWindowFactory;
                this.$myNotifications = arrayList;
                this.$suggestions = notificationGroupComponent;
                this.$timeline = notificationGroupComponent2;
                this.$toolWindow = toolWindow2;
            }
        });
        timeline.setClearCallback((Function1<? super List<? extends Notification>, Unit>)((Function1)new Function1<List<? extends Notification>, Unit>(this, myNotifications, toolWindow2){
            final /* synthetic */ NotificationsToolWindowFactory this$0;
            final /* synthetic */ ArrayList $myNotifications;
            final /* synthetic */ ToolWindow $toolWindow;

            public final void invoke(@NotNull List<? extends Notification> notifications) {
                Intrinsics.checkNotNullParameter(notifications, (String)"notifications");
                this.$myNotifications.removeAll((Collection)notifications);
                NotificationsToolWindowFactory.access$updateIcon(this.this$0, this.$toolWindow, this.$myNotifications);
            }
            {
                this.this$0 = notificationsToolWindowFactory;
                this.$myNotifications = arrayList;
                this.$toolWindow = toolWindow2;
                super(1);
            }
        }));
        Object object = myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            myToolWindowList.add(toolWindow2);
            Disposer.register((Disposable)toolWindow2.getDisposable(), (Disposable)new Disposable(toolWindow2, consumer2){
                final /* synthetic */ ToolWindow $toolWindow$inlined;
                final /* synthetic */ Consumer $consumer$inlined;
                {
                    this.$toolWindow$inlined = toolWindow2;
                    this.$consumer$inlined = consumer2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void dispose() {
                    Object object = NotificationsToolWindowFactory.Companion.getMyLock();
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        NotificationsToolWindowFactory.Companion.getMyToolWindowList().remove(this.$toolWindow$inlined);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            });
            for (Notification notification : myNotificationList) {
                consumer2.accept(notification);
            }
            myNotificationList.clear();
            Unit unit = Unit.INSTANCE;
        }
        ContentManager contentManager2 = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"toolWindow.contentManager");
        ContentManager contentManager3 = contentManager2;
        contentManager3.addContent(content3);
        contentManager3.setSelectedContent(content3);
        project.getMessageBus().connect(toolWindow2.getDisposable()).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(toolWindow2, project, suggestions, timeline){
            private boolean myVisible;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ Project $project;
            final /* synthetic */ NotificationGroupComponent $suggestions;
            final /* synthetic */ NotificationGroupComponent $timeline;

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                boolean visible = this.$toolWindow.isVisible();
                if (this.myVisible != visible) {
                    this.myVisible = visible;
                    if (visible) {
                        IdeFrame ideFrame;
                        IdeFrame ideFrame2 = ideFrame = WindowManager.getInstance().getIdeFrame(this.$project);
                        Intrinsics.checkNotNull((Object)ideFrame2);
                        BalloonLayout balloonLayout = ideFrame2.getBalloonLayout();
                        if (balloonLayout == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.BalloonLayoutImpl");
                        }
                        BalloonLayoutImpl balloonLayout2 = (BalloonLayoutImpl)balloonLayout;
                        balloonLayout2.closeAll();
                    }
                }
                if (!visible) {
                    this.$suggestions.clearNewState();
                    this.$timeline.clearNewState();
                }
            }
            {
                this.$toolWindow = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$suggestions = $captured_local_variable$2;
                this.$timeline = $captured_local_variable$3;
                this.myVisible = true;
            }
        });
    }

    private final void updateIcon(ToolWindow toolWindow2, List<? extends Notification> notifications) {
        toolWindow2.setIcon(IdeNotificationArea.getActionCenterNotificationIcon(notifications));
    }

    static {
        Companion = new Companion(null);
        myNotificationList = new ArrayList();
        myToolWindowList = new ArrayList();
        myLock = new Object();
        Key key = Key.create((String)"callbackInterface");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Consumer<Noti\u2026on>>(\"callbackInterface\")");
        ADD_KEY = key;
        Key key2 = Key.create((String)"removeCallbackInterface");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<Consumer<Noti\u2026removeCallbackInterface\")");
        REMOVE_KEY = key2;
    }

    public static final /* synthetic */ void access$updateIcon(NotificationsToolWindowFactory $this, ToolWindow toolWindow2, List notifications) {
        $this.updateIcon(toolWindow2, notifications);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u001b\u001a\u00020\u001c2\u001a\u0010\u001d\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0004\u0012\u00020\u001c0\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u0006R0\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R4\u0010\r\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0006 \u0007*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0014j\b\u0012\u0004\u0012\u00020\u0006`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0014j\b\u0012\u0004\u0012\u00020\u0019`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/notification/impl/NotificationsToolWindowFactory$Companion;", "", "()V", "ADD_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/function/Consumer;", "Lcom/intellij/notification/Notification;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getADD_KEY", "()Lcom/intellij/openapi/util/Key;", "ID", "", "REMOVE_KEY", "getREMOVE_KEY", "myLock", "Ljava/lang/Object;", "getMyLock", "()Ljava/lang/Object;", "myNotificationList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getMyNotificationList", "()Ljava/util/ArrayList;", "myToolWindowList", "Lcom/intellij/openapi/wm/ToolWindow;", "getMyToolWindowList", "iterate", "", "callback", "Lkotlin/Function1;", "remove", "notification", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final ArrayList<Notification> getMyNotificationList() {
            return myNotificationList;
        }

        @NotNull
        public final ArrayList<ToolWindow> getMyToolWindowList() {
            return myToolWindowList;
        }

        @NotNull
        public final Object getMyLock() {
            return myLock;
        }

        @NotNull
        public final Key<Consumer<Notification>> getADD_KEY() {
            return ADD_KEY;
        }

        @NotNull
        public final Key<Consumer<Notification>> getREMOVE_KEY() {
            return REMOVE_KEY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void remove(@Nullable Notification notification) {
            this.iterate((Function1<? super Consumer<Notification>, Unit>)((Function1)new Function1<Consumer<Notification>, Unit>(notification){
                final /* synthetic */ Notification $notification;

                public final void invoke(@NotNull Consumer<Notification> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.accept(this.$notification);
                }
                {
                    this.$notification = notification;
                    super(1);
                }
            }));
            Object object = this.getMyLock();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                Object object2;
                boolean bl3 = false;
                if (notification == null) {
                    Companion.getMyNotificationList().clear();
                    object2 = Unit.INSTANCE;
                } else {
                    object2 = Companion.getMyNotificationList().remove(notification);
                }
                Object object3 = object2;
            }
        }

        public final void iterate(@NotNull Function1<? super Consumer<Notification>, Unit> callback2) {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            Project[] projectArray = ProjectUtilCore.getOpenProjects();
            int n = projectArray.length;
            for (int j = 0; j < n; ++j) {
                Project project;
                Project project2 = project = projectArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(project2).getToolWindow(NotificationsToolWindowFactory.ID);
                if (toolWindow2 == null) continue;
                Content content2 = toolWindow2.getContentManager().getContent(0);
                Intrinsics.checkNotNull((Object)content2);
                Object object = content2.getUserData(this.getREMOVE_KEY());
                Intrinsics.checkNotNull((Object)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toolWindow.contentManage\u2026getUserData(REMOVE_KEY)!!");
                callback2.invoke(object);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

