/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBMenu;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.screenmenu.Menu;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionMenu
extends JBMenu {
    private final String myPlace;
    private final DataContext myContext;
    private final ActionRef<ActionGroup> myGroup;
    private final PresentationFactory myPresentationFactory;
    private final Presentation myPresentation;
    private boolean myMnemonicEnabled;
    private StubItem myStubItem;
    private final boolean myUseDarkIcons;
    private Disposable myDisposable;
    @Nullable
    private final Menu myScreenMenuPeer;
    private JPopupMenu mySpecialMenu;

    public ActionMenu(@Nullable DataContext context2, @NotNull String place, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, boolean enableMnemonics, boolean useDarkIcons) {
        if (place == null) {
            ActionMenu.$$$reportNull$$$0(0);
        }
        if (group2 == null) {
            ActionMenu.$$$reportNull$$$0(1);
        }
        if (presentationFactory == null) {
            ActionMenu.$$$reportNull$$$0(2);
        }
        this.myContext = context2;
        this.myPlace = place;
        this.myGroup = ActionRef.fromAction(group2);
        this.myPresentationFactory = presentationFactory;
        this.myPresentation = this.myPresentationFactory.getPresentation((AnAction)group2);
        this.myMnemonicEnabled = enableMnemonics;
        this.myUseDarkIcons = useDarkIcons;
        if (Menu.isJbScreenMenuEnabled() && "MainMenu".equals(this.myPlace)) {
            this.myScreenMenuPeer = new Menu(this.myPresentation.getText(enableMnemonics));
            this.myScreenMenuPeer.setOnOpen(() -> this.fillMenu(), (Component)((Object)this));
            this.myScreenMenuPeer.setOnClose(() -> this.setSelected(false), (Component)((Object)this));
            this.myScreenMenuPeer.listenPresentationChanges(this.myPresentation);
        } else {
            this.myScreenMenuPeer = null;
        }
        this.updateUI();
        this.init();
        this.getPopupMenu();
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        if (!(this.getParent() instanceof JMenuBar)) {
            return super.getComponentGraphics(graphics);
        }
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    @NotNull
    public AnAction getAnAction() {
        ActionGroup actionGroup2 = this.myGroup.getAction();
        if (actionGroup2 == null) {
            ActionMenu.$$$reportNull$$$0(3);
        }
        return actionGroup2;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.mySpecialMenu == null) {
            this.mySpecialMenu = new JBPopupMenu();
            this.mySpecialMenu.setInvoker((Component)((Object)this));
            this.popupListener = this.createWinListener(this.mySpecialMenu);
            ReflectionUtil.setField(JMenu.class, (Object)((Object)this), JPopupMenu.class, (String)"popupMenu", (Object)this.mySpecialMenu);
        }
        return super.getPopupMenu();
    }

    public void updateUI() {
        this.setUI(IdeaMenuUI.createUI((JComponent)((Object)this)));
        this.setFont(UIUtil.getMenuFont());
        JPopupMenu popupMenu = this.getPopupMenu();
        if (popupMenu != null) {
            popupMenu.updateUI();
        }
    }

    @Nullable
    public Menu getScreenMenuPeer() {
        return this.myScreenMenuPeer;
    }

    private void init() {
        boolean macSystemMenu = SystemInfo.isMacSystemMenu && this.isMainMenuPlace();
        this.myStubItem = macSystemMenu ? null : new StubItem();
        this.addStubItem();
        this.setBorderPainted(false);
        MenuListenerImpl menuListener = new MenuListenerImpl();
        this.addMenuListener(menuListener);
        this.getModel().addChangeListener(menuListener);
        this.updateFromPresentation(this.myMnemonicEnabled);
    }

    public boolean isMainMenuPlace() {
        return this.myPlace.equals("MainMenu");
    }

    public void updateFromPresentation(boolean enableMnemonics) {
        this.myMnemonicEnabled = enableMnemonics;
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setText(this.myPresentation.getText(this.myMnemonicEnabled));
        this.setMnemonic(this.myPresentation.getMnemonic());
        this.setDisplayedMnemonicIndex(this.myPresentation.getDisplayedMnemonicIndex());
        this.updateIcon();
    }

    private void addStubItem() {
        if (this.myStubItem != null) {
            this.add(this.myStubItem);
        }
    }

    public void setDisplayedMnemonicIndex(int index2) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(this.myMnemonicEnabled ? index2 : -1);
    }

    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.myMnemonicEnabled ? mnemonic : 0);
    }

    private void updateIcon() {
        UISettings settings = UISettings.getInstanceOrNull();
        if (settings != null && settings.getShowIconsInMenus()) {
            Icon icon2 = this.myPresentation.getIcon();
            if (SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace) && icon2 != null) {
                icon2 = IconLoader.getMenuBarIcon((Icon)icon2, (boolean)this.myUseDarkIcons);
            }
            if (ActionMenu.isShowNoIcons()) {
                this.setIcon(null);
                this.setDisabledIcon(null);
            } else {
                this.setIcon(icon2);
                if (this.myPresentation.getDisabledIcon() != null) {
                    this.setDisabledIcon(this.myPresentation.getDisabledIcon());
                } else {
                    this.setDisabledIcon(icon2 == null ? null : IconLoader.getDisabledIcon((Icon)icon2));
                }
                if (this.myScreenMenuPeer != null) {
                    this.myScreenMenuPeer.setIcon(icon2);
                }
            }
        }
    }

    static boolean isShowNoIcons() {
        return SystemInfo.isMac && Registry.get((String)"ide.macos.main.menu.alignment.options").isOptionEnabled("No icons");
    }

    static boolean isAligned() {
        return SystemInfo.isMac && Registry.get((String)"ide.macos.main.menu.alignment.options").isOptionEnabled("Aligned");
    }

    static boolean isAlignedInGroup() {
        return SystemInfo.isMac && Registry.get((String)"ide.macos.main.menu.alignment.options").isOptionEnabled("Aligned in group");
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.myPresentation.getDescription());
    }

    public static void showDescriptionInStatusBar(boolean isIncluded, Component component2, @NlsContexts.StatusBarText String description) {
        StatusBar statusBar2;
        IdeFrame frame = (IdeFrame)(component2 instanceof IdeFrame ? component2 : SwingUtilities.getAncestorOfClass(IdeFrame.class, component2));
        if (frame != null && (statusBar2 = frame.getStatusBar()) != null) {
            statusBar2.setInfo(isIncluded ? description : null);
        }
    }

    public void setPopupMenuVisible(boolean b) {
        if (!(!b || SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace))) {
            this.fillMenu();
            if (!this.isSelected()) {
                return;
            }
        }
        super.setPopupMenuVisible(b);
    }

    public void clearItems() {
        if (SystemInfo.isMacSystemMenu && this.isMainMenuPlace()) {
            for (Component menuComponent : this.getMenuComponents()) {
                if (menuComponent instanceof ActionMenu) {
                    ((ActionMenu)((Object)menuComponent)).clearItems();
                    continue;
                }
                if (!(menuComponent instanceof ActionMenuItem) || SystemInfo.isMac) continue;
                ((ActionMenuItem)((Object)menuComponent)).setAccelerator(KeyStroke.getKeyStroke(61451, 0));
            }
        }
        this.removeAll();
        this.validate();
    }

    public void fillMenu() {
        Utils.performWithRetries(this::fillMenuInner, () -> !this.isSelected());
    }

    private void fillMenuInner() {
        DataContext context2;
        if (this.myContext != null) {
            context2 = this.myContext;
        } else {
            DataManager dataManager = DataManager.getInstance();
            DataContext contextFromFocus = dataManager.getDataContext();
            context2 = contextFromFocus;
            if (PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context2) == null) {
                IdeFrame frame = (IdeFrame)ComponentUtil.getParentOfType(IdeFrame.class, (Component)((Object)this));
                context2 = dataManager.getDataContext(IdeFocusManager.getGlobalInstance().getLastFocusedFor((Window)frame));
            }
            context2 = Utils.wrapDataContext(context2);
        }
        boolean isDarkMenu = SystemInfo.isMacSystemMenu && NSDefaults.isDarkMenuBar();
        Utils.fillMenu(this.myGroup.getAction(), (JComponent)((Object)this), this.myMnemonicEnabled, this.myPresentationFactory, context2, this.myPlace, true, isDarkMenu, RelativePoint.getNorthEastOf((JComponent)((Object)this)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionMenu";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UsabilityHelper
    implements IdeEventQueue.EventDispatcher,
    AWTEventListener,
    Disposable {
        private Component myComponent;
        private Point myStartMousePoint;
        private Point myUpperTargetPoint;
        private Point myLowerTargetPoint;
        private SingleAlarm myCallbackAlarm = new SingleAlarm(() -> {
            Disposer.dispose((Disposable)this.myCallbackAlarm);
            this.myCallbackAlarm = null;
            if (this.myEventToRedispatch != null) {
                IdeEventQueue.getInstance().dispatchEvent(this.myEventToRedispatch);
            }
        }, 50, ModalityState.any(), (Disposable)this);
        private MouseEvent myEventToRedispatch;

        private UsabilityHelper(Component component2) {
            this.myComponent = component2;
            PointerInfo info2 = MouseInfo.getPointerInfo();
            Point point = this.myStartMousePoint = info2 != null ? info2.getLocation() : null;
            if (this.myStartMousePoint != null) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 1L);
                IdeEventQueue.getInstance().addDispatcher(this, this);
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            ComponentEvent componentEvent;
            Component component2;
            JPopupMenu popup2;
            if (event instanceof ComponentEvent && (popup2 = (JPopupMenu)ComponentUtil.getParentOfType(JPopupMenu.class, (Component)(component2 = (componentEvent = (ComponentEvent)event).getComponent()))) != null && popup2.getInvoker() == this.myComponent && popup2.isShowing()) {
                Rectangle bounds2 = popup2.getBounds();
                if (bounds2.isEmpty()) {
                    return;
                }
                bounds2.setLocation(popup2.getLocationOnScreen());
                if (this.myStartMousePoint.x < bounds2.x) {
                    this.myUpperTargetPoint = new Point(bounds2.x, bounds2.y);
                    this.myLowerTargetPoint = new Point(bounds2.x, bounds2.y + bounds2.height);
                }
                if (this.myStartMousePoint.x > bounds2.x + bounds2.width) {
                    this.myUpperTargetPoint = new Point(bounds2.x + bounds2.width, bounds2.y);
                    this.myLowerTargetPoint = new Point(bounds2.x + bounds2.width, bounds2.y + bounds2.height);
                }
            }
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                UsabilityHelper.$$$reportNull$$$0(0);
            }
            if (e instanceof MouseEvent && this.myUpperTargetPoint != null && this.myLowerTargetPoint != null && this.myCallbackAlarm != null) {
                if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
                    return false;
                }
                Point point = ((MouseEvent)e).getLocationOnScreen();
                Rectangle bounds2 = this.myComponent.getBounds();
                bounds2.setLocation(this.myComponent.getLocationOnScreen());
                boolean isMouseMovingTowardsSubmenu = bounds2.contains(point) || new Polygon(new int[]{this.myStartMousePoint.x, this.myUpperTargetPoint.x, this.myLowerTargetPoint.x}, new int[]{this.myStartMousePoint.y, this.myUpperTargetPoint.y, this.myLowerTargetPoint.y}, 3).contains(point);
                this.myEventToRedispatch = (MouseEvent)e;
                if (!isMouseMovingTowardsSubmenu) {
                    this.myCallbackAlarm.request();
                } else {
                    this.myCallbackAlarm.cancel();
                }
                return true;
            }
            return false;
        }

        public void dispose() {
            this.myComponent = null;
            this.myEventToRedispatch = null;
            this.myLowerTargetPoint = null;
            this.myUpperTargetPoint = null;
            this.myStartMousePoint = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionMenu$UsabilityHelper", "dispatch"));
        }
    }

    private class MenuListenerImpl
    implements ChangeListener,
    MenuListener {
        ScheduledFuture<?> myDelayedClear;
        boolean isSelected = false;

        private MenuListenerImpl() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ButtonModel model2 = (ButtonModel)e.getSource();
            boolean modelSelected = model2.isSelected();
            if (modelSelected != this.isSelected) {
                this.isSelected = modelSelected;
                if (modelSelected) {
                    this.menuSelected();
                } else {
                    this.menuDeselected();
                }
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            this.onMenuHidden();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
        }

        private void menuDeselected() {
            if (ActionMenu.this.myDisposable != null) {
                Disposer.dispose((Disposable)ActionMenu.this.myDisposable);
                ActionMenu.this.myDisposable = null;
            }
            this.onMenuHidden();
        }

        private void onMenuHidden() {
            Runnable clearSelf = () -> {
                ActionMenu.this.clearItems();
                ActionMenu.this.addStubItem();
            };
            if (SystemInfo.isMacSystemMenu && ActionMenu.this.isMainMenuPlace()) {
                this.myDelayedClear = EdtScheduledExecutorService.getInstance().schedule(clearSelf, 1000L, TimeUnit.MILLISECONDS);
            } else {
                clearSelf.run();
            }
        }

        private void menuSelected() {
            UsabilityHelper helper2 = new UsabilityHelper((Component)((Object)ActionMenu.this));
            if (ActionMenu.this.myDisposable == null) {
                ActionMenu.this.myDisposable = Disposer.newDisposable();
            }
            Disposer.register((Disposable)ActionMenu.this.myDisposable, (Disposable)helper2);
            if (this.myDelayedClear != null) {
                this.myDelayedClear.cancel(false);
                this.myDelayedClear = null;
                ActionMenu.this.clearItems();
            }
            if (SystemInfo.isMacSystemMenu && "MainMenu".equals(ActionMenu.this.myPlace)) {
                ActionMenu.this.fillMenu();
            }
        }
    }
}

