/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.CommonBundle;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataContextUtils;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupExpander;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionUpdater;
import com.intellij.openapi.actionSystem.impl.AsyncDataContext;
import com.intellij.openapi.actionSystem.impl.EdtDataContext;
import com.intellij.openapi.actionSystem.impl.PreCachedDataContext;
import com.intellij.openapi.actionSystem.impl.PreCachedDataContext2;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.mac.screenmenu.Menu;
import com.intellij.ui.mac.screenmenu.MenuItem;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;

public final class Utils
extends DataContextUtils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    public static final AnAction EMPTY_MENU_FILLER = new EmptyAction();
    private static final boolean DO_FULL_EXPAND;
    private static int ourExpandActionGroupImplEDTLoopLevel;
    private static boolean ourInUpdateSessionForInputEventEDTLoop;

    @NotNull
    public static DataContext wrapToAsyncDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(0);
        }
        Component component2 = (Component)dataContext.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        if (dataContext instanceof EdtDataContext) {
            return Utils.newPreCachedDataContext(component2);
        }
        if (dataContext instanceof SimpleDataContext && component2 != null) {
            DataContext wrapped = Utils.newPreCachedDataContext(component2);
            LOG.assertTrue(wrapped.getData(CommonDataKeys.PROJECT) == dataContext.getData(CommonDataKeys.PROJECT));
            LOG.warn(new Throwable("Use DataManager.getDataContext(component) instead of SimpleDataContext for wrapping."));
            DataContext dataContext2 = wrapped;
            if (dataContext2 == null) {
                Utils.$$$reportNull$$$0(1);
            }
            return dataContext2;
        }
        DataContext dataContext3 = dataContext;
        if (dataContext3 == null) {
            Utils.$$$reportNull$$$0(2);
        }
        return dataContext3;
    }

    @NotNull
    private static DataContext newPreCachedDataContext(@Nullable Component component2) {
        if (Registry.is((String)"actionSystem.update.actions.async.data-context2")) {
            return new PreCachedDataContext2(component2);
        }
        return new PreCachedDataContext(component2);
    }

    @NotNull
    public static DataContext wrapDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(3);
        }
        if (!Registry.is((String)"actionSystem.update.actions.async")) {
            DataContext dataContext2 = dataContext;
            if (dataContext2 == null) {
                Utils.$$$reportNull$$$0(4);
            }
            return dataContext2;
        }
        return Utils.wrapToAsyncDataContext(dataContext);
    }

    @ApiStatus.Internal
    @NotNull
    public static DataContext freezeDataContext(@NotNull DataContext dataContext, @Nullable Consumer<? super String> missedKeys) {
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(5);
        }
        DataContext dataContext2 = dataContext instanceof PreCachedDataContext2 ? ((PreCachedDataContext2)dataContext).frozenCopy(missedKeys) : (dataContext instanceof PreCachedDataContext ? ((PreCachedDataContext)dataContext).frozenCopy(missedKeys) : dataContext);
        if (dataContext2 == null) {
            Utils.$$$reportNull$$$0(6);
        }
        return dataContext2;
    }

    public static boolean isAsyncDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(7);
        }
        return dataContext instanceof AsyncDataContext;
    }

    @ApiStatus.Internal
    @Nullable
    public static Object getRawDataIfCached(@NotNull DataContext dataContext, @NotNull String dataId) {
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(8);
        }
        if (dataId == null) {
            Utils.$$$reportNull$$$0(9);
        }
        return dataContext instanceof PreCachedDataContext2 ? ((PreCachedDataContext2)dataContext).getRawDataIfCached(dataId) : (dataContext instanceof PreCachedDataContext ? ((PreCachedDataContext)dataContext).getRawDataIfCached(dataId) : (dataContext instanceof EdtDataContext ? ((EdtDataContext)dataContext).getRawDataIfCached(dataId) : null));
    }

    static void clearAllCachesAndUpdates() {
        ActionUpdater.cancelAllUpdates("clear-all-caches-and-updates requested");
        ActionUpdater.waitForAllUpdatesToFinish();
        PreCachedDataContext2.clearAllCaches();
        PreCachedDataContext.clearAllCaches();
    }

    @ApiStatus.Internal
    public static CancellablePromise<List<AnAction>> expandActionGroupAsync(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context2, @NotNull String place) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(10);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            Utils.$$$reportNull$$$0(12);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(13);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context2, place, false, false).expandActionGroupAsync(group2, group2 instanceof CompactActionGroup);
    }

    @ApiStatus.Internal
    public static List<AnAction> expandActionGroupWithTimeout(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context2, @NotNull String place, int timeoutMs) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(14);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            Utils.$$$reportNull$$$0(16);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(17);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context2, place, false, false).expandActionGroupWithTimeout(group2, group2 instanceof CompactActionGroup, timeoutMs);
    }

    @NotNull
    public static List<AnAction> expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context2, @NotNull String place) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(18);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            Utils.$$$reportNull$$$0(20);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(21);
        }
        return Utils.expandActionGroupImpl(isInModalContext, group2, presentationFactory, context2, place, ActionPlaces.isPopupPlace((String)place), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<AnAction> expandActionGroupImpl(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context2, @NotNull String place, boolean isContextMenu, @Nullable Runnable onProcessed, @Nullable JComponent menuItem) {
        List<Object> list2;
        LinkedBlockingQueue queue0;
        boolean async;
        if (group2 == null) {
            Utils.$$$reportNull$$$0(22);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(23);
        }
        if (context2 == null) {
            Utils.$$$reportNull$$$0(24);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(25);
        }
        boolean asyncUI = (async = Utils.isAsyncDataContext(context2)) && Registry.is((String)"actionSystem.update.actions.async.ui");
        LinkedBlockingQueue linkedBlockingQueue = queue0 = async && !asyncUI ? new LinkedBlockingQueue() : null;
        ActionUpdater updater = new ActionUpdater(isInModalContext, presentationFactory, context2, place, isContextMenu, false, null, queue0 != null ? queue0::offer : null);
        ActionGroupExpander expander = ActionGroupExpander.getInstance();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (async) {
            int maxLoops;
            if (expander.allowsFastUpdate(project, place)) {
                HashSet missedKeys = new HashSet();
                list2 = Utils.expandActionGroupFastTrack(updater, group2, group2 instanceof CompactActionGroup, missedKeys::add);
                if (list2 != null && missedKeys.isEmpty()) {
                    if (onProcessed != null) {
                        onProcessed.run();
                    }
                    List<AnAction> list3 = list2;
                    if (list3 == null) {
                        Utils.$$$reportNull$$$0(26);
                    }
                    return list3;
                }
            }
            if (ourExpandActionGroupImplEDTLoopLevel >= (maxLoops = Math.max(2, Registry.intValue((String)"actionSystem.update.actions.async.max.nested.loops", (int)20)))) {
                LOG.warn("Maximum number of recursive EDT loops reached (" + maxLoops + ") at '" + place + "'");
                if (onProcessed != null) {
                    onProcessed.run();
                }
                ActionUpdater.cancelAllUpdates("recursive EDT loops limit reached at '" + place + "'");
                throw new ProcessCanceledException();
            }
            IdeEventQueue queue2 = IdeEventQueue.getInstance();
            CancellablePromise<List<AnAction>> promise = expander.expandActionGroupAsync(project, place, group2, group2 instanceof CompactActionGroup, updater::expandActionGroupAsync);
            if (onProcessed != null) {
                promise.onProcessed(__ -> onProcessed.run());
            }
            try (AccessToken ignore = Utils.cancelOnUserActivityInside(promise, (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context2), menuItem);){
                ++ourExpandActionGroupImplEDTLoopLevel;
                list2 = Utils.runLoopAndWaitForFuture(promise, Collections.emptyList(), true, () -> {
                    if (queue0 != null) {
                        Runnable runnable2 = (Runnable)queue0.poll(1L, TimeUnit.MILLISECONDS);
                        if (runnable2 != null) {
                            runnable2.run();
                        }
                    } else {
                        AWTEvent event = queue2.getNextEvent();
                        queue2.dispatchEvent(event);
                    }
                });
            }
            finally {
                --ourExpandActionGroupImplEDTLoopLevel;
            }
            if (promise.isCancelled()) {
                throw new ProcessCanceledException();
            }
        } else {
            if (Registry.is((String)"actionSystem.update.actions.async") && !ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn(new Throwable("Non-async data context detected in async mode in '" + place + "': " + context2.getClass().getName()));
            }
            try {
                list2 = DO_FULL_EXPAND ? updater.expandActionGroupFull(group2, group2 instanceof CompactActionGroup) : updater.expandActionGroupWithTimeout(group2, group2 instanceof CompactActionGroup);
            }
            finally {
                if (onProcessed != null) {
                    onProcessed.run();
                }
            }
        }
        List<AnAction> list4 = list2;
        if (list4 == null) {
            Utils.$$$reportNull$$$0(27);
        }
        return list4;
    }

    @NotNull
    private static AccessToken cancelOnUserActivityInside(@NotNull CancellablePromise<List<AnAction>> promise, @Nullable Component contextComponent, @Nullable Component menuItem) {
        if (promise == null) {
            Utils.$$$reportNull$$$0(28);
        }
        Window window = contextComponent == null ? null : SwingUtilities.getWindowAncestor(contextComponent);
        AccessToken accessToken = ProhibitAWTEvents.startFiltered("expandActionGroup", event -> {
            if (event instanceof FocusEvent && event.getID() == 1005 && ((FocusEvent)event).getCause() == FocusEvent.Cause.ACTIVATION && window != null && window == SwingUtilities.getWindowAncestor(((FocusEvent)event).getComponent()) || event instanceof KeyEvent && event.getID() == 401 || event instanceof MouseEvent && event.getID() == 501 && UIUtil.getDeepestComponentAt((Component)((MouseEvent)event).getComponent(), (int)((MouseEvent)event).getX(), (int)((MouseEvent)event).getY()) != menuItem) {
                ActionUpdater.cancelPromise(promise, event);
            }
            return null;
        });
        if (accessToken == null) {
            Utils.$$$reportNull$$$0(29);
        }
        return accessToken;
    }

    @Nullable
    static List<AnAction> expandActionGroupFastTrack(@NotNull ActionUpdater updater, @NotNull ActionGroup group2, boolean hideDisabled, @Nullable Consumer<String> missedKeys) {
        int maxTime;
        if (updater == null) {
            Utils.$$$reportNull$$$0(30);
        }
        if (group2 == null) {
            Utils.$$$reportNull$$$0(31);
        }
        if ((maxTime = Registry.intValue((String)"actionSystem.update.actions.async.fast-track.timeout.ms", (int)20)) < 1) {
            return null;
        }
        LinkedBlockingQueue queue2 = new LinkedBlockingQueue();
        ActionUpdater fastUpdater = ActionUpdater.getActionUpdater(updater.asFastUpdateSession(missedKeys, queue2::offer));
        try (AccessToken ignore = SlowOperations.allowSlowOperations((String)"  fast track  ");){
            long start2 = System.currentTimeMillis();
            CancellablePromise<List<AnAction>> promise = fastUpdater.expandActionGroupAsync(group2, hideDisabled);
            List list2 = Utils.runLoopAndWaitForFuture(promise, null, false, () -> {
                long elapsed;
                Runnable runnable2 = (Runnable)queue2.poll(1L, TimeUnit.MILLISECONDS);
                if (runnable2 != null) {
                    runnable2.run();
                }
                if ((elapsed = System.currentTimeMillis() - start2) > (long)maxTime) {
                    ActionUpdater.cancelPromise(promise, "fast-track timed out");
                }
            });
            return list2;
        }
    }

    static void fillMenu(@NotNull ActionGroup group2, @NotNull JComponent component2, boolean enableMnemonics, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context2, @NotNull String place, boolean isWindowMenu, boolean useDarkIcons, @Nullable RelativePoint relativePoint) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(32);
        }
        if (component2 == null) {
            Utils.$$$reportNull$$$0(33);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(34);
        }
        if (context2 == null) {
            Utils.$$$reportNull$$$0(35);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(36);
        }
        if (ApplicationManagerEx.getApplicationEx().isWriteActionInProgress()) {
            throw new ProcessCanceledException();
        }
        Runnable removeIcon = Utils.addLoadingIcon(relativePoint, context2, place);
        List<AnAction> list2 = Utils.expandActionGroupImpl(LaterInvocator.isInModalContext(), group2, presentationFactory, context2, place, true, removeIcon, component2);
        boolean checked = group2 instanceof CheckedActionGroup;
        Utils.fillMenuInner(component2, list2, checked, enableMnemonics, presentationFactory, context2, place, isWindowMenu, useDarkIcons);
    }

    @NotNull
    static Runnable addLoadingIcon(@Nullable RelativePoint point, @NotNull DataContext context2, @NotNull String place) {
        JComponent glassPane;
        if (context2 == null) {
            Utils.$$$reportNull$$$0(37);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(38);
        }
        JRootPane rootPane = point == null ? null : UIUtil.getRootPane((Component)point.getComponent());
        JComponent jComponent = glassPane = rootPane == null ? null : (JComponent)rootPane.getGlassPane();
        if (glassPane == null || !Utils.isAsyncDataContext(context2)) {
            Runnable runnable2 = EmptyRunnable.getInstance();
            if (runnable2 == null) {
                Utils.$$$reportNull$$$0(39);
            }
            return runnable2;
        }
        Component comp = point.getOriginalComponent();
        if (comp instanceof ActionMenu && comp.getParent() instanceof IdeMenuBar || "ICON_NAVIGATION_SECONDARY_BUTTON".equals(place) && comp instanceof EditorGutterComponentEx && ((EditorGutterComponentEx)comp).getGutterRenderer(point.getOriginalPoint()) != null) {
            Runnable runnable3 = EmptyRunnable.getInstance();
            if (runnable3 == null) {
                Utils.$$$reportNull$$$0(40);
            }
            return runnable3;
        }
        boolean isMenuItem = comp instanceof ActionMenu;
        JLabel icon2 = new JLabel((Icon)(isMenuItem ? AnimatedIcon.Default.INSTANCE : AnimatedIcon.Big.INSTANCE));
        Dimension size = icon2.getPreferredSize();
        icon2.setSize(size);
        Point location = point.getPoint((Component)glassPane);
        if (isMenuItem) {
            location.x -= 2 * size.width;
            location.y += (comp.getSize().height - size.height + 1) / 2;
        } else {
            location.x -= size.width / 2;
            location.y -= size.height / 2;
        }
        icon2.setLocation(location);
        EdtScheduledExecutorService.getInstance().schedule(() -> {
            if (!icon2.isVisible()) {
                return;
            }
            glassPane.add(icon2);
        }, (long)Registry.intValue((String)"actionSystem.popup.progress.icon.delay", (int)500), TimeUnit.MILLISECONDS);
        Runnable runnable4 = () -> {
            if (icon2.getParent() != null) {
                glassPane.remove(icon2);
            } else {
                icon2.setVisible(false);
            }
        };
        if (runnable4 == null) {
            Utils.$$$reportNull$$$0(41);
        }
        return runnable4;
    }

    private static void fillMenuInner(@NotNull JComponent component2, @NotNull List<? extends AnAction> list2, boolean checked, boolean enableMnemonics, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context2, @NotNull String place, boolean isWindowMenu, boolean useDarkIcons) {
        Menu nativePeer;
        if (component2 == null) {
            Utils.$$$reportNull$$$0(42);
        }
        if (list2 == null) {
            Utils.$$$reportNull$$$0(43);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(44);
        }
        if (context2 == null) {
            Utils.$$$reportNull$$$0(45);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(46);
        }
        component2.removeAll();
        Menu menu = nativePeer = component2 instanceof ActionMenu ? ((ActionMenu)((Object)component2)).getScreenMenuPeer() : null;
        if (nativePeer != null) {
            nativePeer.beginFill();
        }
        ArrayList<Object> children2 = new ArrayList<Object>();
        int size = list2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            AnAction action2 = list2.get(i2);
            Presentation presentation2 = presentationFactory.getPresentation(action2);
            if (!(action2 instanceof Separator) && presentation2.isVisible() && StringUtil.isEmpty((String)presentation2.getText())) {
                String message2 = "Skipping empty menu item for action '" + action2 + "' (" + action2.getClass() + ")";
                if (action2.getTemplatePresentation().getText() == null) {
                    message2 = message2 + ". Please specify some default action text in plugin.xml or action constructor";
                }
                LOG.warn(message2);
                continue;
            }
            if (action2 instanceof Separator) {
                String text2 = ((Separator)action2).getText();
                if (StringUtil.isEmpty((String)text2) && (i2 <= 0 || i2 >= size - 1)) continue;
                JPopupMenu.Separator separator2 = Utils.createSeparator(text2);
                component2.add(separator2);
                children2.add(separator2);
                if (nativePeer == null) continue;
                nativePeer.add(null);
                continue;
            }
            if (action2 instanceof ActionGroup && !Boolean.TRUE.equals(presentation2.getClientProperty("actionGroup.perform.only"))) {
                ActionMenu menu2 = new ActionMenu(context2, place, (ActionGroup)action2, presentationFactory, enableMnemonics, useDarkIcons);
                component2.add((Component)((Object)menu2));
                children2.add((Object)menu2);
                if (nativePeer == null) continue;
                nativePeer.add((MenuItem)menu2.getScreenMenuPeer());
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action2, presentation2, place, context2, enableMnemonics, true, checked, useDarkIcons);
            component2.add((Component)((Object)each));
            children2.add((Object)each);
            if (nativePeer == null) continue;
            nativePeer.add(each.getScreenMenuItemPeer());
        }
        if (list2.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context2, enableMnemonics, true, checked, useDarkIcons);
            component2.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (SystemInfo.isMacSystemMenu && isWindowMenu) {
            if (ActionMenu.isAligned()) {
                Icon icon2 = Utils.hasIcons(children2) ? ActionMenuItem.EMPTY_ICON : null;
                children2.forEach((Consumer<Object>)((Consumer<Component>)child2 -> Utils.replaceIconIn(child2, icon2)));
            } else if (ActionMenu.isAlignedInGroup()) {
                ArrayList<Component> currentGroup = new ArrayList<Component>();
                for (int i3 = 0; i3 < children2.size(); ++i3) {
                    boolean isLastElement;
                    Component child3 = (Component)children2.get(i3);
                    boolean isSeparator = child3 instanceof JPopupMenu.Separator;
                    boolean bl = isLastElement = i3 == children2.size() - 1;
                    if (isLastElement || isSeparator) {
                        if (isLastElement && !isSeparator) {
                            currentGroup.add(child3);
                        }
                        Icon icon3 = Utils.hasIcons(currentGroup) ? ActionMenuItem.EMPTY_ICON : null;
                        currentGroup.forEach(menuItem -> Utils.replaceIconIn(menuItem, icon3));
                        currentGroup.clear();
                        continue;
                    }
                    currentGroup.add(child3);
                }
            }
        }
    }

    @NotNull
    private static JPopupMenu.Separator createSeparator(final @NlsContexts.Separator String text2) {
        return new JPopupMenu.Separator(){
            private final JMenuItem myMenu;
            {
                this.myMenu = !StringUtil.isEmpty((String)text2) ? new JMenuItem(text2) : null;
            }

            @Override
            public void doLayout() {
                super.doLayout();
                if (this.myMenu != null) {
                    this.myMenu.setBounds(this.getBounds());
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel()) {
                    g.setColor(this.getParent().getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (this.myMenu != null) {
                    this.myMenu.paint(g);
                } else {
                    super.paintComponent(g);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.myMenu != null ? this.myMenu.getPreferredSize() : super.getPreferredSize();
            }
        };
    }

    private static void replaceIconIn(Component menuItem, Icon icon2) {
        Icon from2;
        Icon icon3 = from2 = icon2 == null ? ActionMenuItem.EMPTY_ICON : null;
        if (menuItem instanceof ActionMenuItem && ((ActionMenuItem)((Object)menuItem)).getIcon() == from2) {
            ((ActionMenuItem)((Object)menuItem)).setIcon(icon2);
        } else if (menuItem instanceof ActionMenu && ((ActionMenu)((Object)menuItem)).getIcon() == from2) {
            ((ActionMenu)((Object)menuItem)).setIcon(icon2);
        }
    }

    private static boolean hasIcons(List<? extends Component> components) {
        for (Component component2 : components) {
            if (!Utils.hasNotEmptyIcon(component2)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNotEmptyIcon(Component comp) {
        Icon icon2 = null;
        if (comp instanceof ActionMenuItem) {
            icon2 = ((ActionMenuItem)((Object)comp)).getIcon();
        } else if (comp instanceof ActionMenu) {
            icon2 = ((ActionMenu)((Object)comp)).getIcon();
        }
        return icon2 != null && icon2 != ActionMenuItem.EMPTY_ICON;
    }

    @NotNull
    public static UpdateSession getOrCreateUpdateSession(@NotNull AnActionEvent e) {
        UpdateSession updater;
        if (e == null) {
            Utils.$$$reportNull$$$0(47);
        }
        if ((updater = e.getUpdateSession()) == null) {
            ActionUpdater actionUpdater = new ActionUpdater(LaterInvocator.isInModalContext(), new PresentationFactory(), e.getDataContext(), e.getPlace(), e.isFromContextMenu(), e.isFromActionToolbar());
            updater = actionUpdater.asUpdateSession();
        }
        UpdateSession updateSession = updater;
        if (updateSession == null) {
            Utils.$$$reportNull$$$0(48);
        }
        return updateSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public static <T> T runUpdateSessionForInputEvent(@NotNull InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull String place, @NotNull ActionProcessor actionProcessor, @NotNull PresentationFactory factory2, @Nullable Consumer<? super AnActionEvent> eventTracker, @NotNull Function<? super UpdateSession, ? extends T> function) {
        T result2;
        ApplicationEx applicationEx;
        if (inputEvent == null) {
            Utils.$$$reportNull$$$0(49);
        }
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(50);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(51);
        }
        if (actionProcessor == null) {
            Utils.$$$reportNull$$$0(52);
        }
        if (factory2 == null) {
            Utils.$$$reportNull$$$0(53);
        }
        if (function == null) {
            Utils.$$$reportNull$$$0(54);
        }
        if (ProgressIndicatorUtils.isWriteActionRunningOrPending(applicationEx = ApplicationManagerEx.getApplicationEx())) {
            LOG.error("Actions cannot be updated when write-action is running or pending");
            return null;
        }
        if (ourInUpdateSessionForInputEventEDTLoop) {
            LOG.warn("Recursive shortcut processing invocation is ignored");
            return null;
        }
        long start2 = System.currentTimeMillis();
        boolean async = Utils.isAsyncDataContext(dataContext);
        LinkedBlockingQueue queue2 = async ? new LinkedBlockingQueue() : null;
        ActionUpdater actionUpdater = new ActionUpdater(LaterInvocator.isInModalContext(), factory2, dataContext, place, false, false, event -> {
            AnActionEvent transformed = actionProcessor.createEvent(inputEvent, event.getDataContext(), event.getPlace(), event.getPresentation(), event.getActionManager());
            if (eventTracker != null) {
                eventTracker.accept(transformed);
            }
            return transformed;
        }, async ? queue2::offer : null);
        if (async) {
            ActionUpdater.cancelAllUpdates("'" + place + "' invoked");
            AsyncPromise promise = ActionUpdater.newPromise(place);
            ProgressIndicator parentIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            ActionUpdater.ourBeforePerformedExecutor.execute(() -> {
                try {
                    Ref ref = Ref.create();
                    Ref sessionRef = Ref.create();
                    Runnable runnable2 = () -> {
                        Set missedKeys = ContainerUtil.newConcurrentSet();
                        UpdateSession fastSession = actionUpdater.asFastUpdateSession(missedKeys::add, null);
                        Object fastResult = function.apply(fastSession);
                        sessionRef.set((Object)fastSession);
                        if (fastResult != null) {
                            ref.set(fastResult);
                        } else if (Utils.tryInReadAction(() -> ContainerUtil.exists((Iterable)missedKeys, o -> dataContext.getData((String)o) != null))) {
                            UpdateSession slowSession = actionUpdater.asUpdateSession();
                            Object slowResult = function.apply(slowSession);
                            ref.set(slowResult);
                            sessionRef.set((Object)slowSession);
                        }
                    };
                    boolean inReadAction = Registry.is((String)"actionSystem.update.actions.call.beforeActionPerformedUpdate.once");
                    Object indicator2 = parentIndicator == null ? new EmptyProgressIndicator() : new SensitiveProgressWrapper(parentIndicator);
                    promise.onError(arg_0 -> Utils.lambda$runUpdateSessionForInputEvent$12((ProgressIndicator)indicator2, arg_0));
                    ProgressManager.getInstance().computePrioritized(() -> Utils.lambda$runUpdateSessionForInputEvent$16(inReadAction, runnable2, applicationEx, promise, (ProgressIndicator)indicator2, ref));
                    queue2.offer(ActionUpdater.getActionUpdater((UpdateSession)sessionRef.get())::applyPresentationChanges);
                    queue2.offer(() -> promise.setResult(ref.get()));
                }
                catch (Throwable e) {
                    promise.setError(e);
                }
            });
            try {
                ourInUpdateSessionForInputEventEDTLoop = true;
                result2 = Utils.runLoopAndWaitForFuture(promise, null, false, () -> {
                    Runnable runnable2 = (Runnable)queue2.poll(1L, TimeUnit.MILLISECONDS);
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                    if (parentIndicator != null) {
                        parentIndicator.checkCanceled();
                    }
                });
            }
            finally {
                ourInUpdateSessionForInputEventEDTLoop = false;
            }
        } else {
            result2 = function.apply((UpdateSession)actionUpdater.asUpdateSession());
            actionUpdater.applyPresentationChanges();
        }
        long time = System.currentTimeMillis() - start2;
        if (time > 500L) {
            LOG.debug("runUpdateSessionForKeyEvent() took: " + time + " ms");
        }
        return result2;
    }

    private static <T> T runLoopAndWaitForFuture(@NotNull Future<? extends T> promise, @Nullable T defValue, boolean rethrowCancellation, @NotNull ThrowableRunnable<?> pumpRunnable) {
        if (promise == null) {
            Utils.$$$reportNull$$$0(55);
        }
        if (pumpRunnable == null) {
            Utils.$$$reportNull$$$0(56);
        }
        while (!promise.isDone()) {
            try {
                pumpRunnable.run();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        try {
            return promise.isCancelled() ? defValue : promise.get();
        }
        catch (Throwable ex) {
            Throwable cause = ExceptionUtil.getRootCause((Throwable)ex);
            if (!(cause instanceof ProcessCanceledException)) {
                LOG.error(cause);
            } else if (rethrowCancellation) {
                cause.fillInStackTrace();
                throw (ProcessCanceledException)cause;
            }
            return defValue;
        }
    }

    @ApiStatus.Internal
    public static boolean tryInReadAction(@NotNull BooleanSupplier supplier2) {
        if (supplier2 == null) {
            Utils.$$$reportNull$$$0(57);
        }
        boolean[] result2 = new boolean[]{false};
        ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
            result2[0] = supplier2.getAsBoolean();
        });
        return result2[0];
    }

    static void performWithRetries(@NotNull Runnable runnable2, @NotNull BooleanSupplier expire) {
        if (runnable2 == null) {
            Utils.$$$reportNull$$$0(58);
        }
        if (expire == null) {
            Utils.$$$reportNull$$$0(59);
        }
        ProcessCanceledWithReasonException lastCancellation = null;
        int retries = Math.max(1, Registry.intValue((String)"actionSystem.update.actions.max.retries", (int)20));
        for (int i2 = 0; i2 < retries; ++i2) {
            try {
                runnable2.run();
                return;
            }
            catch (ProcessCanceledWithReasonException ex) {
                String reasonStr;
                lastCancellation = ex;
                String string = reasonStr = ex.reason instanceof String ? (String)ex.reason : "";
                if (reasonStr.contains("write-action") || reasonStr.contains("fast-track")) {
                    if (!expire.getAsBoolean()) continue;
                    return;
                }
                throw ex;
            }
            catch (Throwable ex) {
                ExceptionUtil.rethrow((Throwable)ex);
            }
        }
        if (retries > 1) {
            LOG.warn("Maximum number of retries to show a menu reached (" + retries + "): " + lastCancellation.reason);
        }
        throw Objects.requireNonNull(lastCancellation);
    }

    private static /* synthetic */ Object lambda$runUpdateSessionForInputEvent$16(boolean inReadAction, Runnable runnable2, ApplicationEx applicationEx, AsyncPromise promise, ProgressIndicator indicator2, Ref ref) throws RuntimeException {
        ProgressManager.getInstance().executeProcessUnderProgress(!inReadAction ? runnable2 : () -> ProgressIndicatorUtils.runActionAndCancelBeforeWrite(applicationEx, () -> ActionUpdater.cancelPromise(promise, "nested write-action requested"), () -> applicationEx.tryRunReadAction(runnable2)), indicator2);
        return ref.get();
    }

    private static /* synthetic */ void lambda$runUpdateSessionForInputEvent$12(ProgressIndicator indicator2, Throwable __) {
        indicator2.cancel();
    }

    static {
        EMPTY_MENU_FILLER.getTemplatePresentation().setText(CommonBundle.messagePointer((String)"empty.menu.filler", (Object[])new Object[0]));
        DO_FULL_EXPAND = Boolean.getBoolean("actionSystem.use.full.group.expand");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 26: 
            case 27: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 26: 
            case 27: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 26: 
            case 27: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/Utils";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 34: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationFactory";
                break;
            }
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 35: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 36: 
            case 38: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 28: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEvent";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionProcessor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pumpRunnable";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expire";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToAsyncDataContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapDataContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeDataContext";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "expandActionGroupImpl";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelOnUserActivityInside";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addLoadingIcon";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateUpdateSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapToAsyncDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 26: 
            case 27: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 48: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapDataContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "freezeDataContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAsyncDataContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRawDataIfCached";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroupAsync";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroupWithTimeout";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroup";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroupImpl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "cancelOnUserActivityInside";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroupFastTrack";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fillMenu";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addLoadingIcon";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "fillMenuInner";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateUpdateSession";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "runUpdateSessionForInputEvent";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "runLoopAndWaitForFuture";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "tryInReadAction";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "performWithRetries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 26: 
            case 27: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ProcessCanceledWithReasonException
    extends ProcessCanceledException {
        final Object reason;

        ProcessCanceledWithReasonException(Object reason) {
            this.reason = reason;
        }
    }
}

