/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.plugins.BundledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.ConfigImportProgressDialog;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.ImportOldConfigsUsagesCollector;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.RestoreDefaultConfigCustomizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullBiFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.text.VersionComparatorUtil;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConfigImportHelper {
    private static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    private static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    public static final String CONFIG_IMPORTED_FROM_OTHER_PRODUCT_KEY = "intellij.config.imported.from.other.product";
    public static final String CONFIG_IMPORTED_FROM_PREVIOUS_VERSION_KEY = "intellij.config.imported.from.previous.version";
    private static final String CONFIG = "config";
    private static final String[] OPTIONS = new String[]{"options/other.xml", "options/ide.general.xml", "options/options.xml"};
    private static final String BIN = "bin";
    private static final String CONTENTS = "Contents";
    private static final String PLIST = "Info.plist";
    private static final String PLUGINS = "plugins";
    private static final String SYSTEM = "system";
    public static final Pattern SELECTOR_PATTERN = Pattern.compile("\\.?([^\\d]+)(\\d+(?:\\.\\d+)*)");
    private static final String SHOW_IMPORT_CONFIG_DIALOG_PROPERTY = "idea.initially.ask.config";
    public static final String CUSTOM_MARKER_FILE_NAME = "migrate.config";

    private ConfigImportHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importConfigsTo(boolean veryFirstStartOnThisComputer, @NotNull Path newConfigDir, @NotNull List<String> args, @NotNull Logger log) {
        boolean vmOptionFileChanged;
        ConfigImportSettings settings;
        block37: {
            if (newConfigDir == null) {
                ConfigImportHelper.$$$reportNull$$$0(0);
            }
            if (args == null) {
                ConfigImportHelper.$$$reportNull$$$0(1);
            }
            if (log == null) {
                ConfigImportHelper.$$$reportNull$$$0(2);
            }
            log.info("Importing configs to " + newConfigDir);
            System.setProperty(FIRST_SESSION_KEY, Boolean.TRUE.toString());
            CustomConfigMigrationOption customMigrationOption = CustomConfigMigrationOption.readCustomConfigMigrationOptionAndRemoveMarkerFile(newConfigDir);
            if (customMigrationOption instanceof CustomConfigMigrationOption.SetProperties) {
                List<String> properties2 = ((CustomConfigMigrationOption.SetProperties)customMigrationOption).getProperties();
                log.info("Enabling system properties after restart: " + properties2);
                Iterator<String> iterator2 = properties2.iterator();
                while (iterator2.hasNext()) {
                    String property2 = iterator2.next();
                    System.setProperty(property2, Boolean.TRUE.toString());
                }
                return;
            }
            settings = ConfigImportHelper.findCustomConfigImportSettings();
            String pathSelectorOfOtherIde = settings != null ? settings.getProductToImportFrom(args) : null;
            ConfigDirsSearchResult guessedOldConfigDirs = ConfigImportHelper.findConfigDirectories(newConfigDir, pathSelectorOfOtherIde);
            File tempBackup = null;
            vmOptionFileChanged = false;
            ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario importScenarioStatistics = null;
            try {
                Pair<Path, Path> oldConfigDirAndOldIdePath;
                block36: {
                    oldConfigDirAndOldIdePath = null;
                    if (customMigrationOption != null) {
                        log.info("Custom migration option: " + customMigrationOption);
                        vmOptionFileChanged = ConfigImportHelper.doesVmOptionsFileExist(newConfigDir);
                        try {
                            if (customMigrationOption instanceof CustomConfigMigrationOption.MigrateFromCustomPlace) {
                                tempBackup = ConfigImportHelper.backupCurrentConfigToTempAndDelete(newConfigDir, log, false);
                                Path location = ((CustomConfigMigrationOption.MigrateFromCustomPlace)customMigrationOption).getLocation();
                                oldConfigDirAndOldIdePath = ConfigImportHelper.findConfigDirectoryByPath(location);
                                importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.IMPORT_SETTINGS_ACTION;
                                break block36;
                            }
                            tempBackup = ConfigImportHelper.backupCurrentConfigToTempAndDelete(newConfigDir, log, true);
                            importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.RESTORE_DEFAULT_ACTION;
                        }
                        catch (IOException e) {
                            log.error("Couldn't backup current config or delete current config directory", (Throwable)e);
                        }
                    } else if (ConfigImportHelper.shouldAskForConfig()) {
                        oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs.getPaths());
                        importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.SHOW_DIALOG_REQUESTED_BY_PROPERTY;
                    } else if (guessedOldConfigDirs.isEmpty()) {
                        boolean importedFromCloud = false;
                        CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
                        if (configProvider != null && (importedFromCloud = configProvider.importSettingsSilently(newConfigDir))) {
                            importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.IMPORTED_FROM_CLOUD;
                        }
                        if (!importedFromCloud && !veryFirstStartOnThisComputer) {
                            oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs.getPaths());
                            importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.SHOW_DIALOG_NO_CONFIGS_FOUND;
                        }
                    } else {
                        Pair<Path, FileTime> bestConfigGuess = guessedOldConfigDirs.getFirstItem();
                        if (ConfigImportHelper.isConfigOld((FileTime)bestConfigGuess.second)) {
                            log.info("The best config guess [" + bestConfigGuess.first + "] is too old, it won't be used for importing.");
                            oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs.getPaths());
                            importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.SHOW_DIALOG_CONFIGS_ARE_TOO_OLD;
                        } else {
                            oldConfigDirAndOldIdePath = ConfigImportHelper.findConfigDirectoryByPath((Path)bestConfigGuess.first);
                            if (oldConfigDirAndOldIdePath == null) {
                                log.info("Previous config directory was detected but not accepted: " + bestConfigGuess.first);
                                importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.CONFIG_DIRECTORY_NOT_FOUND;
                            }
                        }
                    }
                }
                if (oldConfigDirAndOldIdePath != null) {
                    Path oldConfigDir = (Path)oldConfigDirAndOldIdePath.first;
                    Path oldIdeHome = (Path)oldConfigDirAndOldIdePath.second;
                    ConfigImportOptions configImportOptions = new ConfigImportOptions(log);
                    if (!guessedOldConfigDirs.fromSameProduct) {
                        configImportOptions.importPlugins = false;
                        configImportOptions.importSettings = settings;
                        importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.IMPORTED_FROM_OTHER_PRODUCT;
                    } else if (importScenarioStatistics == null) {
                        importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.IMPORTED_FROM_PREVIOUS_VERSION;
                    }
                    if (guessedOldConfigDirs.fromSameProduct) {
                        System.setProperty(CONFIG_IMPORTED_FROM_PREVIOUS_VERSION_KEY, oldConfigDir.toString());
                    } else {
                        System.setProperty(CONFIG_IMPORTED_FROM_OTHER_PRODUCT_KEY, oldConfigDir.toString());
                    }
                    ConfigImportHelper.doImport(oldConfigDir, newConfigDir, oldIdeHome, log, configImportOptions);
                    if (settings != null) {
                        settings.importFinished(newConfigDir);
                    }
                    ConfigImportHelper.setConfigImportedInThisSession();
                } else {
                    log.info("No configs imported, starting with clean configs at " + newConfigDir);
                    if (importScenarioStatistics == null) {
                        importScenarioStatistics = ImportOldConfigsUsagesCollector.ImportOldConfigsState.InitialImportScenario.CLEAN_CONFIGS;
                    }
                }
                ImportOldConfigsUsagesCollector.ImportOldConfigsState.getInstance().reportImportScenario(importScenarioStatistics);
                vmOptionFileChanged |= ConfigImportHelper.doesVmOptionsFileExist(newConfigDir);
                if (tempBackup == null) break block37;
            }
            catch (Throwable throwable) {
                if (tempBackup == null) throw throwable;
                try {
                    ConfigImportHelper.moveTempBackupToStandardBackup(tempBackup);
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir", tempBackup), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ConfigImportHelper.moveTempBackupToStandardBackup(tempBackup);
            }
            catch (IOException e) {
                log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir", tempBackup), (Throwable)e);
            }
        }
        if (!vmOptionFileChanged) return;
        log.info("The vmoptions file has changed, restarting...");
        ArrayList<String> properties3 = new ArrayList<String>();
        properties3.add(FIRST_SESSION_KEY);
        if (ConfigImportHelper.isConfigImported()) {
            properties3.add(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
        }
        if (settings != null) {
            if (!settings.shouldRestartAfterVmOptionsChange()) return;
        }
        new CustomConfigMigrationOption.SetProperties(properties3).writeConfigMarkerFile();
        ConfigImportHelper.restart();
    }

    @Nullable
    static ConfigImportSettings findCustomConfigImportSettings() {
        try {
            String customProviderName = "com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings";
            Class<?> customProviderClass = Class.forName(customProviderName);
            if (ConfigImportSettings.class.isAssignableFrom(customProviderClass)) {
                return (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isConfigOld(FileTime time) {
        Instant deadline = Instant.now().minus(180L, ChronoUnit.DAYS);
        return time.toInstant().compareTo(deadline) < 0;
    }

    private static boolean doesVmOptionsFileExist(Path configDir) {
        return Files.isRegularFile(configDir.resolve(VMOptions.getFileName()), new LinkOption[0]);
    }

    private static void restart() {
        if (Restarter.isSupported()) {
            try {
                Restarter.scheduleRestart(false, new String[0]);
            }
            catch (IOException e) {
                Main.showMessage((String)BootstrapBundle.message((String)"restart.failed.title", (Object[])new Object[0]), (Throwable)e);
            }
            System.exit(0);
        } else {
            String no;
            String yes;
            String title2 = BootstrapBundle.message((String)"import.settings.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            String message2 = BootstrapBundle.message((String)"import.settings.restart", (Object[])new Object[0]);
            if (Messages.showYesNoDialog((String)message2, (String)title2, (String)(yes = BootstrapBundle.message((String)"import.settings.restart.now", (Object[])new Object[0])), (String)(no = BootstrapBundle.message((String)"import.settings.restart.later", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) == 0) {
                System.exit(0);
            }
        }
    }

    private static File backupCurrentConfigToTempAndDelete(Path currentConfig, Logger log, boolean smartDelete) throws IOException {
        Path configDir = PathManager.getConfigDir();
        File tempBackupDir = FileUtil.createTempDirectory((String)configDir.getFileName().toString(), (String)("-backup-" + UUID.randomUUID()));
        log.info("Backup config from " + currentConfig + " to " + tempBackupDir);
        FileUtil.copyDir((File)configDir.toFile(), (File)tempBackupDir, file2 -> !ConfigImportHelper.shouldSkipFileDuringImport(file2.getName()));
        ConfigImportHelper.deleteCurrentConfigDir(currentConfig, log, smartDelete);
        Path pluginsDir = currentConfig.getFileSystem().getPath(PathManager.getPluginsPath(), new String[0]);
        if (Files.exists(pluginsDir, new LinkOption[0]) && !pluginsDir.startsWith(currentConfig)) {
            File pluginsBackup = new File(tempBackupDir, PLUGINS);
            log.info("Backup plugins dir separately from " + pluginsDir + " to " + pluginsBackup);
            if (pluginsBackup.mkdir()) {
                FileUtil.copyDir((File)new File(pluginsDir.toString()), (File)pluginsBackup);
                FileUtil.delete((Path)pluginsDir);
            } else {
                log.warn("Couldn't backup plugins directory to " + pluginsBackup);
            }
        }
        return tempBackupDir;
    }

    private static void deleteCurrentConfigDir(Path currentConfig, Logger log, boolean smartDelete) throws IOException {
        log.debug("Removing current config directory, smartDelete: " + smartDelete);
        if (!smartDelete) {
            FileUtil.delete((Path)currentConfig);
            return;
        }
        boolean removedViaCustomizer = false;
        try {
            Iterator<RestoreDefaultConfigCustomizer> iterator2 = ServiceLoader.load(RestoreDefaultConfigCustomizer.class).iterator();
            if (iterator2.hasNext()) {
                RestoreDefaultConfigCustomizer customizer = iterator2.next();
                log.debug("Found " + customizer);
                customizer.removeCurrentConfigDir(currentConfig);
                removedViaCustomizer = true;
            }
        }
        catch (Exception e) {
            log.warn("Couldn't remove current config dir using the customizer", (Throwable)e);
        }
        if (!removedViaCustomizer) {
            log.debug("RestoreDefaultConfigCustomizer not found, removing config directory manually...");
            FileUtil.delete((Path)currentConfig);
        }
    }

    private static void moveTempBackupToStandardBackup(File backupToMove) throws IOException {
        new ConfigBackup(PathManager.getConfigDir()).moveToBackup(backupToMove);
    }

    private static boolean shouldAskForConfig() {
        String showImportDialog = System.getProperty(SHOW_IMPORT_CONFIG_DIALOG_PROPERTY);
        if ("force-not".equals(showImportDialog)) {
            return false;
        }
        return PluginManagerCore.isRunningFromSources() || System.getProperty("idea.config.path") != null || "true".equals(showImportDialog);
    }

    @Nullable
    private static Pair<Path, Path> showDialogAndGetOldConfigPath(List<Path> guessedOldConfigDirs) {
        ImportOldConfigsPanel dialog2 = new ImportOldConfigsPanel(guessedOldConfigDirs, ConfigImportHelper::findConfigDirectoryByPath);
        dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        AppUIUtil.updateWindowIcon(dialog2);
        Ref result2 = new Ref();
        SplashManager.executeWithHiddenSplash(dialog2, () -> {
            dialog2.setVisible(true);
            result2.set(dialog2.getSelectedFile());
            dialog2.dispose();
        });
        return (Pair)result2.get();
    }

    public static boolean isFirstSession() {
        return Boolean.getBoolean(FIRST_SESSION_KEY);
    }

    public static boolean isNewUser() {
        return ConfigImportHelper.isFirstSession() && !ConfigImportHelper.isConfigImported();
    }

    public static boolean isSettingsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(3);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)ArchiveFileType.INSTANCE);
    }

    public static void setConfigImportedInThisSession() {
        System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
    }

    public static boolean isConfigImported() {
        return Boolean.getBoolean(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
    }

    static boolean isValidSettingsFile(@NotNull File file2) {
        boolean bl;
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(4);
        }
        ZipFile zip = new ZipFile(file2);
        try {
            bl = zip.getEntry("IntelliJ IDEA Global Settings") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return false;
            }
        }
        zip.close();
        return bl;
    }

    public static boolean isConfigDirectory(@NotNull Path candidate) {
        if (candidate == null) {
            ConfigImportHelper.$$$reportNull$$$0(5);
        }
        return ContainerUtil.exists((Object[])OPTIONS, name2 -> Files.exists(candidate.resolve((String)name2), new LinkOption[0]));
    }

    @NotNull
    static ConfigDirsSearchResult findConfigDirectories(@NotNull Path newConfigDir) {
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(6);
        }
        return ConfigImportHelper.findConfigDirectories(newConfigDir, null);
    }

    @NotNull
    static ConfigDirsSearchResult findConfigDirectories(@NotNull Path newConfigDir, @Nullable String productPrefixOtherIde) {
        boolean exact;
        ArrayList<Path> candidates;
        String productName;
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(7);
        }
        HashSet<Path> homes = new HashSet<Path>();
        homes.add(newConfigDir.getParent());
        homes.add(newConfigDir.getFileSystem().getPath(PathManager.getDefaultConfigPathFor((String)"X"), new String[0]).getParent());
        Path historic = newConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultConfigPath("X2019.3"), new String[0]);
        Path historicHome = SystemInfo.isMac ? historic.getParent() : historic.getParent().getParent();
        homes.add(historicHome);
        String prefix = ConfigImportHelper.getPrefixFromSelector(PathManager.getPathsSelector());
        if (prefix == null) {
            prefix = ConfigImportHelper.getPrefixFromSelector(ConfigImportHelper.getNameWithVersion(newConfigDir));
        }
        if (prefix == null && (productName = ApplicationNamesInfo.getInstance().getFullProductName()) != null) {
            prefix = productName.replace(" ", "");
        }
        if (prefix == null) {
            prefix = PlatformUtils.getPlatformPrefix();
        }
        ArrayList<Path> exactCandidates = new ArrayList<Path>();
        ArrayList<Path> otherPreferredCandidates = new ArrayList<Path>();
        ArrayList<Path> otherCandidates = new ArrayList<Path>();
        for (Path home2 : homes) {
            if (home2 == null || !Files.isDirectory(home2, new LinkOption[0])) continue;
            boolean dotted = !SystemInfo.isMac && home2 == historicHome;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(home2);
                try {
                    for (Path path2 : stream) {
                        if (path2.equals(newConfigDir) || !Files.isDirectory(path2, new LinkOption[0])) continue;
                        String name2 = path2.getFileName().toString();
                        if (ConfigImportHelper.nameMatchesPrefix(name2, prefix, dotted)) {
                            exactCandidates.add(path2);
                            continue;
                        }
                        if (!exactCandidates.isEmpty() || productPrefixOtherIde == null) continue;
                        if (ConfigImportHelper.nameMatchesPrefix(name2, productPrefixOtherIde, dotted)) {
                            otherPreferredCandidates.add(path2);
                            continue;
                        }
                        if (!otherPreferredCandidates.isEmpty() || !ConfigImportHelper.isConfigDirectory(path2)) continue;
                        otherCandidates.add(path2);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (!exactCandidates.isEmpty()) {
            candidates = exactCandidates;
            exact = true;
        } else if (!otherPreferredCandidates.isEmpty()) {
            candidates = otherPreferredCandidates;
            exact = false;
        } else if (!otherCandidates.isEmpty()) {
            candidates = otherCandidates;
            exact = false;
        } else {
            return new ConfigDirsSearchResult(List.of(), true);
        }
        ArrayList<Pair<Path, FileTime>> lastModified = new ArrayList<Pair<Path, FileTime>>();
        Iterator iterator2 = candidates.iterator();
        while (iterator2.hasNext()) {
            Path child2;
            Path candidate = child2 = (Path)iterator2.next();
            Path config2 = child2.resolve(CONFIG);
            if (Files.isDirectory(config2, new LinkOption[0])) {
                candidate = config2;
            }
            FileTime max = null;
            for (String name3 : OPTIONS) {
                try {
                    FileTime cur = Files.getLastModifiedTime(candidate.resolve(name3), new LinkOption[0]);
                    if (max != null && cur.compareTo(max) <= 0) continue;
                    max = cur;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            lastModified.add((Pair<Path, FileTime>)Pair.pair((Object)candidate, (Object)(max != null ? max : FileTime.fromMillis(0L))));
        }
        lastModified.sort((o1, o2) -> {
            int diff = ((FileTime)o2.second).compareTo((FileTime)o1.second);
            if (diff == 0) {
                diff = StringUtil.naturalCompare((String)((Path)o2.first).toString(), (String)((Path)o1.first).toString());
            }
            return diff;
        });
        return new ConfigDirsSearchResult(lastModified, exact);
    }

    private static boolean nameMatchesPrefix(String name2, String prefix, boolean dotted) {
        return StringUtil.startsWithIgnoreCase((String)name2, (String)(dotted ? "." + prefix : prefix));
    }

    private static String getNameWithVersion(Path configDir) {
        String name2 = configDir.getFileName().toString();
        if (CONFIG.equals(name2)) {
            name2 = StringUtil.trimStart((String)configDir.getParent().getFileName().toString(), (String)".");
        }
        return name2;
    }

    @Nullable
    private static String getPrefixFromSelector(@Nullable String nameWithSelector) {
        Matcher m;
        if (nameWithSelector != null && (m = SELECTOR_PATTERN.matcher(nameWithSelector)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    private static Pair<Path, Path> findConfigDirectoryByPath(Path selectedDir) {
        Path configDir;
        if (ConfigImportHelper.isConfigDirectory(selectedDir)) {
            return Pair.pair((Object)selectedDir, null);
        }
        Path config2 = selectedDir.resolve(CONFIG);
        if (ConfigImportHelper.isConfigDirectory(config2)) {
            return Pair.pair((Object)config2, null);
        }
        if (Files.isDirectory(selectedDir.resolve(SystemInfo.isMac ? CONTENTS : BIN), new LinkOption[0]) && (configDir = ConfigImportHelper.getSettingsPath(selectedDir, "idea.config.path", ConfigImportHelper::defaultConfigPath)) != null && ConfigImportHelper.isConfigDirectory(configDir)) {
            return Pair.pair((Object)configDir, (Object)selectedDir);
        }
        return null;
    }

    @Nullable
    private static Path getSettingsPath(Path ideHome, String propertyName, Function<? super String, String> pathBySelector) {
        Path candidate;
        ArrayList<Path> files2 = new ArrayList<Path>();
        if (SystemInfo.isMac) {
            files2.add(ideHome.resolve("Contents/bin/idea.properties"));
            files2.add(ideHome.resolve("Contents/Info.plist"));
        } else {
            files2.add(ideHome.resolve("bin/idea.properties"));
            String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
            files2.add(ideHome.resolve("bin/" + scriptName + ".bat"));
            files2.add(ideHome.resolve("bin/" + scriptName + ".sh"));
        }
        for (Path file2 : files2) {
            String candidatePath;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (candidatePath = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromFile(file2, propertyName), (String)ideHome.toString())) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(candidatePath, new String[0]), new LinkOption[0])) continue;
            return candidate.toAbsolutePath();
        }
        for (Path file2 : files2) {
            String selector;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (selector = ConfigImportHelper.getPropertyFromFile(file2, "idea.paths.selector")) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(pathBySelector.apply(selector), new String[0]), new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static String getPropertyFromFile(Path file2, String propertyName) {
        try {
            String propertyValue;
            String fileContent = Files.readString(file2);
            String fileName = file2.getFileName().toString();
            if (fileName.endsWith(".properties")) {
                PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(fileContent));
                return bundle.containsKey(propertyName) ? bundle.getString(propertyName) : null;
            }
            if (fileName.endsWith(".plist") && !StringUtil.isEmpty((String)(propertyValue = ConfigImportHelper.findPListKey(propertyName, fileContent)))) {
                return propertyValue;
            }
            propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
            if (!StringUtil.isEmpty((String)propertyValue)) {
                return propertyValue;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String findPListKey(String propertyName, String fileContent) {
        String key = "<key>" + propertyName + "</key>";
        int idx = fileContent.indexOf(key);
        if (idx > 0 && (idx = fileContent.indexOf("<string>", idx + key.length())) != -1) {
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)));
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String prefix = propertyName + "=";
        int idx = fileContent.indexOf(prefix);
        if (idx >= 0) {
            StringBuilder configDir = new StringBuilder();
            if (fileContent.length() > (idx += prefix.length())) {
                boolean quoted;
                boolean bl = quoted = fileContent.charAt(idx) == '\"';
                if (quoted) {
                    ++idx;
                }
                while (fileContent.length() > idx && (quoted ? fileContent.charAt(idx) != '\"' : fileContent.charAt(idx) != ' ' && fileContent.charAt(idx) != '\t') && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir.append(fileContent.charAt(idx));
                    ++idx;
                }
            }
            if (configDir.length() > 0) {
                return Paths.get(ConfigImportHelper.fixDirName(configDir.toString()), new String[0]).toString();
            }
        }
        return null;
    }

    private static String fixDirName(String dir) {
        return FileUtil.expandUserHome((String)StringUtil.unquoteString((String)dir, (char)'\"'));
    }

    private static void doImport(Path oldConfigDir, Path newConfigDir, @Nullable Path oldIdeHome, Logger log, ConfigImportOptions importOptions) {
        if (oldConfigDir.equals(newConfigDir)) {
            log.info("New config directory is the same as the old one, no import needed.");
            return;
        }
        Path oldPluginsDir = oldConfigDir.resolve(PLUGINS);
        if (!Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            oldPluginsDir = null;
            if (oldIdeHome != null) {
                oldPluginsDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.plugins.path", ConfigImportHelper::defaultPluginsPath);
            }
            if (oldPluginsDir == null) {
                oldPluginsDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultPluginsPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]);
            }
        }
        Path newPluginsDir = newConfigDir.getFileSystem().getPath(PathManager.getPluginsPath(), new String[0]);
        try {
            log.info(String.format("Importing configs: oldConfigDir=[%s], newConfigDir=[%s], oldIdeHome=[%s], oldPluginsDir=[%s], newPluginsDir=[%s]", oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir));
            ConfigImportHelper.doImport(oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir, importOptions);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            String message2 = BootstrapBundle.message((String)"import.settings.failed", (Object[])new Object[]{e.getMessage()});
            Main.showMessage((String)BootstrapBundle.message((String)"import.settings.failed.title", (Object[])new Object[0]), (String)message2, (boolean)false);
        }
    }

    static void doImport(final @NotNull Path oldConfigDir, final @NotNull Path newConfigDir, @Nullable Path oldIdeHome, final @NotNull Path oldPluginsDir, @NotNull Path newPluginsDir, @NotNull ConfigImportOptions options2) throws IOException {
        boolean importBundledPlugins;
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(8);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(9);
        }
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(10);
        }
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(11);
        }
        if (options2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(12);
        }
        Logger log = options2.log;
        if (Files.isRegularFile(oldConfigDir, new LinkOption[0])) {
            new Decompressor.Zip(oldConfigDir).extract(newConfigDir);
            return;
        }
        Files.walkFileTree(oldConfigDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return ConfigImportHelper.blockImport(dir, oldConfigDir, newConfigDir, oldPluginsDir) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                if (!ConfigImportHelper.blockImport(file2, oldConfigDir, newConfigDir, oldPluginsDir)) {
                    Path target2 = newConfigDir.resolve(oldConfigDir.relativize(file2));
                    NioFiles.createDirectories((Path)target2.getParent());
                    Files.copy(file2, target2, LinkOption.NOFOLLOW_LINKS);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        List<StartupActionScriptManager.ActionCommand> actionCommands = ConfigImportHelper.loadStartupActionScript(oldConfigDir, oldIdeHome, oldPluginsDir);
        boolean bl = importBundledPlugins = options2.importSettings != null && options2.importSettings.shouldImportBundledPlugins();
        if (!options2.importPlugins && !importBundledPlugins) {
            log.info("plugins are not imported.");
        } else if (options2.importPlugins && !Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            log.info("non-existing plugins directory: " + oldPluginsDir);
        } else if (!ConfigImportHelper.isEmptyDirectory(newPluginsDir)) {
            log.info("non-empty plugins directory: " + newPluginsDir);
        } else {
            ConfigImportHelper.migratePlugins(oldPluginsDir, newPluginsDir, oldConfigDir, actionCommands, options2);
        }
        if (SystemInfo.isMac && (PlatformUtils.isIntelliJ() || "AndroidStudio".equals(PlatformUtils.getPlatformPrefix()))) {
            ConfigImportHelper.setKeymapIfNeeded(oldConfigDir, newConfigDir, log);
        }
        StartupActionScriptManager.executeActionScriptCommands(actionCommands, (Path)oldPluginsDir, (Path)newPluginsDir);
        ConfigImportHelper.updateVMOptions(newConfigDir, log);
    }

    private static List<StartupActionScriptManager.ActionCommand> loadStartupActionScript(Path oldConfigDir, @Nullable Path oldIdeHome, Path oldPluginsDir) throws IOException {
        if (Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            Path script;
            Path oldSystemDir = oldConfigDir.getParent().resolve(SYSTEM);
            if (!Files.isDirectory(oldSystemDir, new LinkOption[0])) {
                oldSystemDir = null;
                if (oldIdeHome != null) {
                    oldSystemDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.system.path", ConfigImportHelper::defaultSystemPath);
                }
                if (oldSystemDir == null) {
                    oldSystemDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultSystemPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]);
                }
            }
            if (Files.isRegularFile(script = oldSystemDir.resolve("plugins/action.script"), new LinkOption[0])) {
                return StartupActionScriptManager.loadActionScript((Path)script);
            }
        }
        return List.of();
    }

    private static void migratePlugins(Path oldPluginsDir, Path newPluginsDir, Path oldConfigDir, List<StartupActionScriptManager.ActionCommand> actionCommands, ConfigImportOptions options2) throws IOException {
        Logger log = options2.log;
        try {
            List<PluginId> pendingUpdates;
            ArrayList<IdeaPluginDescriptor> pluginsToMigrate = new ArrayList<IdeaPluginDescriptor>();
            ArrayList<IdeaPluginDescriptor> pluginsToDownload = new ArrayList<IdeaPluginDescriptor>();
            if (options2.importPlugins) {
                pendingUpdates = ConfigImportHelper.collectPendingPluginUpdates(actionCommands, options2);
                PluginDescriptorLoader.getDescriptorsToMigrate(oldPluginsDir, options2.compatibleBuildNumber, options2.bundledPluginPath, options2.brokenPluginVersions, pluginsToMigrate, pluginsToDownload);
                ConfigImportHelper.migratePlugins(newPluginsDir, pluginsToMigrate, pendingUpdates, log);
            } else {
                pendingUpdates = new ArrayList<PluginId>();
                log.info("non-bundled plugins are not imported.");
            }
            if (options2.importSettings != null && options2.importSettings.shouldImportBundledPlugins()) {
                ConfigImportHelper.collectBundledPluginsToDownload(oldConfigDir, pluginsToDownload, options2.importSettings);
            }
            if (!pluginsToDownload.isEmpty()) {
                if (options2.headless) {
                    ConfigImportHelper.downloadUpdatesForIncompatiblePlugins(newPluginsDir, options2, pluginsToDownload, pendingUpdates, (ProgressIndicator)new EmptyProgressIndicator());
                } else {
                    ConfigImportProgressDialog dialog2 = new ConfigImportProgressDialog();
                    dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
                    AppUIUtil.updateWindowIcon(dialog2);
                    SplashManager.executeWithHiddenSplash(dialog2, () -> {
                        new Thread(() -> {
                            ConfigImportHelper.downloadUpdatesForIncompatiblePlugins(newPluginsDir, options2, pluginsToDownload, pendingUpdates, dialog2.getIndicator());
                            SwingUtilities.invokeLater(() -> dialog2.setVisible(false));
                        }, "Plugin migration downloader").start();
                        dialog2.setVisible(true);
                    });
                }
                ConfigImportHelper.migratePlugins(newPluginsDir, pluginsToDownload, pendingUpdates, log);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.info("Error loading list of plugins from old dir, migrating entire plugin directory");
            FileUtil.copyDir((File)oldPluginsDir.toFile(), (File)newPluginsDir.toFile());
        }
    }

    private static List<PluginId> collectPendingPluginUpdates(List<StartupActionScriptManager.ActionCommand> commands, ConfigImportOptions options2) {
        if (commands.isEmpty()) {
            return List.of();
        }
        ArrayList<PluginId> result2 = new ArrayList<PluginId>();
        for (StartupActionScriptManager.ActionCommand command : commands) {
            String source;
            if (command instanceof StartupActionScriptManager.CopyCommand) {
                source = ((StartupActionScriptManager.CopyCommand)command).getSource();
            } else {
                if (!(command instanceof StartupActionScriptManager.UnzipCommand)) continue;
                source = ((StartupActionScriptManager.UnzipCommand)command).getSource();
            }
            try {
                IdeaPluginDescriptorImpl descriptor2 = PluginDescriptorLoader.loadDescriptorFromArtifact(Paths.get(source, new String[0]), null);
                if (descriptor2 != null) {
                    result2.add(descriptor2.getPluginId());
                    continue;
                }
                options2.log.info("No plugin descriptor in pending update " + source);
            }
            catch (IOException e) {
                options2.log.info("Failed to load plugin descriptor from pending update " + source);
            }
        }
        return result2;
    }

    private static void migratePlugins(Path newPluginsDir, List<IdeaPluginDescriptor> pluginsToMigrate, List<PluginId> idsToSkip, Logger log) throws IOException {
        for (IdeaPluginDescriptor descriptor2 : pluginsToMigrate) {
            if (idsToSkip.contains(descriptor2.getPluginId())) {
                log.info("Skipping migration of plugin " + descriptor2.getPluginId() + " because there's a pending update for it");
                continue;
            }
            log.info("Migrating plugin " + descriptor2.getPluginId() + " version " + descriptor2.getVersion());
            if (descriptor2.getPluginPath() == null) continue;
            File path2 = descriptor2.getPluginPath().toFile();
            if (path2.isDirectory()) {
                FileUtil.copyDir((File)path2, (File)new File(newPluginsDir.toFile(), path2.getName()));
                continue;
            }
            FileUtil.copy((File)path2, (File)new File(newPluginsDir.toFile(), path2.getName()));
        }
    }

    private static void downloadUpdatesForIncompatiblePlugins(Path newPluginsDir, ConfigImportOptions options2, List<IdeaPluginDescriptor> incompatiblePlugins, List<PluginId> pendingUpdates, ProgressIndicator indicator2) {
        Logger log = options2.log;
        Iterator<IdeaPluginDescriptor> iterator2 = incompatiblePlugins.iterator();
        while (iterator2.hasNext()) {
            IdeaPluginDescriptor plugin2 = iterator2.next();
            if (pendingUpdates.contains(plugin2.getPluginId())) {
                log.info("Skipping download of compatible version for plugin with pending update: " + plugin2.getPluginId());
                iterator2.remove();
                continue;
            }
            try {
                PluginDownloader downloader = PluginDownloader.createDownloader(plugin2);
                if (options2.downloadFunction != null) {
                    downloader.setDownloadFunction(options2.downloadFunction);
                }
                if (downloader.prepareToInstallAndLoadDescriptor(indicator2, false) != null) {
                    PluginInstaller.unpackPlugin(downloader.getFile().toPath(), newPluginsDir);
                    log.info("Downloaded and unpacked compatible version of plugin " + plugin2.getPluginId());
                    iterator2.remove();
                    continue;
                }
                if (!ConfigImportHelper.isBrokenPlugin(plugin2, options2)) continue;
                iterator2.remove();
            }
            catch (ProcessCanceledException e) {
                log.info("Plugin download cancelled");
                break;
            }
            catch (IOException e) {
                log.info("Failed to download and install compatible version of " + plugin2.getPluginId() + ": " + e.getMessage());
            }
        }
    }

    private static boolean isBrokenPlugin(IdeaPluginDescriptor plugin2, ConfigImportOptions options2) {
        Map<PluginId, Set<String>> versions = options2.brokenPluginVersions;
        return versions != null ? versions.get(plugin2.getPluginId()).contains(plugin2.getVersion()) : PluginManagerCore.isBrokenPlugin(plugin2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEmptyDirectory(Path newPluginsDir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(newPluginsDir);){
            Path path2;
            boolean hidden;
            Iterator<Path> iterator2 = stream.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                path2 = iterator2.next();
            } while (hidden = SystemInfo.isWindows ? Files.readAttributes(path2, DosFileAttributes.class, new LinkOption[0]).isHidden() : path2.getFileName().startsWith("."));
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    static void setKeymapIfNeeded(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @NotNull Logger log) {
        Path keymapOptionFile;
        String keymapFileSpec;
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(13);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(14);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(15);
        }
        String nameWithVersion = ConfigImportHelper.getNameWithVersion(oldConfigDir);
        Matcher m = Pattern.compile("\\.?[^\\d]+(\\d+\\.\\d+)?").matcher(nameWithVersion);
        if (m.matches() && VersionComparatorUtil.compare((String)"2019.1", (String)m.group(1)) >= 0 && (keymapFileSpec = StoreUtilKt.getDefaultStoragePathSpec(KeymapManagerImpl.class)) != null && !Files.exists(keymapOptionFile = newConfigDir.resolve("options").resolve(keymapFileSpec), new LinkOption[0])) {
            try {
                Files.createDirectories(keymapOptionFile.getParent(), new FileAttribute[0]);
                Files.writeString(keymapOptionFile, (CharSequence)"<application>\n  <component name=\"KeymapManager\">\n    <active_keymap name=\"Mac OS X\" />\n  </component>\n</application>", new OpenOption[0]);
            }
            catch (IOException e) {
                log.error("Cannot set keymap", (Throwable)e);
            }
        }
    }

    private static void updateVMOptions(Path newConfigDir, Logger log) {
        Path vmOptionsFile = newConfigDir.resolve(VMOptions.getFileName());
        if (Files.exists(vmOptionsFile, new LinkOption[0])) {
            try {
                List<String> lines2 = Files.readAllLines(vmOptionsFile, VMOptions.getFileCharset());
                Path platformVmOptionsFile = newConfigDir.getFileSystem().getPath(VMOptions.getPlatformOptionsFile().toString(), new String[0]);
                LinkedHashSet<String> platformLines = new LinkedHashSet<String>(ConfigImportHelper.readPlatformOptions(platformVmOptionsFile, log));
                boolean updated = false;
                ListIterator<String> i2 = lines2.listIterator();
                while (i2.hasNext()) {
                    String line = i2.next().trim();
                    if (line.equals("-XX:MaxJavaStackTraceDepth=-1")) {
                        i2.set("-XX:MaxJavaStackTraceDepth=10000");
                        updated = true;
                        continue;
                    }
                    if (!("-XX:+UseConcMarkSweepGC".equals(line) || "-Xverify:none".equals(line) || "-noverify".equals(line) || "-XX:+UseCompressedOops".equals(line) || line.startsWith("-agentlib:yjpagent") || line.startsWith("-agentpath:") && line.contains("yjpagent") || "-Dsun.io.useCanonPrefixCache=false".equals(line) || "-Dfile.encoding=UTF-8".equals(line) && SystemInfo.isMac) && !ConfigImportHelper.isDuplicateOrLowerValue(line, platformLines)) continue;
                    i2.remove();
                    updated = true;
                }
                if (updated) {
                    Files.write(vmOptionsFile, lines2, VMOptions.getFileCharset(), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                log.warn("Failed to update custom VM options file " + vmOptionsFile, (Throwable)e);
            }
        }
    }

    private static List<String> readPlatformOptions(Path platformVmOptionsFile, Logger log) {
        try {
            return Files.readAllLines(platformVmOptionsFile, VMOptions.getFileCharset());
        }
        catch (IOException e) {
            log.warn("Cannot read platform VM options file " + platformVmOptionsFile, (Throwable)e);
            return List.of();
        }
    }

    private static boolean isDuplicateOrLowerValue(String line, Collection<String> platformLines) {
        int p;
        if (platformLines.isEmpty()) {
            return false;
        }
        if (platformLines.contains(line)) {
            return true;
        }
        if (line.startsWith("-Xms") || line.startsWith("-Xmx") || line.startsWith("-Xss")) {
            return ConfigImportHelper.isLowerValue(line.substring(0, 4), line.substring(4), platformLines);
        }
        if (line.startsWith("-XX:") && (p = line.indexOf(61, 4)) > 0) {
            return ConfigImportHelper.isLowerValue(line.substring(0, p + 1), line.substring(p + 1), platformLines);
        }
        return false;
    }

    private static boolean isLowerValue(String prefix, String userValue, Collection<String> platformLines) {
        for (String line : platformLines) {
            if (!line.startsWith(prefix)) continue;
            try {
                return VMOptions.parseMemoryOption(userValue) <= VMOptions.parseMemoryOption(line.substring(prefix.length()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    private static boolean blockImport(Path path2, Path oldConfig, Path newConfig, Path oldPluginsDir) {
        if (oldConfig.equals(path2.getParent())) {
            String name2 = path2.getFileName().toString();
            return ConfigImportHelper.shouldSkipFileDuringImport(name2) || Files.exists(newConfig.resolve(path2.getFileName()), new LinkOption[0]) || path2.startsWith(oldPluginsDir);
        }
        return false;
    }

    private static boolean shouldSkipFileDuringImport(String fileName) {
        List<String> filesToSkip = Arrays.asList("port", "port.lock", "token", "user.web.token", "bundled_plugins.txt");
        return filesToSkip.contains(fileName) || fileName.startsWith("chrome-user-data");
    }

    private static String defaultConfigPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultConfigPathFor((String)selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Preferences/" + selector : SystemProperties.getUserHome() + "/." + selector + "/config");
    }

    private static String defaultPluginsPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultPluginPathFor((String)selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Application Support/" + selector : SystemProperties.getUserHome() + "/." + selector + "/config/plugins");
    }

    private static String defaultSystemPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultSystemPathFor((String)selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Caches/" + selector : SystemProperties.getUserHome() + "/." + selector + "/system");
    }

    private static String defaultLogsPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultLogPathFor((String)selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Logs/" + selector : SystemProperties.getUserHome() + "/." + selector + "/system/logs");
    }

    private static boolean newOrUnknown(String selector) {
        Matcher m = SELECTOR_PATTERN.matcher(selector);
        return !m.matches() || "2020.1".compareTo(m.group(2)) <= 0;
    }

    private static List<Path> getRelatedDirectories(Path config2, boolean forAutoClean) {
        Path logs;
        Path plugins2;
        List files2;
        Path commonParent;
        String selector = ConfigImportHelper.getNameWithVersion(config2);
        FileSystem fs = config2.getFileSystem();
        Path system = fs.getPath(ConfigImportHelper.defaultSystemPath(selector), new String[0]);
        if (!forAutoClean && (commonParent = config2.getParent()).equals(system.getParent()) && ((files2 = NioFiles.list((Path)commonParent)).size() == 1 || files2.size() == 2 && files2.containsAll(List.of(config2, system)))) {
            return List.of(commonParent);
        }
        ArrayList<Path> result2 = new ArrayList<Path>();
        if (!forAutoClean) {
            result2.add(config2);
        }
        if (Files.exists(system, new LinkOption[0])) {
            result2.add(system);
        }
        if (!forAutoClean && !(plugins2 = fs.getPath(ConfigImportHelper.defaultPluginsPath(selector), new String[0])).startsWith(config2) && Files.exists(plugins2, new LinkOption[0])) {
            result2.add(plugins2);
        }
        if (!(logs = fs.getPath(ConfigImportHelper.defaultLogsPath(selector), new String[0])).startsWith(system) && Files.exists(logs, new LinkOption[0])) {
            result2.add(logs);
        }
        return result2;
    }

    private static void collectBundledPluginsToDownload(Path configDir, List<IdeaPluginDescriptor> pluginsToDownload, @NotNull ConfigImportSettings settings) {
        List<kotlin.Pair<PluginId, String>> plugins2;
        if (settings == null) {
            ConfigImportHelper.$$$reportNull$$$0(16);
        }
        if ((plugins2 = BundledPluginsState.getBundledPlugins(configDir)) != null) {
            for (kotlin.Pair<PluginId, String> plugin2 : plugins2) {
                if (!settings.shouldImport((PluginId)plugin2.getFirst(), (String)plugin2.getSecond())) continue;
                PluginNode pluginNode = new PluginNode((PluginId)plugin2.getFirst());
                pluginsToDownload.add(pluginNode);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConfigDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPluginsDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginsDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ConfigImportHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "importConfigsTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSettingsFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSettingsFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findConfigDirectories";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "doImport";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "setKeymapIfNeeded";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "collectBundledPluginsToDownload";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ConfigImportOptions {
        final Logger log;
        boolean headless;
        boolean importPlugins = true;
        @Nullable
        ConfigImportSettings importSettings;
        BuildNumber compatibleBuildNumber = null;
        ThrowableNotNullBiFunction<? super String, ? super ProgressIndicator, ? extends File, ? extends IOException> downloadFunction = null;
        Path bundledPluginPath = null;
        Map<PluginId, Set<String>> brokenPluginVersions = null;

        ConfigImportOptions(Logger log) {
            this.log = log;
        }
    }

    static class ConfigDirsSearchResult {
        private final List<Pair<Path, FileTime>> directories;
        private final boolean fromSameProduct;

        private ConfigDirsSearchResult(List<Pair<Path, FileTime>> directories, boolean fromSameProduct) {
            this.directories = directories;
            this.fromSameProduct = fromSameProduct;
        }

        @NotNull
        List<Path> getPaths() {
            List list2 = ContainerUtil.map(this.directories, it -> (Path)it.first);
            if (list2 == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(0);
            }
            return list2;
        }

        boolean isEmpty() {
            return this.directories.isEmpty();
        }

        @NotNull
        Pair<Path, FileTime> getFirstItem() {
            Pair<Path, FileTime> pair = this.directories.get(0);
            if (pair == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(1);
            }
            return pair;
        }

        @NotNull
        @NlsSafe
        String getNameAndVersion(@NotNull Path config2) {
            if (config2 == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(2);
            }
            String string = ConfigImportHelper.getNameWithVersion(config2);
            if (string == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        List<Path> findRelatedDirectories(@NotNull Path config2, boolean forAutoClean) {
            if (config2 == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(4);
            }
            List<Path> list2 = ConfigImportHelper.getRelatedDirectories(config2, forAutoClean);
            if (list2 == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/ConfigImportHelper$ConfigDirsSearchResult";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ConfigImportHelper.CONFIG;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPaths";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstItem";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/ConfigImportHelper$ConfigDirsSearchResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameAndVersion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRelatedDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameAndVersion";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findRelatedDirectories";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

