/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportOldConfigsUsagesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup EVENT_GROUP = new EventLogGroup("import.old.config", 4);
    private static final EventId2<ImportOldConfigType, Boolean> IMPORT_DIALOG_SHOWN_EVENT = EVENT_GROUP.registerEvent("import.dialog.shown", (EventField)EventFields.Enum((String)"selected", ImportOldConfigType.class), (EventField)EventFields.Boolean((String)"config_folder_exists"));
    private static final EventId1<ImportOldConfigsState.InitialImportScenario> INITIAL_IMPORT_SCENARIO = EVENT_GROUP.registerEvent("import.initially", (EventField)EventFields.Enum((String)"initial_import_scenario", ImportOldConfigsState.InitialImportScenario.class));

    public EventLogGroup getGroup() {
        return EVENT_GROUP;
    }

    public static enum ImportOldConfigType {
        FROM_PREVIOUS,
        FROM_CUSTOM,
        DO_NOT_IMPORT,
        OTHER,
        NOT_INITIALIZED;

    }

    public static class ImportOldConfigsState {
        private static final ImportOldConfigsState ourInstance = new ImportOldConfigsState();
        @Nullable
        private volatile InitialImportScenario myInitialImportScenario = null;
        private volatile boolean myOldConfigPanelWasOpened = false;
        private volatile boolean mySourceConfigFolderExists = false;
        @NotNull
        private volatile ImportOldConfigType myType = ImportOldConfigType.NOT_INITIALIZED;

        @NotNull
        public static ImportOldConfigsState getInstance() {
            ImportOldConfigsState importOldConfigsState = ourInstance;
            if (importOldConfigsState == null) {
                ImportOldConfigsState.$$$reportNull$$$0(0);
            }
            return importOldConfigsState;
        }

        public void reportImportScenario(@NotNull InitialImportScenario strategy) {
            if (strategy == null) {
                ImportOldConfigsState.$$$reportNull$$$0(1);
            }
            this.myInitialImportScenario = strategy;
        }

        @Nullable
        private InitialImportScenario getInitialImportScenario() {
            return this.myInitialImportScenario;
        }

        public void saveImportOldConfigType(@NotNull JRadioButton previous, @NotNull JRadioButton custom, @NotNull JRadioButton doNotImport, boolean configFolderExists) {
            if (previous == null) {
                ImportOldConfigsState.$$$reportNull$$$0(2);
            }
            if (custom == null) {
                ImportOldConfigsState.$$$reportNull$$$0(3);
            }
            if (doNotImport == null) {
                ImportOldConfigsState.$$$reportNull$$$0(4);
            }
            this.myOldConfigPanelWasOpened = true;
            this.mySourceConfigFolderExists = configFolderExists;
            this.myType = ImportOldConfigsState.getOldImportType(previous, custom, doNotImport);
        }

        @NotNull
        private static ImportOldConfigType getOldImportType(@NotNull JRadioButton previous, @NotNull JRadioButton custom, @NotNull JRadioButton doNotImport) {
            if (previous == null) {
                ImportOldConfigsState.$$$reportNull$$$0(5);
            }
            if (custom == null) {
                ImportOldConfigsState.$$$reportNull$$$0(6);
            }
            if (doNotImport == null) {
                ImportOldConfigsState.$$$reportNull$$$0(7);
            }
            if (previous.isSelected()) {
                ImportOldConfigType importOldConfigType = ImportOldConfigType.FROM_PREVIOUS;
                if (importOldConfigType == null) {
                    ImportOldConfigsState.$$$reportNull$$$0(8);
                }
                return importOldConfigType;
            }
            if (custom.isSelected()) {
                ImportOldConfigType importOldConfigType = ImportOldConfigType.FROM_CUSTOM;
                if (importOldConfigType == null) {
                    ImportOldConfigsState.$$$reportNull$$$0(9);
                }
                return importOldConfigType;
            }
            if (doNotImport.isSelected()) {
                ImportOldConfigType importOldConfigType = ImportOldConfigType.DO_NOT_IMPORT;
                if (importOldConfigType == null) {
                    ImportOldConfigsState.$$$reportNull$$$0(10);
                }
                return importOldConfigType;
            }
            ImportOldConfigType importOldConfigType = ImportOldConfigType.OTHER;
            if (importOldConfigType == null) {
                ImportOldConfigsState.$$$reportNull$$$0(11);
            }
            return importOldConfigType;
        }

        public boolean wasOldConfigPanelOpened() {
            return this.myOldConfigPanelWasOpened;
        }

        public boolean doesSourceConfigFolderExist() {
            return this.mySourceConfigFolderExists;
        }

        @NotNull
        public ImportOldConfigType getType() {
            ImportOldConfigType importOldConfigType = this.myType;
            if (importOldConfigType == null) {
                ImportOldConfigsState.$$$reportNull$$$0(12);
            }
            return importOldConfigType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/ImportOldConfigsUsagesCollector$ImportOldConfigsState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previous";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "custom";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doNotImport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/ImportOldConfigsUsagesCollector$ImportOldConfigsState";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldImportType";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reportImportScenario";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "saveImportOldConfigType";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getOldImportType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum InitialImportScenario {
            CLEAN_CONFIGS,
            IMPORTED_FROM_PREVIOUS_VERSION,
            IMPORTED_FROM_OTHER_PRODUCT,
            IMPORTED_FROM_CLOUD,
            CONFIG_DIRECTORY_NOT_FOUND,
            SHOW_DIALOG_NO_CONFIGS_FOUND,
            SHOW_DIALOG_CONFIGS_ARE_TOO_OLD,
            SHOW_DIALOG_REQUESTED_BY_PROPERTY,
            IMPORT_SETTINGS_ACTION,
            RESTORE_DEFAULT_ACTION;

        }
    }

    public static class Trigger
    implements ApplicationInitializedListener {
        public void componentsInitialized() {
            ImportOldConfigsState state = ImportOldConfigsState.getInstance();
            ImportOldConfigsState.InitialImportScenario initialImportScenario = state.getInitialImportScenario();
            if (initialImportScenario != null) {
                INITIAL_IMPORT_SCENARIO.log((Object)initialImportScenario);
            }
            if (state.wasOldConfigPanelOpened()) {
                IMPORT_DIALOG_SHOWN_EVENT.log((Object)state.getType(), (Object)state.doesSourceConfigFolderExist());
            }
        }
    }
}

