/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NlsContexts;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBProtocolCommand {
    public static final String SCHEME = "jetbrains";
    public static final String FRAGMENT_PARAM_NAME = "__fragment";
    private static final ExtensionPointName<JBProtocolCommand> EP_NAME = new ExtensionPointName("com.intellij.jbProtocolCommand");
    private final String myCommand;

    public JBProtocolCommand(@NotNull String command) {
        if (command == null) {
            JBProtocolCommand.$$$reportNull$$$0(0);
        }
        this.myCommand = command;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public void perform(String target2, @NotNull Map<String, String> parameters2) {
        if (parameters2 == null) {
            JBProtocolCommand.$$$reportNull$$$0(1);
        }
        throw PluginException.createByClass((Throwable)new UnsupportedOperationException(), this.getClass());
    }

    public @NotNull Future<@Nullable @NlsContexts.NotificationContent String> perform(@Nullable String target2, @NotNull Map<String, String> parameters2, @Nullable String fragment2) {
        if (parameters2 == null) {
            JBProtocolCommand.$$$reportNull$$$0(2);
        }
        LinkedHashMap<String, String> simpleParameters = new LinkedHashMap<String, String>(parameters2);
        simpleParameters.put(FRAGMENT_PARAM_NAME, fragment2);
        this.perform(target2, simpleParameters);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            JBProtocolCommand.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    @NotNull
    protected String parameter(@NotNull Map<String, String> parameters2, @NotNull String name2) {
        String value2;
        if (parameters2 == null) {
            JBProtocolCommand.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            JBProtocolCommand.$$$reportNull$$$0(5);
        }
        if ((value2 = parameters2.get(name2)) == null || value2.isBlank()) {
            throw new IllegalArgumentException(IdeBundle.message((String)"jb.protocol.parameter.missing", (Object[])new Object[]{name2}));
        }
        String string = value2;
        if (string == null) {
            JBProtocolCommand.$$$reportNull$$$0(6);
        }
        return string;
    }

    @ApiStatus.Internal
    public static @NotNull Future<@Nullable @NlsContexts.NotificationContent String> execute(@NotNull String query2) {
        QueryStringDecoder decoder;
        String[] parts;
        if (query2 == null) {
            JBProtocolCommand.$$$reportNull$$$0(7);
        }
        if ((parts = (decoder = new QueryStringDecoder(query2)).path().split("/")).length < 2) {
            throw new IllegalArgumentException(query2);
        }
        String commandName2 = parts[1];
        for (JBProtocolCommand command : EP_NAME.getIterable()) {
            if (!command.myCommand.equals(commandName2)) continue;
            String target2 = parts.length > 2 ? parts[2] : null;
            LinkedHashMap<String, String> parameters2 = new LinkedHashMap<String, String>();
            for (Map.Entry entry2 : decoder.parameters().entrySet()) {
                List list2 = (List)entry2.getValue();
                parameters2.put((String)entry2.getKey(), list2.isEmpty() ? "" : (String)list2.get(list2.size() - 1));
            }
            int fragmentStart = query2.lastIndexOf(35);
            String fragment2 = fragmentStart > 0 ? query2.substring(fragmentStart + 1) : null;
            Future<String> future2 = command.perform(target2, Collections.unmodifiableMap(parameters2), fragment2);
            if (future2 == null) {
                JBProtocolCommand.$$$reportNull$$$0(8);
            }
            return future2;
        }
        CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(IdeBundle.message((String)"jb.protocol.unknown.command", (Object[])new Object[]{commandName2}));
        if (completableFuture == null) {
            JBProtocolCommand.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/JBProtocolCommand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/JBProtocolCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parameter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

