/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.messages.MessageBus;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    protected CommandDescriptor myCurrentCommand;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount;
    private boolean myAllowMergeGlobalCommands;
    private final CommandListener eventPublisher;

    public CoreCommandProcessor() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.simpleConnect().subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.commandStarted(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void beforeCommandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.beforeCommandFinished(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.commandFinished(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void undoTransparentActionStarted() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.undoTransparentActionStarted();
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void beforeUndoTransparentActionFinished() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.beforeUndoTransparentActionFinished();
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void undoTransparentActionFinished() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.undoTransparentActionFinished();
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommandFinished";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.eventPublisher = (CommandListener)messageBus.syncPublisher(CommandListener.TOPIC);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable2, String name2, Object groupId2) {
        if (runnable2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(0);
        }
        this.executeCommand(project, runnable2, name2, groupId2, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable2, String name2, Object groupId2, Document document) {
        if (runnable2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(1);
        }
        this.executeCommand(project, runnable2, name2, groupId2, UndoConfirmationPolicy.DEFAULT, document);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name2, Object groupId2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(2);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(3);
        }
        this.executeCommand(project, command, name2, groupId2, undoConfirmationPolicy, null);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name2, Object groupId2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, Document document) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(4);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(5);
        }
        this.executeCommand(project, command, name2, groupId2, undoConfirmationPolicy, true, document);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name2, @Nullable Object groupId2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordCommandForActiveDocument) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(6);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(7);
        }
        this.executeCommand(project, command, name2, groupId2, undoConfirmationPolicy, shouldRecordCommandForActiveDocument, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable @NlsContexts.Command String name2, @Nullable Object groupId2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(8);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(9);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsWriteThread();
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name2 + ", groupId = " + groupId2 + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (project != null && project.isDisposed()) {
            CommandLog.LOG.error("Project " + project + " already disposed");
            return;
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        CommandDescriptor descriptor2 = new CommandDescriptor(command, project, name2, groupId2, undoConfirmationPolicy, shouldRecordCommandForActiveDocument, document);
        try {
            this.myCurrentCommand = descriptor2;
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th2) {
            throwable = th2;
        }
        finally {
            this.finishCommand(descriptor2, throwable);
        }
    }

    @Override
    @Nullable
    public CommandToken startCommand(@Nullable Project project, String name2, @Nullable Object groupId2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        if (project != null && project.isDisposed()) {
            return null;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("startCommand: name = " + name2 + ", groupId = " + groupId2);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId2 instanceof Document ? (Document)groupId2 : (groupId2 instanceof Ref && ((Ref)groupId2).get() instanceof Document ? (Document)((Ref)groupId2).get() : null);
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name2, groupId2, undoConfirmationPolicy, true, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    @Override
    public void finishCommand(@NotNull CommandToken command, @Nullable Throwable throwable) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, (Object)"no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        CommandListener publisher = this.eventPublisher;
        try {
            publisher.beforeCommandFinished(event);
        }
        finally {
            this.myCurrentCommand = null;
            publisher.commandFinished(event);
        }
    }

    @Override
    public void enterModal() {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        this.myInterruptedCommands.push((Object)currentCommand);
        if (currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand == null, (Object)("Command must not run: " + this.myCurrentCommand));
        this.myCurrentCommand = (CommandDescriptor)this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    public void setCurrentCommandName(String name2) {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myName = name2;
    }

    public void setCurrentCommandGroupId(Object groupId2) {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myGroupId = groupId2;
    }

    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Nullable
    public String getCurrentCommandName() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = (CommandDescriptor)this.myInterruptedCommands.peek();
            return command != null ? command.myName : null;
        }
        return null;
    }

    @Nullable
    public Object getCurrentCommandGroupId() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = (CommandDescriptor)this.myInterruptedCommands.peek();
            return command != null ? command.myGroupId : null;
        }
        return null;
    }

    @Nullable
    public Project getCurrentCommandProject() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myProject : null;
    }

    public void addCommandListener(@NotNull CommandListener listener2) {
        if (listener2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(12);
        }
        this.myListeners.add(listener2);
    }

    public void removeCommandListener(@NotNull CommandListener listener2) {
        if (listener2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(13);
        }
        this.myListeners.remove(listener2);
    }

    public void runUndoTransparentAction(@NotNull Runnable action2) {
        if (action2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(14);
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("runUndoTransparentAction: " + action2 + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.eventPublisher.undoTransparentActionStarted();
        }
        try {
            action2.run();
        }
        finally {
            if (this.myUndoTransparentCount == 1) {
                this.eventPublisher.beforeUndoTransparentActionFinished();
            }
            if (--this.myUndoTransparentCount == 0) {
                this.eventPublisher.undoTransparentActionFinished();
            }
        }
    }

    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    public void markCurrentCommandAsGlobal(@Nullable Project project) {
    }

    public void addAffectedDocuments(@Nullable Project project, Document ... docs) {
        if (docs == null) {
            CoreCommandProcessor.$$$reportNull$$$0(15);
        }
    }

    public void addAffectedFiles(@Nullable Project project, VirtualFile ... files2) {
        if (files2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(16);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public Boolean isMergeGlobalCommandsAllowed() {
        return this.myAllowMergeGlobalCommands;
    }

    public void allowMergeGlobalCommands(@NotNull Runnable action2) {
        if (action2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        if (this.myAllowMergeGlobalCommands) {
            action2.run();
        }
        this.myAllowMergeGlobalCommands = true;
        try {
            action2.run();
        }
        finally {
            this.myAllowMergeGlobalCommands = false;
        }
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsWriteThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        this.eventPublisher.commandStarted(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoConfirmationPolicy";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "finishCommand";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommandListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCommandListener";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "runUndoTransparentAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "allowMergeGlobalCommands";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommandDescriptor
    implements CommandToken {
        @NotNull
        public final Runnable myCommand;
        public final Project myProject;
        public @NlsContexts.Command String myName;
        public Object myGroupId;
        public final Document myDocument;
        @NotNull
        final UndoConfirmationPolicy myUndoConfirmationPolicy;
        final boolean myShouldRecordActionForActiveDocument;

        CommandDescriptor(@NotNull Runnable command, Project project, @NlsContexts.Command String name2, Object groupId2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document) {
            if (command == null) {
                CommandDescriptor.$$$reportNull$$$0(0);
            }
            if (undoConfirmationPolicy == null) {
                CommandDescriptor.$$$reportNull$$$0(1);
            }
            this.myCommand = command;
            this.myProject = project;
            this.myName = name2;
            this.myGroupId = groupId2;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
            this.myDocument = document;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "undoConfirmationPolicy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor$CommandDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

