/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StartMarkAction
extends BasicUndoableAction {
    public static final Key<StartMarkAction> START_MARK_ACTION_KEY = Key.create((String)"current.inplace.refactorings.mark");
    private @NlsContexts.Command String myCommandName;
    private boolean myGlobal;
    private Document myDocument;

    private StartMarkAction(Editor editor2, @NlsContexts.Command String commandName2) {
        super(new DocumentReference[]{DocumentReferenceManager.getInstance().create(editor2.getDocument())});
        this.myCommandName = commandName2;
        this.myDocument = editor2.getDocument();
    }

    public void undo() {
    }

    public void redo() {
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    @NlsContexts.Command
    public String getCommandName() {
        return this.myCommandName;
    }

    public void setCommandName(@NlsContexts.Command String commandName2) {
        this.myCommandName = commandName2;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    @TestOnly
    public static void checkCleared(@Nullable Editor editor2) {
        if (editor2 == null) {
            return;
        }
        try {
            StartMarkAction markAction = (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
            assert (markAction == null) : markAction.myDocument;
        }
        finally {
            editor2.putUserData(START_MARK_ACTION_KEY, null);
        }
    }

    public static StartMarkAction start(Editor editor2, Project project, @NlsContexts.Command String commandName2) throws AlreadyStartedException {
        StartMarkAction existingMark = (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
        if (existingMark != null) {
            throw new AlreadyStartedException(existingMark.myCommandName, existingMark.myDocument, existingMark.getAffectedDocuments());
        }
        StartMarkAction markAction = new StartMarkAction(editor2, commandName2);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)markAction);
        editor2.putUserData(START_MARK_ACTION_KEY, (Object)markAction);
        return markAction;
    }

    public static StartMarkAction canStart(Editor editor2) {
        return (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
    }

    @Deprecated
    public static StartMarkAction canStart(@NotNull Project project) {
        if (project == null) {
            StartMarkAction.$$$reportNull$$$0(0);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
            StartMarkAction startMarkAction;
            if (!(fileEditor instanceof TextEditor) || (startMarkAction = (StartMarkAction)((Object)((TextEditor)fileEditor).getEditor().getUserData(START_MARK_ACTION_KEY))) == null) continue;
            return startMarkAction;
        }
        return null;
    }

    static void markFinished(Editor editor2) {
        StartMarkAction existingMark = (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
        if (existingMark != null) {
            editor2.putUserData(START_MARK_ACTION_KEY, null);
            existingMark.myDocument = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/command/impl/StartMarkAction", "canStart"));
    }

    public static class AlreadyStartedException
    extends Exception {
        private final DocumentReference[] myAffectedDocuments;
        private final Document myDocument;

        public AlreadyStartedException(String commandName2, Document document, DocumentReference[] documentRefs) {
            super("Unable to start inplace refactoring:\n" + IdeBundle.message((String)"dialog.message.command.not.finished.yet", (Object[])new Object[]{commandName2}));
            this.myAffectedDocuments = documentRefs;
            this.myDocument = document;
        }

        public DocumentReference[] getAffectedDocuments() {
            return this.myAffectedDocuments;
        }

        public Document getDocument() {
            return this.myDocument;
        }
    }
}

