/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.google.common.collect.Iterables;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.GitPatchParser;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchFileHeaderInfo;
import com.intellij.openapi.diff.impl.patch.PatchFileHeaderParser;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.vcsUtil.VcsFileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchReader {
    @NonNls
    public static final String NO_NEWLINE_SIGNATURE = "\\ No newline at end of file";
    private final List<String> myLines;
    private final PatchContentParser myPatchContentParser;
    private final AdditionalInfoParser myAdditionalInfoParser;
    private List<FilePatch> myPatches;
    private PatchFileHeaderInfo myPatchFileInfo;
    @NonNls
    private static final String CONTEXT_HUNK_PREFIX = "***************";
    @NonNls
    private static final String CONTEXT_FILE_PREFIX = "*** ";
    @NonNls
    private static final String UNIFIED_BEFORE_HUNK_PREFIX = "--- ";
    @NonNls
    private static final String UNIFIED_AFTER_HUNK_PREFIX = "+++ ";
    @NonNls
    private static final String DIFF_GIT_HEADER_LINE = "diff --git";
    @NonNls
    static final String HASH_PATTERN = "[0-9a-fA-F]+";
    @NonNls
    private static final Pattern ourUnifiedHunkStartPattern = Pattern.compile("@@ -(\\d+)(,(\\d+))? \\+(\\d+)(,(\\d+))? @@.*");
    @NonNls
    private static final Pattern ourContextBeforeHunkStartPattern = Pattern.compile("\\*\\*\\* (\\d+),(\\d+) \\*\\*\\*\\*");
    @NonNls
    private static final Pattern ourContextAfterHunkStartPattern = Pattern.compile("--- (\\d+),(\\d+) ----");
    @NonNls
    private static final Pattern ourEmptyRevisionInfoPattern = Pattern.compile("\\(\\s*revision\\s*\\)");
    @NonNls
    private static final Pattern ourGitHeaderLinePattern = Pattern.compile("diff --git\\s+(\\S+)\\s+(\\S+).*");

    public PatchReader(CharSequence patchContent) {
        this(patchContent, true);
    }

    public PatchReader(@NotNull Path file2) {
        if (file2 == null) {
            PatchReader.$$$reportNull$$$0(0);
        }
        this(PathKt.readChars((Path)file2), true);
    }

    public PatchReader(CharSequence patchContent, boolean saveHunks) {
        this.myLines = LineTokenizer.tokenizeIntoList((CharSequence)patchContent, (boolean)false);
        this.myAdditionalInfoParser = new AdditionalInfoParser(!saveHunks);
        this.myPatchContentParser = new PatchContentParser(saveHunks);
    }

    @NotNull
    public List<TextFilePatch> readTextPatches() throws PatchSyntaxException {
        this.parseAllPatches();
        List<TextFilePatch> list2 = this.getTextPatches();
        if (list2 == null) {
            PatchReader.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public CharSequence getBaseRevision(@NotNull String relativeFilePath) {
        Map<String, CharSequence> inner;
        Map<String, Map<String, CharSequence>> map2;
        if (relativeFilePath == null) {
            PatchReader.$$$reportNull$$$0(2);
        }
        if (!(map2 = this.myAdditionalInfoParser.getResultMap()).isEmpty() && (inner = map2.get(relativeFilePath)) != null) {
            BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class);
            return inner.get(baseRevisionTextPatchEP.getName());
        }
        return null;
    }

    @NotNull
    public List<TextFilePatch> getTextPatches() {
        List list2 = ContainerUtil.findAll(this.myPatches, TextFilePatch.class);
        if (list2 == null) {
            PatchReader.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public List<FilePatch> getAllPatches() {
        List<FilePatch> list2 = this.myPatches;
        if (list2 == null) {
            PatchReader.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void parseAllPatches() throws PatchSyntaxException {
        ListIterator<String> iterator2 = this.myLines.listIterator();
        if (!iterator2.hasNext()) {
            this.myPatches = Collections.emptyList();
            return;
        }
        boolean containsAdditional = false;
        boolean isHeaderLine = true;
        int headerLineNum = 0;
        while (iterator2.hasNext()) {
            String next = iterator2.next();
            boolean containsAdditionalNow = this.myAdditionalInfoParser.testIsStart(next);
            if (containsAdditionalNow && containsAdditional) {
                this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.contains.additional.information.without.patch.itself", (Object[])new Object[0])));
            }
            if (containsAdditionalNow) {
                isHeaderLine = false;
                containsAdditional = true;
                this.myAdditionalInfoParser.parse(next, iterator2);
                if (!iterator2.hasNext()) {
                    this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.contains.additional.information.without.patch.itself", (Object[])new Object[0])));
                    break;
                }
                next = iterator2.next();
            }
            if (this.myPatchContentParser.testIsStart(next)) {
                isHeaderLine = false;
                this.myPatchContentParser.parse(next, iterator2);
                if (containsAdditional) {
                    String lastName = this.myPatchContentParser.getLastName();
                    if (lastName == null) {
                        this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.contains.additional.information.without.patch.itself", (Object[])new Object[0])));
                    } else {
                        this.myAdditionalInfoParser.copyToResult(lastName);
                    }
                }
                containsAdditional = false;
            }
            if (!isHeaderLine) continue;
            ++headerLineNum;
        }
        this.myPatches = this.myPatchContentParser.getResult();
        this.myPatchFileInfo = PatchFileHeaderParser.parseHeader(Iterables.limit(this.myLines, (int)headerLineNum).iterator());
    }

    @NotNull
    public ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> getAdditionalInfo(@Nullable Set<String> paths2) {
        PatchSyntaxException e = this.myAdditionalInfoParser.getSyntaxException();
        if (e != null) {
            ThrowableComputable throwableComputable = () -> {
                throw e;
            };
            if (throwableComputable == null) {
                PatchReader.$$$reportNull$$$0(5);
            }
            return throwableComputable;
        }
        ThrowableComputable throwableComputable = () -> ContainerUtil.filter(this.myAdditionalInfoParser.getResultMap(), path2 -> paths2 == null || paths2.contains(path2));
        if (throwableComputable == null) {
            PatchReader.$$$reportNull$$$0(6);
        }
        return throwableComputable;
    }

    public PatchFileHeaderInfo getPatchFileInfo() {
        return this.myPatchFileInfo;
    }

    public static boolean isPatchContent(@Nullable String content2) {
        String line;
        if (content2 == null) {
            return false;
        }
        List lines2 = LineTokenizer.tokenizeIntoList((CharSequence)content2, (boolean)false);
        ListIterator iterator2 = lines2.listIterator();
        DiffFormat currentFormat = null;
        while (iterator2.hasNext()) {
            line = (String)iterator2.next();
            if (line.startsWith(CONTEXT_HUNK_PREFIX)) {
                currentFormat = DiffFormat.CONTEXT;
                continue;
            }
            if (currentFormat == DiffFormat.CONTEXT && ourContextBeforeHunkStartPattern.matcher(line).matches()) break;
            if (line.startsWith(UNIFIED_BEFORE_HUNK_PREFIX) && currentFormat == null) {
                currentFormat = DiffFormat.UNIFIED;
                continue;
            }
            if (currentFormat != DiffFormat.UNIFIED || !line.startsWith(UNIFIED_AFTER_HUNK_PREFIX)) continue;
            break;
        }
        if (currentFormat == null) {
            return false;
        }
        while (iterator2.hasNext()) {
            line = (String)iterator2.next();
            if (!(currentFormat == DiffFormat.CONTEXT ? ourContextAfterHunkStartPattern.matcher(line).matches() : ourUnifiedHunkStartPattern.matcher(line).matches())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/PatchReader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/PatchReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readTextPatches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPatches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatches";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBaseRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyTextFilePatch
    extends TextFilePatch {
        private int myHunkCount = 0;
        private boolean myNew;
        private boolean myDeleted;

        EmptyTextFilePatch() {
            super(null);
        }

        public void addHunk(PatchHunk hunk) {
            if (this.myHunkCount == 0) {
                if (hunk.isNewContent()) {
                    this.myNew = true;
                } else if (hunk.isDeletedContent()) {
                    this.myDeleted = true;
                }
            }
            ++this.myHunkCount;
        }

        public boolean isNewFile() {
            return this.myHunkCount == 1 && this.myNew;
        }

        public boolean isDeletedFile() {
            return this.myHunkCount == 1 && this.myDeleted;
        }
    }

    private static interface Parser {
        public boolean testIsStart(String var1);

        public void parse(String var1, ListIterator<String> var2) throws PatchSyntaxException;
    }

    static final class PatchContentParser
    implements Parser {
        private final boolean mySaveHunks;
        private DiffFormat myDiffFormat = null;
        private final List<FilePatch> myPatches;
        private boolean myGitDiffFormat;

        PatchContentParser(boolean saveHunks) {
            this.mySaveHunks = saveHunks;
            this.myPatches = new SmartList();
        }

        @Override
        public boolean testIsStart(String start2) {
            if (start2.startsWith(PatchReader.DIFF_GIT_HEADER_LINE)) {
                this.myGitDiffFormat = true;
                return true;
            }
            if (start2.startsWith(PatchReader.UNIFIED_BEFORE_HUNK_PREFIX) && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.UNIFIED)) {
                this.myDiffFormat = DiffFormat.UNIFIED;
                return true;
            }
            if (start2.startsWith(PatchReader.CONTEXT_FILE_PREFIX) && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.CONTEXT)) {
                this.myDiffFormat = DiffFormat.CONTEXT;
                return true;
            }
            return false;
        }

        @Override
        public void parse(String start2, ListIterator<String> iterator2) throws PatchSyntaxException {
            if (this.myGitDiffFormat) {
                this.addPatchAndResetSettings(GitPatchParser.parse(start2, iterator2, this.mySaveHunks));
            } else {
                this.addPatchAndResetSettings((FilePatch)this.readTextPatch(start2, iterator2));
            }
        }

        private void addPatchAndResetSettings(@Nullable FilePatch patch2) {
            if (patch2 != null) {
                this.myPatches.add(patch2);
            }
            this.myGitDiffFormat = false;
        }

        public List<FilePatch> getResult() {
            return this.myPatches;
        }

        TextFilePatch readTextPatch(String curLine, ListIterator<String> iterator2) throws PatchSyntaxException {
            PatchHunk hunk;
            String secondNamePrefix;
            TextFilePatch curPatch = this.mySaveHunks ? new TextFilePatch(null) : new EmptyTextFilePatch();
            PatchContentParser.extractFileName(curLine, (FilePatch)curPatch, true);
            if (!iterator2.hasNext()) {
                throw new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.second.file.name.expected", (Object[])new Object[0]));
            }
            curLine = iterator2.next();
            String string = secondNamePrefix = this.myDiffFormat == DiffFormat.UNIFIED ? PatchReader.UNIFIED_AFTER_HUNK_PREFIX : PatchReader.UNIFIED_BEFORE_HUNK_PREFIX;
            if (!curLine.startsWith(secondNamePrefix)) {
                throw new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.second.file.name.expected", (Object[])new Object[0]));
            }
            PatchContentParser.extractFileName(curLine, (FilePatch)curPatch, false);
            while (iterator2.hasNext() && (hunk = this.myDiffFormat == DiffFormat.UNIFIED ? PatchContentParser.readNextHunkUnified(iterator2) : PatchContentParser.readNextHunkContext(iterator2)) != null) {
                curPatch.addHunk(hunk);
            }
            if (curPatch.getBeforeName() == null) {
                curPatch.setBeforeName(curPatch.getAfterName());
            }
            if (curPatch.getAfterName() == null) {
                curPatch.setAfterName(curPatch.getBeforeName());
            }
            return curPatch;
        }

        @Nullable
        private static PatchHunk readNextHunkUnified(@NotNull ListIterator<String> iterator2) throws PatchSyntaxException {
            if (iterator2 == null) {
                PatchContentParser.$$$reportNull$$$0(0);
            }
            String curLine = null;
            int numIncrements = 0;
            while (iterator2.hasNext()) {
                curLine = iterator2.next();
                ++numIncrements;
                if (curLine.startsWith(PatchReader.UNIFIED_BEFORE_HUNK_PREFIX) || ourGitHeaderLinePattern.matcher(curLine).matches()) {
                    for (int i2 = 0; i2 < numIncrements; ++i2) {
                        iterator2.previous();
                    }
                    return null;
                }
                if (!curLine.startsWith("@@ ")) continue;
            }
            if (!iterator2.hasNext()) {
                return null;
            }
            Matcher m = ourUnifiedHunkStartPattern.matcher(curLine);
            if (!m.matches()) {
                throw new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.unknown.hunk.start.syntax", (Object[])new Object[0]));
            }
            int startLineBefore = Integer.parseInt(m.group(1));
            String linesBeforeText = m.group(3);
            int linesBefore = linesBeforeText == null ? 1 : Integer.parseInt(linesBeforeText);
            int startLineAfter = Integer.parseInt(m.group(4));
            String linesAfterText = m.group(6);
            int linesAfter = linesAfterText == null ? 1 : Integer.parseInt(linesAfterText);
            PatchHunk hunk = new PatchHunk(startLineBefore - 1, startLineBefore + linesBefore - 1, startLineAfter - 1, startLineAfter + linesAfter - 1);
            PatchLine lastLine = null;
            int before = 0;
            int after2 = 0;
            while (iterator2.hasNext()) {
                String hunkCurLine = iterator2.next();
                if (lastLine != null && hunkCurLine.startsWith(PatchReader.NO_NEWLINE_SIGNATURE)) {
                    lastLine.setSuppressNewLine(true);
                    continue;
                }
                lastLine = PatchContentParser.parsePatchLine(hunkCurLine, 1, before < linesBefore || after2 < linesAfter);
                if (lastLine == null) {
                    iterator2.previous();
                    break;
                }
                switch (lastLine.getType()) {
                    case CONTEXT: {
                        ++before;
                        ++after2;
                        break;
                    }
                    case ADD: {
                        ++after2;
                        break;
                    }
                    case REMOVE: {
                        ++before;
                    }
                }
                hunk.addLine(lastLine);
            }
            return hunk;
        }

        @Nullable
        public String getLastName() {
            if (this.myPatches.isEmpty()) {
                return null;
            }
            FilePatch patch2 = this.myPatches.get(this.myPatches.size() - 1);
            return patch2.getBeforeName() == null ? patch2.getAfterName() : patch2.getBeforeName();
        }

        @Nullable
        private static PatchLine parsePatchLine(String line, int prefixLength) {
            return PatchContentParser.parsePatchLine(line, prefixLength, true);
        }

        @Nullable
        private static PatchLine parsePatchLine(String line, int prefixLength, boolean expectMeaningfulLines) {
            PatchLine.Type type;
            if (line.startsWith("+") && expectMeaningfulLines) {
                type = PatchLine.Type.ADD;
            } else if (line.startsWith("-") && expectMeaningfulLines) {
                type = PatchLine.Type.REMOVE;
            } else if (line.startsWith(" ") && expectMeaningfulLines) {
                type = PatchLine.Type.CONTEXT;
            } else {
                return null;
            }
            String lineText = line.length() < prefixLength ? "" : line.substring(prefixLength);
            return new PatchLine(type, lineText);
        }

        @Nullable
        private static PatchHunk readNextHunkContext(ListIterator<String> iterator2) throws PatchSyntaxException {
            while (iterator2.hasNext()) {
                String curLine = iterator2.next();
                if (curLine.startsWith(PatchReader.CONTEXT_FILE_PREFIX)) {
                    iterator2.previous();
                    return null;
                }
                if (!curLine.startsWith(PatchReader.CONTEXT_HUNK_PREFIX)) continue;
                break;
            }
            if (!iterator2.hasNext()) {
                return null;
            }
            Matcher beforeMatcher = ourContextBeforeHunkStartPattern.matcher(iterator2.next());
            if (!beforeMatcher.matches()) {
                throw new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.unknown.before.hunk.start.syntax", (Object[])new Object[0]));
            }
            List<String> beforeLines = PatchContentParser.readContextDiffLines(iterator2);
            if (!iterator2.hasNext()) {
                throw new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.missing.after.hunk", (Object[])new Object[0]));
            }
            Matcher afterMatcher = ourContextAfterHunkStartPattern.matcher(iterator2.next());
            if (!afterMatcher.matches()) {
                throw new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.unknown.after.hunk.start.syntax", (Object[])new Object[0]));
            }
            List<String> afterLines = PatchContentParser.readContextDiffLines(iterator2);
            int startLineBefore = Integer.parseInt(beforeMatcher.group(1));
            int endLineBefore = Integer.parseInt(beforeMatcher.group(2));
            int startLineAfter = Integer.parseInt(afterMatcher.group(1));
            int endLineAfter = Integer.parseInt(afterMatcher.group(2));
            PatchHunk hunk = new PatchHunk(startLineBefore - 1, endLineBefore - 1, startLineAfter - 1, endLineAfter - 1);
            int beforeLineIndex = 0;
            int afterLineIndex = 0;
            PatchLine lastBeforePatchLine = null;
            PatchLine lastAfterPatchLine = null;
            if (beforeLines.size() == 0) {
                for (String line : afterLines) {
                    hunk.addLine(PatchContentParser.parsePatchLine(line, 2));
                }
            } else if (afterLines.size() == 0) {
                for (String line : beforeLines) {
                    hunk.addLine(PatchContentParser.parsePatchLine(line, 2));
                }
            } else {
                while (beforeLineIndex < beforeLines.size() || afterLineIndex < afterLines.size()) {
                    String afterLine;
                    String beforeLine = beforeLineIndex >= beforeLines.size() ? null : beforeLines.get(beforeLineIndex);
                    String string = afterLine = afterLineIndex >= afterLines.size() ? null : afterLines.get(afterLineIndex);
                    if (PatchContentParser.startsWith(beforeLine, PatchReader.NO_NEWLINE_SIGNATURE) && lastBeforePatchLine != null) {
                        lastBeforePatchLine.setSuppressNewLine(true);
                        ++beforeLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(afterLine, PatchReader.NO_NEWLINE_SIGNATURE) && lastAfterPatchLine != null) {
                        lastAfterPatchLine.setSuppressNewLine(true);
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, " ") && (PatchContentParser.startsWith(afterLine, " ") || afterLine == null)) {
                        PatchContentParser.addContextDiffLine(hunk, beforeLine, PatchLine.Type.CONTEXT);
                        ++beforeLineIndex;
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, "-")) {
                        lastBeforePatchLine = PatchContentParser.addContextDiffLine(hunk, beforeLine, PatchLine.Type.REMOVE);
                        ++beforeLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(afterLine, "+")) {
                        lastAfterPatchLine = PatchContentParser.addContextDiffLine(hunk, afterLine, PatchLine.Type.ADD);
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, "!") && PatchContentParser.startsWith(afterLine, "!")) {
                        while (beforeLineIndex < beforeLines.size() && beforeLines.get(beforeLineIndex).startsWith("! ")) {
                            lastBeforePatchLine = PatchContentParser.addContextDiffLine(hunk, beforeLines.get(beforeLineIndex), PatchLine.Type.REMOVE);
                            ++beforeLineIndex;
                        }
                        while (afterLineIndex < afterLines.size() && afterLines.get(afterLineIndex).startsWith("! ")) {
                            lastAfterPatchLine = PatchContentParser.addContextDiffLine(hunk, afterLines.get(afterLineIndex), PatchLine.Type.ADD);
                            ++afterLineIndex;
                        }
                        continue;
                    }
                    throw new PatchSyntaxException(-1, VcsBundle.message((String)"patch.unknown.line.prefix", (Object[])new Object[0]));
                }
            }
            return hunk;
        }

        private static boolean startsWith(@Nullable String line, String prefix) {
            return line != null && line.startsWith(prefix);
        }

        private static PatchLine addContextDiffLine(PatchHunk hunk, String line, PatchLine.Type type) {
            PatchLine patchLine = new PatchLine(type, line.length() < 2 ? "" : line.substring(2));
            hunk.addLine(patchLine);
            return patchLine;
        }

        private static List<String> readContextDiffLines(ListIterator<String> iterator2) {
            ArrayList<String> result2 = new ArrayList<String>();
            while (iterator2.hasNext()) {
                String line = iterator2.next();
                if (!(line.startsWith(" ") || line.startsWith("+ ") || line.startsWith("- ") || line.startsWith("! ") || line.startsWith(PatchReader.NO_NEWLINE_SIGNATURE))) {
                    iterator2.previous();
                    break;
                }
                result2.add(line);
            }
            return result2;
        }

        private static void extractFileName(String curLine, FilePatch patch2, boolean before) {
            String newFileName;
            String fileName = curLine.substring(4);
            int pos = fileName.indexOf(9);
            if (pos < 0) {
                pos = fileName.indexOf(32);
            }
            if (pos >= 0) {
                @NlsSafe String versionId = fileName.substring(pos).trim();
                fileName = fileName.substring(0, pos);
                if (versionId.length() > 0 && !ourEmptyRevisionInfoPattern.matcher(versionId).matches()) {
                    if (before) {
                        patch2.setBeforeVersionId(versionId);
                    } else {
                        patch2.setAfterVersionId(versionId);
                    }
                }
            }
            if ((newFileName = PatchContentParser.stripPatchNameIfNeeded(fileName = VcsFileUtil.unescapeGitPath(fileName), before)) == null) {
                return;
            }
            if (before) {
                patch2.setBeforeName(newFileName);
            } else {
                patch2.setAfterName(newFileName);
            }
        }

        @Nullable
        static String stripPatchNameIfNeeded(@NotNull String fileName, boolean before) {
            if (fileName == null) {
                PatchContentParser.$$$reportNull$$$0(1);
            }
            if ("/dev/null".equals(fileName)) {
                return null;
            }
            String prefix = before ? "a/" : "b/";
            return StringUtil.trimStart((String)fileName, (String)prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/patch/PatchReader$PatchContentParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readNextHunkUnified";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stripPatchNameIfNeeded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AdditionalInfoParser
    implements Parser {
        private final Map<String, Map<String, CharSequence>> myResultMap;
        private final boolean myIgnoreMode;
        private Map<String, CharSequence> myAddMap;
        private PatchSyntaxException mySyntaxException;

        private AdditionalInfoParser(boolean ignore) {
            this.myIgnoreMode = ignore;
            this.myAddMap = new HashMap<String, CharSequence>();
            this.myResultMap = new HashMap<String, Map<String, CharSequence>>();
        }

        public PatchSyntaxException getSyntaxException() {
            return this.mySyntaxException;
        }

        public Map<String, Map<String, CharSequence>> getResultMap() {
            return this.myResultMap;
        }

        public void copyToResult(String filePath) {
            if (this.myAddMap != null && !this.myAddMap.isEmpty()) {
                this.myResultMap.put(filePath, this.myAddMap);
                this.myAddMap = new HashMap<String, CharSequence>();
            }
        }

        @Override
        public boolean testIsStart(String start2) {
            if (this.myIgnoreMode || this.mySyntaxException != null) {
                return false;
            }
            return start2 != null && start2.contains("IDEA additional info:");
        }

        @Override
        public void parse(String start2, ListIterator<String> iterator2) {
            if (this.myIgnoreMode) {
                return;
            }
            if (!iterator2.hasNext()) {
                this.mySyntaxException = new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.empty.additional.info.header", (Object[])new Object[0]));
                return;
            }
            block0: while (true) {
                String header2;
                int idxHead;
                if ((idxHead = (header2 = iterator2.next()).indexOf("Subsystem: ")) == -1) {
                    if (this.myAddMap.isEmpty()) {
                        this.mySyntaxException = new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.empty.additional.info.header", (Object[])new Object[0]));
                    }
                    iterator2.previous();
                    return;
                }
                String subsystem = header2.substring(idxHead + "Subsystem: ".length()).trim();
                if (!iterator2.hasNext()) {
                    this.mySyntaxException = new PatchSyntaxException(iterator2.previousIndex(), VcsBundle.message((String)"patch.empty.0.data.section", (Object[])new Object[]{subsystem}));
                    return;
                }
                StringBuilder sb = new StringBuilder();
                this.myAddMap.put(subsystem, sb);
                while (true) {
                    if (!iterator2.hasNext()) continue block0;
                    String line = iterator2.next();
                    if (!line.startsWith("<+>")) {
                        iterator2.previous();
                        continue block0;
                    }
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(StringUtil.unescapeStringCharacters((String)line.substring("<+>".length())));
                }
                break;
            }
        }

        public void acceptError(PatchSyntaxException e) {
            this.mySyntaxException = e;
        }
    }

    private static enum DiffFormat {
        CONTEXT,
        UNIFIED;

    }
}

