/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import org.jetbrains.annotations.NotNull;

public class AddCaretPerSelectedLineAction
extends EditorAction {
    public AddCaretPerSelectedLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static final class Handler
    extends EditorActionHandler.ForEachCaret {
        private Handler() {
        }

        protected void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            CaretModel caretModel = editor2.getCaretModel();
            Document document = editor2.getDocument();
            int selectionStart = caret.getSelectionStart();
            int startLine = document.getLineNumber(selectionStart);
            int selectionEnd = caret.getSelectionEnd();
            int endLine = document.getLineNumber(selectionEnd);
            if (endLine > startLine && selectionEnd == document.getLineStartOffset(endLine)) {
                --endLine;
            }
            if (caretModel.getCaretCount() + endLine - startLine > caretModel.getMaxCaretCount()) {
                EditorUtil.notifyMaxCarets(editor2);
                return;
            }
            caret.removeSelection();
            boolean primary = caret.getOffset() != selectionStart;
            for (int i2 = startLine; i2 <= endLine; ++i2) {
                int targetOffset = document.getLineEndOffset(i2);
                if (targetOffset == caret.getOffset()) {
                    caret.moveToOffset(targetOffset == 0 ? document.getTextLength() : 0);
                }
                caretModel.addCaret(editor2.offsetToLogicalPosition(targetOffset), primary);
            }
            caretModel.removeCaret(caret);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/AddCaretPerSelectedLineAction$Handler";
            objectArray[2] = "doExecute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

