/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConvertIndentsActionBase
extends EditorAction {
    protected ConvertIndentsActionBase() {
        super(null);
        this.setupHandler((EditorActionHandler)new Handler());
    }

    protected abstract int performAction(Editor var1, TextRange var2);

    private class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            SelectionModel selectionModel = editor2.getSelectionModel();
            int changedLines = 0;
            changedLines = selectionModel.hasSelection() ? ConvertIndentsActionBase.this.performAction(editor2, new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd())) : (changedLines += ConvertIndentsActionBase.this.performAction(editor2, new TextRange(0, editor2.getDocument().getTextLength())));
            if (changedLines == 0) {
                HintManager.getInstance().showInformationHint(editor2, IdeBundle.message((String)"hint.text.all.lines.already.have.requested.indentation", (Object[])new Object[0]));
            } else {
                HintManager.getInstance().showInformationHint(editor2, IdeBundle.message((String)"hint.text.changed.indentation.in", (Object[])new Object[]{changedLines}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/ConvertIndentsActionBase$Handler", "executeWriteAction"));
        }
    }
}

