/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

class DeleteToWordBoundaryHandler
extends EditorWriteActionHandler.ForEachCaret {
    private final boolean myIsUntilStart;
    private final boolean myNegateCamelMode;

    DeleteToWordBoundaryHandler(boolean isUntilStart, boolean negateCamelMode) {
        this.myIsUntilStart = isUntilStart;
        this.myNegateCamelMode = negateCamelMode;
    }

    public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        TextRange range2;
        if (editor2 == null) {
            DeleteToWordBoundaryHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            DeleteToWordBoundaryHandler.$$$reportNull$$$0(1);
        }
        CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
        CopyPasteManager.getInstance().stopKillRings();
        boolean camelMode = editor2.getSettings().isCamelWords();
        if (this.myNegateCamelMode) {
            boolean bl = camelMode = !camelMode;
        }
        if (editor2.getSelectionModel().hasSelection()) {
            EditorModificationUtil.deleteSelectedText((Editor)editor2);
            return;
        }
        TextRange textRange = range2 = this.myIsUntilStart ? EditorActionUtil.getRangeToWordStart(editor2, camelMode, true) : EditorActionUtil.getRangeToWordEnd(editor2, camelMode, true);
        if (!range2.isEmpty()) {
            editor2.getDocument().deleteString(range2.getStartOffset(), range2.getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caret";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/actions/DeleteToWordBoundaryHandler";
        objectArray[2] = "executeWriteAction";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

