/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import org.jetbrains.annotations.NotNull;

public final class DocumentGuardedTextUtil {
    private DocumentGuardedTextUtil() {
    }

    public static void deleteString(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            DocumentGuardedTextUtil.$$$reportNull$$$0(0);
        }
        try {
            document.deleteString(startOffset, endOffset);
        }
        catch (ReadOnlyFragmentModificationException ex) {
            RangeMarker block = ex.getGuardedBlock();
            if (block.getEndOffset() < endOffset) {
                throw ex;
            }
            CharSequence blockPrefix = document.getImmutableCharSequence().subSequence(block.getStartOffset(), endOffset);
            CharSequence textBefore = document.getImmutableCharSequence().subSequence(Math.max(0, startOffset - blockPrefix.length()), startOffset);
            if (blockPrefix.toString().equals(textBefore.toString())) {
                DocumentGuardedTextUtil.deleteString(document, startOffset - blockPrefix.length(), endOffset - blockPrefix.length());
            }
            throw ex;
        }
    }

    public static void insertString(@NotNull Document document, int offset, @NotNull CharSequence s) {
        if (document == null) {
            DocumentGuardedTextUtil.$$$reportNull$$$0(1);
        }
        if (s == null) {
            DocumentGuardedTextUtil.$$$reportNull$$$0(2);
        }
        try {
            document.insertString(offset, s);
        }
        catch (ReadOnlyFragmentModificationException ex) {
            String blockPrefix = document.getImmutableCharSequence().subSequence(ex.getGuardedBlock().getStartOffset(), offset).toString();
            if (s.toString().endsWith(blockPrefix)) {
                int newOffset = offset - blockPrefix.length();
                String newString = blockPrefix + s.subSequence(0, s.length() - blockPrefix.length());
                DocumentGuardedTextUtil.insertString(document, newOffset, newString);
            }
            throw ex;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/DocumentGuardedTextUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "insertString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

