/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CaretStop;
import com.intellij.openapi.editor.actions.CaretStopPolicy;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import org.jetbrains.annotations.NotNull;

public class KillToWordEndAction
extends TextComponentEditorAction {
    public KillToWordEndAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public static final CaretStopPolicy WORD_END_IGNORE_LINE_BREAK = new CaretStopPolicy(CaretStop.END, CaretStop.NONE);

        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, Caret caret, DataContext dataContext) {
            int endOffset;
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            boolean camelMode = editor2.getSettings().isCamelWords();
            int startOffset = editor2.getCaretModel().getOffset();
            if (startOffset != (endOffset = EditorActionUtil.getNextCaretStopOffset(editor2, WORD_END_IGNORE_LINE_BREAK, camelMode, true))) {
                KillRingUtil.cut(editor2, startOffset, endOffset);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/KillToWordEndAction$Handler", "executeWriteAction"));
        }
    }
}

