/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.NotNull;

class MoveCaretLeftOrRightHandler
extends EditorActionHandler.ForEachCaret {
    private final Direction myDirection;

    MoveCaretLeftOrRightHandler(Direction direction) {
        this.myDirection = direction;
    }

    public void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            MoveCaretLeftOrRightHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            MoveCaretLeftOrRightHandler.$$$reportNull$$$0(1);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        CaretModel caretModel = editor2.getCaretModel();
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        if (!(!selectionModel.hasSelection() || editor2 instanceof EditorEx && ((EditorEx)editor2).isStickySelection())) {
            int start2 = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            int caretOffset = caretModel.getOffset();
            if (start2 <= caretOffset && end >= caretOffset) {
                VisualPosition targetPosition = this.myDirection == Direction.RIGHT ? caret.getSelectionEndPosition() : caret.getSelectionStartPosition();
                selectionModel.removeSelection();
                caretModel.moveToVisualPosition(targetPosition);
                if (caret == editor2.getCaretModel().getPrimaryCaret()) {
                    scrollingModel.scrollToCaret(ScrollType.RELATIVE);
                }
                return;
            }
        }
        VisualPosition currentPosition = caret.getVisualPosition();
        if (caret.isAtBidiRunBoundary() && this.myDirection == Direction.RIGHT ^ currentPosition.leansRight) {
            caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
        } else {
            boolean scrollToCaret = (!(editor2 instanceof EditorImpl) || ((EditorImpl)editor2).isScrollToCaret()) && caret == editor2.getCaretModel().getPrimaryCaret();
            caretModel.moveCaretRelatively(this.myDirection == Direction.RIGHT ? 1 : -1, 0, false, false, scrollToCaret);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caret";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/actions/MoveCaretLeftOrRightHandler";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum Direction {
        LEFT,
        RIGHT;

    }
}

