/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import org.jetbrains.annotations.NotNull;

class NextPrevWordHandler
extends EditorActionHandler.ForEachCaret {
    private final boolean myNext;
    private final boolean myWithSelection;
    private final boolean myInDifferentHumpsMode;

    NextPrevWordHandler(boolean next, boolean withSelection, boolean inDifferentHumpsMode) {
        this.myNext = next;
        this.myWithSelection = withSelection;
        this.myInDifferentHumpsMode = inDifferentHumpsMode;
    }

    protected void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            NextPrevWordHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            NextPrevWordHandler.$$$reportNull$$$0(1);
        }
        if (EditorUtil.isPasswordEditor(editor2)) {
            int selectionStartOffset = caret.getLeadSelectionOffset();
            caret.moveToOffset(this.myNext ? editor2.getDocument().getTextLength() : 0);
            if (this.myWithSelection) {
                caret.setSelection(selectionStartOffset, caret.getOffset());
            }
        } else {
            VisualPosition currentPosition = caret.getVisualPosition();
            if (caret.isAtBidiRunBoundary() && this.myNext ^ currentPosition.leansRight) {
                int selectionStartOffset = caret.getLeadSelectionOffset();
                VisualPosition selectionStartPosition = caret.getLeadSelectionPosition();
                caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
                if (this.myWithSelection) {
                    caret.setSelection(selectionStartPosition, selectionStartOffset, caret.getVisualPosition(), caret.getOffset());
                }
            } else if (this.myNext ^ caret.isAtRtlLocation()) {
                EditorActionUtil.moveCaretToNextWord(editor2, this.myWithSelection, this.myInDifferentHumpsMode ^ editor2.getSettings().isCamelWords());
            } else {
                EditorActionUtil.moveCaretToPreviousWord(editor2, this.myWithSelection, this.myInDifferentHumpsMode ^ editor2.getSettings().isCamelWords());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caret";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/actions/NextPrevWordHandler";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

