/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;

public class ScrollToTheEndToolbarAction
extends ToggleAction
implements DumbAware {
    private final Editor myEditor;

    public ScrollToTheEndToolbarAction(@NotNull Editor editor2) {
        if (editor2 == null) {
            ScrollToTheEndToolbarAction.$$$reportNull$$$0(0);
        }
        this.myEditor = editor2;
        String message2 = ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]);
        this.getTemplatePresentation().setDescription(message2);
        this.getTemplatePresentation().setText(message2);
        this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Document document;
        if (e == null) {
            ScrollToTheEndToolbarAction.$$$reportNull$$$0(1);
        }
        return (document = this.myEditor.getDocument()).getLineCount() == 0 || document.getLineNumber(this.myEditor.getCaretModel().getOffset()) == document.getLineCount() - 1;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            ScrollToTheEndToolbarAction.$$$reportNull$$$0(2);
        }
        if (state) {
            EditorUtil.scrollToTheEnd(this.myEditor);
        } else {
            int lastLine = Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
            LogicalPosition currentPosition = this.myEditor.getCaretModel().getLogicalPosition();
            LogicalPosition position = new LogicalPosition(Math.max(0, Math.min(currentPosition.line, lastLine - 1)), currentPosition.column);
            this.myEditor.getCaretModel().moveToLogicalPosition(position);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/ScrollToTheEndToolbarAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

