/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerListener;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.UIManager;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(value="colors.scheme.xml")}, additionalExportDirectory="colors", category=SettingsCategory.UI)
@ApiStatus.Internal
public final class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    public static final ExtensionPointName<AdditionalTextAttributesEP> ADDITIONAL_TEXT_ATTRIBUTES_EP_NAME = new ExtensionPointName("com.intellij.additionalTextAttributes");
    private static final Logger LOG = Logger.getInstance(EditorColorsManagerImpl.class);
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = new ExtensionPointName("com.intellij.bundledColorScheme");
    private final ComponentTreeEventDispatcher<EditorColorsListener> myTreeDispatcher;
    private final SchemeManager<EditorColorsScheme> mySchemeManager;
    static final String FILE_SPEC = "colors";
    private State myState;
    private boolean themeIsCustomized;
    @NonNls
    private static final String TEMP_SCHEME_KEY = "TEMP_SCHEME_KEY";
    @NonNls
    private static final String TEMP_SCHEME_FILE_KEY = "TEMP_SCHEME_FILE_KEY";

    public EditorColorsManagerImpl() {
        this(SchemeManagerFactory.getInstance());
    }

    @NonInjectable
    public EditorColorsManagerImpl(@NotNull SchemeManagerFactory schemeManagerFactory) {
        if (schemeManagerFactory == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(0);
        }
        this.myTreeDispatcher = ComponentTreeEventDispatcher.create(EditorColorsListener.class);
        this.myState = new State();
        Map<String, List<AdditionalTextAttributesEP>> additionalTextAttributes = EditorColorsManagerImpl.collectAdditionalTextAttributesEPs();
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new EditorColorSchemeProcessor(additionalTextAttributes));
        this.initDefaultSchemes();
        this.loadBundledSchemes();
        this.loadSchemesFromThemes();
        this.mySchemeManager.loadSchemes();
        this.loadRemainAdditionalTextAttributes(additionalTextAttributes);
        this.initEditableDefaultSchemesCopies();
        this.initEditableBundledSchemesCopies();
        this.resolveLinksToBundledSchemes();
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditorColorsManagerImpl.this.reloadKeepingActiveScheme();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorColorsManagerImpl.this.reloadKeepingActiveScheme();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void reloadKeepingActiveScheme() {
        EditorColorsScheme scheme2;
        String activeScheme = this.mySchemeManager.getCurrentSchemeName();
        this.mySchemeManager.reload();
        if (Strings.isNotEmpty((String)activeScheme) && (scheme2 = this.getScheme(activeScheme)) != null) {
            this.setGlobalScheme(scheme2);
        }
    }

    private void initDefaultSchemes() {
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.getInstance().getAllSchemes()) {
            this.mySchemeManager.addScheme(defaultScheme);
        }
    }

    private void initEditableDefaultSchemesCopies() {
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.getInstance().getAllSchemes()) {
            if (!defaultScheme.hasEditableCopy()) continue;
            this.createEditableCopy(defaultScheme, defaultScheme.getEditableCopyName());
        }
    }

    public void initScheme(@NotNull UIManager.LookAndFeelInfo currentLaf) {
        if (currentLaf == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(1);
        }
        EditorColorsScheme scheme2 = null;
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        if (wizardEditorScheme != null) {
            scheme2 = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme2 != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        if (!this.themeIsCustomized && scheme2 == null) {
            if (currentLaf instanceof UIThemeBasedLookAndFeelInfo) {
                String schemeName = ((UIThemeBasedLookAndFeelInfo)currentLaf).getTheme().getEditorSchemeName();
                if (schemeName != null) {
                    scheme2 = this.getScheme(schemeName);
                }
            } else if (currentLaf.getName().contains("Darcula")) {
                scheme2 = this.getScheme("Darcula");
            }
        }
        if (scheme2 != null) {
            this.mySchemeManager.setCurrent(scheme2, false);
        }
    }

    private void loadBundledSchemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            BUNDLED_EP_NAME.processWithPluginDescriptor((ep2, pluginDescriptor) -> this.mySchemeManager.loadBundledScheme(ep2.getPath() + ".xml", null, (PluginDescriptor)pluginDescriptor));
        }
    }

    private void loadSchemesFromThemes() {
        if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            return;
        }
        for (UIManager.LookAndFeelInfo laf : LafManager.getInstance().getInstalledLookAndFeels()) {
            UITheme theme;
            String path2;
            if (!(laf instanceof UIThemeBasedLookAndFeelInfo) || (path2 = (theme = ((UIThemeBasedLookAndFeelInfo)laf).getTheme()).getEditorScheme()) == null) continue;
            this.mySchemeManager.loadBundledScheme(path2, theme, null);
        }
    }

    private void initEditableBundledSchemesCopies() {
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme2 instanceof BundledScheme)) continue;
            this.createEditableCopy((BundledScheme)scheme2, "_@user_" + scheme2.getName());
        }
    }

    private void resolveLinksToBundledSchemes() {
        ArrayList<EditorColorsScheme> brokenSchemesList = new ArrayList<EditorColorsScheme>();
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            try {
                this.resolveSchemeParent(scheme2);
            }
            catch (InvalidDataException e) {
                brokenSchemesList.add(scheme2);
                String message2 = IdeBundle.message((String)"notification.content.color.scheme", (Object[])new Object[]{scheme2.getName(), e.getMessage()});
                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"notification.title.incompatible.color.scheme", (Object[])new Object[0]), message2, NotificationType.ERROR));
            }
        }
        for (EditorColorsScheme brokenScheme : brokenSchemesList) {
            this.mySchemeManager.removeScheme(brokenScheme);
        }
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(2);
        }
        if (scheme2 instanceof AbstractColorsScheme && !(scheme2 instanceof ReadOnlyColorsScheme)) {
            ((AbstractColorsScheme)scheme2).resolveParent(name2 -> this.mySchemeManager.findSchemeByName((String)name2));
        }
    }

    private void createEditableCopy(@NotNull AbstractColorsScheme initialScheme, @NotNull String editableCopyName) {
        AbstractColorsScheme editableCopy;
        if (initialScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(3);
        }
        if (editableCopyName == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(4);
        }
        if ((editableCopy = (AbstractColorsScheme)this.getScheme(editableCopyName)) == null) {
            editableCopy = (AbstractColorsScheme)initialScheme.clone();
            editableCopy.setName(editableCopyName);
            this.mySchemeManager.addScheme(editableCopy);
        }
        editableCopy.setCanBeDeleted(false);
    }

    public void schemeChangedOrSwitched(@Nullable EditorColorsScheme newScheme) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PsiManager.getInstance((Project)project).dropPsiCaches();
        }
        ((EditorColorsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).globalSchemeChange(newScheme);
        ((EditorColorsListener)this.myTreeDispatcher.getMulticaster()).globalSchemeChange(newScheme);
    }

    public void handleThemeAdded(@NotNull UITheme theme) {
        String editorScheme;
        if (theme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(5);
        }
        if ((editorScheme = theme.getEditorScheme()) != null) {
            this.getSchemeManager().loadBundledScheme(editorScheme, theme, null);
            this.initEditableBundledSchemesCopies();
        }
    }

    public void handleThemeRemoved(@NotNull UITheme theme) {
        EditorColorsScheme scheme2;
        String editorSchemeName;
        if (theme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(6);
        }
        if ((editorSchemeName = theme.getEditorSchemeName()) != null && (scheme2 = this.mySchemeManager.findSchemeByName(editorSchemeName)) != null) {
            this.mySchemeManager.removeScheme(scheme2);
            String editableCopyName = EditorColorsManagerImpl.getEditableCopyName(scheme2);
            if (editableCopyName != null) {
                this.mySchemeManager.removeScheme(editableCopyName);
            }
        }
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey key) {
        if (key == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(7);
        }
        boolean dark = StartupUiUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        return this.getScheme(dark ? "Darcula" : "Default").getAttributes(key);
    }

    @NotNull
    private static Map<String, List<AdditionalTextAttributesEP>> collectAdditionalTextAttributesEPs() {
        HashMap<String, List<AdditionalTextAttributesEP>> result2 = new HashMap<String, List<AdditionalTextAttributesEP>>();
        ADDITIONAL_TEXT_ATTRIBUTES_EP_NAME.forEachExtensionSafe(attributesEP -> result2.computeIfAbsent(attributesEP.scheme, __ -> new ArrayList()).add(attributesEP));
        HashMap<String, List<AdditionalTextAttributesEP>> hashMap = result2;
        if (hashMap == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private void loadRemainAdditionalTextAttributes(@NotNull Map<String, List<AdditionalTextAttributesEP>> additionalTextAttributes) {
        if (additionalTextAttributes == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, List<AdditionalTextAttributesEP>> entry2 : additionalTextAttributes.entrySet()) {
            String schemeName = entry2.getKey();
            EditorColorsScheme editorColorsScheme = this.mySchemeManager.findSchemeByName(schemeName);
            if (!(editorColorsScheme instanceof AbstractColorsScheme)) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + schemeName + " from plugins: " + StringUtil.join((Collection)entry2.getValue(), ep2 -> ep2.pluginDescriptor.getPluginId().getIdString(), (String)";"));
                continue;
            }
            EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme((AbstractColorsScheme)editorColorsScheme, (Collection<AdditionalTextAttributesEP>)entry2.getValue());
        }
        additionalTextAttributes.clear();
    }

    private static void loadAdditionalTextAttributesForScheme(@NotNull AbstractColorsScheme scheme2, @NotNull Collection<AdditionalTextAttributesEP> attributeEps) {
        if (scheme2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(10);
        }
        if (attributeEps == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(11);
        }
        for (AdditionalTextAttributesEP attributesEP : attributeEps) {
            InputStream resourceStream = attributesEP.pluginDescriptor.getClassLoader().getResourceAsStream(StringUtil.trimStart((String)attributesEP.file, (String)"/"));
            if (resourceStream == null) {
                LOG.warn("resource not found: " + attributesEP.file);
                continue;
            }
            try {
                Element root2 = JDOMUtil.load((InputStream)resourceStream);
                scheme2.readAttributes(Objects.requireNonNullElse(root2.getChild("attributes"), root2));
                Element colors = root2.getChild(FILE_SPEC);
                if (colors == null) continue;
                scheme2.readColors(colors);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(12);
        }
        if (!this.isDefaultScheme(scheme2) && !Strings.isEmpty((String)scheme2.getName())) {
            this.mySchemeManager.addScheme(scheme2);
        }
    }

    public void removeAllSchemes() {
    }

    public EditorColorsScheme @NotNull [] getAllSchemes() {
        EditorColorsScheme[] result2 = EditorColorsManagerImpl.getAllVisibleSchemes(this.mySchemeManager.getAllSchemes());
        Arrays.sort(result2, EditorColorSchemesComparator.INSTANCE);
        if (result2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(13);
        }
        return result2;
    }

    private static EditorColorsScheme[] getAllVisibleSchemes(@NotNull Collection<? extends EditorColorsScheme> schemes) {
        if (schemes == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(14);
        }
        ArrayList<EditorColorsScheme> visibleSchemes = new ArrayList<EditorColorsScheme>(schemes.size() - 1);
        for (EditorColorsScheme editorColorsScheme : schemes) {
            if (!AbstractColorsScheme.isVisible(editorColorsScheme)) continue;
            visibleSchemes.add(editorColorsScheme);
        }
        return visibleSchemes.toArray(new EditorColorsScheme[0]);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme2) {
        this.setGlobalScheme(scheme2, false);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme2, boolean processChangeSynchronously) {
        boolean notify2 = LoadingState.COMPONENTS_LOADED.isOccurred();
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, notify2, processChangeSynchronously);
    }

    private void setGlobalSchemeInner(@Nullable EditorColorsScheme scheme2) {
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, false);
    }

    @NotNull
    private EditorColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultScheme = DefaultColorSchemesManager.getInstance().getFirstScheme();
        String editableCopyName = defaultScheme.getEditableCopyName();
        EditorColorsScheme editableCopy = this.getScheme(editableCopyName);
        assert (editableCopy != null) : "An editable copy of " + defaultScheme.getName() + " has not been initialized.";
        EditorColorsScheme editorColorsScheme = editableCopy;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(15);
        }
        return editorColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme scheme2 = this.mySchemeManager.getActiveScheme();
        EditorColorsScheme editableCopy = this.getEditableCopy(scheme2);
        if (editableCopy != null) {
            EditorColorsScheme editorColorsScheme = editableCopy;
            if (editorColorsScheme == null) {
                EditorColorsManagerImpl.$$$reportNull$$$0(16);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme2 == null ? this.getDefaultScheme() : scheme2;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(17);
        }
        return editorColorsScheme;
    }

    @Nullable
    private EditorColorsScheme getEditableCopy(EditorColorsScheme scheme2) {
        EditorColorsScheme editableCopy;
        if (EditorColorsManagerImpl.isTempScheme(scheme2)) {
            return scheme2;
        }
        String editableCopyName = EditorColorsManagerImpl.getEditableCopyName(scheme2);
        if (editableCopyName != null && (editableCopy = this.getScheme(editableCopyName)) != null) {
            return editableCopy;
        }
        return null;
    }

    @Nullable
    private static String getEditableCopyName(EditorColorsScheme scheme2) {
        Object editableCopyName = null;
        if (scheme2 instanceof DefaultColorsScheme && ((DefaultColorsScheme)scheme2).hasEditableCopy()) {
            editableCopyName = ((DefaultColorsScheme)scheme2).getEditableCopyName();
        } else if (scheme2 instanceof BundledScheme) {
            editableCopyName = "_@user_" + scheme2.getName();
        }
        return editableCopyName;
    }

    public EditorColorsScheme getScheme(@NonNls @NotNull String schemeName) {
        if (schemeName == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(18);
        }
        return this.mySchemeManager.findSchemeByName(schemeName);
    }

    public void setUseOnlyMonospacedFonts(boolean value2) {
        this.myState.USE_ONLY_MONOSPACED_FONTS = value2;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.myState.USE_ONLY_MONOSPACED_FONTS;
    }

    @Nullable
    public State getState() {
        String currentSchemeName = this.mySchemeManager.getCurrentSchemeName();
        if (currentSchemeName != null && !EditorColorsManagerImpl.isTempScheme(this.mySchemeManager.getActiveScheme())) {
            this.myState.colorScheme = currentSchemeName;
        }
        return this.myState;
    }

    public void noStateLoaded() {
        this.themeIsCustomized = false;
        this.setGlobalSchemeInner(StartupUiUtil.isUnderDarcula() ? this.getScheme("Darcula") : this.getDefaultScheme());
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(19);
        }
        this.themeIsCustomized = true;
        this.myState = state;
        this.setGlobalSchemeInner(this.myState.colorScheme == null ? this.getDefaultScheme() : this.mySchemeManager.findSchemeByName(this.myState.colorScheme));
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme2) {
        return scheme2 instanceof DefaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editableCopy;
        UITheme theme;
        String schemeName;
        EditorColorsScheme globalScheme;
        UIManager.LookAndFeelInfo lookAndFeelInfo = LafManager.getInstance().getCurrentLookAndFeel();
        EditorColorsScheme scheme2 = null;
        if (lookAndFeelInfo instanceof TempUIThemeBasedLookAndFeelInfo && EditorColorsManagerImpl.isTempScheme(globalScheme = EditorColorsManager.getInstance().getGlobalScheme())) {
            EditorColorsScheme editorColorsScheme = globalScheme;
            if (editorColorsScheme == null) {
                EditorColorsManagerImpl.$$$reportNull$$$0(20);
            }
            return editorColorsScheme;
        }
        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo && (schemeName = (theme = ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).getTheme()).getEditorSchemeName()) != null) {
            scheme2 = this.getScheme(schemeName);
            assert (scheme2 != null) : "Theme " + theme.getName() + " refers to unknown color scheme " + schemeName;
        }
        if (scheme2 == null) {
            String schemeName2 = StartupUiUtil.isUnderDarcula() ? "Darcula" : "Default";
            DefaultColorSchemesManager colorSchemeManager = DefaultColorSchemesManager.getInstance();
            scheme2 = colorSchemeManager.getScheme(schemeName2);
            assert (scheme2 != null) : "The default scheme '" + schemeName2 + "' not found, available schemes: " + colorSchemeManager.listNames();
        }
        EditorColorsScheme editorColorsScheme = (editableCopy = this.getEditableCopy(scheme2)) != null ? editableCopy : scheme2;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(21);
        }
        return editorColorsScheme;
    }

    @NotNull
    public SchemeManager<EditorColorsScheme> getSchemeManager() {
        SchemeManager<EditorColorsScheme> schemeManager2 = this.mySchemeManager;
        if (schemeManager2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(22);
        }
        return schemeManager2;
    }

    public static boolean isTempScheme(EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            return false;
        }
        return StringUtil.equals((CharSequence)scheme2.getMetaProperties().getProperty(TEMP_SCHEME_KEY), (CharSequence)Boolean.TRUE.toString());
    }

    @Nullable
    public static Path getTempSchemeOriginalFilePath(EditorColorsScheme scheme2) {
        String path2;
        if (EditorColorsManagerImpl.isTempScheme(scheme2) && (path2 = scheme2.getMetaProperties().getProperty(TEMP_SCHEME_FILE_KEY)) != null) {
            return Paths.get(path2, new String[0]);
        }
        return null;
    }

    public static void setTempScheme(EditorColorsScheme scheme2, @Nullable VirtualFile originalSchemeFile) {
        if (scheme2 == null) {
            return;
        }
        scheme2.getMetaProperties().setProperty(TEMP_SCHEME_KEY, Boolean.TRUE.toString());
        if (originalSchemeFile != null) {
            scheme2.getMetaProperties().setProperty(TEMP_SCHEME_FILE_KEY, originalSchemeFile.getPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeManagerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLaf";
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScheme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editableCopyName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalTextAttributes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeEps";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAdditionalTextAttributesEPs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSchemes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScheme";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalScheme";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeForCurrentUITheme";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initScheme";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemeParent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditableCopy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleThemeAdded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleThemeRemoved";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultAttributes";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadRemainAdditionalTextAttributes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalTextAttributesForScheme";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addColorsScheme";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleSchemes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getScheme";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class State {
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        public String colorScheme;

        State() {
        }
    }

    static final class BundledScheme
    extends EditorColorsSchemeImpl
    implements ReadOnlyColorsScheme {
        BundledScheme() {
            super(null);
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }

    private final class EditorColorSchemeProcessor
    extends LazySchemeProcessor<EditorColorsScheme, EditorColorsSchemeImpl>
    implements SchemeExtensionProvider {
        private final Map<String, List<AdditionalTextAttributesEP>> additionalTextAttributes;

        EditorColorSchemeProcessor(Map<String, List<AdditionalTextAttributesEP>> additionalTextAttributes) {
            if (additionalTextAttributes == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(0);
            }
            this.additionalTextAttributes = additionalTextAttributes;
        }

        @Override
        @NotNull
        public EditorColorsSchemeImpl createScheme(@NotNull SchemeDataHolder<? super EditorColorsSchemeImpl> dataHolder, @NotNull String name2, @NotNull Function<? super String, String> attributeProvider2, boolean isBundled) {
            if (dataHolder == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(2);
            }
            if (attributeProvider2 == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(3);
            }
            EditorColorsSchemeImpl scheme2 = isBundled ? new BundledScheme() : new EditorColorsSchemeImpl(null);
            scheme2.readExternal(dataHolder.read());
            if (isBundled || ApplicationManager.getApplication().isUnitTestMode() && Boolean.parseBoolean(scheme2.getMetaProperties().getProperty("forceOptimize"))) {
                Collection attributesEPs;
                if (scheme2.myParentScheme instanceof AbstractColorsScheme && (attributesEPs = (Collection)this.additionalTextAttributes.remove(scheme2.myParentScheme.getName())) != null && !attributesEPs.isEmpty()) {
                    EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme((AbstractColorsScheme)scheme2.myParentScheme, attributesEPs);
                }
                scheme2.optimizeAttributeMap();
            }
            EditorColorsSchemeImpl editorColorsSchemeImpl = scheme2;
            if (editorColorsSchemeImpl == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(4);
            }
            return editorColorsSchemeImpl;
        }

        @Override
        @NotNull
        public SchemeState getState(@NotNull EditorColorsScheme scheme2) {
            if (scheme2 == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(5);
            }
            SchemeState schemeState = scheme2 instanceof ReadOnlyColorsScheme ? SchemeState.NON_PERSISTENT : SchemeState.POSSIBLY_CHANGED;
            if (schemeState == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(6);
            }
            return schemeState;
        }

        @Override
        public void onCurrentSchemeSwitched(@Nullable EditorColorsScheme oldScheme, @Nullable EditorColorsScheme newScheme, boolean processChangeSynchronously) {
            if (processChangeSynchronously) {
                this.handleCurrentSchemeSwitched(newScheme);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.handleCurrentSchemeSwitched(newScheme));
            }
        }

        private void handleCurrentSchemeSwitched(@Nullable EditorColorsScheme newScheme) {
            LafManager.getInstance().updateUI();
            EditorColorsManagerImpl.this.schemeChangedOrSwitched(newScheme);
        }

        @Override
        @NotNull
        @NonNls
        public String getSchemeExtension() {
            return ".icls";
        }

        @Override
        public boolean isSchemeEqualToBundled(@NotNull EditorColorsSchemeImpl scheme2) {
            if (scheme2 == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(7);
            }
            if (!scheme2.getName().startsWith("_@user_")) {
                return false;
            }
            AbstractColorsScheme bundledScheme = (AbstractColorsScheme)EditorColorsManagerImpl.this.mySchemeManager.findSchemeByName(scheme2.getName().substring("_@user_".length()));
            if (bundledScheme == null) {
                return false;
            }
            return scheme2.settingsEqual(bundledScheme);
        }

        @Override
        public void reloaded(@NotNull SchemeManager<EditorColorsScheme> schemeManager2, @NotNull Collection<? extends EditorColorsScheme> schemes) {
            if (schemeManager2 == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(8);
            }
            if (schemes == null) {
                EditorColorSchemeProcessor.$$$reportNull$$$0(9);
            }
            EditorColorsManagerImpl.this.loadBundledSchemes();
            EditorColorsManagerImpl.this.loadSchemesFromThemes();
            EditorColorsManagerImpl.this.initEditableDefaultSchemesCopies();
            EditorColorsManagerImpl.this.initEditableBundledSchemesCopies();
            ((EditorColorsManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorColorsManagerListener.TOPIC)).schemesReloaded();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalTextAttributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeProvider";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$EditorColorSchemeProcessor";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemeManager";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$EditorColorSchemeProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createScheme";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createScheme";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSchemeEqualToBundled";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "reloaded";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

