/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;
import org.jetbrains.annotations.NotNull;

public class EditorCssFontResolver
implements JBHtmlEditorKit.FontResolver {
    public static final String EDITOR_FONT_NAME_PLACEHOLDER = "_EditorFont_";
    public static final String EDITOR_FONT_NAME_NO_LIGATURES_PLACEHOLDER = "_EditorFontNoLigatures_";
    private static final EditorCssFontResolver GLOBAL_INSTANCE = new EditorCssFontResolver(null);
    private static final Key<EditorCssFontResolver> LOCAL_KEY = Key.create((String)"EditorCssFontResolver");
    private static final Map<TextAttribute, Integer> NO_LIGATURES_ATTRIBUTES = Map.of(TextAttribute.LIGATURES, 0);
    private final Editor myEditor;

    private EditorCssFontResolver(Editor editor2) {
        this.myEditor = editor2;
    }

    @NotNull
    public static EditorCssFontResolver getGlobalInstance() {
        EditorCssFontResolver editorCssFontResolver = GLOBAL_INSTANCE;
        if (editorCssFontResolver == null) {
            EditorCssFontResolver.$$$reportNull$$$0(0);
        }
        return editorCssFontResolver;
    }

    @NotNull
    public static EditorCssFontResolver getInstance(@NotNull Editor editor2) {
        EditorCssFontResolver result2;
        if (editor2 == null) {
            EditorCssFontResolver.$$$reportNull$$$0(1);
        }
        if ((result2 = (EditorCssFontResolver)editor2.getUserData(LOCAL_KEY)) == null) {
            result2 = new EditorCssFontResolver(editor2);
            editor2.putUserData(LOCAL_KEY, (Object)result2);
        }
        EditorCssFontResolver editorCssFontResolver = result2;
        if (editorCssFontResolver == null) {
            EditorCssFontResolver.$$$reportNull$$$0(2);
        }
        return editorCssFontResolver;
    }

    @NotNull
    public Font getFont(@NotNull Font defaultFont, @NotNull AttributeSet attributeSet) {
        Object fontFamily;
        if (defaultFont == null) {
            EditorCssFontResolver.$$$reportNull$$$0(3);
        }
        if (attributeSet == null) {
            EditorCssFontResolver.$$$reportNull$$$0(4);
        }
        if ((fontFamily = attributeSet.getAttribute(CSS.Attribute.FONT_FAMILY)) == null) {
            Font font = defaultFont;
            if (font == null) {
                EditorCssFontResolver.$$$reportNull$$$0(5);
            }
            return font;
        }
        String fontFamilyAsString = fontFamily.toString();
        if (!EDITOR_FONT_NAME_PLACEHOLDER.equals(fontFamilyAsString) && !EDITOR_FONT_NAME_NO_LIGATURES_PLACEHOLDER.equals(fontFamilyAsString)) {
            Font font = defaultFont;
            if (font == null) {
                EditorCssFontResolver.$$$reportNull$$$0(6);
            }
            return font;
        }
        EditorColorsScheme scheme2 = this.myEditor == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.myEditor.getColorsScheme();
        Font font = scheme2.getFont(EditorFontType.forJavaStyle((int)defaultFont.getStyle())).deriveFont(defaultFont.getSize2D());
        if (EDITOR_FONT_NAME_NO_LIGATURES_PLACEHOLDER.equals(fontFamilyAsString)) {
            font = font.deriveFont(NO_LIGATURES_ATTRIBUTES);
        }
        FontUIResource fontUIResource = UIUtil.getFontWithFallback((Font)font);
        if (fontUIResource == null) {
            EditorCssFontResolver.$$$reportNull$$$0(7);
        }
        return fontUIResource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorCssFontResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFont";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorCssFontResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

