/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorFilteringMarkupModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ErrorStripeMarkerImpl;
import com.intellij.openapi.editor.impl.ErrorStripeRangeMarkerTree;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

final class ErrorStripeMarkersModel {
    private static final Logger LOG = Logger.getInstance(ErrorStripeMarkersModel.class);
    private final EditorImpl myEditor;
    private final ErrorStripeRangeMarkerTree myTree;
    private final ErrorStripeRangeMarkerTree myTreeForLines;
    private final List<ErrorStripeListener> myListeners;
    private final MarkupModelListener myDocumentMarkupListener;
    private final MarkupModelListener myEditorMarkupListener;
    private Disposable myActiveDisposable;
    private static final Comparator<ErrorStripeMarkerImpl> BY_AFFECTED_START_OFFSET = Comparator.comparingInt(marker -> {
        RangeHighlighterEx highlighter = marker.getHighlighter();
        return highlighter.isValid() ? highlighter.getAffectedAreaStartOffset() : -1;
    });

    ErrorStripeMarkersModel(@NotNull EditorImpl editor2, @NotNull Disposable parentDisposable) {
        if (editor2 == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDocumentMarkupListener = this.createMarkupListener(true);
        this.myEditorMarkupListener = this.createMarkupListener(false);
        this.myEditor = editor2;
        this.myTree = new ErrorStripeRangeMarkerTree(this.myEditor.getDocument());
        this.myTreeForLines = new ErrorStripeRangeMarkerTree(this.myEditor.getDocument());
        Disposer.register((Disposable)parentDisposable, () -> {
            DocumentEx document = this.myEditor.getDocument();
            this.myTree.dispose(document);
            this.myTreeForLines.dispose(document);
            this.setActive(false);
        });
    }

    void setActive(boolean value2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (value2 == (this.myActiveDisposable != null)) {
            return;
        }
        if (value2) {
            this.myActiveDisposable = Disposer.newDisposable((String)"ErrorStripeMarkersModel");
            this.myEditor.getFilteredDocumentMarkupModel().addMarkupModelListener(this.myActiveDisposable, this.myDocumentMarkupListener);
            this.myEditor.getMarkupModel().addMarkupModelListener(this.myActiveDisposable, this.myEditorMarkupListener);
            this.rebuild();
        } else {
            Disposer.dispose((Disposable)this.myActiveDisposable);
            this.myActiveDisposable = null;
            this.clear();
        }
    }

    void rebuild() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myActiveDisposable == null) {
            return;
        }
        this.clear();
        int textLength = this.myEditor.getDocument().getTextLength();
        this.myEditor.getMarkupModel().processRangeHighlightersOverlappingWith(0, textLength, (Processor<? super RangeHighlighterEx>)((Processor)ex -> {
            this.afterAdded((RangeHighlighterEx)ex, false);
            return true;
        }));
        ((EditorFilteringMarkupModelEx)this.myEditor.getFilteredDocumentMarkupModel()).getDelegate().processRangeHighlightersOverlappingWith(0, textLength, (Processor<? super RangeHighlighterEx>)((Processor)ex -> {
            this.afterAdded((RangeHighlighterEx)ex, true);
            return true;
        }));
    }

    void addErrorMarkerListener(ErrorStripeListener listener2, Disposable parent) {
        ContainerUtil.add((Object)listener2, this.myListeners, (Disposable)parent);
    }

    void fireErrorMarkerClicked(RangeHighlighter highlighter, MouseEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ErrorStripeEvent event = new ErrorStripeEvent(this.myEditor, e, highlighter);
        this.myListeners.forEach(listener2 -> listener2.errorMarkerClicked(event));
    }

    private MarkupModelListener createMarkupListener(final boolean documentMarkupModel) {
        return new MarkupModelListener(){

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                ErrorStripeMarkersModel.this.afterAdded(highlighter, documentMarkupModel);
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                ErrorStripeMarkersModel.this.beforeRemoved(highlighter, documentMarkupModel);
            }

            @Override
            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(2);
                }
                ErrorStripeMarkersModel.this.attributesChanged(highlighter, documentMarkupModel);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/openapi/editor/impl/ErrorStripeMarkersModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attributesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void afterAdded(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(2);
        }
        if (this.isAvailable(highlighter, documentMarkupModel)) {
            this.createErrorStripeMarker(highlighter);
        }
    }

    private void beforeRemoved(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        ErrorStripeMarkerImpl errorStripeMarker;
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(3);
        }
        if ((errorStripeMarker = this.findErrorStripeMarker(highlighter, false)) != null) {
            this.removeErrorStripeMarker(errorStripeMarker);
        } else if (this.isAvailable(highlighter, documentMarkupModel)) {
            errorStripeMarker = this.findErrorStripeMarker(highlighter, true);
            if (errorStripeMarker == null) {
                LOG.error("Missing " + highlighter);
            } else {
                LOG.error("Full scan performed for " + highlighter);
                this.removeErrorStripeMarker(errorStripeMarker);
            }
        }
    }

    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(4);
        }
        ErrorStripeMarkerImpl existingErrorStripeMarker = this.findErrorStripeMarker(highlighter, false);
        boolean hasErrorStripe = this.isAvailable(highlighter, documentMarkupModel);
        if (existingErrorStripeMarker == null) {
            if (hasErrorStripe) {
                this.createErrorStripeMarker(highlighter);
            }
            return;
        }
        if (!hasErrorStripe) {
            this.removeErrorStripeMarker(existingErrorStripeMarker);
            return;
        }
        existingErrorStripeMarker.setGreedyToLeft(highlighter.isGreedyToLeft());
        existingErrorStripeMarker.setGreedyToRight(highlighter.isGreedyToRight());
        if (highlighter instanceof RangeMarkerImpl) {
            existingErrorStripeMarker.setStickingToRight(((RangeMarkerImpl)((Object)highlighter)).isStickingToRight());
        }
        this.myListeners.forEach(l -> l.errorMarkerChanged(new ErrorStripeEvent(this.myEditor, null, highlighter)));
    }

    private boolean isAvailable(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(5);
        }
        if (!(!documentMarkupModel || highlighter.getEditorFilter().avaliableIn((Editor)this.myEditor) && this.myEditor.isHighlighterAvailable(highlighter))) {
            return false;
        }
        return highlighter.getErrorStripeMarkColor(this.myEditor.getColorsScheme()) != null;
    }

    private void createErrorStripeMarker(@NotNull RangeHighlighterEx h) {
        if (h == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ErrorStripeMarkerImpl marker = new ErrorStripeMarkerImpl(this.myEditor.getDocument(), h);
        this.treeFor(h).addInterval(marker, h.getStartOffset(), h.getEndOffset(), h.isGreedyToLeft(), h.isGreedyToRight(), h instanceof RangeMarkerImpl && ((RangeMarkerImpl)((Object)h)).isStickingToRight(), h.getLayer());
        this.myListeners.forEach(l -> l.errorMarkerChanged(new ErrorStripeEvent(this.myEditor, null, h)));
    }

    private void removeErrorStripeMarker(ErrorStripeMarkerImpl errorStripeMarker) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighterEx highlighter = errorStripeMarker.getHighlighter();
        this.treeFor(highlighter).removeInterval(errorStripeMarker);
        this.myListeners.forEach(l -> l.errorMarkerChanged(new ErrorStripeEvent(this.myEditor, null, highlighter)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorStripeMarkerImpl findErrorStripeMarker(@NotNull RangeHighlighterEx highlighter, boolean lookEverywhere) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int offset = highlighter.getStartOffset();
        MarkupIterator iterator2 = this.treeFor(highlighter).overlappingIterator((TextRange)new ProperTextRange(lookEverywhere ? 0 : offset, lookEverywhere ? this.myEditor.getDocument().getTextLength() : offset), null);
        try {
            ErrorStripeMarkerImpl errorStripeMarkerImpl = (ErrorStripeMarkerImpl)ContainerUtil.find(iterator2, marker -> marker.getHighlighter() == highlighter);
            return errorStripeMarkerImpl;
        }
        finally {
            iterator2.dispose();
        }
    }

    MarkupIterator<RangeHighlighterEx> highlighterIterator(int startOffset, int endOffset) {
        return new HighlighterIterator(startOffset, endOffset);
    }

    private ErrorStripeRangeMarkerTree treeFor(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(8);
        }
        return highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE ? this.myTree : this.myTreeForLines;
    }

    private void clear() {
        this.myTree.clear();
        this.myTreeForLines.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/ErrorStripeMarkersModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "afterAdded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeRemoved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "attributesChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createErrorStripeMarker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorStripeMarker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "treeFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class HighlighterIterator
    implements MarkupIterator<RangeHighlighterEx> {
        private final MarkupIterator<ErrorStripeMarkerImpl> myDelegate;
        private final List<ErrorStripeMarkerImpl> myToRemove = new ArrayList<ErrorStripeMarkerImpl>();
        private RangeHighlighterEx myNext;

        private HighlighterIterator(int startOffset, int endOffset) {
            startOffset = Math.max(0, startOffset);
            endOffset = Math.max(startOffset, endOffset);
            MarkupIterator exact = ErrorStripeMarkersModel.this.myTree.overlappingIterator((TextRange)new ProperTextRange(startOffset, endOffset), null);
            MarkupIterator lines2 = ErrorStripeMarkersModel.this.myTreeForLines.overlappingIterator(MarkupModelImpl.roundToLineBoundaries(ErrorStripeMarkersModel.this.myEditor.getDocument(), startOffset, endOffset), null);
            this.myDelegate = MarkupIterator.mergeIterators(exact, lines2, BY_AFFECTED_START_OFFSET);
            this.advance();
        }

        @Override
        public void dispose() {
            this.myDelegate.dispose();
            this.myToRemove.forEach(m -> ErrorStripeMarkersModel.this.treeFor(m.getHighlighter()).removeInterval(m));
        }

        public RangeHighlighterEx peek() throws NoSuchElementException {
            return this.myNext;
        }

        public boolean hasNext() {
            return this.myNext != null;
        }

        public RangeHighlighterEx next() {
            RangeHighlighterEx result2 = this.myNext;
            this.advance();
            return result2;
        }

        private void advance() {
            while (this.myDelegate.hasNext()) {
                ErrorStripeMarkerImpl next = (ErrorStripeMarkerImpl)this.myDelegate.next();
                RangeHighlighterEx highlighter = next.getHighlighter();
                if (highlighter.isValid()) {
                    this.myNext = highlighter;
                    return;
                }
                LOG.error("Dangling highlighter found: " + highlighter + " (" + next + ")");
                this.myToRemove.add(next);
            }
            this.myNext = null;
        }
    }
}

