/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ClipDetector;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TabCharacterPaintMode;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.ComplexTextFragment;
import com.intellij.openapi.editor.impl.view.EditorSizeManager;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.CachingPainter;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IntPair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorPainter
implements TextDrawingCallback {
    private static final Color CARET_LIGHT = Gray._255;
    private static final Color CARET_DARK = Gray._0;
    private static final Stroke IME_COMPOSED_TEXT_UNDERLINE_STROKE = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
    private static final int CARET_DIRECTION_MARK_SIZE = 3;
    private static final char IDEOGRAPHIC_SPACE = '\u3000';
    private static final String WHITESPACE_CHARS = " \t\u3000";
    private static final Object ourCachedDot = ObjectUtils.sentinel((String)"space symbol");
    public static final String EDITOR_TAB_PAINTING = "editor.tab.painting";
    private final EditorView myView;

    EditorPainter(EditorView view) {
        this.myView = view;
    }

    void paint(Graphics2D g) {
        new Session(this.myView, g).paint();
    }

    void repaintCarets() {
        EditorImpl editor2 = this.myView.getEditor();
        EditorImpl.CaretRectangle[] locations = editor2.getCaretLocations(false);
        if (locations == null) {
            return;
        }
        int nominalLineHeight = this.myView.getNominalLineHeight();
        int topOverhang = this.myView.getTopOverhang();
        for (EditorImpl.CaretRectangle location : locations) {
            float x = (float)location.myPoint.getX();
            int y = (int)location.myPoint.getY() - topOverhang;
            float width = location.myWidth + 3.0f;
            int xStart = (int)Math.floor(x - width);
            int xEnd = (int)Math.ceil(x + width);
            editor2.getContentComponent().repaint(xStart, y, xEnd - xStart, nominalLineHeight);
        }
    }

    @Override
    public void drawChars(@NotNull Graphics g, char @NotNull [] data2, int start2, int end, int x, int y, @NotNull Color color, @NotNull FontInfo fontInfo) {
        if (g == null) {
            EditorPainter.$$$reportNull$$$0(0);
        }
        if (color == null) {
            EditorPainter.$$$reportNull$$$0(1);
        }
        if (fontInfo == null) {
            EditorPainter.$$$reportNull$$$0(2);
        }
        if (data2 == null) {
            EditorPainter.$$$reportNull$$$0(3);
        }
        g.setFont(fontInfo.getFont());
        g.setColor(color);
        g.drawChars(data2, start2, end - start2, x, y);
    }

    public static boolean isMarginShown(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorPainter.$$$reportNull$$$0(4);
        }
        return editor2.getSettings().isRightMarginShown() && editor2.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR) != null && (Registry.is((String)"editor.show.right.margin.in.read.only.files") || editor2.getDocument().isWritable());
    }

    public static int getIndentGuideShift(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorPainter.$$$reportNull$$$0(5);
        }
        return -Session.getTabGap(Session.getWhiteSpaceScale(editor2)) / 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "drawChars";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarginShown";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentGuideShift";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MarginPositions {
        private final float[] x;
        private final int[] y;

        private MarginPositions(int size) {
            this.x = new float[size];
            this.y = new int[size];
        }
    }

    private static final class LineExtensionData {
        private final LineExtensionInfo info;
        private final LineLayout layout;

        private LineExtensionData(LineExtensionInfo info2, LineLayout layout) {
            this.info = info2;
            this.layout = layout;
        }
    }

    private static interface XCorrector {
        public float startX(int var1);

        public int lineWidth(int var1, float var2);

        public int emptyTextX();

        public int minX(int var1, int var2);

        public int maxX(int var1, int var2);

        public int lineSeparatorStart(int var1);

        public int lineSeparatorEnd(int var1);

        public float singleLineBorderStart(float var1);

        public float singleLineBorderEnd(float var1);

        public int marginX(float var1);

        public List<Integer> softMarginsX();

        @NotNull
        public static XCorrector create(@NotNull EditorView view, @NotNull Insets insets) {
            if (view == null) {
                XCorrector.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                XCorrector.$$$reportNull$$$0(1);
            }
            return view.getEditor().isRightAligned() ? new RightAligned(view) : new LeftAligned(view, insets);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "insets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/view/EditorPainter$XCorrector";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static final class RightAligned
        implements XCorrector {
            private final EditorView myView;

            private RightAligned(@NotNull EditorView view) {
                if (view == null) {
                    RightAligned.$$$reportNull$$$0(0);
                }
                this.myView = view;
            }

            @Override
            public float startX(int line) {
                return this.myView.getRightAlignmentLineStartX(line);
            }

            @Override
            public int lineWidth(int line, float x) {
                return (int)(x - this.myView.getRightAlignmentLineStartX(line));
            }

            @Override
            public int emptyTextX() {
                return this.myView.getRightAlignmentMarginX();
            }

            @Override
            public int minX(int startLine, int endLine) {
                return this.myView.getRightAlignmentMarginX() - this.myView.getMaxTextWidthInLineRange(startLine, endLine - 1) - 1;
            }

            @Override
            public int maxX(int startLine, int endLine) {
                return this.myView.getRightAlignmentMarginX() - 1;
            }

            @Override
            public float singleLineBorderStart(float x) {
                return x - 1.0f;
            }

            @Override
            public float singleLineBorderEnd(float x) {
                return x;
            }

            @Override
            public int lineSeparatorStart(int minX) {
                return EditorPainter.isMarginShown(this.myView.getEditor()) ? Math.max(this.marginX(Session.getBaseMarginWidth(this.myView)), minX) : minX;
            }

            @Override
            public int lineSeparatorEnd(int maxX) {
                return maxX;
            }

            @Override
            public int marginX(float marginWidth) {
                return (int)((float)this.myView.getRightAlignmentMarginX() - marginWidth);
            }

            @Override
            public List<Integer> softMarginsX() {
                List margins = this.myView.getEditor().getSettings().getSoftMargins();
                ArrayList<Integer> result2 = new ArrayList<Integer>(margins.size());
                for (Integer margin : margins) {
                    result2.add((int)((float)this.myView.getRightAlignmentMarginX() - (float)margin.intValue() * this.myView.getPlainSpaceWidth()));
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/EditorPainter$XCorrector$RightAligned", "<init>"));
            }
        }

        public static final class LeftAligned
        implements XCorrector {
            private final EditorView myView;
            private final int myLeftInset;

            private LeftAligned(@NotNull EditorView view, @NotNull Insets insets) {
                if (view == null) {
                    LeftAligned.$$$reportNull$$$0(0);
                }
                if (insets == null) {
                    LeftAligned.$$$reportNull$$$0(1);
                }
                this.myView = view;
                this.myLeftInset = insets.left;
            }

            @Override
            public float startX(int line) {
                return this.myLeftInset;
            }

            @Override
            public int emptyTextX() {
                return this.myLeftInset;
            }

            @Override
            public int minX(int startLine, int endLine) {
                return this.myLeftInset;
            }

            @Override
            public int maxX(int startLine, int endLine) {
                return this.minX(startLine, endLine) + this.myView.getMaxTextWidthInLineRange(startLine, endLine - 1) - 1;
            }

            @Override
            public float singleLineBorderStart(float x) {
                return x;
            }

            @Override
            public float singleLineBorderEnd(float x) {
                return x + 1.0f;
            }

            @Override
            public int lineWidth(int line, float x) {
                return (int)x - this.myLeftInset;
            }

            @Override
            public int lineSeparatorStart(int maxX) {
                return this.myLeftInset;
            }

            @Override
            public int lineSeparatorEnd(int maxX) {
                return EditorPainter.isMarginShown(this.myView.getEditor()) ? Math.min(this.marginX(Session.getBaseMarginWidth(this.myView)), maxX) : maxX;
            }

            @Override
            public int marginX(float marginWidth) {
                return (int)((float)this.myLeftInset + marginWidth);
            }

            @Override
            public List<Integer> softMarginsX() {
                List margins = this.myView.getEditor().getSettings().getSoftMargins();
                ArrayList<Integer> result2 = new ArrayList<Integer>(margins.size());
                for (Integer margin : margins) {
                    result2.add((int)((float)this.myLeftInset + (float)margin.intValue() * this.myView.getPlainSpaceWidth()));
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "view";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "insets";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/view/EditorPainter$XCorrector$LeftAligned";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class LineWhitespacePaintingStrategy {
        private final boolean myWhitespaceShown;
        private final boolean myLeadingWhitespaceShown;
        private final boolean myInnerWhitespaceShown;
        private final boolean myTrailingWhitespaceShown;
        private int currentLeadingEdge;
        private int currentTrailingEdge;

        LineWhitespacePaintingStrategy(EditorSettings settings) {
            this.myWhitespaceShown = settings.isWhitespacesShown();
            this.myLeadingWhitespaceShown = settings.isLeadingWhitespaceShown();
            this.myInnerWhitespaceShown = settings.isInnerWhitespaceShown();
            this.myTrailingWhitespaceShown = settings.isTrailingWhitespaceShown();
        }

        private boolean showAnyWhitespace() {
            return this.myWhitespaceShown && (this.myLeadingWhitespaceShown || this.myInnerWhitespaceShown || this.myTrailingWhitespaceShown);
        }

        private void update(CharSequence chars, int lineStart, int lineEnd) {
            if (!(!this.showAnyWhitespace() || this.myLeadingWhitespaceShown && this.myInnerWhitespaceShown && this.myTrailingWhitespaceShown)) {
                this.currentTrailingEdge = CharArrayUtil.shiftBackward((CharSequence)chars, (int)lineStart, (int)(lineEnd - 1), (String)EditorPainter.WHITESPACE_CHARS) + 1;
                this.currentLeadingEdge = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (int)this.currentTrailingEdge, (String)EditorPainter.WHITESPACE_CHARS);
            }
        }

        private boolean showWhitespaceAtOffset(int offset) {
            return this.myWhitespaceShown && (offset < this.currentLeadingEdge ? this.myLeadingWhitespaceShown : (offset >= this.currentTrailingEdge ? this.myTrailingWhitespaceShown : this.myInnerWhitespaceShown));
        }
    }

    static interface LineFragmentPainter {
        public void paintBeforeLineStart(TextAttributes var1, boolean var2, int var3, float var4, int var5);

        public void paint(VisualLineFragmentsIterator.Fragment var1, int var2, int var3, TextAttributes var4, float var5, float var6, int var7);

        public void paintAfterLineEnd(IterationState var1, int var2, float var3, int var4);
    }

    private static final class Session {
        private final EditorView myView;
        private final EditorImpl myEditor;
        private final Document myDocument;
        private final CharSequence myText;
        private final MarkupModelEx myDocMarkup;
        private final MarkupModelEx myEditorMarkup;
        private final XCorrector myCorrector;
        private final Graphics2D myGraphics;
        private final Rectangle myClip;
        private final Insets myInsets;
        private final int myYShift;
        private final int myStartVisualLine;
        private final int myEndVisualLine;
        private final int myStartOffset;
        private final int myEndOffset;
        private final int mySeparatorHighlightersStartOffset;
        private final int mySeparatorHighlightersEndOffset;
        private final ClipDetector myClipDetector;
        private final IterationState.CaretData myCaretData;
        private final Int2ObjectMap<IntPair> myVirtualSelectionMap;
        private final Int2ObjectMap<List<LineExtensionData>> myExtensionData = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<TextAttributes> myBetweenLinesAttributes = new Int2ObjectOpenHashMap();
        private final int myLineHeight;
        private final int myAscent;
        private final int myDescent;
        private final Color myDefaultBackgroundColor;
        private final Color myBackgroundColor;
        private final int myMarginColumns;
        private final List<Consumer<Graphics2D>> myTextDrawingTasks = new ArrayList<Consumer<Graphics2D>>();
        private final List<RangeHighlighter> myForegroundCustomHighlighters = new SmartList();
        private final ScaleContext myScaleContext;
        private MarginPositions myMarginPositions;

        private Session(EditorView view, Graphics2D g) {
            this.myView = view;
            this.myEditor = this.myView.getEditor();
            this.myDocument = this.myEditor.getDocument();
            this.myText = this.myDocument.getImmutableCharSequence();
            this.myDocMarkup = this.myEditor.getFilteredDocumentMarkupModel();
            this.myEditorMarkup = this.myEditor.getMarkupModel();
            this.myInsets = this.myView.getInsets();
            this.myCorrector = XCorrector.create(this.myView, this.myInsets);
            this.myGraphics = g;
            this.myClip = this.myGraphics.getClipBounds();
            this.myYShift = -this.myClip.y;
            this.myStartVisualLine = this.myView.yToVisualLine(this.myClip.y);
            this.myEndVisualLine = this.myView.yToVisualLine(this.myClip.y + this.myClip.height - 1);
            this.myStartOffset = this.myView.visualLineToOffset(this.myStartVisualLine);
            this.myEndOffset = this.myView.visualLineToOffset(this.myEndVisualLine + 1);
            this.mySeparatorHighlightersStartOffset = DocumentUtil.getLineStartOffset(this.myView.visualLineToOffset(this.myStartVisualLine - 1), this.myDocument);
            this.mySeparatorHighlightersEndOffset = DocumentUtil.getLineEndOffset(this.myView.visualLineToOffset(this.myEndVisualLine + 2), this.myDocument);
            this.myClipDetector = new ClipDetector(this.myEditor, this.myClip);
            this.myCaretData = this.myEditor.isPaintSelection() ? IterationState.createCaretData(this.myEditor) : null;
            this.myVirtualSelectionMap = Session.createVirtualSelectionMap(this.myEditor, this.myStartVisualLine, this.myEndVisualLine);
            this.myLineHeight = this.myView.getLineHeight();
            this.myAscent = this.myView.getAscent();
            this.myDescent = this.myView.getDescent();
            this.myDefaultBackgroundColor = this.myEditor.getColorsScheme().getDefaultBackground();
            this.myBackgroundColor = this.myEditor.getBackgroundColor();
            this.myMarginColumns = this.myEditor.getSettings().getRightMargin(this.myEditor.getProject());
            this.myScaleContext = ScaleContext.create((Graphics2D)this.myGraphics);
        }

        private void paint() {
            if (this.myEditor.getContentComponent().isOpaque()) {
                this.myGraphics.setColor(this.myBackgroundColor);
                this.myGraphics.fillRect(this.myClip.x, this.myClip.y, this.myClip.width, this.myClip.height);
            }
            this.myGraphics.translate(0, -this.myYShift);
            if (this.paintPlaceholderText()) {
                this.paintCaret();
                return;
            }
            this.paintBackground();
            this.paintRightMargin();
            this.paintCustomRenderers(this.myDocMarkup);
            this.paintCustomRenderers(this.myEditorMarkup);
            this.paintLineMarkersSeparators(this.myDocMarkup);
            this.paintLineMarkersSeparators(this.myEditorMarkup);
            this.paintTextWithEffects();
            this.paintHighlightersAfterEndOfLine(this.myDocMarkup);
            this.paintHighlightersAfterEndOfLine(this.myEditorMarkup);
            this.paintBorderEffect(this.myEditor.getHighlighter());
            this.paintBorderEffect(this.myDocMarkup);
            this.paintBorderEffect(this.myEditorMarkup);
            this.paintForegroundCustomRenderers();
            this.paintBlockInlays();
            this.paintCaret();
            this.paintComposedTextDecoration();
            this.myGraphics.translate(0, this.myYShift);
        }

        private boolean paintPlaceholderText() {
            CharSequence hintText = this.myEditor.getPlaceholder();
            EditorComponentImpl editorComponent = this.myEditor.getContentComponent();
            if (this.myDocument.getTextLength() > 0 || hintText == null || hintText.length() == 0 || KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == editorComponent && !this.myEditor.getShowPlaceholderWhenFocused()) {
                return false;
            }
            EditorFontType fontType = EditorFontType.PLAIN;
            Object color = JBColor.namedColor((String)"Component.infoForeground", (Color)this.myEditor.getColorsScheme().getDefaultForeground());
            TextAttributes attributes2 = this.myEditor.getPlaceholderAttributes();
            if (attributes2 != null) {
                int type = attributes2.getFontType();
                if (type == 2) {
                    fontType = EditorFontType.ITALIC;
                } else if (type == 1) {
                    fontType = EditorFontType.BOLD;
                } else if (type == 3) {
                    fontType = EditorFontType.BOLD_ITALIC;
                }
                Color attColor = attributes2.getForegroundColor();
                if (attColor != null) {
                    color = attColor;
                }
            }
            this.myGraphics.setColor((Color)color);
            String hintString = hintText.toString();
            this.myGraphics.setFont(UIUtil.getFontWithFallbackIfNeeded((Font)this.myEditor.getColorsScheme().getFont(fontType), (String)hintString));
            String toDisplay = SwingUtilities.layoutCompoundLabel(this.myGraphics.getFontMetrics(), hintString, null, 0, 0, 0, 0, SwingUtilities.calculateInnerArea(editorComponent, null), new Rectangle(), new Rectangle(), 0);
            this.myGraphics.drawString(toDisplay, this.myInsets.left, this.myInsets.top + this.myAscent + this.myYShift);
            return true;
        }

        private void paintRightMargin() {
            Color visualGuidesColor;
            if (this.myEditor.getSettings().isRightMarginShown() && (visualGuidesColor = this.myEditor.getColorsScheme().getColor(EditorColors.VISUAL_INDENT_GUIDE_COLOR)) != null) {
                this.myGraphics.setColor(visualGuidesColor);
                for (Integer marginX : this.myCorrector.softMarginsX()) {
                    LinePainter2D.paint((Graphics2D)this.myGraphics, (double)marginX.intValue(), (double)0.0, (double)marginX.intValue(), (double)this.myClip.height);
                }
            }
            if (!this.isMarginShown()) {
                return;
            }
            this.myGraphics.setColor(this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR));
            float baseMarginWidth = Session.getBaseMarginWidth(this.myView);
            int baseMarginX = this.myCorrector.marginX(baseMarginWidth);
            if (this.myMarginPositions == null) {
                LinePainter2D.paint((Graphics2D)this.myGraphics, (double)baseMarginX, (double)0.0, (double)baseMarginX, (double)this.myClip.height);
            } else {
                int displayedLinesCount = this.myMarginPositions.x.length - 1;
                for (int i2 = 0; i2 <= displayedLinesCount; ++i2) {
                    float width = this.myMarginPositions.x[i2];
                    int x = width == 0.0f ? baseMarginX : (int)width;
                    int y = this.myMarginPositions.y[i2];
                    if (i2 == 0 && y > this.myYShift) {
                        this.myGraphics.fillRect(baseMarginX, this.myYShift, 1, y - this.myYShift);
                        if (x != baseMarginX) {
                            this.myGraphics.fillRect(Math.min(x, baseMarginX), y - 1, Math.abs(x - baseMarginX) + 1, 1);
                        }
                    }
                    if (i2 < displayedLinesCount) {
                        this.myGraphics.fillRect(x, y, 1, this.myLineHeight);
                        float nextWidth = this.myMarginPositions.x[i2 + 1];
                        int nextX = nextWidth == 0.0f ? baseMarginX : (int)nextWidth;
                        int nextY = this.myMarginPositions.y[i2 + 1];
                        if (nextY > y + this.myLineHeight) {
                            if (x != baseMarginX) {
                                this.myGraphics.fillRect(Math.min(x, baseMarginX), y + this.myLineHeight - 1, Math.abs(x - baseMarginX) + 1, 1);
                            }
                            this.myGraphics.fillRect(baseMarginX, y + this.myLineHeight, 1, nextY - y - this.myLineHeight);
                            if (baseMarginX == nextX) continue;
                            this.myGraphics.fillRect(Math.min(nextX, baseMarginX), nextY - 1, Math.abs(nextX - baseMarginX) + 1, 1);
                            continue;
                        }
                        if (x == nextX) continue;
                        this.myGraphics.fillRect(Math.min(x, nextX), y + this.myLineHeight - 1, Math.abs(x - nextX) + 1, 1);
                        continue;
                    }
                    this.myGraphics.fillRect(x, y, 1, this.myClip.y + this.myClip.height + this.myYShift - y);
                }
            }
        }

        private static float getBaseMarginWidth(EditorView view) {
            EditorImpl editor2 = view.getEditor();
            return (float)editor2.getSettings().getRightMargin(editor2.getProject()) * view.getPlainSpaceWidth();
        }

        private boolean isMarginShown() {
            return EditorPainter.isMarginShown(this.myEditor);
        }

        private void paintBackground() {
            int visualLine;
            int lineCount = this.myEditor.getVisibleLineCount();
            boolean calculateMarginWidths = Registry.is((String)"editor.adjust.right.margin") && this.isMarginShown() && this.myStartVisualLine < lineCount;
            this.myMarginPositions = calculateMarginWidths ? new MarginPositions(Math.min(this.myEndVisualLine, lineCount - 1) - this.myStartVisualLine + 2) : null;
            final LineWhitespacePaintingStrategy whitespacePaintingStrategy = new LineWhitespacePaintingStrategy(this.myEditor.getSettings());
            boolean paintAllSoftWraps = this.myEditor.getSettings().isAllSoftWrapsShown();
            final float whiteSpaceScale = Session.getWhiteSpaceScale(this.myEditor);
            final BasicStroke whiteSpaceStroke = new BasicStroke(Session.calcFeatureSize(1, whiteSpaceScale));
            PeekableIteratorWrapper caretIterator = null;
            if (this.myEditor.getInlayModel().hasBlockElements()) {
                Iterator carets = this.myEditor.getCaretModel().getAllCarets().stream().filter(Caret::hasSelection).sorted(Comparator.comparingInt(Caret::getSelectionStart)).iterator();
                caretIterator = new PeekableIteratorWrapper(carets);
            }
            final VisualPosition primarySelectionStart = this.myEditor.getSelectionModel().getSelectionStartPosition();
            final VisualPosition primarySelectionEnd = this.myEditor.getSelectionModel().getSelectionEndPosition();
            LineLayout prefixLayout = this.myView.getPrefixLayout();
            if (this.myStartVisualLine == 0 && prefixLayout != null) {
                float width2 = prefixLayout.getWidth();
                TextAttributes attributes2 = this.myView.getPrefixAttributes();
                this.paintBackground(attributes2, this.myCorrector.startX(this.myStartVisualLine), this.myYShift + this.myView.visualLineToY(0), width2);
                this.myTextDrawingTasks.add(g -> this.paintLineLayoutWithEffect(prefixLayout, this.myCorrector.startX(this.myStartVisualLine), this.myAscent + this.myYShift + this.myView.visualLineToY(0), attributes2.getForegroundColor(), attributes2.getEffectColor(), attributes2.getEffectType()));
            }
            final int startX = this.myInsets.left;
            final int endX = this.myClip.x + this.myClip.width;
            int prevY = Math.max(this.myInsets.top, this.myClip.y) + this.myYShift;
            final VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, this.myStartVisualLine);
            while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= this.myEndVisualLine + 1) {
                boolean dryRun;
                int y = visLinesIterator.getY() + this.myYShift;
                if (calculateMarginWidths) {
                    this.myMarginPositions.y[visualLine - this.myStartVisualLine] = y;
                }
                if (y > prevY) {
                    TextAttributes attributes3 = this.getBetweenLinesAttributes(visualLine, visLinesIterator.getVisualLineStartOffset(), (PeekableIterator<? extends Caret>)((PeekableIterator)Objects.requireNonNull(caretIterator)));
                    this.myBetweenLinesAttributes.put(visualLine, (Object)attributes3);
                    this.paintBackground(attributes3.getBackgroundColor(), (float)startX, prevY, (float)(endX - startX), y - prevY);
                }
                boolean bl = dryRun = visualLine > this.myEndVisualLine;
                if (dryRun && !calculateMarginWidths) break;
                final boolean paintSoftWraps = paintAllSoftWraps || this.myEditor.getCaretModel().getLogicalPosition().line == visLinesIterator.getDisplayedLogicalLine();
                final int[] currentLogicalLine = new int[]{-1};
                this.paintLineFragments(visLinesIterator, y, new LineFragmentPainter(){

                    @Override
                    public void paintBeforeLineStart(TextAttributes attributes2, boolean hasSoftWrap, int columnEnd, float xEnd, int y) {
                        if (dryRun) {
                            return;
                        }
                        if (visualLine == 0) {
                            xEnd -= myView.getPrefixTextWidthInPixels();
                        }
                        this.paintBackground(attributes2, (float)startX, y, xEnd);
                        if (!hasSoftWrap) {
                            return;
                        }
                        this.paintSelectionOnSecondSoftWrapLineIfNecessary(visualLine, columnEnd, xEnd, y, primarySelectionStart, primarySelectionEnd);
                        if (paintSoftWraps) {
                            int x = (int)xEnd;
                            myTextDrawingTasks.add(g -> {
                                SoftWrapModelImpl softWrapModel = myEditor.getSoftWrapModel();
                                int symbolWidth = softWrapModel.getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                                softWrapModel.doPaint((Graphics)g, SoftWrapDrawingType.AFTER_SOFT_WRAP, x - symbolWidth, y, myLineHeight);
                            });
                        }
                    }

                    @Override
                    public void paint(VisualLineFragmentsIterator.Fragment fragment2, int start2, int end, TextAttributes attributes2, float xStart, float xEnd, int y) {
                        Inlay inlay;
                        TextAttributes foldRegionInnerAttributes;
                        if (dryRun) {
                            return;
                        }
                        FoldRegion foldRegion = fragment2.getCurrentFoldRegion();
                        TextAttributes textAttributes = foldRegionInnerAttributes = foldRegion == null || !Registry.is((String)"editor.highlight.foldings") ? null : this.getInnerHighlighterAttributes(foldRegion);
                        if (foldRegionInnerAttributes == null || !this.paintFoldingBackground(foldRegionInnerAttributes, xStart, y, xEnd - xStart, foldRegion)) {
                            this.paintBackground(attributes2, xStart, y, xEnd - xStart);
                        }
                        if ((inlay = fragment2.getCurrentInlay()) != null) {
                            TextAttributes attrs = attributes2.clone();
                            myTextDrawingTasks.add(g -> inlay.getRenderer().paint(inlay, g, (Rectangle2D)new Rectangle2D.Double(xStart, y, xEnd - xStart, myLineHeight), attrs));
                        } else {
                            Color color2;
                            if (foldRegionInnerAttributes != null) {
                                attributes2 = TextAttributes.merge((TextAttributes)attributes2, (TextAttributes)foldRegionInnerAttributes);
                            }
                            if (attributes2 != null) {
                                attributes2.forEachEffect((type, color) -> myTextDrawingTasks.add(g -> this.paintTextEffect(xStart, xEnd, y + myAscent, (Color)color, (EffectType)type, foldRegion != null)));
                            }
                            if (attributes2 != null && (color2 = attributes2.getForegroundColor()) != null) {
                                myTextDrawingTasks.add(g -> g.setColor(color2));
                                myTextDrawingTasks.add(fragment2.draw(xStart, y + myAscent, start2, end));
                            }
                        }
                        if (foldRegion == null) {
                            int logicalLine = fragment2.getStartLogicalLine();
                            if (logicalLine != currentLogicalLine[0]) {
                                whitespacePaintingStrategy.update(myText, myDocument.getLineStartOffset(logicalLine), myDocument.getLineEndOffset(logicalLine));
                                currentLogicalLine[0] = logicalLine;
                            }
                            this.paintWhitespace(xStart, y + myAscent, start2, end, whitespacePaintingStrategy, fragment2, whiteSpaceStroke, whiteSpaceScale);
                        }
                    }

                    @Override
                    public void paintAfterLineEnd(IterationState it, int columnStart, float x, int y) {
                        if (dryRun) {
                            return;
                        }
                        TextAttributes backgroundAttributes = it.getPastLineEndBackgroundAttributes().clone();
                        CustomFoldRegion cfr = visLinesIterator.getCustomFoldRegion();
                        if (cfr != null) {
                            this.paintBackground(backgroundAttributes, (float)startX, y, (float)(endX - startX), cfr.getHeightInPixels());
                            myTextDrawingTasks.add(g -> cfr.getRenderer().paint(cfr, g, (Rectangle2D)new Rectangle2D.Double(x, y, cfr.getWidthInPixels(), cfr.getHeightInPixels()), backgroundAttributes));
                            return;
                        }
                        this.paintBackground(backgroundAttributes, x, y, (float)endX - x);
                        int offset = it.getEndOffset();
                        SoftWrap softWrap = myEditor.getSoftWrapModel().getSoftWrap(offset);
                        if (softWrap == null) {
                            int logicalLine = myDocument.getLineNumber(offset);
                            List<Inlay<?>> inlays = myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
                            float extensionsStartX = inlays.isEmpty() ? x : x + myView.getPlainSpaceWidth() + (float)inlays.stream().mapToInt(Inlay::getWidthInPixels).sum();
                            this.collectExtensions(visualLine, offset);
                            this.paintLineExtensionsBackground(visualLine, extensionsStartX, y);
                            this.paintVirtualSelectionIfNecessary(visualLine, columnStart, x, y);
                            myTextDrawingTasks.add(g -> {
                                if (!inlays.isEmpty()) {
                                    float curX = x + myView.getPlainSpaceWidth();
                                    for (Inlay inlay : inlays) {
                                        int width = inlay.getWidthInPixels();
                                        inlay.getRenderer().paint(inlay, g, (Rectangle2D)new Rectangle2D.Double(curX, y, width, myLineHeight), backgroundAttributes);
                                        curX += (float)width;
                                    }
                                }
                                this.paintLineExtensions(visualLine, logicalLine, extensionsStartX, y + myAscent);
                            });
                        } else {
                            this.paintSelectionOnFirstSoftWrapLineIfNecessary(visualLine, columnStart, x, y, primarySelectionStart, primarySelectionEnd);
                            if (paintSoftWraps) {
                                myTextDrawingTasks.add(g -> myEditor.getSoftWrapModel().doPaint((Graphics)g, SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, (int)x, y, myLineHeight));
                            }
                        }
                    }
                }, calculateMarginWidths && !visLinesIterator.endsWithSoftWrap() && !visLinesIterator.startsWithSoftWrap() ? width -> {
                    this.myMarginPositions.x[visualLine - this.myStartVisualLine] = width;
                } : null);
                prevY = y + visLinesIterator.getLineHeight();
                visLinesIterator.advance();
            }
            if (calculateMarginWidths && this.myEndVisualLine >= lineCount - 1) {
                this.myMarginPositions.y[this.myMarginPositions.y.length - 1] = this.myMarginPositions.y[this.myMarginPositions.y.length - 2] + this.myLineHeight;
            }
        }

        private boolean paintFoldingBackground(TextAttributes innerAttributes, float x, int y, float width, @NotNull FoldRegion foldRegion) {
            if (foldRegion == null) {
                Session.$$$reportNull$$$0(0);
            }
            if (innerAttributes.getBackgroundColor() != null && !Session.isSelected(foldRegion)) {
                Shape border;
                this.paintBackground(innerAttributes, x, y, width);
                Color borderColor = this.myEditor.getColorsScheme().getColor(EditorColors.FOLDED_TEXT_BORDER_COLOR);
                if (borderColor != null && (border = Session.getBorderShape(x, y, width, this.myLineHeight, 2, false)) != null) {
                    this.myGraphics.setColor(borderColor);
                    this.myGraphics.fill(border);
                }
                return true;
            }
            return false;
        }

        @NotNull
        private static Int2ObjectMap<IntPair> createVirtualSelectionMap(Editor editor2, int startVisualLine, int endVisualLine) {
            Int2ObjectOpenHashMap map2 = new Int2ObjectOpenHashMap();
            for (Caret caret : editor2.getCaretModel().getAllCarets()) {
                int line;
                if (!caret.hasSelection()) continue;
                VisualPosition selectionStart = caret.getSelectionStartPosition();
                VisualPosition selectionEnd = caret.getSelectionEndPosition();
                if (selectionStart.line != selectionEnd.line || (line = selectionStart.line) < startVisualLine || line > endVisualLine) continue;
                map2.put(line, (Object)new IntPair(selectionStart.column, selectionEnd.column));
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = map2;
            if (int2ObjectOpenHashMap == null) {
                Session.$$$reportNull$$$0(1);
            }
            return int2ObjectOpenHashMap;
        }

        private void paintVirtualSelectionIfNecessary(int visualLine, int columnStart, float xStart, int y) {
            IntPair selectionRange = (IntPair)this.myVirtualSelectionMap.get(visualLine);
            if (selectionRange == null || selectionRange.second <= columnStart) {
                return;
            }
            float startX = selectionRange.first <= columnStart ? xStart : (float)this.myView.visualPositionToXY(new VisualPosition(visualLine, selectionRange.first)).getX();
            float endX = (float)Math.min((double)(this.myClip.x + this.myClip.width), this.myView.visualPositionToXY(new VisualPosition(visualLine, selectionRange.second)).getX());
            this.paintBackground(this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
        }

        private void paintSelectionOnSecondSoftWrapLineIfNecessary(int visualLine, int columnEnd, float xEnd, int y, VisualPosition selectionStartPosition, VisualPosition selectionEndPosition) {
            if (selectionStartPosition.equals((Object)selectionEndPosition) || visualLine < selectionStartPosition.line || visualLine > selectionEndPosition.line || visualLine == selectionStartPosition.line && selectionStartPosition.column >= columnEnd) {
                return;
            }
            float startX = selectionStartPosition.line == visualLine && selectionStartPosition.column > 0 ? (float)this.myView.visualPositionToXY(selectionStartPosition).getX() : this.myCorrector.startX(visualLine);
            float endX = selectionEndPosition.line == visualLine && selectionEndPosition.column < columnEnd ? (float)this.myView.visualPositionToXY(selectionEndPosition).getX() : xEnd;
            this.paintBackground(this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
        }

        private void paintSelectionOnFirstSoftWrapLineIfNecessary(int visualLine, int columnStart, float xStart, int y, VisualPosition selectionStartPosition, VisualPosition selectionEndPosition) {
            if (selectionStartPosition.equals((Object)selectionEndPosition) || visualLine < selectionStartPosition.line || visualLine > selectionEndPosition.line || visualLine == selectionEndPosition.line && selectionEndPosition.column <= columnStart) {
                return;
            }
            float startX = selectionStartPosition.line == visualLine && selectionStartPosition.column > columnStart ? (float)this.myView.visualPositionToXY(selectionStartPosition).getX() : xStart;
            float endX = selectionEndPosition.line == visualLine ? (float)this.myView.visualPositionToXY(selectionEndPosition).getX() : (float)(this.myClip.x + this.myClip.width);
            this.paintBackground(this.myEditor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), startX, y, endX - startX);
        }

        private void paintBackground(TextAttributes attributes2, float x, int y, float width) {
            this.paintBackground(attributes2, x, y, width, this.myLineHeight);
        }

        private void paintBackground(TextAttributes attributes2, float x, int y, float width, int height) {
            if (attributes2 == null) {
                return;
            }
            this.paintBackground(attributes2.getBackgroundColor(), x, y, width, height);
        }

        private void paintBackground(Color color, float x, int y, float width) {
            this.paintBackground(color, x, y, width, this.myLineHeight);
        }

        private void paintBackground(Color color, float x, int y, float width, int height) {
            if (width <= 0.0f || color == null || color.equals(this.myDefaultBackgroundColor) || color.equals(this.myBackgroundColor)) {
                return;
            }
            this.myGraphics.setColor(color);
            this.myGraphics.fill(new Rectangle2D.Float(x, y, width, height));
        }

        private void paintCustomRenderers(MarkupModelEx markupModel) {
            this.myGraphics.translate(0, this.myYShift);
            markupModel.processRangeHighlightersOverlappingWith(this.myStartOffset, this.myEndOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
                CustomHighlighterRenderer customRenderer = highlighter.getCustomRenderer();
                if (customRenderer != null && this.myClipDetector.rangeCanBeVisible(highlighter.getStartOffset(), highlighter.getEndOffset())) {
                    if (customRenderer.isForeground()) {
                        this.myForegroundCustomHighlighters.add((RangeHighlighter)highlighter);
                    } else {
                        customRenderer.paint((Editor)this.myEditor, (RangeHighlighter)highlighter, (Graphics)this.myGraphics);
                    }
                }
                return true;
            }));
            this.myGraphics.translate(0, -this.myYShift);
        }

        private void paintForegroundCustomRenderers() {
            if (!this.myForegroundCustomHighlighters.isEmpty()) {
                this.myGraphics.translate(0, this.myYShift);
                for (RangeHighlighter highlighter : this.myForegroundCustomHighlighters) {
                    CustomHighlighterRenderer customRenderer = highlighter.getCustomRenderer();
                    if (customRenderer == null) continue;
                    customRenderer.paint((Editor)this.myEditor, highlighter, (Graphics)this.myGraphics);
                }
                this.myGraphics.translate(0, -this.myYShift);
            }
        }

        private void paintLineMarkersSeparators(MarkupModelEx markupModel) {
            markupModel.processRangeHighlightersOverlappingWith(this.mySeparatorHighlightersStartOffset, this.mySeparatorHighlightersEndOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
                this.paintLineMarkerSeparator((RangeHighlighter)highlighter);
                return true;
            }));
        }

        private void paintLineMarkerSeparator(RangeHighlighter marker) {
            Color separatorColor = marker.getLineSeparatorColor();
            LineSeparatorRenderer lineSeparatorRenderer = marker.getLineSeparatorRenderer();
            if (separatorColor == null && lineSeparatorRenderer == null) {
                return;
            }
            boolean isTop = marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP;
            int edgeOffset = isTop ? this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(marker.getStartOffset())) : this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(marker.getEndOffset()));
            int visualLine = this.myView.offsetToVisualLine(edgeOffset, !isTop);
            int y = (isTop ? EditorUtil.getVisualLineAreaStartY(this.myEditor, visualLine) : EditorUtil.getVisualLineAreaEndY(this.myEditor, visualLine)) - 1 + this.myYShift;
            int startX = this.myCorrector.lineSeparatorStart(this.myClip.x);
            int endX = this.myCorrector.lineSeparatorEnd(this.myClip.x + this.myClip.width);
            this.myGraphics.setColor(separatorColor);
            if (lineSeparatorRenderer != null) {
                lineSeparatorRenderer.drawLine((Graphics)this.myGraphics, startX, endX, y);
            } else {
                LinePainter2D.paint((Graphics2D)this.myGraphics, (double)startX, (double)y, (double)endX, (double)y);
            }
        }

        private void paintTextWithEffects() {
            this.myTextDrawingTasks.forEach(t -> t.accept(this.myGraphics));
            ComplexTextFragment.flushDrawingCache(this.myGraphics);
        }

        @Nullable
        private TextAttributes getInnerHighlighterAttributes(@NotNull FoldRegion region) {
            if (region == null) {
                Session.$$$reportNull$$$0(2);
            }
            if (region.areInnerHighlightersMuted()) {
                return null;
            }
            ArrayList<RangeHighlighterEx> innerHighlighters = new ArrayList<RangeHighlighterEx>();
            Session.collectVisibleInnerHighlighters(region, this.myEditorMarkup, innerHighlighters);
            Session.collectVisibleInnerHighlighters(region, this.myDocMarkup, innerHighlighters);
            if (innerHighlighters.isEmpty()) {
                return null;
            }
            innerHighlighters.sort(IterationState.createByLayerThenByAttributesComparator(this.myEditor.getColorsScheme()));
            Color fgColor = null;
            Color bgColor = null;
            Color effectColor = null;
            EffectType effectType = null;
            for (RangeHighlighter rangeHighlighter : innerHighlighters) {
                EffectType type;
                TextAttributes attrs = rangeHighlighter.getTextAttributes(this.myEditor.getColorsScheme());
                if (attrs == null) continue;
                if (fgColor == null && attrs.getForegroundColor() != null) {
                    fgColor = attrs.getForegroundColor();
                }
                if (bgColor == null && attrs.getBackgroundColor() != null) {
                    bgColor = attrs.getBackgroundColor();
                }
                if (effectColor != null || attrs.getEffectColor() == null || (type = attrs.getEffectType()) == null || type == EffectType.BOXED || type == EffectType.ROUNDED_BOX || type == EffectType.SLIGHTLY_WIDER_BOX || type == EffectType.STRIKEOUT) continue;
                effectColor = attrs.getEffectColor();
                effectType = type;
            }
            return new TextAttributes(fgColor, bgColor, effectColor, effectType, 0);
        }

        private static void collectVisibleInnerHighlighters(@NotNull FoldRegion region, @NotNull MarkupModelEx markupModel, @NotNull List<? super RangeHighlighterEx> highlighters) {
            if (region == null) {
                Session.$$$reportNull$$$0(3);
            }
            if (markupModel == null) {
                Session.$$$reportNull$$$0(4);
            }
            if (highlighters == null) {
                Session.$$$reportNull$$$0(5);
            }
            int startOffset = region.getStartOffset();
            int endOffset = region.getEndOffset();
            markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)h -> {
                if (h.isVisibleIfFolded() && h.getAffectedAreaStartOffset() >= startOffset && h.getAffectedAreaEndOffset() <= endOffset) {
                    highlighters.add((RangeHighlighterEx)h);
                }
                return true;
            }));
        }

        private float paintLineLayoutWithEffect(LineLayout layout, float x, float y, @Nullable Color color, @Nullable Color effectColor, @Nullable EffectType effectType) {
            this.paintTextEffect(x, x + layout.getWidth(), (int)y, effectColor, effectType, false);
            this.myGraphics.setColor(color);
            for (LineLayout.VisualFragment fragment2 : layout.getFragmentsInVisualOrder(x)) {
                fragment2.draw(this.myGraphics, fragment2.getStartX(), y);
                x = fragment2.getEndX();
            }
            return x;
        }

        private void paintTextEffect(float xFrom, float xTo, int y, @Nullable Color effectColor, @Nullable EffectType effectType, boolean allowBorder) {
            if (effectColor == null) {
                return;
            }
            this.myGraphics.setColor(effectColor);
            int xStart = (int)xFrom;
            int xEnd = (int)xTo;
            if (effectType == EffectType.LINE_UNDERSCORE) {
                EffectPainter.LINE_UNDERSCORE.paint(this.myGraphics, xStart, y, xEnd - xStart, this.myDescent, (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                EffectPainter.BOLD_LINE_UNDERSCORE.paint(this.myGraphics, xStart, y, xEnd - xStart, this.myDescent, (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            } else if (effectType == EffectType.STRIKEOUT) {
                EffectPainter.STRIKE_THROUGH.paint(this.myGraphics, xStart, y, xEnd - xStart, this.myView.getCharHeight(), (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                EffectPainter.WAVE_UNDERSCORE.paint(this.myGraphics, xStart, y, xEnd - xStart, this.myDescent, (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
                EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(this.myGraphics, xStart, y, xEnd - xStart, this.myDescent, (Object)this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            } else if (allowBorder && (effectType == EffectType.BOXED || effectType == EffectType.ROUNDED_BOX)) {
                this.drawSimpleBorder(xFrom, xTo, y - this.myAscent, effectType == EffectType.ROUNDED_BOX);
            }
        }

        private static int calcFeatureSize(int unscaledSize, float scale) {
            return Math.max(1, Math.round(scale * (float)unscaledSize));
        }

        private float roundToPixelCenter(double value2) {
            double devPixel = 1.0 / PaintUtil.devValue((double)1.0, (ScaleContext)this.myScaleContext);
            return (float)(PaintUtil.alignToInt((double)value2, (ScaleContext)this.myScaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null) + devPixel / 2.0);
        }

        private void paintWhitespace(float x, int y, int start2, int end, LineWhitespacePaintingStrategy whitespacePaintingStrategy, VisualLineFragmentsIterator.Fragment fragment2, BasicStroke stroke, float scale) {
            if (!whitespacePaintingStrategy.showAnyWhitespace()) {
                return;
            }
            boolean restoreStroke = false;
            Stroke defaultStroke = this.myGraphics.getStroke();
            Color color = this.myEditor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR);
            boolean isRtl = fragment2.isRtl();
            int baseStartOffset = fragment2.getStartOffset();
            int startOffset = isRtl ? baseStartOffset - start2 : baseStartOffset + start2;
            int yToUse = y - 1;
            for (int i2 = start2; i2 < end; ++i2) {
                int charOffset = isRtl ? baseStartOffset - i2 - 1 : baseStartOffset + i2;
                char c = this.myText.charAt(charOffset);
                if (EditorPainter.WHITESPACE_CHARS.indexOf(c) < 0 || !whitespacePaintingStrategy.showWhitespaceAtOffset(charOffset)) continue;
                int startX = (int)fragment2.offsetToX(x, startOffset, isRtl ? baseStartOffset - i2 : baseStartOffset + i2);
                int endX = (int)fragment2.offsetToX(x, startOffset, isRtl ? baseStartOffset - i2 - 1 : baseStartOffset + i2 + 1);
                if (c == ' ') {
                    float dotX = this.roundToPixelCenter((double)(startX + endX) / 2.0) - scale / 2.0f;
                    float dotY = this.roundToPixelCenter((double)(yToUse + 1 - this.myAscent) + (double)this.myLineHeight / 2.0) - scale / 2.0f;
                    this.myTextDrawingTasks.add(g -> CachingPainter.paint((Graphics2D)g, (float)dotX, (float)dotY, (float)scale, (float)scale, _g -> {
                        _g.setColor(color);
                        _g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        _g.fill(new Ellipse2D.Float(0.0f, 0.0f, scale, scale));
                    }, (Object)ourCachedDot, (Object[])new Object[]{color}));
                    continue;
                }
                if (c == '\t') {
                    double strokeWidth = Math.max((double)scale, PaintUtil.devPixel((Graphics2D)this.myGraphics));
                    switch ((TabCharacterPaintMode)AdvancedSettings.getEnum((String)EditorPainter.EDITOR_TAB_PAINTING, TabCharacterPaintMode.class)) {
                        case LONG_ARROW: {
                            int tabEndX = endX - (int)(this.myView.getPlainSpaceWidth() / 4.0f);
                            int height = this.myView.getCharHeight();
                            Color tabColor = color == null ? null : ColorUtil.mix((Color)this.myBackgroundColor, (Color)color, (double)0.7);
                            this.myTextDrawingTasks.add(g -> {
                                int halfHeight = height / 2;
                                int yMid = yToUse - halfHeight;
                                int yTop = yToUse - height;
                                g.setColor(tabColor);
                                LinePainter2D.paint((Graphics2D)g, (double)startX, (double)yMid, (double)tabEndX, (double)yMid, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)strokeWidth);
                                LinePainter2D.paint((Graphics2D)g, (double)tabEndX, (double)yToUse, (double)tabEndX, (double)yTop, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)strokeWidth);
                                g.fillPolygon(new int[]{tabEndX - halfHeight, tabEndX - halfHeight, tabEndX}, new int[]{yToUse, yTop, yMid}, 3);
                            });
                            break;
                        }
                        case ARROW: {
                            int tabLineHeight = Session.calcFeatureSize(4, scale);
                            int tabLineWidth = Math.min(endX - startX, Session.calcFeatureSize(3, scale));
                            int xToUse = Math.min(endX - tabLineWidth, startX + tabLineWidth);
                            this.myTextDrawingTasks.add(g -> {
                                g.setColor(color);
                                g.setStroke(stroke);
                                Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                g.drawLine(xToUse, yToUse, xToUse + tabLineWidth, yToUse - tabLineHeight);
                                g.drawLine(xToUse, yToUse - tabLineHeight * 2, xToUse + tabLineWidth, yToUse - tabLineHeight);
                                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
                            });
                            restoreStroke = true;
                            break;
                        }
                        default: {
                            int yMid = yToUse - this.myView.getCharHeight() / 2;
                            int tabEndX = Math.max(startX + 1, endX - Session.getTabGap(scale));
                            this.myTextDrawingTasks.add(g -> {
                                g.setColor(color);
                                LinePainter2D.paint((Graphics2D)g, (double)startX, (double)yMid, (double)tabEndX, (double)yMid, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)strokeWidth);
                            });
                            break;
                        }
                    }
                    continue;
                }
                if (c != '\u3000') continue;
                int charHeight = this.myView.getCharHeight();
                int strokeWidth = Math.round(stroke.getLineWidth());
                this.myTextDrawingTasks.add(g -> {
                    g.setColor(color);
                    g.setStroke(stroke);
                    g.drawRect(startX + JBUIScale.scale((int)2) + strokeWidth / 2, yToUse - charHeight + strokeWidth / 2, endX - startX - JBUIScale.scale((int)4) - (strokeWidth - 1), charHeight - (strokeWidth - 1));
                });
                restoreStroke = true;
            }
            if (restoreStroke) {
                this.myTextDrawingTasks.add(g -> g.setStroke(defaultStroke));
            }
        }

        private static int getTabGap(float scale) {
            return Session.calcFeatureSize(5, scale);
        }

        private static float getWhiteSpaceScale(@NotNull Editor editor2) {
            if (editor2 == null) {
                Session.$$$reportNull$$$0(6);
            }
            return (float)editor2.getColorsScheme().getEditorFontSize() / (float)FontPreferences.DEFAULT_FONT_SIZE;
        }

        private void collectExtensions(int visualLine, int offset) {
            this.myEditor.processLineExtensions(this.myDocument.getLineNumber(offset), (Processor<? super LineExtensionInfo>)((Processor)info2 -> {
                ArrayList<LineExtensionData> list2 = (ArrayList<LineExtensionData>)this.myExtensionData.get(visualLine);
                if (list2 == null) {
                    list2 = new ArrayList<LineExtensionData>();
                    this.myExtensionData.put(visualLine, list2);
                }
                list2.add(new LineExtensionData((LineExtensionInfo)info2, LineLayout.create(this.myView, info2.getText(), info2.getFontType())));
                return true;
            }));
        }

        private void paintLineExtensionsBackground(int visualLine, float x, int y) {
            List data2 = (List)this.myExtensionData.get(visualLine);
            if (data2 == null) {
                return;
            }
            for (LineExtensionData datum : data2) {
                float width = datum.layout.getWidth();
                this.paintBackground(datum.info.getBgColor(), x, y, width);
                x += width;
            }
        }

        private void paintLineExtensions(int visualLine, int logicalLine, float x, int y) {
            EditorSizeManager sizeManager;
            List data2 = (List)this.myExtensionData.get(visualLine);
            if (data2 == null) {
                return;
            }
            for (LineExtensionData datum : data2) {
                x = this.paintLineLayoutWithEffect(datum.layout, x, y, datum.info.getColor(), datum.info.getEffectColor(), datum.info.getEffectType());
            }
            int currentLineWidth = this.myCorrector.lineWidth(visualLine, x);
            if (currentLineWidth > (sizeManager = this.myView.getSizeManager()).getMaxLineWithExtensionWidth()) {
                sizeManager.setMaxLineWithExtensionWidth(logicalLine, currentLineWidth);
                this.myEditor.getContentComponent().revalidate();
            }
        }

        private void paintHighlightersAfterEndOfLine(MarkupModelEx markupModel) {
            markupModel.processRangeHighlightersOverlappingWith(this.myStartOffset, this.myEndOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
                if (highlighter.getStartOffset() >= this.myStartOffset) {
                    this.paintHighlighterAfterEndOfLine((RangeHighlighterEx)highlighter);
                }
                return true;
            }));
        }

        private void paintHighlighterAfterEndOfLine(RangeHighlighterEx highlighter) {
            if (!highlighter.isAfterEndOfLine()) {
                return;
            }
            int startOffset = highlighter.getStartOffset();
            int lineEndOffset = this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(startOffset));
            if (this.myEditor.getFoldingModel().isOffsetCollapsed(lineEndOffset)) {
                return;
            }
            Point2D lineEnd = this.myView.offsetToXY(lineEndOffset, true, false);
            float x = (float)lineEnd.getX();
            int y = (int)lineEnd.getY() + this.myYShift;
            TextAttributes attributes2 = highlighter.getTextAttributes(this.myEditor.getColorsScheme());
            this.paintBackground(attributes2, x, y, this.myView.getPlainSpaceWidth());
            if (attributes2 != null) {
                attributes2.forEachEffect((type, color) -> this.paintTextEffect(x, x + this.myView.getPlainSpaceWidth() - 1.0f, y + this.myAscent, (Color)color, (EffectType)type, false));
            }
        }

        private void paintBorderEffect(EditorHighlighter highlighter) {
            HighlighterIterator it = highlighter.createIterator(this.myStartOffset);
            while (!it.atEnd() && it.getStart() < this.myEndOffset) {
                TextAttributes attributes2 = it.getTextAttributes();
                TextAttributesEffectsBuilder.EffectDescriptor borderDescriptor = Session.getBorderDescriptor(attributes2);
                if (borderDescriptor != null) {
                    this.paintBorderEffect(it.getStart(), it.getEnd(), borderDescriptor);
                }
                it.advance();
            }
        }

        private void paintBorderEffect(MarkupModelEx markupModel) {
            markupModel.processRangeHighlightersOverlappingWith(this.myStartOffset, this.myEndOffset, (Processor<? super RangeHighlighterEx>)((Processor)rangeHighlighter -> {
                TextAttributes attributes2 = rangeHighlighter.getTextAttributes(this.myEditor.getColorsScheme());
                TextAttributesEffectsBuilder.EffectDescriptor borderDescriptor = Session.getBorderDescriptor(attributes2);
                if (borderDescriptor != null) {
                    this.paintBorderEffect(rangeHighlighter.getAffectedAreaStartOffset(), rangeHighlighter.getAffectedAreaEndOffset(), borderDescriptor);
                }
                return true;
            }));
        }

        @Contract(value="null -> null")
        @Nullable
        private static TextAttributesEffectsBuilder.EffectDescriptor getBorderDescriptor(@Nullable TextAttributes attributes2) {
            return attributes2 == null || !attributes2.hasEffects() ? null : TextAttributesEffectsBuilder.create((TextAttributes)attributes2).getEffectDescriptor(TextAttributesEffectsBuilder.EffectSlot.FRAME_SLOT);
        }

        private void paintBorderEffect(int startOffset, int endOffset, TextAttributesEffectsBuilder.EffectDescriptor borderDescriptor) {
            int endLine;
            startOffset = DocumentUtil.alignToCodePointBoundary(this.myDocument, startOffset);
            endOffset = DocumentUtil.alignToCodePointBoundary(this.myDocument, endOffset);
            FoldRegion foldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
            if (foldRegion != null && endOffset <= foldRegion.getEndOffset()) {
                return;
            }
            if (!this.myClipDetector.rangeCanBeVisible(startOffset, endOffset)) {
                return;
            }
            int startLine = this.myDocument.getLineNumber(startOffset);
            if (startLine + 1 == (endLine = this.myDocument.getLineNumber(endOffset)) && startOffset == this.myDocument.getLineStartOffset(startLine) && endOffset == this.myDocument.getLineStartOffset(endLine)) {
                endOffset = this.myDocument.getLineEndOffset(--endLine);
            }
            boolean rounded = borderDescriptor.effectType == EffectType.ROUNDED_BOX;
            boolean margin = borderDescriptor.effectType == EffectType.SLIGHTLY_WIDER_BOX;
            this.myGraphics.setColor(borderDescriptor.effectColor);
            int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
            int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
            if (startVisualLine == endVisualLine) {
                int y = this.myView.visualLineToY(startVisualLine) + this.myYShift;
                FloatList ranges = this.adjustedLogicalRangeToVisualRanges(startOffset, endOffset);
                for (int i2 = 0; i2 < ranges.size() - 1; i2 += 2) {
                    float startX = this.myCorrector.singleLineBorderStart(ranges.getFloat(i2));
                    if (startX - (float)margin >= this.myCorrector.startX(startVisualLine)) {
                        startX -= (float)margin;
                    }
                    float endX = this.myCorrector.singleLineBorderEnd(ranges.getFloat(i2 + 1)) + (float)margin;
                    this.drawSimpleBorder(startX, endX, y, rounded);
                }
            } else {
                FloatList leadingRanges = this.adjustedLogicalRangeToVisualRanges(startOffset, this.myView.visualPositionToOffset(new VisualPosition(startVisualLine, Integer.MAX_VALUE, true)));
                FloatList trailingRanges = this.adjustedLogicalRangeToVisualRanges(this.myView.visualPositionToOffset(new VisualPosition(endVisualLine, 0)), endOffset);
                if (!leadingRanges.isEmpty() && !trailingRanges.isEmpty()) {
                    int minX = Math.min(this.myCorrector.minX(startVisualLine, endVisualLine), (int)leadingRanges.getFloat(0));
                    int maxX = Math.max(this.myCorrector.maxX(startVisualLine, endVisualLine), (int)trailingRanges.getFloat(trailingRanges.size() - 1));
                    boolean containsInnerLines = endVisualLine > startVisualLine + 1;
                    int lineHeight = this.myLineHeight - 1;
                    int leadingTopY = this.myView.visualLineToY(startVisualLine) + this.myYShift;
                    int leadingBottomY = leadingTopY + lineHeight;
                    int trailingTopY = this.myView.visualLineToY(endVisualLine) + this.myYShift;
                    int trailingBottomY = trailingTopY + lineHeight;
                    float start2 = 0.0f;
                    float end = 0.0f;
                    float leftGap = leadingRanges.getFloat(0) - (containsInnerLines ? (float)minX : trailingRanges.getFloat(0));
                    int adjustY = leftGap == 0.0f ? 2 : (leftGap > 0.0f ? 1 : 0);
                    for (int i3 = 0; i3 < leadingRanges.size() - 1; i3 += 2) {
                        start2 = leadingRanges.getFloat(i3);
                        end = leadingRanges.getFloat(i3 + 1);
                        if (i3 > 0) {
                            this.drawLine(leadingRanges.getFloat(i3 - 1), leadingBottomY, start2, leadingBottomY, rounded);
                        }
                        this.drawLine(start2, leadingBottomY + (i3 == 0 ? adjustY : 0), start2, leadingTopY, rounded);
                        if (i3 + 2 >= leadingRanges.size()) continue;
                        this.drawLine(start2, leadingTopY, end, leadingTopY, rounded);
                        this.drawLine(end, leadingTopY, end, leadingBottomY, rounded);
                    }
                    end = Math.max(end, (float)maxX);
                    this.drawLine(start2, leadingTopY, end, leadingTopY, rounded);
                    this.drawLine(end, leadingTopY, end, trailingTopY - 1, rounded);
                    float targetX = trailingRanges.getFloat(trailingRanges.size() - 1);
                    this.drawLine(end, trailingTopY - 1, targetX, trailingTopY - 1, rounded);
                    adjustY = end == targetX ? -2 : -1;
                    for (int i4 = trailingRanges.size() - 2; i4 >= 0; i4 -= 2) {
                        start2 = trailingRanges.getFloat(i4);
                        end = trailingRanges.getFloat(i4 + 1);
                        this.drawLine(end, trailingTopY + (i4 == 0 ? adjustY : 0), end, trailingBottomY, rounded);
                        this.drawLine(end, trailingBottomY, start2, trailingBottomY, rounded);
                        this.drawLine(start2, trailingBottomY, start2, trailingTopY, rounded);
                        if (i4 <= 0) continue;
                        this.drawLine(start2, trailingTopY, trailingRanges.getFloat(i4 - 1), trailingTopY, rounded);
                    }
                    float lastX = start2;
                    if (containsInnerLines) {
                        if (start2 != (float)minX) {
                            this.drawLine(start2, trailingTopY, start2, trailingTopY - 1, rounded);
                            this.drawLine(start2, trailingTopY - 1, minX, trailingTopY - 1, rounded);
                            this.drawLine(minX, trailingTopY - 1, minX, leadingBottomY + 1, rounded);
                        } else {
                            this.drawLine(minX, trailingTopY, minX, leadingBottomY + 1, rounded);
                        }
                        lastX = minX;
                    }
                    if (lastX < (targetX = leadingRanges.getFloat(0))) {
                        this.drawLine(lastX, leadingBottomY + 1, targetX, leadingBottomY + 1, rounded);
                    } else {
                        this.drawLine(lastX, leadingBottomY + 1, lastX, leadingBottomY, rounded);
                        this.drawLine(lastX, leadingBottomY, targetX, leadingBottomY, rounded);
                    }
                }
            }
        }

        private void drawSimpleBorder(float xStart, float xEnd, float y, boolean rounded) {
            Shape border = Session.getBorderShape(xStart, y, xEnd - xStart, this.myLineHeight, 1, rounded);
            if (border != null) {
                Object old = this.myGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                this.myGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.myGraphics.fill(border);
                this.myGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
            }
        }

        private static Shape getBorderShape(float x, float y, float width, int height, int thickness, boolean rounded) {
            if (width <= 0.0f || height <= 0) {
                return null;
            }
            RectangularShape outer = rounded ? new RoundRectangle2D.Float(x, y, width, height, 2.0f, 2.0f) : new Rectangle2D.Float(x, y, width, height);
            int doubleThickness = 2 * thickness;
            if (width <= (float)doubleThickness || height <= doubleThickness) {
                return outer;
            }
            Rectangle2D.Float inner = new Rectangle2D.Float(x + (float)thickness, y + (float)thickness, width - (float)doubleThickness, height - doubleThickness);
            Path2D.Float path2 = new Path2D.Float(0);
            path2.append(outer, false);
            path2.append(inner, false);
            return path2;
        }

        private void drawLine(float x1, int y1, float x2, int y2, boolean rounded) {
            if (rounded) {
                UIUtil.drawLinePickedOut((Graphics)this.myGraphics, (int)((int)x1), (int)y1, (int)((int)x2), (int)y2);
            } else {
                LinePainter2D.paint((Graphics2D)this.myGraphics, (double)((int)x1), (double)y1, (double)((int)x2), (double)y2);
            }
        }

        private FloatList adjustedLogicalRangeToVisualRanges(int startOffset, int endOffset) {
            FloatList ranges = this.logicalRangeToVisualRanges(startOffset, endOffset);
            for (int i2 = 0; i2 < ranges.size() - 1; i2 += 2) {
                float endX;
                float startX = ranges.getFloat(i2);
                if (startX == (endX = ranges.getFloat(i2 + 1))) {
                    if (startX > 0.0f) {
                        startX -= 1.0f;
                    } else {
                        endX += 1.0f;
                    }
                } else {
                    endX -= 1.0f;
                }
                ranges.set(i2, startX);
                ranges.set(i2 + 1, endX);
            }
            return ranges;
        }

        private FloatList logicalRangeToVisualRanges(int startOffset, int endOffset) {
            assert (startOffset <= endOffset);
            FloatArrayList result2 = new FloatArrayList();
            if (this.myDocument.getTextLength() == 0) {
                int minX = this.myCorrector.emptyTextX();
                result2.add((float)minX);
                result2.add((float)minX);
            } else {
                float lastX = -1.0f;
                for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, startOffset, false, true)) {
                    float x2;
                    int minOffset = fragment2.getMinOffset();
                    int maxOffset = fragment2.getMaxOffset();
                    if (startOffset == endOffset) {
                        float x;
                        lastX = fragment2.getEndX();
                        Inlay inlay = fragment2.getCurrentInlay();
                        if (inlay != null) {
                            if (startOffset != minOffset || !inlay.isRelatedToPrecedingText()) continue;
                            x = fragment2.getStartX();
                            result2.add(x);
                            result2.add(x);
                            break;
                        }
                        if (startOffset < minOffset || startOffset >= maxOffset) continue;
                        x = fragment2.offsetToX(startOffset);
                        result2.add(x);
                        result2.add(x);
                        break;
                    }
                    if (startOffset >= maxOffset || endOffset <= minOffset) continue;
                    float x1 = minOffset == maxOffset ? fragment2.getStartX() : fragment2.offsetToX(Math.max(minOffset, startOffset));
                    float f = x2 = minOffset == maxOffset ? fragment2.getEndX() : fragment2.offsetToX(Math.min(maxOffset, endOffset));
                    if (x1 > x2) {
                        float tmp = x1;
                        x1 = x2;
                        x2 = tmp;
                    }
                    if (result2.isEmpty() || x1 > result2.getFloat(result2.size() - 1)) {
                        result2.add(x1);
                        result2.add(x2);
                        continue;
                    }
                    result2.set(result2.size() - 1, x2);
                }
                if (startOffset == endOffset && result2.isEmpty() && lastX >= 0.0f) {
                    result2.add(lastX);
                    result2.add(lastX);
                }
            }
            return result2;
        }

        private void paintComposedTextDecoration() {
            TextRange composedTextRange = this.myEditor.getComposedTextRange();
            if (composedTextRange != null) {
                Point2D p1 = this.myView.offsetToXY(Math.min(composedTextRange.getStartOffset(), this.myDocument.getTextLength()), true, false);
                Point2D p2 = this.myView.offsetToXY(Math.min(composedTextRange.getEndOffset(), this.myDocument.getTextLength()), false, true);
                int y = (int)p1.getY() + this.myAscent + 1 + this.myYShift;
                this.myGraphics.setStroke(IME_COMPOSED_TEXT_UNDERLINE_STROKE);
                this.myGraphics.setColor(this.myEditor.getColorsScheme().getDefaultForeground());
                LinePainter2D.paint((Graphics2D)this.myGraphics, (double)((int)p1.getX()), (double)y, (double)((int)p2.getX()), (double)y);
            }
        }

        private void paintBlockInlays() {
            int visualLine;
            if (!this.myEditor.getInlayModel().hasBlockElements()) {
                return;
            }
            int startX = this.myInsets.left;
            int lineCount = this.myEditor.getVisibleLineCount();
            VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, this.myStartVisualLine);
            while (!visLinesIterator.atEnd() && (visualLine = visLinesIterator.getVisualLine()) <= this.myEndVisualLine && visualLine < lineCount) {
                int y;
                int curY = y = visLinesIterator.getY() + this.myYShift;
                List<Inlay<?>> inlaysAbove = visLinesIterator.getBlockInlaysAbove();
                if (!inlaysAbove.isEmpty()) {
                    TextAttributes attributes2 = this.getInlayAttributes(visualLine);
                    for (Inlay<?> inlay : inlaysAbove) {
                        if (curY <= this.myClip.y + this.myYShift) break;
                        int height = inlay.getHeightInPixels();
                        if (height <= 0) continue;
                        int newY = curY - height;
                        inlay.getRenderer().paint(inlay, this.myGraphics, (Rectangle2D)new Rectangle2D.Double(startX, newY, inlay.getWidthInPixels(), height), attributes2);
                        curY = newY;
                    }
                }
                curY = y + this.myLineHeight;
                List<Inlay<?>> inlaysBelow = visLinesIterator.getBlockInlaysBelow();
                if (!inlaysBelow.isEmpty()) {
                    TextAttributes attributes3 = this.getInlayAttributes(visualLine + 1);
                    for (Inlay<?> inlay : inlaysBelow) {
                        if (curY >= this.myClip.y + this.myClip.height + this.myYShift) break;
                        int height = inlay.getHeightInPixels();
                        if (height <= 0) continue;
                        inlay.getRenderer().paint(inlay, this.myGraphics, (Rectangle2D)new Rectangle2D.Double(startX, curY, inlay.getWidthInPixels(), height), attributes3);
                        curY += height;
                    }
                }
                visLinesIterator.advance();
            }
        }

        private TextAttributes getInlayAttributes(int visualLine) {
            TextAttributes attributes2 = (TextAttributes)this.myBetweenLinesAttributes.get(visualLine);
            if (attributes2 != null) {
                return attributes2;
            }
            return new TextAttributes();
        }

        @NotNull
        private TextAttributes getBetweenLinesAttributes(int bottomVisualLine, final int bottomVisualLineStartOffset, PeekableIterator<? extends Caret> caretIterator) {
            boolean selection = false;
            while (caretIterator.hasNext() && ((Caret)caretIterator.peek()).getSelectionEnd() < bottomVisualLineStartOffset) {
                caretIterator.next();
            }
            if (caretIterator.hasNext()) {
                Caret caret = (Caret)caretIterator.peek();
                selection = caret.getSelectionStart() <= bottomVisualLineStartOffset && caret.getSelectionStartPosition().line < bottomVisualLine && bottomVisualLine <= caret.getSelectionEndPosition().line;
            }
            final class MyProcessor
            implements Processor<RangeHighlighterEx> {
                private int layer;
                private Color backgroundColor;

                private MyProcessor(boolean selection) {
                    this.backgroundColor = selection ? Session.this.myEditor.getSelectionModel().getTextAttributes().getBackgroundColor() : null;
                    this.layer = this.backgroundColor == null ? Integer.MIN_VALUE : 6000;
                }

                public boolean process(RangeHighlighterEx highlighterEx) {
                    int layer = highlighterEx.getLayer();
                    if (layer > this.layer && highlighterEx.getAffectedAreaStartOffset() < bottomVisualLineStartOffset && highlighterEx.getAffectedAreaEndOffset() > bottomVisualLineStartOffset - (highlighterEx.getTargetArea() == HighlighterTargetArea.EXACT_RANGE ? 0 : 1)) {
                        Color backgroundColor;
                        TextAttributes attributes2 = highlighterEx.getTextAttributes(Session.this.myEditor.getColorsScheme());
                        Color color = backgroundColor = attributes2 == null ? null : attributes2.getBackgroundColor();
                        if (backgroundColor != null) {
                            this.layer = layer;
                            this.backgroundColor = backgroundColor;
                        }
                    }
                    return true;
                }
            }
            MyProcessor processor2 = new MyProcessor(selection);
            this.myDocMarkup.processRangeHighlightersOverlappingWith(bottomVisualLineStartOffset, bottomVisualLineStartOffset, processor2);
            this.myEditorMarkup.processRangeHighlightersOverlappingWith(bottomVisualLineStartOffset, bottomVisualLineStartOffset, processor2);
            TextAttributes attributes2 = new TextAttributes();
            attributes2.setBackgroundColor(processor2.backgroundColor);
            TextAttributes textAttributes = attributes2;
            if (textAttributes == null) {
                Session.$$$reportNull$$$0(7);
            }
            return textAttributes;
        }

        private void paintCaret() {
            if (this.myEditor.isPurePaintingMode()) {
                return;
            }
            EditorImpl.CaretRectangle[] locations = this.myEditor.getCaretLocations(true);
            if (locations == null) {
                return;
            }
            Graphics2D g = IdeBackgroundUtil.getOriginalGraphics(this.myGraphics);
            int nominalLineHeight = this.myView.getNominalLineHeight();
            int topOverhang = this.myView.getTopOverhang();
            EditorSettings settings = this.myEditor.getSettings();
            Color caretColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
            if (caretColor == null) {
                caretColor = new JBColor(CARET_DARK, CARET_LIGHT);
            }
            int minX = this.myInsets.left;
            block7: for (EditorImpl.CaretRectangle location : locations) {
                float x = (float)location.myPoint.getX();
                int y = (int)location.myPoint.getY() - topOverhang + this.myYShift;
                Caret caret = location.myCaret;
                CaretVisualAttributes attr = caret == null ? CaretVisualAttributes.DEFAULT : caret.getVisualAttributes();
                g.setColor(attr.getColor() != null ? attr.getColor() : caretColor);
                boolean isRtl = location.myIsRtl;
                float width = location.myWidth;
                float startX = Math.max((float)minX, isRtl ? x - width : x);
                CaretVisualAttributes.Shape shape = attr.getShape();
                switch (shape) {
                    case DEFAULT: {
                        if (this.myEditor.isInsertMode() != settings.isBlockCursor()) {
                            int lineWidth = JBUIScale.scale((int)attr.getWidth(settings.getLineCursorWidth()));
                            if (x > (float)minX && lineWidth > 1) {
                                x -= 1.0f / JBUIScale.sysScale((Graphics2D)g);
                            }
                            this.paintCaretBar(g, caret, x, y, lineWidth, nominalLineHeight, isRtl);
                            continue block7;
                        }
                        Session.paintCaretBlock(g, startX, y, width, nominalLineHeight);
                        this.paintCaretText(g, caret, caretColor, startX, y, topOverhang, isRtl);
                        continue block7;
                    }
                    case BLOCK: {
                        Session.paintCaretBlock(g, startX, y, width, nominalLineHeight);
                        this.paintCaretText(g, caret, caretColor, startX, y, topOverhang, isRtl);
                        continue block7;
                    }
                    case BAR: {
                        if (!(attr.getThickness() > 0.0f)) continue block7;
                        int barWidth = Math.max((int)(width * attr.getThickness()), JBUIScale.scale((int)settings.getLineCursorWidth()));
                        if (!isRtl && x > (float)minX && barWidth > 1 && (float)barWidth < width / 2.0f) {
                            x -= 1.0f / JBUIScale.sysScale((Graphics2D)g);
                        }
                        this.paintCaretBar(g, caret, isRtl ? x - (float)barWidth : x, y, barWidth, nominalLineHeight, isRtl);
                        Shape savedClip = g.getClip();
                        g.setClip(new Rectangle2D.Float(isRtl ? x - (float)barWidth : x, y, barWidth, nominalLineHeight));
                        this.paintCaretText(g, caret, caretColor, startX, y, topOverhang, isRtl);
                        g.setClip(savedClip);
                        continue block7;
                    }
                    case UNDERSCORE: {
                        if (!(attr.getThickness() > 0.0f)) continue block7;
                        int underscoreHeight = Math.max((int)((float)nominalLineHeight * attr.getThickness()), 1);
                        Session.paintCaretUnderscore(g, startX, y + nominalLineHeight - underscoreHeight, width, underscoreHeight);
                        Shape oldClip = g.getClip();
                        g.setClip(new Rectangle2D.Float(startX, y + nominalLineHeight - underscoreHeight, width, underscoreHeight));
                        this.paintCaretText(g, caret, caretColor, startX, y, topOverhang, isRtl);
                        g.setClip(oldClip);
                        continue block7;
                    }
                    case BOX: {
                        Session.paintCaretBox(g, startX, y, width, nominalLineHeight);
                    }
                }
            }
        }

        private void paintCaretBar(@NotNull Graphics2D g, @Nullable Caret caret, float x, float y, float w, float h, boolean isRtl) {
            if (g == null) {
                Session.$$$reportNull$$$0(8);
            }
            g.fill(new Rectangle2D.Float(x, y, w, h));
            this.paintCaretRtlMarker(g, caret, x, y, w, isRtl);
        }

        private static void paintCaretBlock(@NotNull Graphics2D g, float x, float y, float w, float h) {
            if (g == null) {
                Session.$$$reportNull$$$0(9);
            }
            g.fill(new Rectangle2D.Float(x, y, w, h));
        }

        private static void paintCaretUnderscore(@NotNull Graphics2D g, float x, float y, float w, float h) {
            if (g == null) {
                Session.$$$reportNull$$$0(10);
            }
            g.fill(new Rectangle2D.Float(x, y, w, h));
        }

        private static void paintCaretBox(@NotNull Graphics2D g, float x, float y, float w, float h) {
            if (g == null) {
                Session.$$$reportNull$$$0(11);
            }
            if (w > 2.0f) {
                float outlineWidth = (float)PaintUtil.alignToInt((double)1.0, (Graphics2D)g);
                Area area = new Area(new Rectangle2D.Float(x, y, w, h));
                area.subtract(new Area(new Rectangle2D.Float(x + outlineWidth, y + outlineWidth, w - 2.0f * outlineWidth, h - 2.0f * outlineWidth)));
                g.fill(area);
            } else {
                Session.paintCaretBlock(g, x, y, w, h);
            }
        }

        private void paintCaretText(@NotNull Graphics2D g, @Nullable Caret caret, @NotNull Color caretColor, float x, float y, int topOverhang, boolean isRtl) {
            if (g == null) {
                Session.$$$reportNull$$$0(12);
            }
            if (caretColor == null) {
                Session.$$$reportNull$$$0(13);
            }
            if (caret != null) {
                int targetVisualColumn = caret.getVisualPosition().column - (isRtl ? 1 : 0);
                for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, caret.getVisualLineStart(), false)) {
                    if (fragment2.getCurrentInlay() != null) continue;
                    int startVisualColumn = fragment2.getStartVisualColumn();
                    int endVisualColumn = fragment2.getEndVisualColumn();
                    if (startVisualColumn > targetVisualColumn || targetVisualColumn >= endVisualColumn) continue;
                    g.setColor(ColorUtil.isDark((Color)caretColor) ? CARET_LIGHT : CARET_DARK);
                    fragment2.draw(x, y + (float)topOverhang + (float)this.myAscent, fragment2.visualColumnToOffset(targetVisualColumn - startVisualColumn), fragment2.visualColumnToOffset(targetVisualColumn + 1 - startVisualColumn)).accept(g);
                    break;
                }
                ComplexTextFragment.flushDrawingCache(g);
            }
        }

        private void paintCaretRtlMarker(@NotNull Graphics2D g, @Nullable Caret caret, float x, float y, float w, boolean isRtl) {
            if (g == null) {
                Session.$$$reportNull$$$0(14);
            }
            if (this.myDocument.getTextLength() > 0 && caret != null && !this.myView.getTextLayoutCache().getLineLayout(caret.getLogicalPosition().line).isLtr()) {
                GeneralPath triangle = new GeneralPath(1, 3);
                triangle.moveTo(isRtl ? x : x + w, y);
                triangle.lineTo(isRtl ? x - 3.0f : x + w + 3.0f, y);
                triangle.lineTo(isRtl ? x : x + w, y + 3.0f);
                triangle.closePath();
                g.fill(triangle);
            }
        }

        private void paintLineFragments(VisualLinesIterator visLineIterator, int y, LineFragmentPainter painter, MarginWidthConsumer marginWidthConsumer) {
            int endLogicalColumn;
            int visualLine = visLineIterator.getVisualLine();
            float x = this.myCorrector.startX(visualLine) + (visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f);
            int offset = visLineIterator.getVisualLineStartOffset();
            int visualLineEndOffset = visLineIterator.getVisualLineEndOffset();
            IterationState it = null;
            int prevEndOffset = -1;
            boolean firstFragment = true;
            int maxColumn = 0;
            int endLogicalLine = visLineIterator.getEndLogicalLine();
            boolean marginReached = false;
            for (VisualLineFragmentsIterator.Fragment fragment2 : VisualLineFragmentsIterator.create(this.myView, visLineIterator, null, true)) {
                FoldRegion foldRegion;
                int fragmentStartOffset;
                int start2 = fragmentStartOffset = fragment2.getStartOffset();
                int end = fragment2.getEndOffset();
                x = fragment2.getStartX();
                if (firstFragment) {
                    boolean hasSoftWrap;
                    firstFragment = false;
                    SoftWrap softWrap = this.myEditor.getSoftWrapModel().getSoftWrap(offset);
                    boolean bl = hasSoftWrap = softWrap != null;
                    if (hasSoftWrap || this.myEditor.isRightAligned()) {
                        prevEndOffset = offset;
                        it = new IterationState(this.myEditor, offset == 0 ? 0 : DocumentUtil.getPreviousCodePointOffset(this.myDocument, offset), visualLineEndOffset, this.myCaretData, false, false, false, false);
                        if (it.getEndOffset() <= offset) {
                            it.advance();
                        }
                        if ((double)x >= this.myClip.getMinX()) {
                            TextAttributes attributes2 = it.getStartOffset() == offset ? it.getBeforeLineStartBackgroundAttributes() : it.getMergedAttributes();
                            painter.paintBeforeLineStart(attributes2, hasSoftWrap, fragment2.getStartVisualColumn(), x, y);
                        }
                    }
                }
                if ((foldRegion = fragment2.getCurrentFoldRegion()) == null) {
                    if (start2 != prevEndOffset) {
                        it = new IterationState(this.myEditor, start2, fragment2.isRtl() ? offset : visualLineEndOffset, this.myCaretData, false, false, false, fragment2.isRtl());
                    }
                    prevEndOffset = end;
                    assert (it != null);
                    if (start2 == end) {
                        if (start2 == it.getEndOffset() && !it.atEnd()) {
                            it.advance();
                        }
                        TextAttributes attributes3 = it.getStartOffset() == start2 ? it.getBreakAttributes() : it.getMergedAttributes();
                        float xNew = fragment2.getEndX();
                        if ((double)xNew >= this.myClip.getMinX()) {
                            painter.paint(fragment2, 0, 0, attributes3, x, xNew, y);
                        }
                        x = xNew;
                    } else {
                        while (fragment2.isRtl() ? start2 > end : start2 < end) {
                            if (fragment2.isRtl() ? it.getEndOffset() >= start2 : it.getEndOffset() <= start2) {
                                assert (!it.atEnd());
                                it.advance();
                            }
                            TextAttributes attributes4 = it.getMergedAttributes();
                            int curEnd = fragment2.isRtl() ? Math.max(it.getEndOffset(), end) : Math.min(it.getEndOffset(), end);
                            float xNew = fragment2.offsetToX(x, start2, curEnd);
                            if ((double)xNew >= this.myClip.getMinX()) {
                                painter.paint(fragment2, fragment2.isRtl() ? fragmentStartOffset - start2 : start2 - fragmentStartOffset, fragment2.isRtl() ? fragmentStartOffset - curEnd : curEnd - fragmentStartOffset, attributes4, x, xNew, y);
                            }
                            x = xNew;
                            start2 = curEnd;
                        }
                        if (marginWidthConsumer != null && fragment2.getEndLogicalLine() == endLogicalLine && fragment2.getStartLogicalColumn() <= this.myMarginColumns && fragment2.getEndLogicalColumn() > this.myMarginColumns) {
                            marginWidthConsumer.process(fragment2.visualColumnToX(fragment2.logicalToVisualColumn(this.myMarginColumns)));
                            marginReached = true;
                        }
                    }
                } else {
                    if (foldRegion instanceof CustomFoldRegion) break;
                    float xNew = fragment2.getEndX();
                    if ((double)xNew >= this.myClip.getMinX()) {
                        painter.paint(fragment2, 0, fragment2.getVisualLength(), this.getFoldRegionAttributes(foldRegion), x, xNew, y);
                    }
                    x = xNew;
                    prevEndOffset = -1;
                    it = null;
                }
                if ((double)x > this.myClip.getMaxX()) {
                    return;
                }
                maxColumn = fragment2.getEndVisualColumn();
            }
            if (firstFragment && this.myEditor.isRightAligned()) {
                it = new IterationState(this.myEditor, offset, visualLineEndOffset, this.myCaretData, false, false, false, false);
                if (it.getEndOffset() <= offset) {
                    it.advance();
                }
                painter.paintBeforeLineStart(it.getBeforeLineStartBackgroundAttributes(), false, maxColumn, x, y);
            }
            if (it == null || it.getEndOffset() != visualLineEndOffset) {
                it = new IterationState(this.myEditor, visualLineEndOffset == offset ? visualLineEndOffset : DocumentUtil.getPreviousCodePointOffset(this.myDocument, visualLineEndOffset), visualLineEndOffset, IterationState.CaretData.copyOf(this.myCaretData, visLineIterator.isCustomFoldRegionLine() && !Registry.is((String)"highlight.caret.line.at.custom.fold")), false, false, false, false);
            }
            if (!it.atEnd()) {
                it.advance();
            }
            assert (it.atEnd());
            painter.paintAfterLineEnd(it, maxColumn, x, y);
            if (marginWidthConsumer != null && !marginReached && (visualLine == this.myEditor.getCaretModel().getVisualPosition().line || x > (float)this.myMarginColumns * this.myView.getPlainSpaceWidth()) && (endLogicalColumn = this.myView.offsetToLogicalPosition((int)visualLineEndOffset).column) <= this.myMarginColumns) {
                marginWidthConsumer.process(x + (float)(this.myMarginColumns - endLogicalColumn) * this.myView.getPlainSpaceWidth());
            }
        }

        private TextAttributes getFoldRegionAttributes(FoldRegion foldRegion) {
            TextAttributes selectionAttributes = Session.isSelected(foldRegion) ? this.myEditor.getSelectionModel().getTextAttributes() : null;
            TextAttributes defaultAttributes = this.getDefaultAttributes();
            if (this.myEditor.isInFocusMode(foldRegion)) {
                return (TextAttributes)ObjectUtils.notNull((Object)((TextAttributes)this.myEditor.getUserData(FocusModeModel.FOCUS_MODE_ATTRIBUTES)), (Object)this.getDefaultAttributes());
            }
            TextAttributes foldAttributes = this.myEditor.getFoldingModel().getPlaceholderAttributes();
            return Session.mergeAttributes(Session.mergeAttributes(selectionAttributes, foldAttributes), defaultAttributes);
        }

        private TextAttributes getDefaultAttributes() {
            TextAttributes attributes2 = this.myEditor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
            if (attributes2.getForegroundColor() == null) {
                attributes2.setForegroundColor(Color.black);
            }
            if (attributes2.getBackgroundColor() == null) {
                attributes2.setBackgroundColor(Color.white);
            }
            return attributes2;
        }

        private static boolean isSelected(FoldRegion foldRegion) {
            int regionStart = foldRegion.getStartOffset();
            int regionEnd = foldRegion.getEndOffset();
            int[] selectionStarts = foldRegion.getEditor().getSelectionModel().getBlockSelectionStarts();
            int[] selectionEnds = foldRegion.getEditor().getSelectionModel().getBlockSelectionEnds();
            for (int i2 = 0; i2 < selectionStarts.length; ++i2) {
                int start2 = selectionStarts[i2];
                int end = selectionEnds[i2];
                if (regionStart < start2 || regionEnd > end) continue;
                return true;
            }
            return false;
        }

        private static TextAttributes mergeAttributes(TextAttributes primary, TextAttributes secondary) {
            if (primary == null) {
                return secondary;
            }
            if (secondary == null) {
                return primary;
            }
            TextAttributes result2 = new TextAttributes(primary.getForegroundColor() == null ? secondary.getForegroundColor() : primary.getForegroundColor(), primary.getBackgroundColor() == null ? secondary.getBackgroundColor() : primary.getBackgroundColor(), null, null, primary.getFontType() == 0 ? secondary.getFontType() : primary.getFontType());
            return TextAttributesEffectsBuilder.create((TextAttributes)secondary).coverWith(primary).applyTo(result2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldRegion";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorPainter$Session";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "region";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markupModel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighters";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caretColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorPainter$Session";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createVirtualSelectionMap";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBetweenLinesAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paintFoldingBackground";
                    break;
                }
                case 1: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getInnerHighlighterAttributes";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectVisibleInnerHighlighters";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getWhiteSpaceScale";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "paintCaretBar";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "paintCaretBlock";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "paintCaretUnderscore";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "paintCaretBox";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "paintCaretText";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "paintCaretRtlMarker";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static interface MarginWidthConsumer {
            public void process(float var1);
        }
    }
}

