/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.TextFragment;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class SimpleTextFragment
extends TextFragment {
    private final char @NotNull [] myText;
    @NotNull
    private final Font myFont;

    SimpleTextFragment(char @NotNull [] lineChars, int start2, int end, @NotNull FontInfo fontInfo) {
        if (fontInfo == null) {
            SimpleTextFragment.$$$reportNull$$$0(0);
        }
        if (lineChars == null) {
            SimpleTextFragment.$$$reportNull$$$0(1);
        }
        super(end - start2);
        this.myText = Arrays.copyOfRange(lineChars, start2, end);
        this.myFont = fontInfo.getFont();
        float x = 0.0f;
        for (int i2 = 0; i2 < this.myText.length; ++i2) {
            this.myCharPositions[i2] = x += fontInfo.charWidth2D(this.myText[i2]);
        }
    }

    @Override
    boolean isRtl() {
        return false;
    }

    @Override
    int offsetToLogicalColumn(int offset) {
        return offset;
    }

    @Override
    public Consumer<Graphics2D> draw(float x, float y, int startColumn, int endColumn) {
        return g -> {
            g.setFont(this.myFont);
            int xAsInt = (int)x;
            int yAsInt = (int)y;
            if (x == (float)xAsInt && y == (float)yAsInt) {
                g.drawChars(this.myText, startColumn, endColumn - startColumn, xAsInt, yAsInt);
            } else {
                g.drawString(new String(this.myText, startColumn, endColumn - startColumn), x, y);
            }
        };
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.myCharPositions.length;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.myCharPositions.length;
    }

    @Override
    public int visualColumnToOffset(float startX, int column2) {
        return column2;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        float relX = x - startX;
        float prevPos = 0.0f;
        for (int i2 = 0; i2 < this.myCharPositions.length; ++i2) {
            float newPos = this.myCharPositions[i2];
            if (relX < (newPos + prevPos) / 2.0f) {
                return new int[]{i2, relX <= prevPos ? 0 : 1};
            }
            prevPos = newPos;
        }
        return new int[]{this.myCharPositions.length, relX <= this.myCharPositions[this.myCharPositions.length - 1] ? 0 : 1};
    }

    @Override
    public float visualColumnToX(float startX, int column2) {
        return startX + this.getX(column2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fontInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lineChars";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/view/SimpleTextFragment";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

