/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentCaret;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.editor.textarea.TextComponentEditorImpl;
import com.intellij.util.EventDispatcher;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextComponentCaretModel
implements CaretModel {
    private final TextComponentEditor myEditor;
    private final Caret myCaret;
    private final EventDispatcher<CaretActionListener> myCaretActionListeners;

    TextComponentCaretModel(@NotNull TextComponentEditorImpl editor2) {
        if (editor2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(0);
        }
        this.myCaretActionListeners = EventDispatcher.create(CaretActionListener.class);
        this.myEditor = editor2;
        this.myCaret = new TextComponentCaret(editor2);
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        if (!(lineShift != 0 || withSelection || blockSelection || scrollToCaret)) {
            this.moveToOffset(this.getOffset() + columnShift);
            return;
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public TextAttributes getTextAttributes() {
        return null;
    }

    public boolean supportsMultipleCarets() {
        return false;
    }

    public int getMaxCaretCount() {
        return 1;
    }

    @NotNull
    public Caret getCurrentCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            TextComponentCaretModel.$$$reportNull$$$0(3);
        }
        return caret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            TextComponentCaretModel.$$$reportNull$$$0(4);
        }
        return caret;
    }

    public int getCaretCount() {
        return 1;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List<Caret> list2 = Collections.singletonList(this.myCaret);
        if (list2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(6);
        }
        return this.myCaret.getVisualPosition().equals((Object)pos) ? this.myCaret : null;
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition pos, boolean makePrimary) {
        if (pos == null) {
            TextComponentCaretModel.$$$reportNull$$$0(8);
        }
        return null;
    }

    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            TextComponentCaretModel.$$$reportNull$$$0(9);
        }
        return false;
    }

    public void removeSecondaryCarets() {
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates) {
        if (caretStates == null) {
            TextComponentCaretModel.$$$reportNull$$$0(10);
        }
        if (caretStates.size() < 1) {
            throw new IllegalArgumentException("Empty list");
        }
        CaretState state = caretStates.get(0);
        if (state != null) {
            if (state.getCaretPosition() != null) {
                this.moveToLogicalPosition(state.getCaretPosition());
            }
            if (state.getSelectionStart() != null && state.getSelectionEnd() != null) {
                this.myEditor.getSelectionModel().setSelection(this.myEditor.logicalPositionToOffset(state.getSelectionStart()), this.myEditor.logicalPositionToOffset(state.getSelectionEnd()));
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates, boolean updateSystemSelection) {
        if (caretStates == null) {
            TextComponentCaretModel.$$$reportNull$$$0(11);
        }
        this.setCaretsAndSelections(caretStates);
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        List<CaretState> list2 = Collections.singletonList(new CaretState(this.getLogicalPosition(), this.myEditor.offsetToLogicalPosition(this.myEditor.getSelectionModel().getSelectionStart()), this.myEditor.offsetToLogicalPosition(this.myEditor.getSelectionModel().getSelectionEnd())));
        if (list2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public void runForEachCaret(@NotNull CaretAction action2) {
        if (action2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(13);
        }
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).beforeAllCaretsAction();
        action2.perform(this.myCaret);
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).afterAllCaretsAction();
    }

    public void runForEachCaret(@NotNull CaretAction action2, boolean reverseOrder) {
        if (action2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(14);
        }
        this.runForEachCaret(action2);
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(15);
        }
        if (disposable2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(16);
        }
        this.myCaretActionListeners.addListener((EventListener)listener2, disposable2);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TextComponentCaretModel.$$$reportNull$$$0(17);
        }
        runnable2.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentCaretModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStates";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentCaretModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeCaret";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCaretsAndSelections";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCaretActionListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

