/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.ProjectTopics;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalStorageSpec;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStreamProviderFactory;
import com.intellij.openapi.externalSystem.configurationStore.ModuleFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.configurationStore.ProjectFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0016R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory;", "Lcom/intellij/configurationStore/StreamProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "getFileStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "fileStorage$delegate", "Lkotlin/Lazy;", "isReimportOnMissedExternalStorageScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "moduleStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "getModuleStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "moduleStorage$delegate", "storageSpecLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "storages", "Ljava/util/HashMap;", "", "Lcom/intellij/openapi/components/Storage;", "customizeStorageSpecs", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getOrCreateStorageSpec", "fileSpec", "inProjectStateSpec", "readModuleData", "Lorg/jdom/Element;", "name", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemStreamProviderFactory
implements StreamProviderFactory {
    @NotNull
    private final Lazy moduleStorage$delegate;
    @NotNull
    private final Lazy fileStorage$delegate;
    private final AtomicBoolean isReimportOnMissedExternalStorageScheduled;
    private final ReentrantReadWriteLock storageSpecLock;
    private final HashMap<String, Storage> storages;
    private final Project project;

    @NotNull
    public final ModuleFileSystemExternalSystemStorage getModuleStorage() {
        Lazy lazy = this.moduleStorage$delegate;
        ExternalSystemStreamProviderFactory externalSystemStreamProviderFactory = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ModuleFileSystemExternalSystemStorage)lazy.getValue();
    }

    @NotNull
    public final ProjectFileSystemExternalSystemStorage getFileStorage() {
        Lazy lazy = this.fileStorage$delegate;
        ExternalSystemStreamProviderFactory externalSystemStreamProviderFactory = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ProjectFileSystemExternalSystemStorage)lazy.getValue();
    }

    @Override
    @Nullable
    public List<Storage> customizeStorageSpecs(@NotNull PersistentStateComponent<?> component2, @NotNull StateStorageManager storageManager2, @NotNull State stateSpec, @NotNull List<Storage> storages, @NotNull StateStorageOperation operation) {
        Project project;
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter(storages, (String)"storages");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        ComponentManager componentManager = storageManager2.getComponentManager();
        if (componentManager == null) {
            return null;
        }
        ComponentManager componentManager2 = componentManager;
        ComponentManager componentManager3 = componentManager2;
        if (!(componentManager3 instanceof Project)) {
            componentManager3 = null;
        }
        if ((project = (Project)componentManager3) == null) {
            ComponentManager componentManager4 = componentManager2;
            if (componentManager4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.module.Module");
            }
            Project project2 = ((Module)componentManager4).getProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"(componentManager as Module).project");
        }
        Project project3 = project;
        if (storages.size() == 1 && Intrinsics.areEqual((Object)((Storage)CollectionsKt.first(storages)).value(), (Object)"$WORKSPACE_FILE$") || !ProjectUtilCore.isExternalStorageEnabled((Project)project3)) {
            return null;
        }
        if (componentManager2 instanceof Project) {
            String fileSpec;
            Storage storage2 = (Storage)CollectionsKt.firstOrNull(storages);
            String string = fileSpec = storage2 != null ? storage2.value() : null;
            if (Intrinsics.areEqual((Object)fileSpec, (Object)"libraries") || Intrinsics.areEqual((Object)fileSpec, (Object)"artifacts")) {
                Storage externalStorageSpec = this.getOrCreateStorageSpec(fileSpec + ".xml", stateSpec);
                if (operation == StateStorageOperation.READ) {
                    return CollectionsKt.listOf((Object)externalStorageSpec);
                }
                ArrayList<Storage> result2 = new ArrayList<Storage>(storages.size() + 1);
                result2.add(externalStorageSpec);
                result2.addAll((Collection)storages);
                return result2;
            }
        }
        if (!(component2 instanceof ProjectModelElement)) {
            return null;
        }
        boolean externalStorageOnly = stateSpec.externalStorageOnly();
        if (operation == StateStorageOperation.WRITE && ((ProjectModelElement)component2).getExternalSource() == null && !externalStorageOnly) {
            return null;
        }
        Storage annotation = null;
        annotation = componentManager2 instanceof Project ? StreamProviderFactory.DefaultImpls.getOrCreateStorageSpec$default(this, storages.get(0).value(), null, 2, null) : StreamProviderFactory.DefaultImpls.getOrCreateStorageSpec$default(this, "$MODULE_FILE$", null, 2, null);
        if (externalStorageOnly) {
            return CollectionsKt.listOf((Object)annotation);
        }
        ArrayList<Storage> result3 = new ArrayList<Storage>(storages.size() + 1);
        result3.add(annotation);
        result3.addAll((Collection)storages);
        return result3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Storage getOrCreateStorageSpec(@NotNull String fileSpec, @Nullable State inProjectStateSpec) {
        Storage storage2;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageSpecLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            Storage storage3 = this.storages.get(fileSpec);
            storage2 = storage3;
        }
        finally {
            readLock.unlock();
        }
        if (storage2 == null) {
            Storage storage4;
            int n;
            int n2;
            reentrantReadWriteLock = this.storageSpecLock;
            bl = false;
            boolean bl4 = false;
            ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl5 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock2.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl6 = false;
                Storage storage5 = this.storages.computeIfAbsent(fileSpec, new java.util.function.Function(this, fileSpec, inProjectStateSpec){
                    final /* synthetic */ ExternalSystemStreamProviderFactory this$0;
                    final /* synthetic */ String $fileSpec$inlined;
                    final /* synthetic */ State $inProjectStateSpec$inlined;
                    {
                        this.this$0 = externalSystemStreamProviderFactory;
                        this.$fileSpec$inlined = string;
                        this.$inProjectStateSpec$inlined = state;
                    }

                    @NotNull
                    public final Storage apply(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new ExternalStorageSpec(this.$fileSpec$inlined, this.$inProjectStateSpec$inlined);
                    }
                });
                storage4 = storage5;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl7 = false;
                    readLock2.lock();
                }
                writeLock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)storage4, (String)"storageSpecLock.write {\n\u2026ProjectStateSpec) }\n    }");
            return storage4;
        }
        return storage2;
    }

    @Nullable
    public final Element readModuleData(@NotNull String name2) {
        Element result2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!this.getModuleStorage().getHasSomeData() && this.isReimportOnMissedExternalStorageScheduled.compareAndSet(false, true) && !this.project.isInitialized() && !ExternalSystemUtil.isNewProject(this.project)) {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(new Runnable(this){
                final /* synthetic */ ExternalSystemStreamProviderFactory this$0;

                public final void run() {
                    ExternalProjectsManager externalProjectsManager = ExternalProjectsManager.getInstance((Project)ExternalSystemStreamProviderFactory.access$getProject$p(this.this$0));
                    externalProjectsManager.runWhenInitialized(new Runnable(this, externalProjectsManager){
                        final /* synthetic */ readModuleData.1 this$0;
                        final /* synthetic */ ExternalProjectsManager $externalProjectsManager;

                        public final void run() {
                            if (!ExternalSystemUtil.isNewProject(ExternalSystemStreamProviderFactory.access$getProject$p(this.this$0.this$0))) {
                                ExternalProjectsManager externalProjectsManager = this.$externalProjectsManager;
                                Intrinsics.checkNotNullExpressionValue((Object)externalProjectsManager, (String)"externalProjectsManager");
                                externalProjectsManager.getExternalProjectsWatcher().markDirtyAllExternalProjects();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$externalProjectsManager = externalProjectsManager;
                        }
                    });
                }
                {
                    this.this$0 = externalSystemStreamProviderFactory;
                }
            });
        }
        if ((result2 = this.getModuleStorage().read(name2)) == null) {
            // empty if block
        }
        return result2;
    }

    public ExternalSystemStreamProviderFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.moduleStorage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ModuleFileSystemExternalSystemStorage>(this){
            final /* synthetic */ ExternalSystemStreamProviderFactory this$0;

            @NotNull
            public final ModuleFileSystemExternalSystemStorage invoke() {
                return new ModuleFileSystemExternalSystemStorage(ExternalSystemStreamProviderFactory.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = externalSystemStreamProviderFactory;
                super(0);
            }
        }));
        this.fileStorage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectFileSystemExternalSystemStorage>(this){
            final /* synthetic */ ExternalSystemStreamProviderFactory this$0;

            @NotNull
            public final ProjectFileSystemExternalSystemStorage invoke() {
                return new ProjectFileSystemExternalSystemStorage(ExternalSystemStreamProviderFactory.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = externalSystemStreamProviderFactory;
                super(0);
            }
        }));
        this.isReimportOnMissedExternalStorageScheduled = new AtomicBoolean(false);
        this.storageSpecLock = new ReentrantReadWriteLock();
        this.storages = new HashMap();
        this.project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                String string = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
                moduleFileSystemExternalSystemStorage.remove(string);
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules2, @NotNull Function<? super Module, String> oldNameProvider) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules2, (String)"modules");
                Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
                for (Module module : modules2) {
                    ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                    Object object = oldNameProvider.fun((Object)module);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oldNameProvider.`fun`(module)");
                    String string = (String)object;
                    String string2 = module.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"module.name");
                    moduleFileSystemExternalSystemStorage.rename(string, string2);
                }
            }
        });
    }

    @Override
    @Nullable
    public StreamProvider createProvider(@NotNull ComponentManager componentManager, @NotNull StateStorageManager storageManager2) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        return StreamProviderFactory.DefaultImpls.createProvider(this, componentManager, storageManager2);
    }

    public static final /* synthetic */ Project access$getProject$p(ExternalSystemStreamProviderFactory $this) {
        return $this.project;
    }
}

