/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskLocation
extends PsiLocation<PsiElement> {
    @NotNull
    private final ExternalTaskExecutionInfo myTaskInfo;

    public ExternalSystemTaskLocation(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ExternalTaskExecutionInfo taskInfo) {
        if (project == null) {
            ExternalSystemTaskLocation.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            ExternalSystemTaskLocation.$$$reportNull$$$0(1);
        }
        if (taskInfo == null) {
            ExternalSystemTaskLocation.$$$reportNull$$$0(2);
        }
        super(project, psiElement);
        this.myTaskInfo = taskInfo;
    }

    @NotNull
    public ExternalTaskExecutionInfo getTaskInfo() {
        ExternalTaskExecutionInfo externalTaskExecutionInfo = this.myTaskInfo;
        if (externalTaskExecutionInfo == null) {
            ExternalSystemTaskLocation.$$$reportNull$$$0(3);
        }
        return externalTaskExecutionInfo;
    }

    public static ExternalSystemTaskLocation create(@NotNull Project project, @NotNull ProjectSystemId systemId2, @Nullable String projectPath, @NotNull ExternalTaskExecutionInfo taskInfo) {
        PsiDirectory psiFile;
        VirtualFile file2;
        if (project == null) {
            ExternalSystemTaskLocation.$$$reportNull$$$0(4);
        }
        if (systemId2 == null) {
            ExternalSystemTaskLocation.$$$reportNull$$$0(5);
        }
        if (taskInfo == null) {
            ExternalSystemTaskLocation.$$$reportNull$$$0(6);
        }
        if (projectPath != null && (file2 = VfsUtil.findFileByIoFile((File)new File(projectPath), (boolean)false)) != null && (psiFile = PsiManager.getInstance((Project)project).findDirectory(file2)) != null) {
            return new ExternalSystemTaskLocation(project, (PsiElement)psiFile, taskInfo);
        }
        String name2 = systemId2.getReadableName() + projectPath + StringUtil.join((Collection)taskInfo.getSettings().getTaskNames(), (String)" ");
        psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(name2, (FileType)PlainTextFileType.INSTANCE, (CharSequence)"");
        return new ExternalSystemTaskLocation(project, (PsiElement)psiFile, taskInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

