/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.MessageCounter;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemNotificationManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemNotificationManager.class);
    @NotNull
    private static final Key<Pair<NotificationSource, ProjectSystemId>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @Nullable
    private volatile Project myProject;
    @NotNull
    private final Set<Notification> myNotifications;
    @NotNull
    private final Map<Key, Notification> myUniqueNotifications;
    @NotNull
    private final Set<ProjectSystemId> initializedExternalSystem;
    @NotNull
    private final MessageCounter myMessageCounter;

    public ExternalSystemNotificationManager(@NotNull Project project) {
        if (project == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myNotifications = ContainerUtil.newConcurrentSet();
        this.myUniqueNotifications = new ConcurrentHashMap<Key, Notification>();
        this.initializedExternalSystem = ContainerUtil.newConcurrentSet();
        this.myMessageCounter = new MessageCounter();
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass() + " updates", 500, true, null, (Disposable)this, null, false);
    }

    @NotNull
    public static ExternalSystemNotificationManager getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(1);
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = (ExternalSystemNotificationManager)project.getService(ExternalSystemNotificationManager.class);
        if (externalSystemNotificationManager == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(2);
        }
        return externalSystemNotificationManager;
    }

    @Nullable
    public NotificationData createNotification(@NotNull @NlsContexts.NotificationTitle String title2, @NotNull Throwable error, @NotNull ProjectSystemId externalSystemId2, @NotNull Project project, @NotNull DataContext dataContext) {
        if (title2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(3);
        }
        if (error == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(4);
        }
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(7);
        }
        if (ExternalSystemNotificationManager.isInternalError(error, externalSystemId2)) {
            return null;
        }
        String message2 = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
        NotificationCategory notificationCategory = NotificationCategory.ERROR;
        String filePath = null;
        Integer line = null;
        Integer column2 = null;
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof LocationAwareExternalSystemException) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = (LocationAwareExternalSystemException)unwrapped;
            filePath = locationAwareExternalSystemException.getFilePath();
            line = locationAwareExternalSystemException.getLine();
            column2 = locationAwareExternalSystemException.getColumn();
        }
        NotificationData notificationData = new NotificationData(title2, message2, notificationCategory, NotificationSource.PROJECT_SYNC, filePath, (Integer)ObjectUtils.notNull((Object)line, (Object)-1), (Integer)ObjectUtils.notNull((Object)column2, (Object)-1), false);
        if (unwrapped instanceof BuildIssueException) {
            BuildIssue buildIssue = ((BuildIssueException)((Object)unwrapped)).getBuildIssue();
            for (BuildIssueQuickFix quickFix : buildIssue.getQuickFixes()) {
                notificationData.setListener(quickFix.getId(), (notification, event) -> quickFix.runQuickFix(project, dataContext));
            }
            notificationData.setNavigatable(buildIssue.getNavigatable(project));
            return notificationData;
        }
        for (ExternalSystemNotificationExtension extension2 : (ExternalSystemNotificationExtension[])ExternalSystemNotificationExtension.EP_NAME.getExtensions()) {
            ProjectSystemId targetExternalSystemId = extension2.getTargetExternalSystemId();
            if (!externalSystemId2.equals((Object)targetExternalSystemId) && !targetExternalSystemId.equals((Object)ProjectSystemId.IDE)) continue;
            extension2.customize(notificationData, project, error);
        }
        return notificationData;
    }

    private static boolean isInternalError(@NotNull Throwable error, @NotNull ProjectSystemId externalSystemId2) {
        if (error == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(8);
        }
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(9);
        }
        if (RemoteUtil.unwrap((Throwable)error) instanceof BuildIssueException) {
            return false;
        }
        return ExternalSystemNotificationExtension.EP_NAME.extensions().anyMatch(extension2 -> externalSystemId2.equals((Object)extension2.getTargetExternalSystemId()) && extension2.isInternalError(error));
    }

    public boolean isNotificationActive(@NotNull Key<String> notificationKey) {
        Notification notification;
        if (notificationKey == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(10);
        }
        return (notification = this.myUniqueNotifications.get(notificationKey)) != null && !notification.isExpired();
    }

    public void showNotification(@NotNull ProjectSystemId externalSystemId2, @NotNull NotificationData notificationData) {
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(11);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(12);
        }
        this.showNotification(externalSystemId2, notificationData, null);
    }

    public void showNotification(final @NotNull ProjectSystemId externalSystemId2, final @NotNull NotificationData notificationData, final @Nullable Key<String> notificationKey) {
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(13);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(14);
        }
        Disposer.register((Disposable)this, (Disposable)notificationData);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (notificationData.getNotificationCategory() == NotificationCategory.INFO) {
                LOG.debug(notificationData.getMessage());
            } else {
                LOG.warn(notificationData.getMessage());
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PrintStream out = notificationData.getNotificationCategory() == NotificationCategory.INFO ? System.out : System.err;
            out.println(notificationData.getMessage());
            return;
        }
        if (notificationKey != null && this.isNotificationActive(notificationKey)) {
            return;
        }
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project = ExternalSystemNotificationManager.this.myProject;
                Application app2 = ApplicationManager.getApplication();
                Runnable action2 = () -> {
                    NotificationGroup group2;
                    if (!ExternalSystemNotificationManager.this.initializedExternalSystem.contains(externalSystemId2)) {
                        app2.runWriteAction(() -> {
                            if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                                return;
                            }
                            ExternalSystemUtil.ensureToolWindowContentInitialized(project, externalSystemId2);
                            ExternalSystemNotificationManager.this.initializedExternalSystem.add(externalSystemId2);
                        });
                    }
                    if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                        return;
                    }
                    if (notificationData.getBalloonGroup() == null) {
                        ExternalProjectsView externalProjectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(externalSystemId2);
                        group2 = externalProjectsView instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null;
                    } else {
                        NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup());
                        NotificationGroup notificationGroup = group2 = registeredGroup != null ? registeredGroup : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup());
                    }
                    if (group2 == null) {
                        return;
                    }
                    Notification notification = group2.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType()).setListener(notificationData.getListener());
                    if (notificationKey == null) {
                        ExternalSystemNotificationManager.this.myNotifications.add(notification);
                    } else {
                        Notification oldNotification = ExternalSystemNotificationManager.this.myUniqueNotifications.put(notificationKey, notification);
                        if (oldNotification != null) {
                            oldNotification.expire();
                        }
                    }
                    if (notificationData.isBalloonNotification()) {
                        ExternalSystemNotificationManager.this.applyNotification(notification);
                    } else {
                        ExternalSystemNotificationManager.this.addMessage(notification, externalSystemId2, notificationData);
                    }
                };
                app2.invokeLater(action2, ModalityState.defaultModalityState(), project.getDisposed());
            }
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void clearNotifications(final @Nullable String groupName, @NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId2) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(15);
        }
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(16);
        }
        this.myMessageCounter.remove(groupName, notificationSource, externalSystemId2);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId2);
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project = ExternalSystemNotificationManager.this.myProject;
                Iterator<Notification> iterator2 = ExternalSystemNotificationManager.this.myNotifications.iterator();
                while (iterator2.hasNext()) {
                    Notification notification = iterator2.next();
                    if (groupName != null && !groupName.equals(notification.getGroupId())) continue;
                    notification.expire();
                    iterator2.remove();
                }
                SmartList toRemove2 = new SmartList();
                ExternalSystemNotificationManager.this.myUniqueNotifications.forEach((arg_0, arg_1) -> 2.lambda$run$0(groupName, (List)toRemove2, arg_0, arg_1));
                toRemove2.forEach(ExternalSystemNotificationManager.this.myUniqueNotifications::remove);
                ToolWindow toolWindow2 = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages");
                if (toolWindow2 == null) {
                    return;
                }
                MessageView messageView = (MessageView)project.getService(MessageView.class);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    for (Content content2 : messageView.getContentManager().getContents()) {
                        if (content2.isPinned() || !contentIdPair.equals(content2.getUserData(CONTENT_ID_KEY))) continue;
                        if (groupName == null) {
                            messageView.getContentManager().removeContent(content2, true);
                            continue;
                        }
                        assert (content2.getComponent() instanceof NewEditableErrorTreeViewPanel);
                        NewEditableErrorTreeViewPanel errorTreeView = (NewEditableErrorTreeViewPanel)content2.getComponent();
                        ErrorViewStructure errorViewStructure = errorTreeView.getErrorViewStructure();
                        errorViewStructure.removeGroup(groupName);
                    }
                });
            }

            private static /* synthetic */ void lambda$run$0(String groupName2, List toRemove2, Key key, Notification notification) {
                if (groupName2 == null || groupName2.equals(notification.getGroupId())) {
                    notification.expire();
                    toRemove2.add(key);
                }
            }
        });
    }

    private void addMessage(@NotNull Notification notification, @NotNull ProjectSystemId externalSystemId2, @NotNull NotificationData notificationData) {
        int guiColumn;
        if (notification == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(17);
        }
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(18);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(19);
        }
        VirtualFile virtualFile2 = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        String groupName = virtualFile2 != null ? virtualFile2.getPresentableUrl() : notificationData.getTitle();
        this.myMessageCounter.increment(groupName, notificationData.getNotificationSource(), notificationData.getNotificationCategory(), externalSystemId2);
        int line = notificationData.getLine() - 1;
        int column2 = notificationData.getColumn() - 1;
        if (virtualFile2 == null) {
            column2 = -1;
            line = -1;
        }
        int guiLine = line < 0 ? -1 : line + 1;
        int n = guiColumn = column2 < 0 ? 0 : column2 + 1;
        if (this.isDisposedOrNotOpen()) {
            return;
        }
        assert (this.myProject != null);
        Project project = this.myProject;
        Navigatable navigatable2 = notificationData.getNavigatable() != null ? notificationData.getNavigatable() : (virtualFile2 != null ? new OpenFileDescriptor(project, virtualFile2, line, column2) : NonNavigatable.INSTANCE);
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)notificationData.getNotificationCategory().getMessageCategory());
        String[] message2 = notificationData.getMessage().split("\n");
        String exportPrefix = NewErrorTreeViewPanel.createExportPrefix(guiLine);
        String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix(guiLine, guiColumn);
        UIUtil.invokeLaterIfNeeded(() -> {
            boolean activate2 = notificationData.getNotificationCategory() == NotificationCategory.ERROR || notificationData.getNotificationCategory() == NotificationCategory.WARNING;
            NewErrorTreeViewPanel errorTreeView = this.prepareMessagesView(externalSystemId2, notificationData.getNotificationSource(), activate2);
            GroupingElement groupingElement = errorTreeView.getErrorViewStructure().getGroupingElement(groupName, null, virtualFile2);
            NotificationMessageElement navigatableMessageElement = notificationData.hasLinks() && !ScreenReader.isActive() ? new EditableNotificationMessageElement(notification, kind, groupingElement, message2, navigatable2, exportPrefix, rendererPrefix) : new NotificationMessageElement(kind, groupingElement, message2, navigatable2, exportPrefix, rendererPrefix);
            errorTreeView.getErrorViewStructure().addNavigatableMessage(groupName, navigatableMessageElement);
            errorTreeView.updateTree();
        });
    }

    private void applyNotification(@NotNull Notification notification) {
        if (notification == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(20);
        }
        if (!this.isDisposedOrNotOpen()) {
            notification.notify(this.myProject);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    @NotNull
    public NewErrorTreeViewPanel prepareMessagesView(@NotNull ProjectSystemId externalSystemId2, @NotNull NotificationSource notificationSource, boolean activateView) {
        NewEditableErrorTreeViewPanel errorTreeView;
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(21);
        }
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String contentDisplayName = ExternalSystemNotificationManager.getContentDisplayName(notificationSource, externalSystemId2);
        Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId2);
        Content targetContent = this.findContent((Pair<NotificationSource, ProjectSystemId>)contentIdPair, contentDisplayName);
        assert (this.myProject != null);
        MessageView messageView = (MessageView)this.myProject.getService(MessageView.class);
        if (targetContent == null || !contentIdPair.equals(targetContent.getUserData(CONTENT_ID_KEY))) {
            errorTreeView = new NewEditableErrorTreeViewPanel(this.myProject, null, true, true, null);
            targetContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, contentDisplayName, true);
            targetContent.putUserData(CONTENT_ID_KEY, (Object)contentIdPair);
            messageView.getContentManager().addContent(targetContent);
            Disposer.register((Disposable)targetContent, (Disposable)errorTreeView);
        } else {
            assert (targetContent.getComponent() instanceof NewEditableErrorTreeViewPanel);
            errorTreeView = (NewEditableErrorTreeViewPanel)targetContent.getComponent();
        }
        messageView.getContentManager().setSelectedContent(targetContent);
        ToolWindow tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages");
        if (activateView && tw != null && !tw.isActive()) {
            tw.activate(null, false);
        }
        NewEditableErrorTreeViewPanel newEditableErrorTreeViewPanel = errorTreeView;
        if (newEditableErrorTreeViewPanel == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(23);
        }
        return newEditableErrorTreeViewPanel;
    }

    @Nullable
    private Content findContent(@NotNull Pair<NotificationSource, ProjectSystemId> contentIdPair, @NotNull String contentDisplayName) {
        if (contentIdPair == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(24);
        }
        if (contentDisplayName == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(25);
        }
        Content targetContent = null;
        assert (this.myProject != null);
        MessageView messageView = (MessageView)this.myProject.getService(MessageView.class);
        for (Content content2 : messageView.getContentManager().getContents()) {
            if (!contentIdPair.equals(content2.getUserData(CONTENT_ID_KEY)) || !StringUtil.equals((CharSequence)content2.getDisplayName(), (CharSequence)contentDisplayName) || content2.isPinned()) continue;
            targetContent = content2;
        }
        return targetContent;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    @NotNull
    @Nls
    public static String getContentDisplayName(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId2) {
        String contentDisplayName;
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(26);
        }
        if (externalSystemId2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(27);
        }
        switch (notificationSource) {
            case PROJECT_SYNC: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.project.sync.tab.name", (Object[])new Object[]{externalSystemId2.getReadableName()});
                break;
            }
            case TASK_EXECUTION: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.task.execution.tab.name", (Object[])new Object[]{externalSystemId2.getReadableName()});
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported notification source found: " + notificationSource));
            }
        }
        String string = contentDisplayName;
        if (string == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(28);
        }
        return string;
    }

    public void dispose() {
        this.myProject = null;
        this.myNotifications.clear();
        this.myUniqueNotifications.clear();
        this.initializedExternalSystem.clear();
    }

    private boolean isDisposedOrNotOpen() {
        return this.myProject == null || this.myProject.isDisposed() || !this.myProject.isOpen();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 23: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 23: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationKey";
                break;
            }
            case 12: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 15: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSource";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentIdPair";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMessagesView";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 23: 
            case 28: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInternalError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationActive";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearNotifications";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyNotification";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareMessagesView";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findContent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getContentDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 23: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

