/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseHandler;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class FileDocumentManagerImpl
extends FileDocumentManagerBase
implements SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance(FileDocumentManagerImpl.class);
    public static final Key<Object> NOT_RELOADABLE_DOCUMENT_KEY = new Key("NOT_RELOADABLE_DOCUMENT_KEY");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create((String)"Must recompute file type");
    private final Set<Document> myUnsavedDocuments = ContainerUtil.newConcurrentSet();
    private final FileDocumentManagerListener myMultiCaster;
    private final TrailingSpacesStripper myTrailingSpacesStripper = new TrailingSpacesStripper();
    private boolean myOnClose;
    private volatile MemoryDiskConflictResolver myConflictResolver = new MemoryDiskConflictResolver();
    private final PrioritizedDocumentListener myPhysicalDocumentChangeTracker = new PrioritizedDocumentListener(){

        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Runnable currentCommand;
            Project project;
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            Document document = e.getDocument();
            if (!ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.ExternalDocumentChange.class)) {
                FileDocumentManagerImpl.this.myUnsavedDocuments.add(document);
            }
            Project project2 = project = (currentCommand = CommandProcessor.getInstance().getCurrentCommand()) == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
            if (project == null) {
                project = ProjectUtil.guessProjectForFile((VirtualFile)FileDocumentManagerImpl.this.getFile(document));
            }
            String lineSeparator = CodeStyle.getProjectOrDefaultSettings((Project)project).getLineSeparator();
            document.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
            if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                FileDocumentManagerImpl.this.saveAllDocumentsLater();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$1", "documentChanged"));
        }
    };
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean ourConflictsSolverEnabled = true;

    public FileDocumentManagerImpl() {
        InvocationHandler handler2 = (__, method2, args) -> {
            if (method2.getDeclaringClass() != FileDocumentManagerListener.class) {
                throw new UnsupportedOperationException(method2.toString());
            }
            this.multiCast(method2, args);
            return null;
        };
        ClassLoader loader = FileDocumentManagerListener.class.getClassLoader();
        this.myMultiCaster = (FileDocumentManagerListener)Proxy.newProxyInstance(loader, new Class[]{FileDocumentManagerListener.class}, handler2);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                DocumentImpl.processQueue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$2", "pluginUnloaded"));
            }
        });
    }

    private static void unwrapAndRethrow(@NotNull Exception e) {
        if (e == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        Exception unwrapped = e;
        if (e instanceof InvocationTargetException) {
            unwrapped = e.getCause() == null ? e : e.getCause();
        }
        ExceptionUtil.rethrowUnchecked((Throwable)unwrapped);
        LOG.error((Throwable)unwrapped);
    }

    private void multiCast(@NotNull Method method2, Object[] args) {
        if (method2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        try {
            method2.invoke(ApplicationManager.getApplication().getMessageBus().syncPublisher(AppTopics.FILE_DOCUMENT_SYNC), args);
        }
        catch (ClassCastException e) {
            LOG.error("Arguments: " + Arrays.toString(args), (Throwable)e);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
        for (FileDocumentManagerListener listener2 : FileDocumentManagerImpl.getListeners()) {
            try {
                method2.invoke((Object)listener2, args);
            }
            catch (Exception e) {
                FileDocumentManagerImpl.unwrapAndRethrow(e);
            }
        }
        try {
            method2.invoke((Object)this.myTrailingSpacesStripper, args);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
    }

    public static boolean areTooManyDocumentsInTheQueue(@NotNull Collection<? extends Document> documents) {
        if (documents == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document : documents) {
            if ((totalSize += document.getTextLength()) <= FileUtilRt.LARGE_FOR_CONTENT_LOADING) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected Document createDocument(@NotNull CharSequence text2, @NotNull VirtualFile file2) {
        if (text2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(4);
        }
        boolean acceptSlashR = file2 instanceof LightVirtualFile && StringUtil.indexOf((CharSequence)text2, (char)'\r') >= 0;
        boolean freeThreaded = Boolean.TRUE.equals(file2.getUserData(AbstractFileViewProvider.FREE_THREADED));
        DocumentImpl document = (DocumentImpl)((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(text2, acceptSlashR, freeThreaded);
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)file2);
        int tabSize = project == null ? CodeStyle.getDefaultSettings().getTabSize(file2.getFileType()) : CodeStyle.getFacade((Project)project, (Document)document, (FileType)file2.getFileType()).getTabSize();
        document.documentCreatedFrom(file2, tabSize);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(5);
        }
        return documentImpl;
    }

    @TestOnly
    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myUnsavedDocuments.clear();
            this.myMultiCaster.unsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Document[] unsavedDocuments;
            for (Document document : unsavedDocuments = this.getUnsavedDocuments()) {
                Project project;
                VirtualFile file2 = this.getFile(document);
                if (file2 == null || (project = ProjectUtil.guessProjectForFile((VirtualFile)file2)) == null || PsiDocumentManager.getInstance((Project)project).isDocumentBlockedByPsi(document)) continue;
                this.saveDocument(document);
            }
        });
    }

    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        this.saveDocuments(null, isExplicit);
    }

    public void saveDocuments(@NotNull Predicate<? super Document> filter) {
        if (filter == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        this.saveDocuments(filter, true);
    }

    private void saveDocuments(@Nullable Predicate<? super Document> filter, boolean isExplicit) {
        int count;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myMultiCaster.beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            for (Document document : this.myUnsavedDocuments) {
                if (filter != null && !filter.test((Document)document) || failedToSave.containsKey(document) || vetoed.contains(document)) continue;
                try {
                    this.doSaveDocument(document, isExplicit);
                }
                catch (IOException e) {
                    failedToSave.put(document, e);
                }
                catch (SaveVetoException e) {
                    vetoed.add(document);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        this.saveDocument(document, true);
    }

    public void saveDocument(@NotNull Document document, boolean explicit) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (!this.myUnsavedDocuments.contains(document)) {
            return;
        }
        try {
            this.doSaveDocument(document, explicit);
        }
        catch (IOException e) {
            this.handleErrorsOnSave(Collections.singletonMap(document, e));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(9);
        }
        VirtualFile file2 = this.getFile(document);
        boolean spaceStrippingEnabled = true;
        if (file2 != null) {
            spaceStrippingEnabled = TrailingSpacesStripper.isEnabled(file2);
            TrailingSpacesStripper.setEnabled(file2, false);
        }
        try {
            this.saveDocument(document);
        }
        finally {
            if (file2 != null) {
                TrailingSpacesStripper.setEnabled(file2, spaceStrippingEnabled);
            }
        }
    }

    private void doSaveDocument(@NotNull Document document, boolean isExplicit) throws IOException, SaveVetoException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(10);
        }
        VirtualFile file2 = this.getFile(document);
        if (LOG.isTraceEnabled()) {
            LOG.trace("saving: " + file2);
        }
        if (file2 == null || file2 instanceof LightVirtualFile || file2.isValid() && !this.isFileModified(file2)) {
            this.removeFromUnsaved(document);
            return;
        }
        if (file2.isValid() && FileDocumentManagerImpl.needsRefresh(file2)) {
            LOG.trace("  refreshing...");
            file2.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document)) {
                return;
            }
        }
        if (!this.maySaveDocument(file2, document, isExplicit)) {
            throw new SaveVetoException();
        }
        LOG.trace("  writing...");
        WriteAction.run(() -> this.doSaveDocumentInWriteAction(document, file2));
        LOG.trace("  done");
    }

    private boolean maySaveDocument(@NotNull VirtualFile file2, @NotNull Document document, boolean isExplicit) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(11);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        return !this.myConflictResolver.hasConflict(file2) && FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList().stream().allMatch(vetoer -> vetoer.maySaveDocument(document, isExplicit));
    }

    private void doSaveDocumentInWriteAction(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(14);
        }
        if (!file2.isValid()) {
            this.removeFromUnsaved(document);
            return;
        }
        if (!file2.equals(this.getFile(document))) {
            FileDocumentManagerImpl.registerDocument(document, file2);
        }
        boolean saveNeeded = false;
        Exception ioException = null;
        try {
            saveNeeded = FileDocumentManagerImpl.isSaveNeeded(document, file2);
        }
        catch (IOException | RuntimeException e) {
            ioException = e;
        }
        if (!saveNeeded) {
            if (document instanceof DocumentEx) {
                ((DocumentEx)document).setModificationStamp(file2.getModificationStamp());
            }
            this.removeFromUnsaved(document);
            FileDocumentManagerImpl.updateModifiedProperty(file2);
            if (ioException instanceof IOException) {
                throw (IOException)ioException;
            }
            if (ioException != null) {
                throw (RuntimeException)ioException;
            }
            return;
        }
        PomModelImpl.guardPsiModificationsIn(() -> {
            this.myMultiCaster.beforeDocumentSaving(document);
            LOG.assertTrue(file2.isValid());
            String text2 = document.getText();
            String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document, file2);
            if (!lineSeparator.equals("\n")) {
                text2 = StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
            }
            Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
            LoadTextUtil.write(project, file2, (Object)this, text2, document.getModificationStamp());
            this.myUnsavedDocuments.remove(document);
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
            this.myTrailingSpacesStripper.clearLineModificationFlags(document);
        });
    }

    private static void updateModifiedProperty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(15);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            for (FileEditor editor2 : fileEditorManager.getAllEditors(file2)) {
                if (!(editor2 instanceof TextEditorImpl)) continue;
                ((TextEditorImpl)editor2).updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(16);
        }
        this.myUnsavedDocuments.remove(document);
        this.myMultiCaster.unsavedDocumentDropped(document);
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
    }

    private static boolean isSaveNeeded(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(18);
        }
        if (file2.getFileType().isBinary() || document.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file2.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, file2, false, false);
        return !Comparing.equal((CharSequence)document.getCharsSequence(), (CharSequence)loaded);
    }

    private static boolean needsRefresh(@NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(19);
        }
        return (fs = file2.getFileSystem()) instanceof NewVirtualFileSystem && file2.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file2);
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document, @NotNull VirtualFile file2) {
        String lineSeparator;
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(21);
        }
        if ((lineSeparator = file2.getDetectedLineSeparator()) == null) {
            lineSeparator = (String)document.getUserData(LINE_SEPARATOR_KEY);
            assert (lineSeparator != null) : document;
        }
        String string = lineSeparator;
        if (string == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file2, @Nullable Project project) {
        String lineSeparator;
        String string = lineSeparator = file2 == null ? null : file2.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = CodeStyle.getProjectOrDefaultSettings((Project)project).getLineSeparator();
        }
        String string2 = lineSeparator;
        if (string2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(23);
        }
        return string2;
    }

    public boolean requestWriting(@NotNull Document document, Project project) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(24);
        }
        return this.requestWritingStatus(document, project).hasWriteAccess();
    }

    @NotNull
    public FileDocumentManager.WriteAccessStatus requestWritingStatus(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(25);
        }
        VirtualFile file2 = FileDocumentManagerImpl.getInstance().getFile(document);
        if (project != null && file2 != null && file2.isValid()) {
            if (file2.getFileType().isBinary()) {
                FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
                if (writeAccessStatus == null) {
                    FileDocumentManagerImpl.$$$reportNull$$$0(26);
                }
                return writeAccessStatus;
            }
            ReadonlyStatusHandler.OperationStatus writableStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(file2));
            if (writableStatus.hasReadonlyFiles()) {
                return new FileDocumentManager.WriteAccessStatus(writableStatus.getReadonlyFilesMessage());
            }
            assert (file2.isWritable()) : file2;
        }
        if (document.isWritable()) {
            FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.WRITABLE;
            if (writeAccessStatus == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(27);
            }
            return writeAccessStatus;
        }
        document.fireReadOnlyModificationAttempt();
        FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
        if (writeAccessStatus == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(28);
        }
        return writeAccessStatus;
    }

    public void reloadFiles(VirtualFile ... files2) {
        if (files2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(29);
        }
        for (VirtualFile file2 : files2) {
            Document doc;
            if (!file2.exists() || (doc = this.getCachedDocument(file2)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    public Document @NotNull [] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(30);
            }
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list2 = new ArrayList<Document>(this.myUnsavedDocuments);
        Document[] documentArray = list2.toArray(Document.EMPTY_ARRAY);
        if (documentArray == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(31);
        }
        return documentArray;
    }

    public boolean processUnsavedDocuments(Processor<? super Document> processor2) {
        for (Document doc : this.myUnsavedDocuments) {
            if (processor2.process((Object)doc)) continue;
            return false;
        }
        return true;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(32);
        }
        return this.myUnsavedDocuments.contains(document);
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        ModelBranch branch;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(33);
        }
        if ((branch = ModelBranch.getFileBranch((VirtualFile)file2)) != null && ((ModelBranchImpl)branch).hasModifications(file2)) {
            return true;
        }
        Document doc = this.getCachedDocument(file2);
        return doc != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file2.getModificationStamp();
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(34);
        }
        if ("writable".equals(event.getPropertyName())) {
            VirtualFile file2 = event.getFile();
            Document document = this.getCachedDocument(file2);
            if (document != null) {
                ApplicationManager.getApplication().runWriteAction(() -> document.setReadOnly(!file2.isWritable()));
            }
        } else if ("name".equals(event.getPropertyName())) {
            VirtualFile file3 = event.getFile();
            Document document = this.getCachedDocument(file3);
            if (document == null) {
                return;
            }
            if (FileDocumentManagerImpl.isBinaryWithoutDecompiler(file3)) {
                this.unbindFileFromDocument(file3, document);
                FileDocumentManagerImpl.closeAllEditorsFor(file3);
                this.myMultiCaster.afterDocumentUnbound(file3, document);
            } else if ("FileContentUtilCore.saveOrReload".equals(event.getRequestor()) && FileDocumentManagerImpl.isBinaryWithDecompiler(file3)) {
                this.reloadFromDisk(document);
            }
        }
    }

    private static void closeAllEditorsFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(35);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager.getInstance((Project)project).closeFile(file2);
        }
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(36);
        }
        return (type = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(type) != null;
    }

    public void contentsChanged(@NotNull VFileContentChangeEvent event) {
        VirtualFile virtualFile2;
        Document document;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(37);
        }
        boolean shouldTraceEvent = (document = this.getCachedDocument(virtualFile2 = event.getFile())) != null && LOG.isTraceEnabled();
        String eventMessage = null;
        if (shouldTraceEvent) {
            eventMessage = "content changed for " + event.getFile() + " with document stamp =  " + document.getModificationStamp();
        }
        if (event.isFromSave()) {
            if (shouldTraceEvent) {
                eventMessage = eventMessage + " , dispatched from save";
                LOG.trace(eventMessage);
            }
            return;
        }
        if (document == null || FileDocumentManagerImpl.isBinaryWithDecompiler(virtualFile2)) {
            this.myMultiCaster.fileWithNoDocumentChanged(virtualFile2);
        }
        if (document != null) {
            if (shouldTraceEvent) {
                eventMessage = eventMessage + " event old modification stamp = " + event.getOldModificationStamp() + ", is unsaved = " + this.isDocumentUnsaved(document);
                LOG.trace(eventMessage);
            }
            if (document.getModificationStamp() == event.getOldModificationStamp() || !this.isDocumentUnsaved(document)) {
                this.reloadFromDisk(document);
            }
        }
    }

    public void reloadFromDisk(final @NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(38);
        }
        try (AccessToken ignored = ClientId.withClientId((ClientId)ClientId.getLocalId());){
            ApplicationManager.getApplication().assertIsDispatchThread();
            final VirtualFile file2 = this.getFile(document);
            assert (file2 != null);
            if (!file2.isValid()) {
                return;
            }
            if (!this.fireBeforeFileContentReload(file2, document)) {
                return;
            }
            final Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
            final boolean[] isReloadable = new boolean[]{FileDocumentManagerImpl.isReloadable(file2, document, project)};
            if (isReloadable[0]) {
                CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction.ExternalDocumentChange(document, project){

                    @Override
                    public void run() {
                        if (!FileDocumentManagerBase.isBinaryWithoutDecompiler(file2)) {
                            LoadTextUtil.clearCharsetAutoDetectionReason(file2);
                            file2.setBOM(null);
                            file2.setCharset(null, null, false);
                            boolean wasWritable = document.isWritable();
                            document.setReadOnly(false);
                            boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
                            isReloadable[0] = FileDocumentManagerImpl.isReloadable(file2, document, project);
                            if (isReloadable[0]) {
                                CharSequence reloaded2 = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerBase.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
                                ((DocumentEx)document).replaceText(reloaded2, file2.getModificationStamp());
                                FileDocumentManagerBase.setDocumentTooLarge(document, tooLarge);
                            }
                            document.setReadOnly(!wasWritable);
                        }
                    }
                }), UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
            }
            if (isReloadable[0]) {
                this.myMultiCaster.fileContentReloaded(file2, document);
            } else {
                this.unbindFileFromDocument(file2, document);
                this.myMultiCaster.fileWithNoDocumentChanged(file2);
                this.myMultiCaster.afterDocumentUnbound(file2, document);
            }
            this.myUnsavedDocuments.remove(document);
        }
    }

    private static boolean isReloadable(@NotNull VirtualFile file2, @NotNull Document document, @Nullable Project project) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(39);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(40);
        }
        PsiFile cachedPsiFile = project == null ? null : PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
        return !(FileUtilRt.isTooLarge((long)file2.getLength()) && file2.getFileType().isBinary() || cachedPsiFile != null && !(cachedPsiFile instanceof PsiFileImpl) && !FileDocumentManagerImpl.isBinaryWithDecompiler(file2) || document.getUserData(NOT_RELOADABLE_DOCUMENT_KEY) != null);
    }

    @TestOnly
    void setAskReloadFromDisk(@NotNull Disposable disposable2, @NotNull MemoryDiskConflictResolver newProcessor) {
        if (disposable2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(41);
        }
        if (newProcessor == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(42);
        }
        MemoryDiskConflictResolver old = this.myConflictResolver;
        this.myConflictResolver = newProcessor;
        Disposer.register((Disposable)disposable2, () -> {
            this.myConflictResolver = old;
        });
    }

    private void fileDeleted(@NotNull VFileDeleteEvent event) {
        Document doc;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(43);
        }
        if ((doc = this.getCachedDocument(event.getFile())) != null) {
            this.myTrailingSpacesStripper.documentDeleted(doc);
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(44);
        }
        if (virtualFile2.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile2.getFileType();
            virtualFile2.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    private boolean fireBeforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(45);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(46);
        }
        for (FileDocumentSynchronizationVetoer vetoer : FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList()) {
            try {
                if (vetoer.mayReloadFileContent(file2, document)) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        this.myMultiCaster.beforeFileContentReload(file2, document);
        return true;
    }

    @NotNull
    private static List<FileDocumentManagerListener> getListeners() {
        List list2 = FileDocumentManagerListener.EP_NAME.getExtensionList();
        if (list2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @Nullable
    public FileViewProvider findCachedPsiInAnyProject(@NotNull VirtualFile file2) {
        FileViewProvider vp;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(48);
        }
        ProjectManagerEx manager2 = ProjectManagerEx.getInstanceEx();
        for (Project project : manager2.getOpenProjects()) {
            FileViewProvider vp2 = PsiManagerEx.getInstanceEx(project).getFileManager().findCachedViewProvider(file2);
            if (vp2 == null) continue;
            return vp2;
        }
        if (manager2.isDefaultProjectInitialized() && (vp = PsiManagerEx.getInstanceEx(manager2.getDefaultProject()).getFileManager().findCachedViewProvider(file2)) != null) {
            return vp;
        }
        return null;
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (failures == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(49);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException = (IOException)ContainerUtil.getFirstItem(failures.values());
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (Map.Entry<Document, IOException> entry2 : failures.entrySet()) {
            LOG.warn("file: " + this.getFile(entry2.getKey()), (Throwable)entry2.getValue());
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            final String text2 = StringUtil.join(failures.values(), Throwable::getMessage, (String)"\n");
            DialogWrapper dialog2 = new DialogWrapper(null){
                {
                    super(arg0);
                    this.init();
                    this.setTitle(UIBundle.message((String)"cannot.save.files.dialog.title", (Object[])new Object[0]));
                }

                protected void createDefaultActions() {
                    super.createDefaultActions();
                    this.myOKAction.putValue("Name", UIBundle.message((String)(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes"), (Object[])new Object[0]));
                    this.myOKAction.putValue("DefaultAction", null);
                    if (!FileDocumentManagerImpl.this.myOnClose) {
                        this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                    }
                }

                protected JComponent createCenterPanel() {
                    JPanel panel2 = new JPanel(new BorderLayout(0, 5));
                    panel2.add((Component)new JLabel(UIBundle.message((String)"cannot.save.files.dialog.message", (Object[])new Object[0])), "North");
                    JTextPane area = new JTextPane();
                    area.setText(text2);
                    area.setEditable(false);
                    area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                    panel2.add((Component)new JBScrollPane((Component)area, 22, 31), "Center");
                    return panel2;
                }
            };
            if (dialog2.showAndGet()) {
                for (Document document : failures.keySet()) {
                    this.reloadFromDisk(document);
                }
            }
        });
    }

    @Override
    protected void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(50);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(51);
        }
        this.myMultiCaster.fileContentLoaded(file2, document);
    }

    @Override
    @NotNull
    protected DocumentListener getDocumentListener() {
        PrioritizedDocumentListener prioritizedDocumentListener = this.myPhysicalDocumentChangeTracker;
        if (prioritizedDocumentListener == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(52);
        }
        return prioritizedDocumentListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 47: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 47: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 45: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 40: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 34: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProcessor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAndRethrow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiCast";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "areTooManyDocumentsInTheQueue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 47: 
            case 52: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveDocuments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentAsIs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocument";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "maySaveDocument";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocumentInWriteAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateModifiedProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeFromUnsaved";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSaveNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "needsRefresh";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparator";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reloadFiles";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUnsaved";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFileModified";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "closeAllEditorsFor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithDecompiler";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isReloadable";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setAskReloadFromDisk";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "recomputeFileTypeIfNecessary";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeFileContentReload";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiInAnyProject";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "handleErrorsOnSave";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fileContentLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 47: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyAsyncFileListener
    implements AsyncFileListener {
        private final FileDocumentManagerImpl myFileDocumentManager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();

        MyAsyncFileListener() {
        }

        public AsyncFileListener.ChangeApplier prepareChange(final @NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyAsyncFileListener.$$$reportNull$$$0(0);
            }
            final ArrayList<VirtualFile> toRecompute = new ArrayList<VirtualFile>();
            final HashMap strongRefsToDocuments = new HashMap();
            final List contentChanges = ContainerUtil.findAll(events, VFileContentChangeEvent.class);
            for (VFileContentChangeEvent event : contentChanges) {
                long lastRecordedLength;
                ProgressManager.checkCanceled();
                VirtualFile virtualFile2 = event.getFile();
                if (virtualFile2 instanceof VirtualFileWithId && (lastRecordedLength = PersistentFS.getInstance().getLastRecordedLength(virtualFile2)) == 0L && FileTypeRegistry.getInstance().isFileOfType(virtualFile2, UnknownFileType.INSTANCE)) {
                    toRecompute.add(virtualFile2);
                }
                this.prepareForRangeMarkerUpdate(strongRefsToDocuments, virtualFile2);
            }
            return new AsyncFileListener.ChangeApplier(){

                public void beforeVfsChange() {
                    for (VFileContentChangeEvent event : contentChanges) {
                        this.prepareForRangeMarkerUpdate(strongRefsToDocuments, event.getFile());
                        if (!ourConflictsSolverEnabled) continue;
                        myFileDocumentManager.myConflictResolver.beforeContentChange(event);
                    }
                    for (VirtualFile file2 : toRecompute) {
                        file2.putUserData(MUST_RECOMPUTE_FILE_TYPE, (Object)Boolean.TRUE);
                    }
                }

                public void afterVfsChange() {
                    for (VFileEvent event : events) {
                        if (event instanceof VFileContentChangeEvent && ((VFileContentChangeEvent)event).getFile().isValid()) {
                            myFileDocumentManager.contentsChanged((VFileContentChangeEvent)event);
                            continue;
                        }
                        if (event instanceof VFileDeleteEvent && ((VFileDeleteEvent)event).getFile().isValid()) {
                            myFileDocumentManager.fileDeleted((VFileDeleteEvent)event);
                            continue;
                        }
                        if (!(event instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)event).getFile().isValid()) continue;
                        myFileDocumentManager.propertyChanged((VFilePropertyChangeEvent)event);
                    }
                    Reference.reachabilityFence(strongRefsToDocuments);
                }
            };
        }

        private void prepareForRangeMarkerUpdate(@NotNull Map<? super VirtualFile, ? super Document> strongRefsToDocuments, @NotNull VirtualFile virtualFile2) {
            Document document;
            if (strongRefsToDocuments == null) {
                MyAsyncFileListener.$$$reportNull$$$0(1);
            }
            if (virtualFile2 == null) {
                MyAsyncFileListener.$$$reportNull$$$0(2);
            }
            if ((document = this.myFileDocumentManager.getCachedDocument(virtualFile2)) == null && DocumentImpl.areRangeMarkersRetainedFor(virtualFile2)) {
                document = this.myFileDocumentManager.getDocument(virtualFile2);
            }
            if (document != null) {
                strongRefsToDocuments.put((VirtualFile)virtualFile2, (Document)document);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strongRefsToDocuments";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$MyAsyncFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareForRangeMarkerUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }

    static final class MyProjectCloseHandler
    implements ProjectCloseHandler {
        MyProjectCloseHandler() {
        }

        public boolean canClose(@NotNull Project project) {
            if (project == null) {
                MyProjectCloseHandler.$$$reportNull$$$0(0);
            }
            FileDocumentManagerImpl manager2 = (FileDocumentManagerImpl)FileDocumentManager.getInstance();
            if (!manager2.myUnsavedDocuments.isEmpty()) {
                manager2.myOnClose = true;
                try {
                    manager2.saveAllDocuments();
                }
                finally {
                    manager2.myOnClose = false;
                }
            }
            return manager2.myUnsavedDocuments.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$MyProjectCloseHandler", "canClose"));
        }
    }
}

