/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.tabActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/tabActions/CloseTab;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "c", "Ljavax/swing/JComponent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "editorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lcom/intellij/openapi/Disposable;)V", "getEditorWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isPinned", "", "update", "intellij.platform.ide.impl"})
public final class CloseTab
extends AnAction
implements DumbAware {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Project project;
    @NotNull
    private final EditorWindow editorWindow;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean pinned = this.isPinned();
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setIcon(!pinned ? AllIcons.Actions.Close : AllIcons.Actions.PinTab);
        Presentation presentation3 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
        presentation3.setHoveredIcon(!pinned ? AllIcons.Actions.CloseHovered : AllIcons.Actions.PinTab);
        Presentation presentation4 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
        presentation4.setVisible(UISettings.Companion.getInstance().getShowCloseButton() || pinned);
        if (pinned && !Registry.get((String)"ide.editor.tabs.interactive.pin.button").asBoolean()) {
            Presentation presentation5 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
            presentation5.setText("");
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.EMPTY);
        } else if (pinned) {
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.EMPTY);
            Presentation presentation6 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation6, (String)"e.presentation");
            TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0])).dropMnemonic(true);
            Intrinsics.checkNotNullExpressionValue((Object)textWithMnemonic, (String)"TextWithMnemonic.parse(I\u2026tab\")).dropMnemonic(true)");
            presentation6.setText(textWithMnemonic.getText());
        } else {
            this.setShortcutSet((ShortcutSet)ObjectUtils.notNull((Object)KeymapUtil.getActiveKeymapShortcuts((String)"CloseContent"), (Object)CustomShortcutSet.EMPTY));
            e.getPresentation().setText(IdeBundle.messagePointer((String)"action.presentation.EditorTabbedContainer.text", (Object[])new Object[0]));
        }
    }

    private final boolean isPinned() {
        return this.editorWindow.isFilePinned(this.file);
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.isPinned() && Intrinsics.areEqual((Object)e.getPlace(), (Object)"EditorTab")) {
                    if (Registry.get((String)"ide.editor.tabs.interactive.pin.button").asBoolean()) {
                        this.editorWindow.setFilePinned(this.file, false);
                    }
                    return;
                }
                mgr = FileEditorManagerEx.getInstanceEx(this.project);
                window = null;
                if (Intrinsics.areEqual((Object)"EditorTab", (Object)e.getPlace())) {
                    window = this.editorWindow;
                } else {
                    v0 = mgr;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"mgr");
                    window = v0.getCurrentWindow();
                }
                if (window == null) break block9;
                if (!(e.getInputEvent() instanceof MouseEvent)) ** GOTO lbl-1000
                v1 = e.getInputEvent();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"e.inputEvent");
                if (BitUtil.isSet((int)v1.getModifiersEx(), (int)512)) {
                    window.closeAllExcept(this.file);
                } else if (window.findFileComposite(this.file) != null) {
                    mgr.closeFile(this.file, window);
                }
            }
            v2 = this.editorWindow.getTabbedPane();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"editorWindow.tabbedPane");
            v3 = v2.getTabs();
            if (v3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.tabs.impl.MorePopupAware");
            }
            var4_4 = (MorePopupAware)v3;
            var5_5 = false;
            var6_6 = false;
            it = var4_4;
            $i$a$-let-CloseTab$actionPerformed$1 = false;
            v4 = e.getInputEvent();
            popup = PopupUtil.getPopupContainerFor((Component)(v4 != null ? v4.getComponent() : null));
            if (popup != null && it.canShowMorePopup()) {
                it.showMorePopup();
            }
            v5 = popup;
            if (v5 == null) break block10;
            v5.cancel();
        }
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final EditorWindow getEditorWindow() {
        return this.editorWindow;
    }

    public CloseTab(@NotNull JComponent c, @NotNull VirtualFile file2, @NotNull Project project, @NotNull EditorWindow editorWindow, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editorWindow, (String)"editorWindow");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.file = file2;
        this.project = project;
        this.editorWindow = editorWindow;
        new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("CloseContent"), c, parentDisposable);
    }
}

