/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.keymap.impl.ui.ShortcutPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.mac.MacGestureSupportForMouseShortcutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public final class MouseShortcutPanel
extends ShortcutPanel<MouseShortcut> {
    private static final JBColor BACKGROUND = JBColor.namedColor((String)"Panel.mouseShortcutBackground", (Color)new JBColor(0xF5F5F5, 4935506));
    private final int myClickCount;
    private MouseShortcut myMouseShortcut = null;
    private final MouseAdapter myMouseListener = new MouseAdapter(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            MouseShortcutPanel.this.setShortcutIfNeeded(this.toMouseShortcut(event));
        }

        @Override
        public void mousePressed(MouseEvent event) {
            MouseShortcutPanel.this.myMouseShortcut = this.toMouseShortcut(event);
        }

        private MouseShortcut toMouseShortcut(MouseEvent event) {
            int clickCount;
            int button4 = MouseShortcut.getButton((MouseEvent)event);
            int n = clickCount = event instanceof MouseWheelEvent ? 1 : event.getClickCount();
            if (0 <= button4 && clickCount <= MouseShortcutPanel.this.myClickCount) {
                int modifiers = event.getModifiersEx();
                return new MouseShortcut(button4, modifiers, clickCount);
            }
            return null;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            event.consume();
            MouseShortcutPanel.this.setShortcutIfNeeded(MouseShortcutPanel.this.myMouseShortcut);
        }
    };

    MouseShortcutPanel(boolean allowDoubleClick) {
        super(new BorderLayout());
        this.myClickCount = allowDoubleClick ? 2 : 1;
        this.addMouseListener(this.myMouseListener);
        this.addMouseWheelListener(this.myMouseListener);
        if (SystemInfo.isMac && SystemInfo.isJetBrainsJvm) {
            new MacGestureSupportForMouseShortcutPanel(this, () -> {
                this.myMouseShortcut = null;
            });
        }
        this.setBackground((Color)BACKGROUND);
        this.setOpaque(true);
    }

    @Override
    public void setShortcut(MouseShortcut shortcut) {
        MouseShortcut old = (MouseShortcut)this.getShortcut();
        if (old != null || shortcut != null) {
            super.setShortcut(shortcut);
        }
    }

    private void setShortcutIfNeeded(MouseShortcut shortcut) {
        if (shortcut != null) {
            this.setShortcut(shortcut);
        }
    }
}

