/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundScheme<E extends SchemeElement>
implements ExternalizableScheme {
    protected String myName;
    protected final ArrayList<E> myElements = new ArrayList();

    public CompoundScheme(String name2) {
        this.setName(name2);
    }

    public final void addElement(E t) {
        this.myElements.add(t);
    }

    @NotNull
    public final List<E> getElements() {
        if (this.myElements.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                CompoundScheme.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List<E> list3 = Collections.unmodifiableList(new ArrayList<E>(this.myElements));
        if (list3 == null) {
            CompoundScheme.$$$reportNull$$$0(1);
        }
        return list3;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CompoundScheme.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public final void setName(@NotNull String name2) {
        if (name2 == null) {
            CompoundScheme.$$$reportNull$$$0(3);
        }
        this.myName = name2;
        for (SchemeElement template : this.myElements) {
            template.setGroupName(name2);
        }
    }

    public final void removeElement(E template) {
        this.myElements.remove(template);
    }

    public final boolean isEmpty() {
        return this.myElements.isEmpty();
    }

    @NotNull
    private CompoundScheme<E> createNewInstance(String name2) {
        CompoundScheme compoundScheme;
        try {
            Constructor<?> constructor = this.getClass().getConstructor(String.class);
            try {
                constructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            compoundScheme = (CompoundScheme)constructor.newInstance(name2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (compoundScheme == null) {
            CompoundScheme.$$$reportNull$$$0(4);
        }
        return compoundScheme;
    }

    @NotNull
    CompoundScheme<E> copy() {
        CompoundScheme<E> result2 = this.createNewInstance(this.getName());
        result2.resetFrom(this);
        CompoundScheme<E> compoundScheme = result2;
        if (compoundScheme == null) {
            CompoundScheme.$$$reportNull$$$0(5);
        }
        return compoundScheme;
    }

    void resetFrom(@NotNull CompoundScheme<? extends E> template) {
        if (template == null) {
            CompoundScheme.$$$reportNull$$$0(6);
        }
        this.myElements.clear();
        this.myElements.ensureCapacity(template.myElements.size());
        for (SchemeElement element2 : template.myElements) {
            this.myElements.add(element2.copy());
        }
    }

    public boolean containsElement(@NotNull String key) {
        if (key == null) {
            CompoundScheme.$$$reportNull$$$0(7);
        }
        return ContainerUtil.exists(this.myElements, e -> key.equals(e.getKey()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/CompoundScheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/CompoundScheme";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MutatorHelper<T extends CompoundScheme<E>, E extends SchemeElement> {
        private final Map<T, T> copiedToOriginal = new IdentityHashMap<T, T>();

        @NotNull
        public T copy(@NotNull T scheme2) {
            if (scheme2 == null) {
                MutatorHelper.$$$reportNull$$$0(0);
            }
            CompoundScheme copied = ((CompoundScheme)scheme2).copy();
            this.copiedToOriginal.put(copied, scheme2);
            CompoundScheme compoundScheme = copied;
            if (compoundScheme == null) {
                MutatorHelper.$$$reportNull$$$0(1);
            }
            return (T)compoundScheme;
        }

        @NotNull
        public List<T> apply(@NotNull List<? extends T> copiedSchemes) {
            if (copiedSchemes == null) {
                MutatorHelper.$$$reportNull$$$0(2);
            }
            List<? extends T> list2 = this.apply(copiedSchemes, null);
            if (list2 == null) {
                MutatorHelper.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public List<T> apply(@NotNull List<? extends T> copiedSchemes, @Nullable BiConsumer<? super T, ? super T> changedConsumer) {
            if (copiedSchemes == null) {
                MutatorHelper.$$$reportNull$$$0(4);
            }
            this.copiedToOriginal.values().removeIf(it -> !ContainerUtil.containsIdentity((Iterable)copiedSchemes, (Object)it));
            ArrayList originals = new ArrayList(copiedSchemes.size());
            for (CompoundScheme copied : copiedSchemes) {
                CompoundScheme original = (CompoundScheme)this.copiedToOriginal.remove(copied);
                if (original == null) {
                    original = copied.copy();
                    this.copiedToOriginal.put(copied, original);
                } else {
                    if (changedConsumer != null) {
                        changedConsumer.accept(original, copied);
                    }
                    original.resetFrom(copied);
                }
                originals.add(original);
            }
            ArrayList arrayList = originals;
            if (arrayList == null) {
                MutatorHelper.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        public void clear() {
            this.copiedToOriginal.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/options/CompoundScheme$MutatorHelper";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copiedSchemes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/options/CompoundScheme$MutatorHelper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copy";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

