/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PotemkinOverlayProgress
extends AbstractProgressIndicatorBase
implements StandardProgressIndicator,
ProgressIndicatorWithDelayedPresentation,
PingProgress,
Disposable {
    private static final MouseShortcut SHORTCUT = new MouseShortcut(1, (SystemInfo.isMac ? 256 : 128) | 0x200 | 0x40, 1);
    private final Component myComponent;
    private final PotemkinProgress.EventStealer myEventStealer;
    private final long myCreatedAt = System.currentTimeMillis();
    private int myDelayInMillis = 3000;
    private long myLastUiUpdate = this.myCreatedAt;
    private long myLastInteraction;
    private boolean myShowing;

    public PotemkinOverlayProgress(@Nullable Component component2) {
        EDT.assertIsEdt();
        this.myComponent = component2;
        this.myEventStealer = PotemkinProgress.startStealingInputEvents(this::dispatchInputEvent, this);
    }

    @Override
    public void setDelayInMillis(int delayInMillis) {
        this.myDelayInMillis = delayInMillis;
    }

    @Override
    public void stop() {
        super.stop();
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        JRootPane rootPane;
        if (this.myShowing && (rootPane = (JRootPane)UIUtil.getParentOfType(JRootPane.class, (Component)this.myComponent)) != null) {
            rootPane.repaint();
        }
    }

    @Override
    public void interact() {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now == this.myLastInteraction) {
            return;
        }
        this.myLastInteraction = now;
        this.myEventStealer.dispatchEvents(0);
        if (!this.myShowing && now - this.myLastUiUpdate > (long)this.myDelayInMillis) {
            this.myShowing = true;
        }
        if (this.myShowing) {
            this.updateUI(now);
        }
    }

    private void dispatchInputEvent(@NotNull InputEvent event) {
        boolean isCancellation;
        if (event == null) {
            PotemkinOverlayProgress.$$$reportNull$$$0(0);
        }
        if (!(event instanceof MouseEvent)) {
            return;
        }
        boolean bl = isCancellation = event.getID() == 501 && (event.getModifiersEx() & SHORTCUT.getModifiers()) == SHORTCUT.getModifiers() && ((MouseEvent)event).getButton() == SHORTCUT.getButton();
        if (isCancellation) {
            this.cancel();
        }
    }

    private void updateUI(long now) {
        if (now - this.myLastUiUpdate <= 50L) {
            return;
        }
        this.myLastUiUpdate = now;
        this.paintProgress();
    }

    private void paintProgress() {
        IdeGlassPane glassPane;
        JRootPane rootPane = (JRootPane)UIUtil.getParentOfType(JRootPane.class, (Component)this.myComponent);
        IdeGlassPane ideGlassPane = glassPane = rootPane == null ? null : (IdeGlassPane)ObjectUtils.tryCast((Object)rootPane.getGlassPane(), IdeGlassPane.class);
        if (glassPane == null) {
            return;
        }
        long roundedDuration = (System.currentTimeMillis() - this.myCreatedAt) / 1000L * 1000L;
        String text2 = "Use " + KeymapUtil.getMouseShortcutText((MouseShortcut)SHORTCUT) + " to cancel (" + NlsMessages.formatDurationApproximateNarrow(roundedDuration) + ")";
        Graphics graphics = rootPane.getGraphics();
        Rectangle viewR = rootPane.getBounds();
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        FontMetrics fm = graphics.getFontMetrics();
        SwingUtilities.layoutCompoundLabel(fm, text2, null, 0, 0, 0, 0, viewR, iconR, textR, 0);
        graphics.translate(textR.x, textR.y);
        graphics.setColor((Color)JBColor.GRAY);
        int border = 10;
        graphics.fillRoundRect(-border, -border, textR.width + 2 * border, textR.height + 2 * border, border, border);
        graphics.setColor((Color)JBColor.WHITE);
        graphics.drawString(text2, 0, fm.getAscent());
        graphics.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/progress/util/PotemkinOverlayProgress", "dispatchInputEvent"));
    }
}

