/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbServiceMergingTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class DumbServiceGuiTaskQueue {
    private static final Logger LOG = Logger.getInstance(DumbServiceGuiTaskQueue.class);
    private final Project myProject;
    private final DumbServiceMergingTaskQueue myTaskQueue;

    DumbServiceGuiTaskQueue(@NotNull Project project, @NotNull DumbServiceMergingTaskQueue queue2) {
        if (project == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(0);
        }
        if (queue2 == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myTaskQueue = queue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTasksWithProgress(@NotNull StructuredIdeActivity activity, @NotNull Consumer<? super ProgressIndicatorEx> bindProgress, @NotNull Consumer<? super ProgressIndicatorEx> unbindProgress) {
        if (activity == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(2);
        }
        if (bindProgress == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(3);
        }
        if (unbindProgress == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(4);
        }
        while (!this.myProject.isDisposed()) {
            DumbServiceMergingTaskQueue.QueuedDumbModeTask pair = this.myTaskQueue.extractNextTask();
            try {
                if (pair == null) break;
                bindProgress.accept(pair.getIndicator());
                pair.registerStageStarted(activity);
                try {
                    HeavyProcessLatch.INSTANCE.performOperation(HeavyProcessLatch.Type.Indexing, IdeBundle.message((String)"progress.performing.indexing.tasks", (Object[])new Object[0]), () -> DumbServiceGuiTaskQueue.runSingleTask(pair));
                }
                finally {
                    unbindProgress.accept(pair.getIndicator());
                }
            }
            finally {
                if (pair == null) continue;
                pair.close();
            }
        }
    }

    private static void runSingleTask(@NotNull DumbServiceMergingTaskQueue.QueuedDumbModeTask task2) {
        if (task2 == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task2.getInfoString());
        }
        ProgressManager.getInstance().runProcess(() -> {
            try {
                task2.executeTask();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable unexpected) {
                LOG.error("Failed to execute task " + task2 + ". " + unexpected.getMessage(), unexpected);
            }
        }, (ProgressIndicator)task2.getIndicator());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindProgress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unbindProgress";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/DumbServiceGuiTaskQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processTasksWithProgress";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runSingleTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

